


import java.awt.*;
import java.awt.geom.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.border.Border.*;
import javax.swing.text.*;
import java.io.File.*;
import java.text.NumberFormat;


public class ComponentLibDialog extends JDialog{
    ComponentAction action;
    ComponentManager componentManager;
    ComponentLibPanel componentLibPanel;
    JLabel messageLabel1=new JLabel(" ");
    JLabel messageLabel2=new JLabel(" ");
    MButton addButton=null;
    MButton deleteButton=null;
    MButton createButton=null;
    MButton changeButton=null;
    MButton guideButton=null;
    JScrollPane scrollPane=null;
    Dimension buttonDimension=new Dimension(140, 22);
    Dimension messageDimension=new Dimension(300, 14);
    Point dialogLocation=new Point(250, 20);
    int debug=0;
    
    public ComponentLibDialog(JFrame frame){
        super(frame, "component lib");
        //this.setName("component lib");
        this.action=new ComponentAction(frame, this);
        this.componentManager=new ComponentManager(this);
        this.componentLibPanel=new ComponentLibPanel(this);
        this.createDialog();
        
    }
    
    public void createDialog(){
      //set Window action  
        this.addWindowListener(this.action);
      //dialog layout
        Container contentPane=this.getContentPane();
        Box box=Box.createVerticalBox();
        box.setBackground(Color.GREEN);
        box.setForeground(Color.MAGENTA);
        contentPane.add(box);

     //ScrollPane
        this.scrollPane=new JScrollPane();
        this.scrollPane.setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_ALWAYS);
        this.scrollPane.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
        JViewport viewport=new JViewport();
        this.scrollPane.setViewport(viewport);
        this.componentLibPanel.setAutoscrolls(true);
        viewport.setView(this.componentLibPanel);
        viewport.setViewPosition(new Point(0,0));
      //OK, Cancel Button    
        JPanel buttonPanel1=new JPanel();
        JPanel buttonPanel2=new JPanel();
        JPanel buttonPanel3=new JPanel();
        this.addButton=   new MButton("add component  ");
        this.deleteButton=new MButton("del component  ");
        this.createButton=new MButton("create shape ");
        this.changeButton=new MButton("change shape ");
        this.guideButton=new MButton("operation guide");
        
        String tipText="Select a shape on the canvas and press this button,\n"
                + " then the selected shape will be added to the upper panel.";
        this.addButton.setToolTipText(tipText);
        this.addButton.setToolTipFont(Font.BOLD);
        //this.addButton.setToolTipFont(Font.BOLD+Font.ITALIC);
        tipText="Select a component on the upper panel and press this button,\n"
                + " then the selected component will be deleted.";
        this.deleteButton.setToolTipText(tipText);
        this.deleteButton.setToolTipFont(Font.BOLD);
        //this.deleteButton.setToolTipFont(Font.BOLD+Font.ITALIC);
        
        this.setButtonAttribute(this.addButton, "add",this.action, this.buttonDimension);
        this.setButtonAttribute(this.deleteButton, "delete",this.action, this.buttonDimension);
        this.setButtonAttribute(this.createButton, "create",this.action, this.buttonDimension);
        this.setButtonAttribute(this.changeButton, "change",this.action, this.buttonDimension);
        this.setButtonAttribute(this.guideButton, "guide",this.action, this.buttonDimension);

        buttonPanel1.add(this.addButton);
        buttonPanel1.add(this.deleteButton);
        //buttonPanel2.add(this.createButton);
        //buttonPanel2.add(this.changeButton);
        //buttonPanel3.add(this.guideButton);
      // description Panel
        JPanel descriptionPanel=new JPanel();
        descriptionPanel.setBorder(BorderFactory.createTitledBorder("operation"));
      //messageLabel
        JPanel messagePanel=new JPanel();
        messagePanel.setBorder(BorderFactory.createTitledBorder("message:"));
        Box messageBox=Box.createVerticalBox();
        messagePanel.add(messageBox);
        messageBox.add(Box.createVerticalStrut(0));
        messageBox.add(this.messageLabel1);
        messageBox.add(Box.createVerticalStrut(0));
        messageBox.add(this.messageLabel2);
        messageBox.add(Box.createVerticalStrut(0));
        //messagePanel.setPreferredSize(new Dimension(300,40));
        this.messageLabel1.setPreferredSize(this.messageDimension);
        this.messageLabel2.setPreferredSize(this.messageDimension);
       
        Box descriptionBox=Box.createVerticalBox();
        descriptionPanel.add(descriptionBox);
        JLabel label1=new JLabel();
        label1.setBorder(BorderFactory.createTitledBorder(" add component"));
        label1.setHorizontalTextPosition(SwingConstants.LEFT);
        String str="Select shapes on the screen, then click add component button";
        label1.setText(str);
        label1.setBackground(Color.YELLOW);
        descriptionPanel.add(label1);

      //deploy all components on the dialog
        box.add(this.scrollPane);
        box.add(Box.createVerticalStrut(0));
        box.add(buttonPanel1);
        box.add(Box.createVerticalStrut(0));
        box.add(buttonPanel2);
        box.add(Box.createVerticalStrut(0));
        box.add(buttonPanel3);
        box.add(Box.createVerticalStrut(0));
        box.add(messagePanel);
    }

    private void setButtonAttribute(JButton button, String actionCommand,
            ActionListener action, Dimension dimension) {
        //button.setFont(MenuConstants.MenuFont);
        button.setActionCommand(actionCommand);
        button.addActionListener(action);
        button.setPreferredSize(dimension);
    }

    public void showDialog(){
       //---------------------------------------//
        this.componentManager.readComponentList();
       //---------------------------------------// 
        //ShapeContainer[] containers=this.getContainerManager().getContainers();
        //this.componentLibPanel.setComponents(containers);
        this.componentLibPanel.repaint();
        if(debug>0) this.printView(this);
        this.scrollPane.setPreferredSize(this.componentLibPanel.getSizeOfScrollPane());
        //dialog position
        Component owner = this.getOwner();
        Point pos = new Point(owner.getX() + (int)this.dialogLocation.getX(),
                owner.getY() + (int)this.dialogLocation.getY());
        this.setLocation(pos);
        this.pack();
        this.setVisible(true);
        //ObjectTable.getMenuUtil().setMenuComponent(this.getDialog());
    }
    
    public void showMessage(String message, Color color){
        //System.out.println(" -- showMessage message="+message);
        this.messageLabel1.setForeground(color);
        this.messageLabel2.setForeground(color);
        //this.messageLabel1.setFont(DrawParameters.Font12Bold);
        //this.messageLabel2.setFont(DrawParameters.Font12Bold);
        int index=message.indexOf("\n");
        String str1=message;
        String str2="";
        if(index>0){
            str1=message.substring(0, index);
            if(index+1<message.length()){
                str2=message.substring(index+1, message.length());
            }
        }
        this.messageLabel1.setText(str1);
        this.messageLabel2.setText(str2);
    }

//DrawMenuIF method
    public void setSelected(boolean selected){}
    
//DrawMenuIF method
    public boolean isSelected(){
        return false;
    }
    
    public ShapeContainer getSelectedComponent(){
        int index=this.componentLibPanel.getSelectedComponentByIndex();
        if(index<0) return null;
        ContainerManager containerManager=this.componentManager.getContainerManager();
        ShapeContainer selectedContainer=containerManager.getContainer(index);
        return selectedContainer;
    }
    
    protected ContainerManager getContainerManager(){
        return this.componentManager.getContainerManager();
    }
    
    protected ComponentLibPanel getComponentLibPanel(){
        return this.componentLibPanel;
    }

    protected ComponentManager getComponentManager(){
        return this.componentManager;
    }
    
    protected JScrollPane getScrollPane(){
        return this.scrollPane;
    }
    
    protected JDialog getDialog(){
        return this;
    }
    
    private void printView(ComponentLibDialog dialog){
        System.out.println("++ printView ComponentLibDialog" +
            "\n   dialog:"+Util.Rect(this)+
            "\n   scrollPane:"+Util.Rect(this.scrollPane)+
            "\n   componentLibPanel:"+Util.Rect(this.componentLibPanel));
    }
}

class ComponentAction extends AbstractAction implements WindowListener, MouseListener {
    ComponentLibDialog dialog;
    String actionButtonName="";
    int debug=0;

    ComponentAction(JFrame frame, ComponentLibDialog dialog){
        this.dialog=dialog;
    }

    public void actionPerformed(ActionEvent e) {
        //int debug=MenuUtil.debug;
        String commandName=e.getActionCommand();
        String componentClassName="";
        componentClassName=e.getSource().getClass().getSimpleName();
        String componentName=((Component)e.getSource()).getName();
        if(debug>0) System.out.println("- ComponentAction.actionPerformed  " +
                "commandName="+commandName+
                ", source component name="+componentName+
                ", source class simple name="+componentClassName);

        this.dialog.showMessage(" ", Color.BLACK);
        if(commandName.equals("add")){}
        if(commandName.equals("delete")){}
  
    }//End of actionPerformed

    public String getActionButtonName(){
        return this.actionButtonName;
    }

    public void mouseClicked(MouseEvent e) {
        String actionButtonName=this.getActionButtonName();
        int index=this.dialog.componentLibPanel.getSelectedComponentByIndex();
    }

    private void closeDialog(){
        ComponentLibDialog dialog=this.dialog;
        Component owner = dialog.getOwner();
        Point dialogPT = dialog.getLocation();
        dialog.dialogLocation = new Point((int) dialogPT.getX() - owner.getX(),
                (int) dialogPT.getY() - owner.getY()); 
        this.dialog.getDialog().setVisible(false);
        return;
    }

    public void windowActivated(WindowEvent e) {}
    public void windowClosed(WindowEvent e) {}
    public void windowClosing(WindowEvent e) {
        this.closeDialog();
    }
    public void windowDeactivated(WindowEvent e) {}
    public void windowDeiconified(WindowEvent e) {}
    public void windowIconified(WindowEvent e) {}
    public void windowOpened(WindowEvent e) {}

    public void mousePressed(MouseEvent e) {
        //System.out.println("Lib panel pressed");
    }
    public void mouseReleased(MouseEvent e) {}
    public void mouseEntered(MouseEvent e) {}
    public void mouseExited(MouseEvent e) {}


} // end of class

class GuideDialog extends JDialog implements ActionListener{
    ComponentLibDialog dialog;
    JRadioButton addComponent=null;
    JRadioButton delComponent=null;
    JRadioButton createShape=null;
    JRadioButton changeShape=null;
    JRadioButton moveComponent=null;
    JScrollPane scrollPane=null;
    JTextPane textBox=null;
    Dimension buttonDimension=new Dimension(150, 20);
    DefaultStyledDocument document=null;
    StyleContext styleContext=null;
    String[] guidances= new String[5];
    String[] keyWords=  new String[10];

    GuideDialog(ComponentLibDialog dialog){
        super(dialog, "Guidance dialog");
        this.dialog=dialog;
        for(int i=0;i<keyWords.length;i++) keyWords[i]="";
        keyWords[0]="add component button";
        keyWords[1]="del component button";
        keyWords[2]="create shape button";
        keyWords[3]="change shape button";
        keyWords[4]="How to move a component";
        keyWords[5]="Component lib dialog";
        this.guidances[0]=keyWords[0]+" :\n"
                +"The button is used for adding a component(s) to the Component lib dialog\n"
                + "(1)Select a shape on the drawing panel (canvas) by mouse click.\n"
                + "(2)Click the add component button on the Component lib dialog\n"
                + "(3)Then the selected shape will be registered in the last cell of "
                + "the Component lib dialog.\n"
                + "(4)If you select multiple shapes, you can register them at once.\n"
                + "(5)You can select a grouped shape.";
        this.guidances[1]=keyWords[1]+" :\n"
                +"The button is used for removing a component from the Component lib dialog\n"
                + "(1)Select a component shown on the Component lib dialog by mouse click.\n"
                + "(2)Click the del component button.\n"
                + "(3)Tthe selected (clicked) component will be removed.\n";

        this.guidances[2] = keyWords[2] + " :\n"
                + "The button is used for creating a shape on the drawing panel (canvas) "
                + "by copying the selected component shown in the dialog \n"
                + "(1)Click a component shown in the Component lib dialog.\n"
                + "(2)Click the create shape button.\n "
                + "(3)Drag your mouse on the drawing panel (canvas) to define "
                + "the size of the shape to be created.\n"
                + "(4)Then a new shape will be created on on the drawing panel (canvas).\n"
                + "The created shape will be similar to the selected (clicked) component and "
                + "it's fit the dragged area";
        this.guidances[3]=keyWords[3]+" :\n"
                +"The button is used for changing the selected shapes on the drawing panel (canvas)\n"
                + "(1)Click a component shown on the Component lib dialog.\n"
                + "(2)Click the change shape button.\n "
                + "(3)Then the selected shapes will be change to the shape of "
                + "the selected component on the dialog";
        this.guidances[4]=keyWords[4]+" :\n"
                +"No button is needed for this operation\n"
                + "(1)Press your mouse button on a component shown on the Component lib dialog.\n"
                + "(2)Move your mouse with holding down the mouse left button.\n"
                + "(3)Release your mouse button where you want to place the component.";
        this.createDialog();
    }

    private void createDialog(){
        Component owner = this.getOwner();
        Point centerP = new Point(owner.getX() + 320, owner.getY()-10 );
        this.setLocation(centerP);

        Container contentPane = this.getContentPane();
        Box box = Box.createVerticalBox();
        contentPane.add(box);
        JPanel radioButtonPanel=new JPanel();
        TitledBorder frameBorder = BorderFactory.createTitledBorder("Guidance buttons");
        frameBorder.setTitleColor(Color.BLACK);
        //frameBorder.setTitleFont(MenuConstants.MenuFont);
        radioButtonPanel.setBorder(frameBorder);
        radioButtonPanel.setLayout(new BoxLayout(radioButtonPanel, BoxLayout.Y_AXIS));
        this.addComponent= new JRadioButton(keyWords[0]);
        this.delComponent = new JRadioButton(keyWords[1]);
        this.createShape = new JRadioButton(keyWords[2]);
        this.changeShape = new JRadioButton(keyWords[3]);
        this.moveComponent = new JRadioButton(keyWords[4]);
        this.setButtonAttribute(this.addComponent, "add", this.buttonDimension);
        this.setButtonAttribute(this.delComponent, "del", this.buttonDimension);
        this.setButtonAttribute(this.createShape, "create", this.buttonDimension);
        this.setButtonAttribute(this.changeShape, "change", this.buttonDimension);
        this.setButtonAttribute(this.moveComponent, "move", this.buttonDimension);

        ButtonGroup group=new ButtonGroup();
        group.add(this.addComponent);
        group.add(this.delComponent);
        group.add(this.createShape);
        group.add(this.changeShape);
        group.add(this.moveComponent);
        this.addComponent.setSelected(true);

        radioButtonPanel.add(this.addComponent);
        radioButtonPanel.add(this.delComponent);
        radioButtonPanel.add(this.createShape);
        radioButtonPanel.add(this.changeShape);
        radioButtonPanel.add(this.moveComponent);

        JPanel guidancePanel=new JPanel();
        //guidancePanel.setPreferredSize(new Dimension(300, 200));
        frameBorder = BorderFactory.createTitledBorder("Guidance");
        frameBorder.setTitleColor(Color.BLACK);
        //frameBorder.setTitleFont(MenuConstants.MenuFont);
        guidancePanel.setBorder(frameBorder);

        this.styleContext = new StyleContext();
        this.document = new DefaultStyledDocument(styleContext);
        this.textBox = new JTextPane(this.document);
        try {
            document.insertString(0, this.guidances[0], null);
            this.setStyle(this.guidances[0]);
        } catch (Exception e) {}

        this.scrollPane = new JScrollPane();
        scrollPane.setPreferredSize(new Dimension(300, 120));
        scrollPane.setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_AS_NEEDED);
        scrollPane.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
        JViewport viewport = new JViewport();
        scrollPane.setViewport(viewport);
        viewport.setView(this.textBox);
        viewport.setViewPosition(new Point(0, 0));
        guidancePanel.add(this.scrollPane);

        box.add(Box.createVerticalStrut(5));
        box.add(radioButtonPanel);
        box.add(Box.createVerticalStrut(5));
        box.add(guidancePanel);
    }

    public void showDialog(){
        this.pack();
        this.setVisible(true);
    }

    private void setButtonAttribute(JRadioButton button, String actionCommand,
            Dimension dimension) {
        button.addActionListener(this);
        button.setActionCommand(actionCommand);
        button.setPreferredSize(dimension);
        
    }

    private void setStyle(String guideText){
        Style bold = this.styleContext.addStyle("guideStyle", null);
        StyleConstants.setBold(bold, true);
        int index=guideText.indexOf("\n");
        int length=guideText.length();
        for(int i=0;i<this.keyWords.length;i++){
            index=0;
            if(this.keyWords[i].equals("")) continue;
            int len=this.keyWords[i].length();
            while(true){
                int pos=guideText.indexOf(this.keyWords[i], index);
                if(pos<0) break;
                this.document.setCharacterAttributes(pos, len, bold, false);
                index=pos+len;
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        String command=e.getActionCommand();
        try {
            int length=this.document.getLength();
            this.document.remove(0, length);
        } catch (Exception de) {
            System.err.println("Error in document.remove");
        }
        String text="";
        if(command.equals("add")){
            text=this.guidances[0];
        } else if(command.equals("del")){
            text=this.guidances[1];
        } else if(command.equals("create")){
            text=this.guidances[2];
        } else if(command.equals("change")){
            text=this.guidances[3];
        } else if(command.equals("move")){
            text=this.guidances[4];
        }
        try {
            this.document.insertString(0, text, null);
            this.setStyle(text);
        } catch (Exception de) {
            System.err.println("Error in document.insertString");
        }
    }
}


class Util {
    static NumberFormat nf = NumberFormat.getNumberInstance();
    static int debug = 0;
    public Util() {
    }

//-------//
//  Sort //
//-------//

    public static void simpleSort(int[] data) {
        String message = "initial array: ";
        printSort(message, data);
        for (int i = 0; i < data.length - 1; i++) {
            for (int j = i; j < data.length; j++) {
                if (data[j] < data[i]) {
                    swap(data, i, j);
                }
            }
            message = i + "th array:    ";
            if (debug > 0) {
                printSort(message, data);
            }
        }
    }

    public static void simpleSort(double[] data) {
        String message = "simpleSort initial array: ";
        printSort(message, data);
        for (int i = 0; i < data.length - 1; i++) {
            for (int j = i; j < data.length; j++) {
                if (data[j] < data[i]) {
                    swap(data, i, j);
                }
            }
            message = "simpleSort  " + i + "th array:    ";
            if (debug > 0) {
                printSort(message, data);
            }
        }
    }

    public static int[] indexedSimpleSort(int[] data) {
        int size = data.length;
        int[] indices = new int[size];
        for (int i = 0; i < size; i++) {
            indices[i] = i;
        }
        String message = "simpleSort initial array: ";
        if (debug > 0) {
            printSort(message, data, indices);
        }

        for (int i = 0; i < size - 1; i++) {
            for (int j = i; j < data.length; j++) {
                if (data[indices[j]] < data[indices[i]]) {
                    indexedSwap(indices, i, j);
                }
            }
        }
        message = "simpleSort final array: ";
        if (debug > 0) {
            printSort(message, data, indices);
        }
        return indices;
    }

    public static int[] indexedSimpleSort(double[] data) {
        int size = data.length;
        int[] indices = new int[size];
        for (int i = 0; i < size; i++) {
            indices[i] = i;
        }
        String message = "simpleSort initial array: ";
        if (debug > 0) {
            printSort(message, data, indices);
        }

        for (int i = 0; i < size - 1; i++) {
            for (int j = i; j < data.length; j++) {
                if (data[indices[j]] < data[indices[i]]) {
                    indexedSwap(indices, i, j);
                }
            }
        }
        message = "simpleSort final array: ";
        if (debug > 0) {
            printSort(message, data, indices);
        }
        return indices;
    }

    private static void indexedSwap(int[] indices, int i, int j) {
        int tmp = indices[j];
        indices[j] = indices[i];
        indices[i] = tmp;
    }

    private static void swap(int[] data, int i, int j) {
        int tmp = data[j];
        data[j] = data[i];
        data[i] = tmp;
    }

    private static void swap(double[] data, int i, int j) {
        double tmp = data[j];
        data[j] = data[i];
        data[i] = tmp;
    }

    private static void printSort(String message, int[] data) {
        int i;
        System.out.print(message);
        for (i = 0; i < data.length - 1; i++) {
            System.out.print(data[i] + ",");
        }
        System.out.println(data[i]);
    }

    private static void printSort(String message, double[] data) {
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumIntegerDigits(4);
        nf.setMinimumFractionDigits(2);
        int i;
        System.out.print(message);
        for (i = 0; i < data.length - 1; i++) {
            System.out.print(nf.format(data[i]) + " ,");
        }
        System.out.println(nf.format(data[i]));
    }

    private static void printSort(String message, int[] data, int[] indices) {
        int i;
        System.out.print(message);
        for (i = 0; i < data.length - 1; i++) {
            System.out.print("[" + indices[i] + "] " + data[indices[i]] + ", ");
        }
        System.out.println("[" + indices[i] + "] " + data[indices[i]]);
    }

    private static void printSort(String message, double[] data, int[] indices) {
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumIntegerDigits(4);
        nf.setMinimumFractionDigits(10);
        int i;
        System.out.print(message);
        for (i = 0; i < data.length - 1; i++) {
            System.out.print("[" + indices[i] + "] " + nf.format(data[indices[i]]) + ", ");
        }
        System.out.println("[" + indices[i] + "] " + nf.format(data[indices[i]]));
    }

//----------------------------------//
//  String/charactertype conversion //
//----------------------------------//
    public static String getASCIIControlString(String str) {
        char ascCode = 0x40;
        char[] c = str.toCharArray();
        char code = c[0];
        char hitChar;
        String outputStr = "";
        for (char i = 0x00; i < 0x1a; i++) {
            if (code == i) {
                hitChar = (char) (i + ascCode);
                outputStr = "ctrl " + String.valueOf(hitChar);
                break;
            }
        }
        if (code == 0x7f) {
            outputStr = "DELETE";
        }
        return outputStr;
    }

    public static String toHexString(String str) {
        String hexString = "";
        byte[] btArray = str.getBytes();
        hexString = Util.toHexString(btArray);
        return hexString;
    }

    public static String toHexString(byte[] byteBuff) {
        String[] hex = {"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
        String result = "";
        for (int i = 0; i < byteBuff.length; i++) {
            result += "0x";
            int num = byteBuff[i] & 0xff;
            int firstNum = num / 16;
            int secondNum = num - 16 * firstNum;
            result += hex[firstNum];
            result += hex[secondNum];
            result += " ";
        }
        return result;
    }
//-----------//
//  toString //
//-----------//

    public static String Num(double d) {
        nf.setMaximumIntegerDigits(4);
        nf.setMaximumFractionDigits(1);
        nf.setMinimumFractionDigits(1);
        String str = "";
        str = nf.format(d);
        return str;

    }

    public static String PercentNum(double d, int fraction) {
        NumberFormat nf = NumberFormat.getPercentInstance();
        nf.setMaximumIntegerDigits(3 + fraction);
        nf.setMaximumFractionDigits(fraction);
        String str = "";
        str = nf.format(d);
        return str;
    }

    public static String Pt(Point point) {
        nf.setMaximumIntegerDigits(4);
        nf.setMaximumFractionDigits(1);
        nf.setMinimumFractionDigits(1);
        String str = "";
        if (point == null) {
            str = "null";
        } else {
            str = nf.format(point.getX()) + ", " + nf.format(point.getY());
        }
        return str;
    }

    public static String Pt(Point2D point) {
        nf.setMaximumIntegerDigits(4);
        nf.setMaximumFractionDigits(1);
        nf.setMinimumFractionDigits(1);
        String str = "";
        if (point == null) {
            str = "null";
        } else {
            str = nf.format(point.getX()) + ", " + nf.format(point.getY());
        }
        return str;
    }


    public static String Pt(Rectangle2D rect) {
        nf.setMaximumIntegerDigits(4);
        nf.setMaximumFractionDigits(1);
        nf.setMinimumFractionDigits(1);
        String str = "";
        if (rect == null) {
            str = "null";
        } else {
            str = nf.format(rect.getX()) + ", " + nf.format(rect.getY());
        }
        return str;
    }

    public static String Pt(Arc2D arc) {
        nf.setMaximumIntegerDigits(4);
        nf.setMaximumFractionDigits(1);
        nf.setMinimumFractionDigits(1);
        String str = "";
        if (arc == null) {
            str = "null";
        } else {
            str = nf.format(arc.getX()) + ", " + nf.format(arc.getY());
        }
        return str;
    }

    public static String Rect(Rectangle rect) {
        nf.setMaximumIntegerDigits(4);
        nf.setMaximumFractionDigits(1);
        nf.setMinimumFractionDigits(1);
        String str = "";
        if (rect == null) {
            str = "null";
        } else {
            str = "x,y=" + nf.format(rect.getX()) + ", " + nf.format(rect.getY())
                    + ", w,h=" + nf.format(rect.getWidth()) + ", " + nf.format(rect.getHeight());
        }
        return str;
    }

    public static String Rect(Component component) {
        nf.setMaximumIntegerDigits(4);
        nf.setMaximumFractionDigits(1);
        nf.setMinimumFractionDigits(1);
        String str = "";
        if (component == null) {
            str = "null";
        } else {
            Dimension size = component.getPreferredSize();
            str = "x,y=" + nf.format(component.getX()) + ", " + nf.format(component.getY())
                    + ", w,h=" + nf.format(component.getWidth()) + ", " + nf.format(component.getHeight())
                    + ", preferredSize=" + nf.format(size.getWidth()) + ", " + nf.format(size.getHeight());
        }

        return str;
    }

    public static String Rect(Rectangle2D rect) {
        nf.setMaximumIntegerDigits(4);
        nf.setMaximumFractionDigits(1);
        nf.setMinimumFractionDigits(1);
        String str = "";
        if (rect == null) {
            str = "null";
        } else {
            str = "x,y=" + nf.format(rect.getX()) + ", " + nf.format(rect.getY())
                    + ", w,h=" + nf.format(rect.getWidth()) + ", " + nf.format(rect.getHeight());
        }
        return str;
    }

}

class MButton extends JButton {
    MultiLineToolTip mToolTip = new MultiLineToolTip(500, 60000);
    
    public MButton(String name) {
        super(name);
        this.mToolTip.setComponent(this);
        Font font = new Font(Font.DIALOG, Font.PLAIN, 12);
        this.mToolTip.setFont(font);
        this.mToolTip.setComponent(this);
    }

    public JToolTip createToolTip() {
        return this.mToolTip;
    }

    public void setToolTipFont(Font font) {
        this.mToolTip.setFont(font);
    }
    
    public void setToolTipFont(int type) {
      // type: Font.BOLD/Font.ITALIC/Font.BOLD+Font.ITALIC etc
        Font font = new Font(Font.DIALOG, type, 12);
        this.mToolTip.setFont(font);
    }
}