/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */


import java.awt.*;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.*;
import java.awt.geom.*;
import java.util.*;
import javax.swing.*;

public class DrawPanel extends JPanel implements DropTargetListener{
    Dimension panelSize=new Dimension(600, 300);
    int debug=0;
    ContainerManager manager;
    DropTarget dropTarget;
    
    public DrawPanel(){
        this.setLayout(null);
        this.setPreferredSize(this.panelSize);
        this.setOpaque(true);
        this.setBackground(Color.WHITE);
        this.manager=new ContainerManager();
        DropTarget dropTarget = new DropTarget(this, this); 
        this.setDropTarget(dropTarget);
        //this.dropTarget = new DropTarget(); 
    }
    
    public ContainerManager getContainerManager(){
        return this.manager;
    }
/*
    public void addDropTarget(){
        this.dropTarget.setComponent(this);
        try{
            this.dropTarget.addDropTargetListener(this);
        }catch(TooManyListenersException e){
            System.out.println("Error DropTargetListener already exit e="+e);
        }
        //this.setDropTarget(dropTarget);
    }
    
    public void removeDropTarget(){
        this.dropTarget.setComponent(null);
        this.dropTarget.removeDropTargetListener(this);
    }
*/
    public void paint(Graphics g) {
        Graphics2D g2=(Graphics2D)g;
        Color currentColor=g2.getColor();
      // draw frame of the canvas 
        Dimension size=this.getPreferredSize();
        Rectangle2D bounds=new Rectangle2D.Double(0.1d, 0.1d, size.getWidth()-0.2d, size.getHeight()-0.2d);
        g2.setColor(Color.WHITE);
        g2.fill(bounds);
        g2.setColor(Color.BLACK);
        g2.draw(bounds);
      // draw shapes  
        //ContainerManager containerManager=ObjectTable.getContainerManager();
        ShapeContainer[] containers=this.manager.getContainers();
        double scale=1.0;
        g2.scale(scale, scale);

        for(int i=0;i<containers.length;i++){
            containers[i].drawShape(g);
        }
        g2.setColor(currentColor);
        g2.scale(1d/scale, 1d/scale);
    }
    
    public void drop(DropTargetDropEvent e) {
        System.out.println("DrawPanel.drop called");
        if (e.isDataFlavorSupported(TransferableComponent.componentFlavor)) {
            e.acceptDrop(DnDConstants.ACTION_COPY);
        }else{
            e.rejectDrop();
            return;
        }
        Transferable transferable = e.getTransferable(); // Holds the dropped data
        ShapeContainer container;
        try {
            container=(ShapeContainer)transferable.getTransferData(TransferableComponent.componentFlavor);
        } catch (Exception ex) {
            e.dropComplete(false);
            return;
        }
       // 
        Point p = e.getLocation(); 
        ComponentLibDialog dialog=ObjectTable.getComponentLibDialog();
        Point pos=SwingUtilities.convertPoint(this, p, dialog);
        Dimension dim=dialog.getSize();
        if(pos.x>=0&&pos.x<=dim.width&&pos.y>=0&&pos.y<=dim.height){
            if(debug>=0) System.out.println("** Warning drop point is inside "
                    + "ComponentLibDialog drop p="+p+", pos="+pos
                    +", ComponentLibDialog size="+dim);
            e.dropComplete(false);
            return;
        }
        ContainerManager manager=this.getContainerManager();
        int index=manager.size();
        container.setShapeId("Dnd_Component-"+index);
        this.getContainerManager().addContainer(container);
        Rectangle2D box=container.getBoundingBox();
        container.translate(p.getX()-0.5*box.getWidth(), p.getY()-0.5*box.getHeight());
        this.repaint();
        e.dropComplete(true);
    }

    public void dragEnter(DropTargetDragEvent e) {}
    public void dragExit(DropTargetEvent e) {}
    public void dropActionChanged(DropTargetDragEvent e) {}
    public void dragOver(DropTargetDragEvent e) {}
}//end of DrawPanel
