/*
 * Decompiled with CFR 0.152.
 */
package DrawTop;

public class Command {
    int commandId = -1;
    int callFrom = 0;
    Object[] params;
    static int debug = 0;
    public static final int NEW = 0;
    public static final int OPEN = 1;
    public static final int SAVE = 2;
    public static final int SAVEAS = 3;
    public static final int PAGE = 4;
    public static final int NEXT_PAGE = 5;
    public static final int PREVIOUS_PAGE = 6;
    public static final int LAST_PAGE = 7;
    public static final int TOP_PAGE = 8;
    public static final int INSERT_NEW_PAGE = 9;
    public static final int DELETE_PAGE = 10;
    public static final int PAGE_SETUP = 12;
    public static final int PAGE_LAYOUT = 13;
    public static final int PRINT = 14;
    public static final int EXIT = 17;
    public static final int EDIT = 20;
    public static final int CUT = 21;
    public static final int COPY = 22;
    public static final int PASTE = 23;
    public static final int DEL = 24;
    public static final int DELETE = 25;
    public static final int SELECT_ALL = 26;
    public static final int UNDO = 30;
    public static final int REDO = 31;
    public static final int CLICKEDPOINT = 32;
    public static final int SELECTION = 33;
    public static final int SHAPE = 40;
    public static final int TEXTBOX = 41;
    public static final int RECTANGLE = 43;
    public static final int ROUND_RECTANGLE = 44;
    public static final int ELLIPSE = 45;
    public static final int IMAGE = 46;
    public static final int COMPONENT_SHAPE = 39;
    public static final int LINE = 51;
    public static final int ARROW = 52;
    public static final int DOUBLE_ARROW = 53;
    public static final int POLYLINE = 54;
    public static final int CUBIC_CURVE = 55;
    public static final int GENERAL_CURVE = 56;
    public static final int COMBINED_CURVE = 57;
    public static final int AUTO_SHAPE_FIRST = 41;
    public static final int AUTO_SHAPE_LAST = 57;
    public static final int AUX = 60;
    public static final int CENTER_LINE = 61;
    public static final int LINE_BISECTOR = 62;
    public static final int ANGLE_BISECTOR = 63;
    public static final int LIB = 80;
    public static final int MOVE = 81;
    public static final int RESIZE = 82;
    public static final int MOVE_ENDPT = 83;
    public static final int UTIL = 85;
    public static final int ADD_TEXTBOX = 86;
    public static final int DELETE_TEXTBOX = 87;
    public static final int TRANSLATE = 88;
    public static final int ROTATE = 89;
    public static final int FLIP = 90;
    public static final int EXTEND_CURVE = 91;
    public static final int CUT_SHAPE = 92;
    public static final int CONNECT_CURVES = 93;
    public static final int COMBINE = 94;
    public static final int BREAK = 95;
    public static final int CHANGE_SHAPE = 100;
    public static final int MODIFY_SHAPE = 101;
    public static final int MOVE_POINT = 102;
    public static final int MOVE_EDGE = 104;
    public static final int ADD_POINT = 105;
    public static final int DELETE_POINT = 106;
    public static final int SMOOTH = 107;
    public static final int CUSP = 108;
    public static final int DISCONNECT = 109;
    public static final int SETTING = 110;
    public static final int AUTO_ALIGN = 111;
    public static final int ENABLE_CONNECTOR = 112;
    public static final int FREE_DIRECTION = 113;
    public static final int KEEP_XY_DIRECTION = 114;
    public static final int KEEP_DIRECTION = 117;
    public static final int TO_NEAREST_PT = 116;
    public static final int HIGHLIGHTING_FOR_SELECTION = 118;
    public static final int DRAW_NODE_POINTS = 119;
    public static final int SHAPE_FORMAT = 120;
    public static final int DRAW_PANEL_INFORMATION = 121;
    public static final int FONT = 130;
    public static final int FONT_FAMILY = 131;
    public static final int FONT_SIZE = 132;
    public static final int BOLD = 133;
    public static final int ITALIC = 134;
    public static final int UNDERLINE = 135;
    public static final int SUBSCRIPT = 136;
    public static final int SUPERSCRIPT = 137;
    public static final int FONT_COLOR = 138;
    public static final int TEXTBOX_LAYOUT = 140;
    public static final int TEXT_ALIGN = 142;
    public static final int TEXT_ALIGN_LEFT = 143;
    public static final int TEXT_ALIGN_CENTER = 144;
    public static final int TEXT_ALIGN_RIGHT = 145;
    public static final int FILL_COLOR = 150;
    public static final int LINE_COLOR = 151;
    public static final int LINE_WIDTH = 152;
    public static final int LINE_STROKE = 153;
    public static final int ARROW_STYLE = 154;
    public static final int Z_ORDER = 160;
    public static final int MOVE_TO_FRONT = 161;
    public static final int MOVE_TO_BACK = 162;
    public static final int MOVE_FORWARD = 163;
    public static final int MOVE_BACKWARD = 164;
    public static final int ALIGN = 170;
    public static final int ALIGN_LEFT = 171;
    public static final int ALIGN_CENTER = 172;
    public static final int ALIGN_RIGHT = 173;
    public static final int ALIGN_TOP = 174;
    public static final int ALIGN_MIDDLE = 175;
    public static final int ALIGN_BOTTOM = 176;
    public static final int GROUP = 180;
    public static final int UNGROUP = 181;
    public static final int REGROUP = 182;
    public static final int ZOOM = 185;
    public static final int ZOOM_TO = 186;
    public static final int DEBUG = 190;
    public static final int TEST = 191;
    public static final int GEOMTEST = 192;
    public static final int DRAW_BOUNDING_BOX = 193;
    public static final int DRAW_CHARACTERISTIC_PT = 194;
    public static final int DRAW_TEXTLAYOUT_BOUND = 195;
    public static final int UNSELECTABLE_AREAS = 196;
    public static final int CONNECTION_TEST = 197;
    public static final int DRAWPANEL_POPUP_MENU = 200;
    public static final int SHAPE_POPUP_MENU = 201;
    public static final int GROUP_POPUP_MENU = 202;
    public static final int TEXTBOX_POPUP_MENU = 203;
    public static final int ABORT_COMMAND = 209;
    public static final int ORIGINAL_TYPE = 250;
    public static final int ENABLE_RESIZING = 253;
    public static final int KEEP_ASPECT_RATIO = 255;
    public static final int KEEP_LINE_DIRECTION = 256;
    public static final int KEEP_CONNECTOR_CONNECTIONS = 257;
    public static final int ENABLE_UNGROUPING = 259;
    static String[] commandString = new String[300];
    public static final int NORMAL_MODE = 0;
    public static final int CREATING_MODE = 1;
    public static final int MOVING_MODE = 2;
    public static final int RESIZING_MODE = 3;
    public static final int MOVING_ENDPT_MODE = 4;
    public static final int MODIFYING_SHAPE_MODE = 5;
    static final String[] modeString = new String[]{"NORMAL_MODE", "CREATING_MODE", "MOVING_MODE", "RESIZE_MODE", "MOVE_ENDPT_MODE", "MODIFY_SHAPE_MODE"};
    public static final int callFromMenu = 1;
    public static final int callFromMousePositionLS = 2;
    public static final int callFromSelectionLS = 3;
    public static final int callFromMouseListener = 4;
    public static final int callFromDialog = 5;
    static final String[] callFromString = new String[]{"        ", "Menu", "MousePositionLS", "SelectionLS", "MouseListener", "Dialog"};

    public Command() {
        this.setCommandStrings();
    }

    public Command(int commandId, int callFrom, Object[] params) {
        this.commandId = commandId;
        this.callFrom = callFrom;
        this.params = params;
    }

    public int getCommandId() {
        return this.commandId;
    }

    public int getCallFrom() {
        return this.callFrom;
    }

    public Object[] getParams() {
        return this.params;
    }

    public String toString() {
        String str = "name=";
        str = str + Command.getCommandString(this.commandId) + ", commandId=" + this.commandId + ", callFrom=" + Command.getCallFromString(this.callFrom);
        Object[] args = this.getParams();
        if (args == null || args.length == 0) {
            str = str + ", args=null";
        } else {
            for (int i = 0; i < args.length; ++i) {
                str = str + "\n  args[" + i + "]=" + "(type: " + args[i].getClass().getSimpleName() + "), details=" + args[i];
            }
        }
        return str;
    }

    private void setCommandStrings() {
        for (int i = 0; i < commandString.length; ++i) {
            Command.commandString[i] = "";
        }
        this.setCommandString(0, "NEW");
        this.setCommandString(1, "OPEN");
        this.setCommandString(2, "SAVE");
        this.setCommandString(3, "SAVEAS");
        this.setCommandString(4, "PAGE");
        this.setCommandString(5, "NEXT_PAGE");
        this.setCommandString(6, "PREVIOUS_PAGE");
        this.setCommandString(7, "LAST_PAGE");
        this.setCommandString(8, "TOP_PAGE");
        this.setCommandString(9, "INSERT_NEW_PAGE");
        this.setCommandString(10, "DELETE_PAGE");
        this.setCommandString(12, "PAGE_SETUP");
        this.setCommandString(13, "PAGE_LAYOUT");
        this.setCommandString(14, "PRINT");
        this.setCommandString(17, "EXIT");
        this.setCommandString(20, "EDIT");
        this.setCommandString(21, "CUT");
        this.setCommandString(22, "COPY");
        this.setCommandString(23, "PASTE");
        this.setCommandString(24, "DEL");
        this.setCommandString(25, "DELETE");
        this.setCommandString(26, "SELECT_ALL");
        this.setCommandString(30, "UNDO");
        this.setCommandString(31, "REDO");
        this.setCommandString(32, "CLICKEDPOINT");
        this.setCommandString(33, "SELECTION");
        this.setCommandString(40, "SHAPE");
        this.setCommandString(41, "TEXTBOX");
        this.setCommandString(43, "RECTANGLE");
        this.setCommandString(44, "ROUND_RECTANGLE");
        this.setCommandString(45, "ELLIPSE");
        this.setCommandString(46, "IMAGE");
        this.setCommandString(39, "COMPONENT_SHAPE");
        this.setCommandString(51, "LINE");
        this.setCommandString(52, "ARROW");
        this.setCommandString(53, "DOUBLE_ARROW");
        this.setCommandString(54, "POLYLINE");
        this.setCommandString(55, "CUBIC_CURVE");
        this.setCommandString(56, "GENERAL_CURVE");
        this.setCommandString(57, "COMBINED_CURVE");
        this.setCommandString(60, "AUX");
        this.setCommandString(61, "CENTER_LINE");
        this.setCommandString(62, "LINE_BISECTOR");
        this.setCommandString(63, "ANGLE_BISECTOR");
        this.setCommandString(80, "LIB");
        this.setCommandString(81, "MOVE");
        this.setCommandString(82, "RESIZE");
        this.setCommandString(83, "MOVE_ENDPT");
        this.setCommandString(85, "UTIL");
        this.setCommandString(86, "ADD_TEXTBOX");
        this.setCommandString(87, "DELETE_TEXTBOX");
        this.setCommandString(88, "TRANSLATE");
        this.setCommandString(89, "ROTATE");
        this.setCommandString(90, "FLIP");
        this.setCommandString(91, "EXTEND_CURVE");
        this.setCommandString(92, "CUT_SHAPE");
        this.setCommandString(93, "CONNECT_CURVES");
        this.setCommandString(100, "CHANGE_SHAPE");
        this.setCommandString(101, "MODIFY_SHAPE");
        this.setCommandString(94, "COMBINE");
        this.setCommandString(95, "BREAK");
        this.setCommandString(102, "MOVE_POINT");
        this.setCommandString(104, "MOVE_EDGE");
        this.setCommandString(105, "ADD_POINT");
        this.setCommandString(106, "DELETE_POINT");
        this.setCommandString(107, "SMOOTH");
        this.setCommandString(108, "CUSP");
        this.setCommandString(109, "DISCONNECT");
        this.setCommandString(110, "SETTING");
        this.setCommandString(111, "AUTO_ALIGN");
        this.setCommandString(112, "ENABLE_CONNECTOR");
        this.setCommandString(113, "FREE_DIRECTION");
        this.setCommandString(114, "KEEP_XY_DIRECTION");
        this.setCommandString(117, "KEEP_DIRECTION");
        this.setCommandString(116, "TO_NEAREST_PT");
        this.setCommandString(118, "HIGHLIGHTING_FOR_SELECTION");
        this.setCommandString(119, "DRAW_NODE_POINTS");
        this.setCommandString(120, "SHAPE_FORMAT");
        this.setCommandString(121, "DRAW_PANEL_INFORMATION");
        this.setCommandString(130, "FONT");
        this.setCommandString(131, "FONT_FAMILY");
        this.setCommandString(132, "FONT_SIZE");
        this.setCommandString(133, "BOLD");
        this.setCommandString(134, "ITALIC");
        this.setCommandString(136, "SUBSCRIPT");
        this.setCommandString(137, "SUPERSCRIPT");
        this.setCommandString(135, "UNDERLINE");
        this.setCommandString(138, "FONT_COLOR");
        this.setCommandString(140, "TEXTBOX_LAYOUT");
        this.setCommandString(142, "TEXT_ALIGN");
        this.setCommandString(143, "TEXT_ALIGN_LEFT");
        this.setCommandString(144, "TEXT_ALIGN_CENTER");
        this.setCommandString(145, "TEXT_ALIGN_RIGHT");
        this.setCommandString(150, "FILL_COLOR");
        this.setCommandString(151, "LINE_COLOR");
        this.setCommandString(152, "LINE_WIDTH");
        this.setCommandString(153, "LINE_STROKE");
        this.setCommandString(154, "ARROW_STYLE");
        this.setCommandString(170, "ALIGN");
        this.setCommandString(171, "ALIGN_LEFT");
        this.setCommandString(172, "ALIGN_CENTER");
        this.setCommandString(173, "ALIGN_RIGHT");
        this.setCommandString(174, "ALIGN_TOP");
        this.setCommandString(175, "ALIGN_MIDDLE");
        this.setCommandString(176, "ALIGN_BOTTOM");
        this.setCommandString(160, "Z_ORDER");
        this.setCommandString(161, "MOVE_TO_FRONT");
        this.setCommandString(162, "MOVE_TO_BACK");
        this.setCommandString(163, "MOVE_FORWARD");
        this.setCommandString(164, "MOVE_BACKWARD");
        this.setCommandString(180, "GROUP");
        this.setCommandString(181, "UNGROUP");
        this.setCommandString(185, "ZOOM");
        this.setCommandString(186, "ZOOM_TO");
        this.setCommandString(191, "TEST");
        this.setCommandString(192, "GEOMTEST");
        this.setCommandString(193, "DRAW_BOUNDING_BOX");
        this.setCommandString(194, "DRAW_CHARACTERISTIC_PT");
        this.setCommandString(195, "DRAW_TEXTLAYOUT_BOUND");
        this.setCommandString(196, "UNSELECTABLE_AREAS");
        this.setCommandString(197, "CONNECTION_TEST");
        this.setCommandString(190, "DEBUG");
        this.setCommandString(200, "DRAWPANEL_POPUP_MENU");
        this.setCommandString(201, "SHAPE_POPUP_MENU");
        this.setCommandString(202, "GROUP_POPUP_MENU");
        this.setCommandString(203, "TEXTBOX_POPUP_MENU");
        this.setCommandString(209, "ABORT_COMMAND");
        this.setCommandString(250, "ORIGINAL_TYPE");
        this.setCommandString(253, "ENABLE_RESIZING");
        this.setCommandString(255, "KEEP_ASPECT_RATIO");
        this.setCommandString(256, "KEEP_LINE_DIRECTION");
        this.setCommandString(257, "KEEP_CONNECTOR_CONNECTIONS");
        this.setCommandString(259, "ENABLE_UNGROUPING");
    }

    private void setCommandString(int commandId, String command) {
        if (!commandString[commandId].equals("")) {
            System.err.println("*** Warning: Command.setCommandString, CommandId duplicated, commandId=" + commandId + ", command=" + command);
        }
        Command.commandString[commandId] = command;
    }

    public static String getCommandString(int commandId) {
        String str = "";
        if (commandId < 0 || commandId >= commandString.length) {
            System.err.println("*** Error Command.getCommandString: illeagal commandId " + commandId);
            return str;
        }
        str = commandString[commandId];
        return str;
    }

    public static String getCommandString(String command) {
        String str = "";
        int size = commandString.length;
        for (int i = 0; i < size; ++i) {
            if (!Command.compareStrings(command, commandString[i])) continue;
            str = commandString[i];
            break;
        }
        return str;
    }

    public static String getCommandLowerString(int commandId) {
        String str = "";
        if (commandId < 0 || commandId >= commandString.length) {
            System.err.println("*** Error Command.getCommandLowercaseString: illeagal commandId " + commandId);
            return str;
        }
        str = commandString[commandId];
        if (!str.equals("")) {
            str = str.toLowerCase();
            str = str.replace("_", " ");
        }
        return str;
    }

    public static String getCallFromString(int callFrom) {
        String str = "";
        if (callFrom <= callFromString.length) {
            str = callFromString[callFrom];
        }
        return str;
    }

    public static String getModeString(int modeId) {
        String str = "";
        int len = modeString.length;
        if (modeId < 0 || modeId > len - 1) {
            return str;
        }
        str = modeString[modeId];
        return str;
    }

    public static int getCommandId(String command) {
        int id = -1;
        if (command == null || command.equals("")) {
            System.err.println("*** Error in Command.getCommandId: argument command=null");
            return id;
        }
        for (int i = 0; i < commandString.length; ++i) {
            if (commandString[i].equals("") || !command.substring(0, 1).equalsIgnoreCase(commandString[i].substring(0, 1)) || !Command.compareStrings(command, commandString[i])) continue;
            id = i;
            break;
        }
        if (debug > 0) {
            System.out.println("** Command.getCommandId command=" + command + ", id=" + id);
        }
        return id;
    }

    public static boolean compareStrings(String str1, String str2) {
        boolean equal = false;
        if (str1.equals("") || str2.equals("")) {
            return false;
        }
        String compressedStr1 = str1.replace(" ", "");
        compressedStr1 = compressedStr1.replace("_", "");
        compressedStr1 = compressedStr1.replace(".", "");
        String compressedStr2 = str2.replace(" ", "");
        compressedStr2 = compressedStr2.replace("_", "");
        if (compressedStr1.compareToIgnoreCase(compressedStr2 = compressedStr2.replace(".", "")) == 0) {
            equal = true;
        }
        return equal;
    }
}

