/*
 * Decompiled with CFR 0.152.
 */
package geomExtension;

import geomExtension.CubicCurve2DE;
import geomExtension.Curve2D;
import geomExtension.Line2DE;
import geomExtension.Polyline2DE;
import geomExtension.Segment2D;
import geomExtension.Vector2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.Vector;
import shape.PathConnect;
import shape.PathSegment;

public class GeneralCurve2DE
extends Curve2D {
    int debug = 0;

    public GeneralCurve2DE(Segment2D[] segments) {
        this.setData(segments);
    }

    @Override
    public void setData(Segment2D[] segments) {
        this.segments = segments;
        this.generalPath = new GeneralPath(0);
        Point2D startP = segments[0].getP(0.0);
        Point2D endP = null;
        for (int i = 0; i < segments.length; ++i) {
            if (segments[i].getType() == 0) {
                if (i == 0 || i == segments.length - 1) {
                    System.err.println("*** ERROR GeneralCurve2DE");
                    continue;
                }
                endP = segments[i - 1].getP(1.0);
                if (Vector2D.dist(startP, endP) < 1.0E-5) {
                    this.generalPath.closePath();
                }
                startP = segments[i + 1].getP(0.0);
                this.generalPath.moveTo(startP.getX(), startP.getY());
            } else {
                Shape shape = segments[i].getShape();
                this.generalPath.append(shape, true);
            }
            if (i != segments.length - 1 || !(Vector2D.dist(startP, endP = segments[i].getP(1.0)) < 1.0E-5)) continue;
            this.generalPath.closePath();
        }
        this.closed = this.isClosed();
        String str = "";
        str = str + "*** GeneralCurve2DE pathtoString\n";
        str = str + this.toPathString();
        if (this.debug > 0) {
            System.out.println(str);
        }
    }

    @Override
    public int getType2DE() {
        return 56;
    }

    @Override
    public int getNumOfSubPaths() {
        int pathCount = 0;
        int localSegCount = 0;
        int error = 0;
        for (int i = 0; i < this.segments.length; ++i) {
            if (this.segments[i].getType() == 0) {
                if (localSegCount == 0) {
                    error = 1;
                }
                if (i == this.segments.length - 1) {
                    error = 2;
                }
                ++pathCount;
                localSegCount = 0;
                continue;
            }
            ++localSegCount;
        }
        if (error == 1) {
            System.err.println("*** ERROR in GeneralCurve2DE.getNumOfSubPaths: No segments before MOVETO");
        }
        if (error == 2) {
            System.err.println("*** ERROR in GeneralCurve2DE.getNumOfSubPaths: The last segmentis before MOVETO");
        }
        return pathCount + 1;
    }

    public int[] getNumOfLocalSegments() {
        int num = this.getNumOfSubPaths();
        int[] numseg = new int[num];
        int pathCount = 0;
        int localSegCount = 0;
        for (int i = 0; i < this.segments.length; ++i) {
            if (this.segments[i].getType() == 0) {
                numseg[pathCount] = localSegCount;
                ++pathCount;
                localSegCount = 0;
            } else {
                ++localSegCount;
            }
            if (i != this.segments.length - 1) continue;
            numseg[pathCount] = localSegCount;
        }
        return numseg;
    }

    public int getSubPathIndex(int segmentPtIndex) {
        if (segmentPtIndex < 0 || segmentPtIndex > this.segments.length) {
            System.err.println("*** ERROR in GeneralCurve2DE.getSubPathIndex: segmentPtIndex is out-of-bound, segmentPtIndex=" + segmentPtIndex);
            return -1;
        }
        int pathCount = 0;
        int localSegCount = -1;
        int max = Math.min(segmentPtIndex, this.segments.length);
        for (int i = 0; i < max; ++i) {
            if (this.segments[i].getType() == 0) {
                ++pathCount;
                localSegCount = -1;
                continue;
            }
            ++localSegCount;
        }
        return pathCount;
    }

    private int getLocalSegmentIndex(int segmentIndex) {
        if (segmentIndex < 0 || segmentIndex >= this.segments.length) {
            System.err.println("*** ERROR in GeneralCurve2DE.getLocalSegmentIndex: segmentPtIndex is out-of-bound, segmentIndex=" + segmentIndex);
            return -1;
        }
        int pathCount = 0;
        int localSegIndex = -1;
        for (int i = 0; i <= segmentIndex; ++i) {
            if (this.segments[i].getType() == 0) {
                ++pathCount;
                localSegIndex = -1;
                continue;
            }
            ++localSegIndex;
        }
        return localSegIndex;
    }

    public int getLocalSegmentPtIndex(int segmentPtIndex) {
        if (segmentPtIndex < 0 || segmentPtIndex > this.segments.length) {
            System.err.println("*** ERROR in GeneralCurve2DE.getLocalSegmentPtIndex: segmentPtIndex is out-of-bound, segmentPtIndex=" + segmentPtIndex);
            return -1;
        }
        int pathCount = 0;
        int localSegIndex = -1;
        for (int i = 0; i <= Math.min(segmentPtIndex, this.segments.length - 1); ++i) {
            if (this.segments[i].getType() == 0) {
                if (i == segmentPtIndex) {
                    return ++localSegIndex;
                }
                ++pathCount;
                localSegIndex = -1;
                continue;
            }
            ++localSegIndex;
        }
        if (segmentPtIndex == this.segments.length) {
            return ++localSegIndex;
        }
        return localSegIndex;
    }

    private int getGlobalSegmentIndex(int subPathIndex, int localSegmentIndex) {
        int numSubPath = this.getNumOfSubPaths();
        int[] numLocalSegs = this.getNumOfLocalSegments();
        if (subPathIndex < 0 || subPathIndex >= numSubPath) {
            System.err.println("*** ERROR in GeneralCurve2DE.getGlobalSegmentIndex: segmentPtIndex is out-of-bound, subPathIndex=" + subPathIndex);
            return -1;
        }
        if (localSegmentIndex < 0 || localSegmentIndex >= numLocalSegs[subPathIndex]) {
            System.err.println("*** ERROR in GeneralCurve2DE.getGlobalSegmentIndex: segmentPtIndex is out-of-bound, localSegmentIndex=" + localSegmentIndex);
            return -1;
        }
        int pathCount = 0;
        int localSegIndex = -1;
        int isave = -1;
        for (int i = 0; i < this.segments.length; ++i) {
            if (this.segments[i].getType() == 0) {
                ++pathCount;
                localSegIndex = -1;
            } else {
                ++localSegIndex;
            }
            if (pathCount != subPathIndex || localSegIndex != localSegmentIndex) continue;
            return i;
        }
        return isave;
    }

    public int getGlobalSegmentPtIndex(int subPathIndex, int localSegmentPtIndex) {
        int numSubPath = this.getNumOfSubPaths();
        int[] numLocalSegs = this.getNumOfLocalSegments();
        if (subPathIndex < 0 || subPathIndex >= numSubPath) {
            System.err.println("*** ERROR in GeneralCurve2DE.getGlobalSegmentIndex: segmentPtIndex is out-of-bound, subPathIndex=" + subPathIndex);
            return -1;
        }
        if (localSegmentPtIndex < 0 || localSegmentPtIndex > numLocalSegs[subPathIndex]) {
            System.err.println("*** ERROR in GeneralCurve2DE.getGlobalSegmentIndex: segmentPtIndex is out-of-bound, subPathIndex=" + subPathIndex + ", localSegmentPtIndex=" + localSegmentPtIndex);
            return -1;
        }
        int pathCount = 0;
        int localSegIndex = -1;
        int isave = -1;
        for (int i = 0; i < this.segments.length; ++i) {
            if (this.segments[i].getType() == 0) {
                if (pathCount == subPathIndex && localSegIndex + 1 == localSegmentPtIndex) {
                    return i;
                }
                ++pathCount;
                localSegIndex = -1;
            } else {
                ++localSegIndex;
            }
            if (pathCount != subPathIndex || localSegIndex != localSegmentPtIndex) continue;
            return i;
        }
        if (pathCount == subPathIndex && localSegIndex + 1 == localSegmentPtIndex) {
            return this.segments.length;
        }
        return isave;
    }

    private Segment2D[] getSubPathSegments(int subPathIndex) {
        int pathCount = 0;
        Vector<Segment2D> vector = new Vector<Segment2D>();
        for (int i = 0; i < this.segments.length; ++i) {
            if (this.segments[i].getType() == 0) {
                ++pathCount;
                continue;
            }
            if (subPathIndex != pathCount) continue;
            vector.add(this.segments[i]);
        }
        Segment2D[] pathSegments = new Segment2D[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            pathSegments[i] = (Segment2D)vector.get(i);
        }
        return pathSegments;
    }

    private GeneralCurve2DE getSubPath(int index) {
        Segment2D[] path = this.getSubPathSegments(index);
        GeneralCurve2DE curve = new GeneralCurve2DE(path);
        return curve;
    }

    public GeneralCurve2DE[] getSubPaths() {
        int numPath = this.getNumOfSubPaths();
        GeneralCurve2DE[] curves = new GeneralCurve2DE[numPath];
        for (int i = 0; i < numPath; ++i) {
            curves[i] = this.getSubPath(i);
            if (this.debug <= 0) continue;
            System.out.println("GeneralCurve2DE.getPathCurves i=" + i + ", PathCurve:" + curves[i].toString());
        }
        return curves;
    }

    public void setSubPaths(Curve2D[] curves) {
        int numPath = curves.length;
        boolean[] closed = new boolean[numPath];
        Point2D[][] endP = new Point2D[numPath][2];
        for (int i = 0; i < numPath; ++i) {
            Point2D P1;
            closed[i] = false;
            Curve2D curve = curves[i];
            int numseg = curve.getNumOfSegments();
            Point2D P0 = curve.getP(0.0);
            if (Vector2D.dist(P0, P1 = curve.getP(numseg)) < 1.0E-5) {
                closed[i] = true;
            }
            endP[i][0] = P0;
            endP[i][1] = P1;
        }
        PathConnect con = new PathConnect();
        PathSegment[][] paths = con.findPaths(endP);
        int numPaths = paths.length;
        if (this.debug > 0) {
            String str = "\nGeneralCurve2DE.setSubPaths paths list";
            for (int i = 0; i < numPaths; ++i) {
                int len = paths[i].length;
                if (len == 0) continue;
                str = str + "\npath no.=" + i;
                for (int j = 0; j < len; ++j) {
                    PathSegment pathSeg = paths[i][j];
                    str = str + "\n  -- pathSegment " + pathSeg.toString();
                }
            }
            System.out.println(str);
        }
        int totalNumSeg = 0;
        for (int i = 0; i < curves.length; ++i) {
            totalNumSeg += curves[i].getNumOfSegments();
        }
        Segment2D[] segments = new Segment2D[totalNumSeg + numPaths - 1];
        Segment2D moveSeg = new Segment2D(0, null);
        int index = 0;
        for (int i = 0; i < numPaths; ++i) {
            int numSubPaths = paths[i].length;
            for (int j = 0; j < numSubPaths; ++j) {
                int curveIndex = paths[i][j].id;
                boolean reversed = paths[i][j].reversed;
                if (reversed) {
                    curves[curveIndex].reverse();
                }
                Segment2D[] segs = curves[curveIndex].getSegment2Ds();
                for (int k = 0; k < segs.length; ++k) {
                    segments[index] = (Segment2D)segs[k].clone();
                    ++index;
                }
            }
            if (i == numPaths - 1) continue;
            segments[index] = (Segment2D)moveSeg.clone();
            ++index;
        }
        this.setData(segments);
        if (this.debug > 0) {
            System.out.println(this.toString());
        }
    }

    @Override
    public boolean isClosed() {
        Point2D p1;
        boolean closed = false;
        if (this.getNumOfSubPaths() != 1) {
            return false;
        }
        int numseg = this.getNumOfSegments();
        Point2D p0 = this.segments[0].getP(0.0);
        if (Vector2D.dist(p0, p1 = this.segments[numseg - 1].getP(1.0)) < 3.0) {
            closed = true;
        }
        return closed;
    }

    public GeneralCurve2DE getTrimmedCurve2D(double t1, double t2) {
        GeneralCurve2DE trimmedCurve = null;
        Vector<Segment2D> vector = new Vector<Segment2D>();
        int it1 = (int)t1;
        int it2 = (int)t2;
        if (this.segments[it1].getType() == 0) {
            System.out.println("*** WARNING GeneralCurve2DE getTrimmedCurve2D  t1 is on MOVETO segment t1=" + t1);
            ++it1;
        }
        if (this.segments[it2].getType() == 0) {
            System.out.println("*** WARNING GeneralCurve2DE getTrimmedCurve2D  t1 is on MOVETO segment t2=" + t2);
            --it2;
        }
        for (int i = it1; i <= it2; ++i) {
            double t01 = 0.0;
            double t02 = 1.0;
            if (i == it1) {
                t01 = t1 - (double)it1;
            }
            if (i == it2) {
                t02 = t2 - (double)it2;
            }
            Segment2D segment = this.getSegment2D(i);
            if (!(Math.abs(t02 - t01) > 1.0E-5)) continue;
            Segment2D subSegment = segment.trimSegment(t01, t02);
            vector.add(subSegment);
        }
        int size = vector.size();
        if (size == 0) {
            return null;
        }
        Segment2D[] segments = new Segment2D[size];
        for (int i = 0; i < size; ++i) {
            segments[i] = (Segment2D)vector.get(i);
        }
        trimmedCurve = new GeneralCurve2DE(segments);
        return trimmedCurve;
    }

    public Curve2D[] getSimpleCurve2Ds() {
        GeneralCurve2DE[] gcurves = this.getSubPaths();
        Curve2D[] curves = new Curve2D[gcurves.length];
        for (int i = 0; i < gcurves.length; ++i) {
            curves[i] = gcurves[i].getSimpleCurve2D();
        }
        if (this.debug > 0) {
            String str = "** GeneralCurve2DE.getSimpleCurve2Ds num=" + curves.length;
            for (int i = 0; i < curves.length; ++i) {
                str = str + "\n SimpleCurve[" + i + "]: " + curves[i].toString();
            }
            System.out.println(str);
        }
        return curves;
    }

    public Curve2D getSimpleCurve2D() {
        int size = this.getNumOfSegments();
        boolean line = false;
        boolean arc = false;
        boolean cubic = false;
        for (int i = 0; i < size; ++i) {
            int type = this.getSegment2D(i).getType();
            if (type == 1) {
                line = true;
            }
            if (type == 2) {
                arc = true;
            }
            if (type != 3) continue;
            cubic = true;
        }
        Curve2D simpleCurve = (GeneralCurve2DE)this.clone();
        if (line && !arc && !cubic && size == 1) {
            Segment2D lineSegment = this.getSegment2D(0);
            lineSegment.getP(0.0);
            simpleCurve = new Line2DE(lineSegment.getP(0.0), lineSegment.getP(1.0));
        }
        if (line && !arc && !cubic && size > 1) {
            Segment2D[] newSegments = new Segment2D[size];
            for (int i = 0; i < size; ++i) {
                newSegments[i] = (Segment2D)this.getSegment2D(i).clone();
            }
            simpleCurve = new Polyline2DE(newSegments);
        }
        boolean smooth = true;
        if (cubic && !line && !arc) {
            Segment2D[] newSegments = new Segment2D[size];
            for (int i = 0; i < size; ++i) {
                newSegments[i] = (Segment2D)this.getSegment2D(i).clone();
                if (i <= 0) continue;
                Vector2D tout = newSegments[i - 1].getTangent(1.0);
                Vector2D tin = newSegments[i].getTangent(0.0);
                double sprod = Vector2D.sproduct(tin, tout);
                sprod /= Vector2D.length(tin) * Vector2D.length(tout);
                if (!smooth || !(Math.abs(sprod) < 0.99999)) continue;
                smooth = false;
            }
            if (smooth) {
                simpleCurve = new CubicCurve2DE(newSegments);
            }
        }
        return simpleCurve;
    }

    @Override
    public Object clone() {
        int size = this.segments.length;
        Segment2D[] newSegments = new Segment2D[size];
        for (int i = 0; i < size; ++i) {
            Segment2D segment = this.segments[i];
            newSegments[i] = (Segment2D)segment.clone();
        }
        return new GeneralCurve2DE(newSegments);
    }

    @Override
    public String toString() {
        String str;
        block5: {
            int numPath;
            boolean detailed;
            block4: {
                detailed = true;
                str = "";
                numPath = this.getNumOfSubPaths();
                if (numPath != 1) break block4;
                int size = this.segments.length;
                str = str + "GeneralCurve, segments=" + size + ", close=" + this.closed;
                for (int j = 0; j < size; ++j) {
                    Segment2D segment = this.segments[j];
                    str = str + "\n   segment[" + j + "]=" + segment.toString();
                }
                break block5;
            }
            str = str + "GeneralCurve, num of subPaths=" + numPath;
            GeneralCurve2DE[] curves = this.getSubPaths();
            int[] numLocalSegs = this.getNumOfLocalSegments();
            for (int i = 0; i < numPath; ++i) {
                str = str + "\n - sub path=" + i + ", close=" + curves[i].isClosed();
                str = str + ", numseg=" + numLocalSegs[i] + ", startSegment=" + this.getGlobalSegmentPtIndex(i, 0) + ", endSegment=" + this.getGlobalSegmentPtIndex(i, numLocalSegs[i] - 1) + " [ start t-param=" + this.getGlobalSegmentPtIndex(i, 0) + ", end t-param=" + this.getGlobalSegmentPtIndex(i, numLocalSegs[i]) + " ]";
                Segment2D[] segments = this.getSubPathSegments(i);
                for (int j = 0; j < segments.length; ++j) {
                    Segment2D segment = segments[j];
                    str = str + "\n   segment[" + j + "]=" + segment.toString();
                }
            }
            if (!detailed) break block5;
            str = str + "\n - global path list";
            Segment2D[] segments = this.getSegment2Ds();
            for (int i = 0; i < this.getNumOfSegments(); ++i) {
                str = str + "\n   segment[" + i + "]=" + segments[i].toString();
            }
        }
        return str;
    }

    public void test() {
        int i;
        String str = "\n******** GeneralCurve2DE method test ********\n" + this.toString();
        System.out.println(str);
        int numPath = this.getNumOfSubPaths();
        int numGlobalSegs = this.getNumOfSegments();
        int[] numLocalSegs = this.getNumOfLocalSegments();
        str = "\n ++ getSubPathIndex, getLocalSegmentPtIndex test\n  ";
        for (i = 0; i <= numGlobalSegs; ++i) {
            str = str + " " + i + "=>(" + this.getSubPathIndex(i) + ", " + this.getLocalSegmentPtIndex(i) + "),";
        }
        System.out.println(str);
        str = " ++ getGlobalSegmentPtIndex test\n";
        for (i = 0; i < numPath; ++i) {
            str = str + "  -- subPath=" + i + ", numLocalseg=" + numLocalSegs[i] + "\n    ";
            for (int j = 0; j <= numLocalSegs[i]; ++j) {
                str = str + " (" + i + "," + j + ")=>" + this.getGlobalSegmentPtIndex(i, j) + " ";
            }
            str = str + "\n";
        }
        System.out.println(str);
    }
}

