/*
 * Decompiled with CFR 0.152.
 */
package geomExtension;

import java.text.NumberFormat;

public class Matrix {
    static double eps = 1.0E-12;

    public static double[] GaussianElimination(double[][] A0, double[] b0) {
        int i;
        int N = A0.length;
        double[][] A = new double[N][N];
        double[] b = new double[N];
        for (i = 0; i < N; ++i) {
            for (int j = 0; j < N; ++j) {
                A[i][j] = A0[i][j];
            }
            b[i] = b0[i];
        }
        for (i = 0; i < N; ++i) {
            int max = i;
            for (int ip = i + 1; ip < N; ++ip) {
                if (!(Math.abs(A[ip][i]) > Math.abs(A[max][i]))) continue;
                max = ip;
            }
            double[] temp = A[i];
            A[i] = A[max];
            A[max] = temp;
            double btemp = b[i];
            b[i] = b[max];
            b[max] = btemp;
            if (Math.abs(A[i][i]) <= eps) {
                System.out.println("** aussianElimination : Matrix is singular or nearly singular");
                throw new RuntimeException("Matrix is singular or nearly singular");
            }
            for (int ip = i + 1; ip < N; ++ip) {
                double alpha = A[ip][i] / A[i][i];
                int n = ip;
                b[n] = b[n] - alpha * b[i];
                for (int j = i; j < N; ++j) {
                    double[] dArray = A[ip];
                    int n2 = j;
                    dArray[n2] = dArray[n2] - alpha * A[i][j];
                }
            }
        }
        double[] x = new double[N];
        for (int i2 = N - 1; i2 >= 0; --i2) {
            double sum = 0.0;
            for (int j = i2 + 1; j < N; ++j) {
                sum += A[i2][j] * x[j];
            }
            x[i2] = (b[i2] - sum) / A[i2][i2];
        }
        return x;
    }

    public static double[][] InverseMatrix(double[][] A) {
        int i;
        int N = A.length;
        double[][] Ainv = new double[N][N];
        double[] b = new double[N];
        double[] x = new double[N];
        for (i = 0; i < N; ++i) {
            b[i] = 0.0;
        }
        for (i = 0; i < N; ++i) {
            b[i] = 1.0;
            if (i >= 1) {
                b[i - 1] = 0.0;
            }
            x = Matrix.GaussianElimination(A, b);
            for (int j = 0; j < N; ++j) {
                Ainv[j][i] = x[j];
            }
        }
        return Ainv;
    }

    public static double[][] multMatrix(double[][] A, double[][] B) {
        int N = A.length;
        double[][] C = new double[N][N];
        for (int i = 0; i < N; ++i) {
            for (int j = 0; j < N; ++j) {
                double sum = 0.0;
                for (int k = 0; k < N; ++k) {
                    sum += A[i][k] * B[k][j];
                }
                C[i][j] = sum;
            }
        }
        return C;
    }

    public static void print(double[][] A, double[] b, double[] x) {
        int j;
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumIntegerDigits(4);
        nf.setMinimumFractionDigits(4);
        System.out.println("** Print result of GaussianElimination");
        int len = A.length;
        for (int i = 0; i < len; ++i) {
            String str = "";
            for (int j2 = 0; j2 < len; ++j2) {
                str = str + " A[" + i + "," + j2 + "]=" + nf.format(A[i][j2]) + ",";
            }
            System.out.println(str);
        }
        String str = "";
        for (j = 0; j < len; ++j) {
            str = str + " b[" + j + "]=" + nf.format(b[j]) + ",";
        }
        System.out.println(str);
        str = " Solution;";
        for (j = 0; j < len; ++j) {
            str = str + " x[" + j + "]=" + nf.format(x[j]) + ",";
        }
        System.out.println(str);
        str = " Accuracy ";
        for (int i = 0; i < len; ++i) {
            double Ax = 0.0;
            for (int j3 = 0; j3 < len; ++j3) {
                Ax += A[i][j3] * x[j3];
            }
            double err = Math.abs(Ax - b[i]);
            str = str + "err[" + i + "]=" + err + ", ";
        }
        System.out.println(str);
    }
}

