/*
 * Decompiled with CFR 0.152.
 */
package menu;

import DrawTop.ObjectTable;
import java.awt.Dimension;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.KeyStroke;
import menu.AcceleratorsAction;
import menu.MenuUtil;

public class ButtonOfAccelerators
extends JButton {
    public static int debug = 0;

    public ButtonOfAccelerators(String commandName, String[] accelerators) {
        this.setName(commandName);
        this.setActionCommand(commandName);
        this.setAccelerators(accelerators);
        this.setPreferredSize(new Dimension(1, 10));
    }

    public void setAccelerators(String[] accelerators) {
        AcceleratorsAction action = new AcceleratorsAction();
        this.addActionListener(action);
        int size = 0;
        if (accelerators != null) {
            size = accelerators.length;
        }
        for (int i = 0; i < size; ++i) {
            KeyStroke stroke = KeyStroke.getKeyStroke(accelerators[i]);
            InputMap inputMap = this.getInputMap(2);
            inputMap.put(stroke, accelerators[i]);
            ActionMap actionMap = this.getActionMap();
            actionMap.put(accelerators[i], action);
            if (debug <= 0) continue;
            System.out.println("-- ButtonOfAcceleratoractionMap stroke=" + stroke + ", key=" + accelerators[i] + ", value=" + actionMap.get(accelerators[i]));
        }
    }

    public static ButtonOfAccelerators createEditAccelerators(String commandName) {
        String[] accelerators = new String[]{"ctrl x", "ctrl x", "ctrl v", "ctrl a", "delete"};
        ButtonOfAccelerators button = new ButtonOfAccelerators(commandName, accelerators);
        MenuUtil menuUtil = ObjectTable.getMenuUtil();
        menuUtil.setMenuComponent(button);
        if (debug > 0) {
            menuUtil.printMenuComponent(button);
        }
        return button;
    }
}

