/*
 * Decompiled with CFR 0.152.
 */
package menu;

import DrawTop.ObjectTable;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.border.BevelBorder;
import menu.DialogOfFontMenu;
import menu.MenuConstants;
import menu.MenuUtil;

public class ButtonOfFontMenu
extends JButton
implements ActionListener {
    DialogOfFontMenu dialog;
    public static int debug = 0;

    public ButtonOfFontMenu(String commandName, String tip, DialogOfFontMenu dialog) {
        this.setActionCommand(commandName);
        this.addActionListener(this);
        this.setName(commandName);
        this.setText(commandName);
        this.setToolTipText(tip);
        this.setStandardButtonStyle();
        this.dialog = dialog;
    }

    public ButtonOfFontMenu(String commandName, boolean setText, ImageIcon imageIcon, String tip, DialogOfFontMenu dialog) {
        super(imageIcon);
        this.setActionCommand(commandName);
        this.addActionListener(this);
        this.setName(commandName);
        if (setText) {
            this.setText(commandName);
        }
        this.setToolTipText(tip);
        this.setStandardButtonStyle();
        this.dialog = dialog;
    }

    public void setStandardButtonStyle() {
        BevelBorder raisedBorder = new BevelBorder(0);
        this.setBorder(raisedBorder);
        this.setHorizontalTextPosition(0);
        this.setIconTextGap(0);
        this.setVerticalTextPosition(3);
        this.setHorizontalAlignment(0);
        this.setFont(MenuConstants.MenuFont);
        this.setForeground(Color.BLACK);
        this.setOpaque(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.showDialog();
    }

    public void showDialog() {
        this.dialog.showDialog();
    }

    public static JButton createFontMenuButton(String commandName, int width, String tip) {
        DialogOfFontMenu dialog = new DialogOfFontMenu();
        ButtonOfFontMenu button = null;
        button = new ButtonOfFontMenu(commandName, tip, dialog);
        if (width > 0) {
            button.setPreferredSize(new Dimension(width, 22));
        }
        MenuUtil menuUtil = ObjectTable.getMenuUtil();
        menuUtil.setMenuComponent(button);
        if (debug > 0) {
            menuUtil.printMenuComponent(button);
        }
        return button;
    }
}

