/*
 * Decompiled with CFR 0.152.
 */
package menu;

import DrawTop.Command;
import DrawTop.ExecCommand;
import DrawTop.ObjectTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import menu.ButtonOfColorChooser;
import menu.ColorSelectionEvent;
import menu.ColorSelectionListener;
import menu.CustomColorChooserDialog;

class ColorChooserAction
extends AbstractAction
implements ColorSelectionListener {
    ButtonOfColorChooser buttonOfColorChooser = null;
    String commandName;
    int debug = 0;

    public ColorChooserAction(ButtonOfColorChooser buttonOfColorChooser) {
        this.buttonOfColorChooser = buttonOfColorChooser;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.commandName = e.getActionCommand();
        String componentClassName = "";
        componentClassName = e.getSource().getClass().getSimpleName();
        String componentName = ((Component)e.getSource()).getName();
        if (this.debug > 0) {
            System.out.println("- ColorChooserAction.actionPerformed  commandName=" + this.commandName + ", source component name=" + componentName + ", source class simple name=" + componentClassName);
        }
        CustomColorChooserDialog dialog = ObjectTable.getCustomColorChooserDialog();
        String title = "";
        if (this.commandName.equals("fill color")) {
            title = "  Command: fill color";
        }
        if (this.commandName.equals("line color")) {
            title = "  Command: line color";
        }
        if (this.commandName.equals("font color")) {
            title = "  Command: font color";
        }
        dialog.commandLabel.setText(title);
        dialog.removeColorSelectionListener();
        dialog.addColorSelectionListener(this);
        dialog.showDialog(this.commandName);
    }

    @Override
    public void colorSelected(ColorSelectionEvent event) {
        Color selectedColor = event.getColor();
        if (this.debug > 0) {
            System.out.println("** ColorSelectionListener colorSelected event.getColor()=" + event.getColor());
        }
        if (selectedColor == null) {
            return;
        }
        Object[] args = new Object[]{selectedColor};
        int commandId = Command.getCommandId(this.commandName);
        if (commandId < 0) {
            System.err.println("*** Error ColorChooserAction: specified command not found;" + this.commandName);
            return;
        }
        if (this.debug > 0) {
            System.out.println("** ColorChooserAction colorSelected commandName=" + this.commandName);
        }
        Command command = new Command(commandId, 1, args);
        ExecCommand execCommand = ObjectTable.getExecCommand("ColorChooserAction");
        execCommand.exec(command);
    }
}

