/*
 * Decompiled with CFR 0.152.
 */
package menu;

import DrawTop.ObjectTable;
import DrawTop.SelectionEvent;
import DrawTop.SelectionListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import javax.swing.event.EventListenerList;
import menu.ColorSelectionEvent;
import menu.ColorSelectionListener;
import menu.ImportedColorsPanel;
import menu.PreviewPanel;
import shape.ShapeContainer;
import util.ContainerManager;

public class CustomColorChooserDialog
extends JDialog
implements ActionListener,
ComponentListener,
WindowListener,
SelectionListener {
    String commandName = "";
    JLabel commandLabel;
    JColorChooser colorChooser;
    PreviewPanel previewPanel;
    ImportedColorsPanel importedColorsPanel;
    Point dialogLocation = new Point(100, 100);
    JButton okButton;
    JButton cancelButton;
    JButton importButton;
    JButton deleteButton;
    protected EventListenerList listenerList = new EventListenerList();
    int debug = 0;

    public CustomColorChooserDialog(JFrame frame) {
        super(frame, "Custom Color Chooser", false);
        this.initializeDialog();
        this.addComponentListener(this);
    }

    private void initializeDialog() {
        Container contentPane = this.getContentPane();
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout());
        this.commandLabel = new JLabel("command:");
        this.commandLabel.setOpaque(true);
        this.commandLabel.setForeground(Color.WHITE);
        this.commandLabel.setBackground(Color.BLACK);
        this.commandLabel.setFont(new Font("Dialog", 1, 14));
        this.commandLabel.setPreferredSize(new Dimension(520, 20));
        topPanel.add((Component)this.commandLabel, "West");
        this.colorChooser = new JColorChooser();
        this.colorChooser.setPreviewPanel(new JLabel("Preview", 0));
        this.colorChooser.getInputMap().put(KeyStroke.getKeyStroke(37, 0), 0);
        this.colorChooser.getInputMap().put(KeyStroke.getKeyStroke(39, 0), 0);
        topPanel.add((Component)this.colorChooser, "South");
        JPanel basePanel = new JPanel();
        basePanel.setLayout(new BoxLayout(basePanel, 0));
        TitledBorder baseBorder = BorderFactory.createTitledBorder("");
        basePanel.setBorder(baseBorder);
        this.importedColorsPanel = new ImportedColorsPanel();
        TitledBorder currentColorBorder = BorderFactory.createTitledBorder("Imported colors");
        JPanel importedColorsPanel = new JPanel();
        importedColorsPanel.setBorder(currentColorBorder);
        importedColorsPanel.add(this.importedColorsPanel);
        JPanel buttonBasePanel = new JPanel();
        this.importButton = new JButton("import colors");
        this.deleteButton = new JButton("delete colors");
        this.importButton.setPreferredSize(new Dimension(105, 20));
        this.deleteButton.setPreferredSize(new Dimension(110, 20));
        String tip = "Select shapes on the canvas and click this button, then the colors will be imported to the left pallete.";
        this.importButton.setToolTipText(tip);
        tip = "Select colors on the left pallete and press this button, then the selected colors will be deleted.";
        this.deleteButton.setToolTipText(tip);
        this.importButton.setActionCommand("import");
        this.deleteButton.setActionCommand("delete");
        this.importButton.addActionListener(this);
        this.deleteButton.addActionListener(this);
        Box box = Box.createVerticalBox();
        buttonBasePanel.add(box);
        box.add(this.importButton);
        box.add(Box.createVerticalStrut(15));
        box.add(this.deleteButton);
        importedColorsPanel.add(buttonBasePanel);
        this.previewPanel = new PreviewPanel(this);
        TitledBorder previewBorder = BorderFactory.createTitledBorder("Preview");
        JPanel previewBasePanel = new JPanel();
        previewBasePanel.setBorder(previewBorder);
        previewBasePanel.add(this.previewPanel);
        basePanel.add(previewBasePanel);
        basePanel.add(importedColorsPanel);
        contentPane.add((Component)basePanel, "Center");
        contentPane.add((Component)topPanel, "North");
        JPanel buttonPanel = new JPanel();
        this.okButton = new JButton("OK !");
        this.cancelButton = new JButton("Cancel");
        this.okButton.setPreferredSize(new Dimension(60, 24));
        this.cancelButton.setPreferredSize(new Dimension(80, 24));
        this.okButton.setActionCommand("OK");
        this.cancelButton.setActionCommand("Cancel");
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        contentPane.add((Component)buttonPanel, "South");
    }

    public void showDialog(String commandName) {
        Window owner = this.getOwner();
        Point pos = new Point(owner.getX() + (int)this.dialogLocation.getX(), owner.getY() + (int)this.dialogLocation.getY());
        this.setLocation(pos);
        this.pack();
        this.setVisible(true);
        this.addWindowListener(this);
        this.commandName = commandName;
        Color[] colors = new Color[]{Color.WHITE, Color.BLACK, Color.RED, Color.GREEN, Color.BLUE};
        this.getImportedColorsPanel().setImportedColors(colors);
    }

    protected String getCommandName() {
        return this.commandName;
    }

    protected JColorChooser getColorChooser() {
        return this.colorChooser;
    }

    protected PreviewPanel getPreviewPanel() {
        return this.previewPanel;
    }

    protected ImportedColorsPanel getImportedColorsPanel() {
        return this.importedColorsPanel;
    }

    public void setPreviewColor(Color color, String command) {
        if ((command = command.toLowerCase()).equals(this.commandName)) {
            this.getPreviewPanel().setSelectedColor(color);
            this.repaint();
            if (this.debug > 0) {
                System.out.println("CustomColorChooserDialog.setPreviewColor command=" + command + ", color=" + color + " >> The color was set to the PreviewPanel");
            }
        }
    }

    public Color getPreviewColor(String command) {
        Color color = this.getPreviewPanel().getSelectedColor();
        if (this.debug > 0) {
            System.out.println("CustomColorChooserDialog.getPreviewColor command=" + command + ", color=" + color);
        }
        return color;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String commandName = e.getActionCommand();
        if (this.debug > 0) {
            System.out.println("actionPerformed commandName=" + commandName);
        }
        if (commandName.equals("OK")) {
            Color color = this.previewPanel.getSelectedColor();
            ColorSelectionEvent event = new ColorSelectionEvent(this, color);
            this.fireEvent(event);
        }
        if (commandName.equals("Cancel")) {
            this.closeDialog();
        }
        if (commandName.equals("import")) {
            this.importColors();
        }
        if (commandName.equals("delete")) {
            this.importedColorsPanel.removeCurrentColors();
        }
    }

    public void importColors() {
        Vector<Color> vector = new Vector<Color>();
        ContainerManager manager = ObjectTable.getContainerManager();
        ShapeContainer[] containers = manager.getSelectedContainers();
        for (int i = 0; i < containers.length; ++i) {
            ShapeContainer[] shapeContainers = containers[i].getGroupedSingleShapeContainers();
            for (int j = 0; j < shapeContainers.length; ++j) {
                Color[] colors = shapeContainers[j].getColors();
                for (int k = 0; k < colors.length; ++k) {
                    vector.add(colors[k]);
                }
            }
        }
        Vector<Color> vector0 = new Vector<Color>();
        for (int i = 0; i < vector.size(); ++i) {
            Color color = (Color)vector.get(i);
            int rgb = color.getRGB();
            int jsave = -1;
            for (int j = 0; j < vector0.size(); ++j) {
                if (((Color)vector0.get(j)).getRGB() != rgb) continue;
                jsave = j;
                break;
            }
            if (jsave != -1) continue;
            vector0.add(color);
        }
        Color[] colors = new Color[vector0.size()];
        for (int i = 0; i < vector0.size(); ++i) {
            colors[i] = (Color)vector0.get(i);
        }
        this.importedColorsPanel.setImportedColors(colors);
    }

    @Override
    public void selected(SelectionEvent event) {
        Vector<Color> vector = new Vector<Color>();
        ShapeContainer[] containers = event.getSelectedContainers();
        for (int i = 0; i < containers.length; ++i) {
            ShapeContainer[] shapeContainers = containers[i].getGroupedSingleShapeContainers();
            for (int j = 0; j < shapeContainers.length; ++j) {
                Color[] colors = shapeContainers[j].getColors();
                for (int k = 0; k < colors.length; ++k) {
                    vector.add(colors[k]);
                }
            }
        }
        Vector<Color> vector0 = new Vector<Color>();
        for (int i = 0; i < vector.size(); ++i) {
            Color color = (Color)vector.get(i);
            int rgb = color.getRGB();
            int jsave = -1;
            for (int j = 0; j < vector0.size(); ++j) {
                if (((Color)vector0.get(j)).getRGB() != rgb) continue;
                jsave = j;
                break;
            }
            if (jsave != -1) continue;
            vector0.add(color);
        }
        Color[] colors = new Color[vector0.size()];
        for (int i = 0; i < vector0.size(); ++i) {
            colors[i] = (Color)vector0.get(i);
        }
        this.importedColorsPanel.setImportedColors(colors);
        this.importButton.setSelected(false);
        ObjectTable.getSelectionLS().removeSelectionListener(this);
    }

    protected void addColorSelectionListener(ColorSelectionListener listener) {
        this.listenerList.add(ColorSelectionListener.class, listener);
        if (this.debug > 0) {
            System.out.println("** Num of SelectionListener=" + this.listenerList.getListenerCount());
        }
    }

    protected void removeColorSelectionListener(ColorSelectionListener listener) {
        this.listenerList.remove(ColorSelectionListener.class, listener);
    }

    protected void removeColorSelectionListener() {
        this.listenerList = new EventListenerList();
    }

    protected void fireEvent(ColorSelectionEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != ColorSelectionListener.class) continue;
            ((ColorSelectionListener)listeners[i + 1]).colorSelected(event);
        }
    }

    protected void closeDialog() {
        this.setVisible(false);
        this.removeColorSelectionListener();
        ObjectTable.getSelectionLS().removeSelectionListener(this);
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.closeDialog();
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        Point pt;
        this.dialogLocation = pt = this.getLocation();
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }
}

