/*
 * Decompiled with CFR 0.152.
 */
package menu;

import DrawTop.ObjectTable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import menu.MenuUtil;
import menu.PageLayoutListener;
import menu.PagePanel;

public class DialogOfPageLayout
extends JDialog {
    JScrollPane scrollPane = null;
    Dimension scrollPaneSize = null;
    PagePanel pagePanel = null;
    PageLayoutListener listener = null;

    public DialogOfPageLayout() {
        super((Frame)ObjectTable.getDrawMain(), "page layout");
        this.setName("DialogOfPageLayout");
        this.listener = new PageLayoutListener(this);
        this.addComponentListener(this.listener);
        this.addWindowListener(this.listener);
        ObjectTable.getPageManager().saveCurrentPage();
    }

    public void showDialog() {
        MenuUtil menuUtil = ObjectTable.getMenuUtil();
        DialogOfPageLayout openedDialog = (DialogOfPageLayout)menuUtil.getMenuComponent("DialogOfPageLayout");
        if (openedDialog != null) {
            JOptionPane.showMessageDialog(ObjectTable.getDrawMain(), "page layout dialog is already opened", "", 0);
            return;
        }
        Dimension frameSize = ObjectTable.getDrawMain().getSize();
        double width = frameSize.getWidth();
        double height = frameSize.getHeight();
        this.scrollPaneSize = new Dimension((int)(width - 160.0), (int)(height / 4.0));
        Window owner = this.getOwner();
        Point centerP = new Point(owner.getX() + 60, owner.getY() + 100);
        this.setLocation(centerP);
        Container contentPane = this.getContentPane();
        JPanel pagesPanel = this.createLayoutPanel();
        contentPane.add((Component)pagesPanel, "North");
        this.pack();
        this.setVisible(true);
        menuUtil.setMenuComponent(this);
    }

    protected void setScrollViewPosition() {
        this.scrollPane.getViewport().setViewPosition(new Point(0, 0));
    }

    private JPanel createLayoutPanel() {
        JPanel basePanel = new JPanel();
        basePanel.setLayout(new FlowLayout(3, 0, 0));
        this.pagePanel = new PagePanel(this);
        this.scrollPane = new JScrollPane();
        this.scrollPane.setHorizontalScrollBarPolicy(30);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        JViewport viewport = new JViewport();
        this.scrollPane.setViewport(viewport);
        viewport.setView(this.pagePanel);
        viewport.setViewPosition(new Point(0, 0));
        this.scrollPane.setPreferredSize(this.scrollPaneSize);
        basePanel.add((Component)this.scrollPane, "North");
        return basePanel;
    }

    protected JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    protected JPanel getPagePanel() {
        return this.pagePanel;
    }
}

