/*
 * Decompiled with CFR 0.152.
 */
package menu;

import java.util.ArrayList;
import menu.SerializableElementUtilEx;
import shape.GroupElement;
import shape.SerializableElement;
import shape.ShapeContainer;

class DrawFileIoEx {
    public final String[] versions = new String[]{"ver0.0", "ver1.0", "ver1_0"};
    private int depth = 0;
    public int debug = 0;

    public void convertContainerList(ArrayList containerList, ArrayList serializableElementList) {
        int size = containerList.size();
        for (int i = 0; i < size; ++i) {
            ShapeContainer container = (ShapeContainer)containerList.get(i);
            SerializableElement[] sElements = this.convertShapeContainer(container);
            for (int j = 0; j < sElements.length; ++j) {
                serializableElementList.add(sElements[j]);
            }
        }
        if (this.debug > 0) {
            System.out.println("\n**** DrawFileIo convertContainerList before convert ****");
            this.printContainerList("Print ContainerLis", containerList);
            System.out.println("\n**** DrawFileIo convertContainerList after convert ****");
            this.printSerializableElementList("Print SerializableElementList", serializableElementList);
        }
    }

    public SerializableElement[] convertShapeContainer(ShapeContainer container) {
        SerializableElement[] sElements = null;
        sElements = container.getContainerType() == ShapeContainer.SHAPE ? new SerializableElement[]{SerializableElementUtilEx.convertSingleContainer(container)} : this.convertGroupContainer(container);
        return sElements;
    }

    public SerializableElement[] convertGroupContainer(ShapeContainer container) {
        SerializableElement[] sElements = null;
        ShapeContainer[] containers = container.getGroupedContainers();
        sElements = new SerializableElement[containers.length];
        for (int i = 0; i < containers.length; ++i) {
            sElements[i] = SerializableElementUtilEx.convertShapeContainer(containers[i]);
            if (sElements[i].containerType != ShapeContainer.GROUP) continue;
            ArrayList childrenList = sElements[i].childrenList;
            for (int j = 0; j < childrenList.size(); ++j) {
                String shapeId = ((SerializableElement)childrenList.get((int)j)).shapeId;
                sElements[i].childrenList.set(j, shapeId);
            }
        }
        return sElements;
    }

    public SerializableElement[] convertGroupContainerSimply(ShapeContainer container) {
        SerializableElement[] sElements = null;
        ShapeContainer[] containers = container.getGroupedContainers();
        sElements = new SerializableElement[containers.length];
        for (int i = 0; i < containers.length; ++i) {
            sElements[i] = SerializableElementUtilEx.convertContainerSimply(containers[i]);
        }
        return sElements;
    }

    public void invertContainerList(ArrayList containerList, ArrayList serializableElementList) {
        int size = serializableElementList.size();
        for (int i = 0; i < size; ++i) {
            SerializableElement sElement = (SerializableElement)serializableElementList.get(i);
            String parent = sElement.parent;
            if (parent != null && !parent.equals("")) continue;
            ShapeContainer container = this.invertShapeContainer(sElement, serializableElementList);
            containerList.add(container);
        }
        if (this.debug > 0) {
            System.out.println("\n**** DrawFileIo invertContainerList before invert ****");
            this.printSerializableElementList("Print SerializableElementList", serializableElementList);
            System.out.println("\n**** DrawFileIo invertContainerList after invert ****");
            this.printContainerList("Print ContainerList ", containerList);
        }
    }

    public ShapeContainer invertShapeContainer(SerializableElement sElement, ArrayList serializableElementList) {
        if (this.debug > 0) {
            System.out.println("\n** DrawFileIo invertShapeContainer before invert, sElement=" + sElement.shapeId + " **");
            System.out.println("Print SerializableElement\n" + sElement.toShortString());
        }
        ShapeContainer container = new ShapeContainer();
        if (sElement.containerType == ShapeContainer.SHAPE) {
            container = SerializableElementUtilEx.invertSingleContainer(sElement);
        } else {
            if (this.debug > 0) {
                System.out.println("- DrawFileIo invertShapeContainer group");
            }
            container = SerializableElementUtilEx.invertGroupContainer(sElement);
            GroupElement groupElement = (GroupElement)container.getElement();
            ArrayList childrenList = (ArrayList)sElement.childrenList.clone();
            for (int j = 0; j < childrenList.size(); ++j) {
                ShapeContainer childContainer;
                String childShapeId = (String)childrenList.get(j);
                SerializableElement childData = this.getSerializableElement(childShapeId, serializableElementList);
                if (this.debug > 0) {
                    System.out.println("--  DrawFileIo invertShapeContainer --");
                    System.out.println(" - childData[=" + j + "]" + childData.toShortString());
                }
                if ((childContainer = this.invertShapeContainer(childData, serializableElementList)) == null) continue;
                groupElement.addChildren(childContainer);
                childContainer.setParent(container);
            }
        }
        container.setSelected(false);
        if (this.debug > 0) {
            System.out.println("\n** DrawFileIo invertShapeContainer after invert, sElement=" + sElement.shapeId + " **");
            System.out.println("Print ShapeContainer\n" + container.toVeryShortString());
        }
        return container;
    }

    public SerializableElement getPerfectSerializableElement(SerializableElement sElement, ArrayList serializableElementList) {
        ++this.depth;
        if (this.debug > 0) {
            System.out.println("** getPerfectSerializableElement start depth=" + this.depth + "\n - sElement=" + sElement.toVeryShortString() + "\n--> getPerfectSerializableElement start end");
        }
        if (sElement.containerType == ShapeContainer.SHAPE) {
            return sElement;
        }
        if (this.debug > 0) {
            System.out.println("   -- sElement.childrenList.size()=" + sElement.childrenList.size());
        }
        String ObjectName = sElement.childrenList.get(0).getClass().getSimpleName();
        for (int i = 0; i < sElement.childrenList.size(); ++i) {
            if (ObjectName.equals("String")) {
                String shapeId = (String)sElement.childrenList.get(i);
                SerializableElement childElement = this.getSerializableElement(shapeId, serializableElementList);
                if (this.debug > 0) {
                    System.out.println("  - ObjectName=" + ObjectName + ": childElement[" + i + "]=" + childElement.shapeId + ", containerType=" + childElement.containerType + ", parent=" + childElement.parent + ", children=" + childElement.childrenList.size());
                }
                if (childElement.containerType == ShapeContainer.SHAPE) {
                    sElement.childrenList.set(i, childElement);
                    int remove = this.removeSerializableElement(shapeId, serializableElementList);
                    continue;
                }
                SerializableElement perfectChildElement = this.getPerfectSerializableElement(childElement, serializableElementList);
                sElement.childrenList.set(i, perfectChildElement);
                int remove = this.removeSerializableElement(shapeId, serializableElementList);
                continue;
            }
            SerializableElement childElement = (SerializableElement)sElement.childrenList.get(i);
            if (this.debug <= 0) continue;
            System.out.println("  - ObjectName=" + ObjectName + ": childElement[" + i + "]=" + childElement.shapeId + ", parent=" + childElement.parent + ", children=" + childElement.childrenList.size());
        }
        if (this.debug > 0) {
            System.out.println("** getPerfectSerializableElement return depth=" + this.depth + "\n - sElement=" + sElement.toVeryShortString() + "\n--> getPerfectSerializableElement return end");
        }
        --this.depth;
        return sElement;
    }

    private SerializableElement getSerializableElement(String shapeId, ArrayList sElementList) {
        SerializableElement target = null;
        int size = sElementList.size();
        for (int i = 0; i < size; ++i) {
            SerializableElement element = (SerializableElement)sElementList.get(i);
            if (!element.shapeId.equals(shapeId)) continue;
            target = element;
            break;
        }
        return target;
    }

    private int removeSerializableElement(String shapeId, ArrayList sElementList) {
        Object target = null;
        int size = sElementList.size();
        int pos = -1;
        for (int i = 0; i < size; ++i) {
            SerializableElement element = (SerializableElement)sElementList.get(i);
            if (!element.shapeId.equals(shapeId)) continue;
            pos = i;
            sElementList.remove(element);
            break;
        }
        if (this.debug > 0) {
            System.out.println("removeSerializableElement shapeId=" + shapeId + ", pos=" + pos);
        }
        return pos;
    }

    public boolean isDuplicatedNumber(ArrayList serializableElementList) {
        int size = serializableElementList.size();
        int[] numbers = new int[size];
        for (int i = 0; i < size; ++i) {
            SerializableElement sElement = (SerializableElement)serializableElementList.get(i);
            String shapeId = sElement.shapeId;
            int id0 = shapeId.indexOf("-");
            int id1 = shapeId.indexOf(")");
            String num = shapeId.substring(id0 + 1, id1);
            numbers[i] = new Integer(num);
        }
        boolean duplicated = false;
        block1: for (int i = 0; i < size; ++i) {
            for (int j = 0; j < i; ++j) {
                if (numbers[j] != numbers[i]) continue;
                duplicated = true;
                continue block1;
            }
        }
        return duplicated;
    }

    private void printContainerList(String title, ArrayList containerList) {
        System.out.println(title);
        for (int i = 0; i < containerList.size(); ++i) {
            ShapeContainer container = (ShapeContainer)containerList.get(i);
            System.out.println(" - Container[" + i + "]=" + container.toVeryShortString());
        }
    }

    private void printSerializableElementList(String title, ArrayList sElementList) {
        System.out.println(title);
        for (int i = 0; i < sElementList.size(); ++i) {
            SerializableElement sElement = (SerializableElement)sElementList.get(i);
            System.out.println(" - SerializableElement[" + i + "]=" + sElement.toVeryShortString());
        }
    }

    private void printPerfectSerializableElementList(String title, ArrayList sElementList) {
        System.out.println(title);
        for (int i = 0; i < sElementList.size(); ++i) {
            SerializableElement sElement = (SerializableElement)sElementList.get(i);
            sElement = this.getPerfectSerializableElement(sElement, sElementList);
            System.out.println(" - SerializableElement[" + i + "]=" + sElement.toVeryShortString());
        }
    }
}

