/*
 * Decompiled with CFR 0.152.
 */
package menu;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JMenu;

class JMenuEx
extends JMenu {
    Color baseColor = new Color(13490419);

    JMenuEx() {
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Dimension size = this.getPreferredSize();
        double w = size.getWidth();
        double h = size.getHeight();
        if (w == 0.0 || h == 0.0) {
            return;
        }
        Point2D.Double p1 = new Point2D.Double(0.0, 0.2 * h);
        Point2D.Double p2 = new Point2D.Double(0.0, 0.8 * h);
        Point2D.Double p3 = new Point2D.Double(0.0, h);
        GradientPaint gradient0 = new GradientPaint(p1, Color.white, p2, this.baseColor, true);
        GradientPaint gradient1 = new GradientPaint(p2, this.baseColor, p3, this.baseColor, true);
        Rectangle2D.Double rect0 = new Rectangle2D.Double(0.0, 0.0, w, h);
        Rectangle2D.Double rect1 = new Rectangle2D.Double(0.0, ((Point2D)p2).getY(), w, h);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setPaint(gradient0);
        g2d.fill(rect0);
        g2d.setPaint(gradient1);
        g2d.fill(rect1);
        g2d.setColor(Color.black);
        FontMetrics metrics = g.getFontMetrics();
        double stringH = metrics.getDescent() + metrics.getAscent();
        double stringW = metrics.stringWidth(this.getText());
        double stringX = 0.0;
        if (w > stringW) {
            stringX = 0.5 * (w - stringW);
        }
        double stringY = h - (double)metrics.getDescent();
        if (h > stringH) {
            stringY = 0.5 * (h + stringH) - (double)metrics.getDescent();
        }
        g2d.drawString(this.getText(), (float)stringX, (float)stringY);
    }
}

