/*
 * Decompiled with CFR 0.152.
 */
package menu;

import DrawTop.Command;
import DrawTop.ExecCommand;
import DrawTop.ObjectTable;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import menu.DialogOfShapeFormat;
import menu.MenuUtil;
import shape.ShapeContainer;

class ShapeFormatAction
extends AbstractAction
implements ChangeListener,
WindowListener {
    DialogOfShapeFormat dialog;
    ShapeContainer shapeContainer = null;
    boolean lineType = false;
    ExecCommand execCommand = ObjectTable.getExecCommand("DialogOfShapeFormat");
    int debug = 0;

    public ShapeFormatAction(DialogOfShapeFormat dialog) {
        this.dialog = dialog;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String commandName = e.getActionCommand();
        String componentClassName = "";
        componentClassName = e.getSource().getClass().getSimpleName();
        String componentName = ((Component)e.getSource()).getName();
        if (this.debug > 0) {
            System.out.println("- actionPerformed  commandName=" + commandName + ", source component name=" + componentName + ", source class simple name=" + componentClassName);
        }
        JRadioButton mmButton = this.dialog.mmButton;
        SpinnerNumberModel[] marginSpinnerModels = this.dialog.getMarginSpinnerModels();
        SpinnerNumberModel lineSpaceSpinnerModel = this.dialog.getLineSpaceSpinnerModels();
        this.shapeContainer = this.dialog.getShapeContainer();
        int type = this.shapeContainer.getElement().getTypeE();
        this.lineType = false;
        if (type >= 51 && type <= 53) {
            this.lineType = true;
        }
        if (commandName.equals("pixel") || commandName.equals("mm")) {
            int unitType = 0;
            if (mmButton.isSelected()) {
                unitType = 1;
            }
            if (this.lineType) {
                this.dialog.showLine(unitType);
            } else {
                this.dialog.showRectangular(unitType);
            }
            System.out.println("pixel or mm button pressed");
        }
        if (commandName.equalsIgnoreCase(DialogOfShapeFormat.RESIZING)) {
            JCheckBox resizeBox = this.dialog.getResizeBox();
            JCheckBox ratioBox = this.dialog.getRatioBox();
            JCheckBox directionBox = this.dialog.getDirectionBox();
            if (resizeBox.isSelected()) {
                ratioBox.setSelected(false);
                directionBox.setSelected(false);
                if (this.lineType) {
                    directionBox.setEnabled(true);
                } else {
                    ratioBox.setEnabled(true);
                }
            } else {
                ratioBox.setSelected(false);
                directionBox.setSelected(false);
                ratioBox.setEnabled(false);
                directionBox.setEnabled(false);
            }
            this.setProperty();
        }
        if (commandName.equalsIgnoreCase(DialogOfShapeFormat.ASPECT_RATIO)) {
            this.setProperty();
        }
        if (commandName.equalsIgnoreCase(DialogOfShapeFormat.LINE_DIRECTION)) {
            this.setProperty();
        }
        if (commandName.equalsIgnoreCase(DialogOfShapeFormat.CONNECTOR_CONNECTIONS)) {
            this.setProperty();
        }
        if (commandName.equalsIgnoreCase(DialogOfShapeFormat.UNGROUPING)) {
            this.setProperty();
        }
        if (commandName.equals("OK Property")) {
            this.removeOldProperty();
            this.closeDialog();
        }
        if (commandName.equals("Cancel Property")) {
            this.closeDialog();
        }
        if (commandName.equals("OK TextBox")) {
            double left = marginSpinnerModels[0].getNumber().doubleValue();
            double top = marginSpinnerModels[1].getNumber().doubleValue();
            double right = marginSpinnerModels[2].getNumber().doubleValue();
            double bottom = marginSpinnerModels[3].getNumber().doubleValue();
            double lineSpace = lineSpaceSpinnerModel.getNumber().doubleValue();
            Insets insets = new Insets((int)top, (int)left, (int)bottom, (int)right);
            Object[] args = new Object[3];
            args[0] = insets;
            args[1] = -1;
            lineSpace = (int)lineSpace;
            args[2] = lineSpace;
            Command command = new Command(140, 5, args);
            this.execCommand = ObjectTable.getExecCommand("");
            this.execCommand.exec(command);
            this.closeDialog();
            return;
        }
        if (commandName.equals("Cancel TextBox")) {
            this.closeDialog();
            return;
        }
    }

    private void setProperty() {
        String str = DialogOfShapeFormat.RESIZING;
        boolean selected = this.dialog.getResizeBox().isSelected();
        if (!selected) {
            this.shapeContainer.setProperty(str, new Boolean(selected), "DialogOfShapeFormat");
        } else {
            this.shapeContainer.removeProperty(str, "DialogOfShapeFormat");
        }
        str = DialogOfShapeFormat.ASPECT_RATIO;
        selected = this.dialog.getRatioBox().isSelected();
        if (selected) {
            this.shapeContainer.setProperty(str, new Boolean(selected), "DialogOfShapeFormat");
        } else {
            this.shapeContainer.removeProperty(str, "DialogOfShapeFormat");
        }
        str = DialogOfShapeFormat.LINE_DIRECTION;
        selected = this.dialog.getDirectionBox().isSelected();
        if (selected) {
            this.shapeContainer.setProperty(str, new Boolean(selected), "DialogOfShapeFormat");
        } else {
            this.shapeContainer.removeProperty(str, "DialogOfShapeFormat");
        }
        str = DialogOfShapeFormat.CONNECTOR_CONNECTIONS;
        selected = this.dialog.getConnectorBox().isSelected();
        if (!selected) {
            this.shapeContainer.setProperty(str, new Boolean(selected), "DialogOfShapeFormat");
        } else {
            this.shapeContainer.removeProperty(str, "DialogOfShapeFormat");
        }
        str = DialogOfShapeFormat.UNGROUPING;
        selected = this.dialog.getUngroupBox().isSelected();
        if (!selected) {
            this.shapeContainer.setProperty(str, new Boolean(selected), "DialogOfShapeFormat");
        } else {
            this.shapeContainer.removeProperty(str, "DialogOfShapeFormat");
        }
        ObjectTable.getDrawPanel().repaint();
    }

    private void removeOldProperty() {
        this.shapeContainer.removeProperty("MOVABLE", "DialogOfShapeFormat");
        this.shapeContainer.removeProperty("UNMOVABLE", "DialogOfShapeFormat");
        this.shapeContainer.removeProperty("RESIZABLE", "DialogOfShapeFormat");
        this.shapeContainer.removeProperty("UNRESIZABLE", "DialogOfShapeFormat");
        this.shapeContainer.removeProperty("ALLOW_CONNECTOR_CONNECTION", "DialogOfShapeFormat");
        this.shapeContainer.removeProperty("UNABLE_TO_DRAG_CONNECTORS", "DialogOfShapeFormat");
        this.shapeContainer.removeProperty("ALLOW_UNGROUP", "DialogOfShapeFormat");
        this.shapeContainer.removeProperty("UNABLE_UNGROUPING", "DialogOfShapeFormat");
        if (this.lineType) {
            this.shapeContainer.removeProperty("KEEP_ASPECT_RATIO", "DialogOfShapeFormat");
        } else {
            this.shapeContainer.removeProperty("KEEP_LINE_DIRECTION", "DialogOfShapeFormat");
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        String componentClassName = e.getSource().getClass().getSimpleName();
    }

    private void closeDialog() {
        this.dialog.setVisible(false);
        MenuUtil menuUtil = ObjectTable.getMenuUtil();
        Component component = menuUtil.getMenuComponent(this.dialog.getName());
        if (component != null) {
            menuUtil.removeMenuComponent(component);
        }
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (this.debug > 0) {
            System.out.println("windowClosing called");
        }
        this.closeDialog();
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }
}

