/*
 * Decompiled with CFR 0.152.
 */
package menu;

import DrawTop.ObjectTable;
import geomExtension.Vector2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import menu.DialogOfShapeFormat;
import shape.ShapeContainer;
import shapeUtil.ConnectionUtil;

class SpinnersChangeListener
implements ChangeListener {
    DialogOfShapeFormat dialog;
    ShapeContainer shapeContainer;

    public SpinnersChangeListener(DialogOfShapeFormat dialog) {
        this.dialog = dialog;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.shapeContainer = this.dialog.getShapeContainer();
        int type = this.shapeContainer.getElement().getTypeE();
        boolean lineType = false;
        if (type >= 51 && type <= 53) {
            lineType = true;
        }
        if (lineType) {
            this.lineChanged(e);
        } else {
            this.rectangularChanged(e);
        }
    }

    private void rectangularChanged(ChangeEvent e) {
        double h;
        double ymax;
        double ymin;
        double w;
        double xmax;
        double xmin;
        JSpinner spinner = (JSpinner)e.getSource();
        System.out.println("changedRectangular spinner=" + spinner.getName());
        SpinnerNumberModel[] positionSpinnerModels = this.dialog.getPositionSpinnerModels();
        JSpinner[] positionSpinners = this.dialog.getPositionSpinners();
        SpinnerNumberModel[] sizeSpinnerModels = this.dialog.getSizeSpinnerModels();
        JSpinner[] sizeSpinners = this.dialog.getSizeSpinners();
        SpinnerNumberModel[] centerSpinnerModels = this.dialog.getCenterSpinnerModels();
        JSpinner[] centerSpinners = this.dialog.getCenterSpinners();
        boolean resizing = this.shapeContainer.getBooleanProperty(DialogOfShapeFormat.RESIZING, "DialogOfShapeFormat");
        boolean keep_connection = this.shapeContainer.getBooleanProperty(DialogOfShapeFormat.CONNECTOR_CONNECTIONS, "DialogOfShapeFormat");
        boolean aspect_ratio = this.shapeContainer.getBooleanProperty(DialogOfShapeFormat.ASPECT_RATIO, "DialogOfShapeFormat");
        boolean moved = false;
        boolean resized = false;
        if (spinner == positionSpinners[0]) {
            System.out.println("Rectangular xmin changed");
            xmin = positionSpinnerModels[0].getNumber().doubleValue();
            xmax = positionSpinnerModels[1].getNumber().doubleValue();
            w = sizeSpinnerModels[0].getNumber().doubleValue();
            this.removeChangeListener();
            sizeSpinners[0].setValue(Math.abs(xmax - xmin));
            centerSpinners[0].setValue(0.5 * (xmin + xmax));
            this.addChangeListener();
            moved = true;
        }
        if (spinner == positionSpinners[1]) {
            System.out.println("Rectangular xmax changed");
            xmin = positionSpinnerModels[0].getNumber().doubleValue();
            xmax = positionSpinnerModels[1].getNumber().doubleValue();
            w = sizeSpinnerModels[0].getNumber().doubleValue();
            this.removeChangeListener();
            sizeSpinners[0].setValue(Math.abs(xmax - xmin));
            centerSpinners[0].setValue(0.5 * (xmin + xmax));
            this.addChangeListener();
            moved = true;
        }
        if (spinner == positionSpinners[2]) {
            System.out.println("Rectangular ymin changed");
            ymin = positionSpinnerModels[2].getNumber().doubleValue();
            ymax = positionSpinnerModels[3].getNumber().doubleValue();
            h = sizeSpinnerModels[1].getNumber().doubleValue();
            this.removeChangeListener();
            sizeSpinners[1].setValue(Math.abs(ymax - ymin));
            centerSpinners[1].setValue(0.5 * (ymin + ymax));
            this.addChangeListener();
            moved = true;
        }
        if (spinner == positionSpinners[3]) {
            System.out.println("Rectangular ymax changed");
            ymin = positionSpinnerModels[2].getNumber().doubleValue();
            ymax = positionSpinnerModels[3].getNumber().doubleValue();
            h = sizeSpinnerModels[1].getNumber().doubleValue();
            this.removeChangeListener();
            sizeSpinners[1].setValue(Math.abs(ymax - ymin));
            centerSpinners[1].setValue(0.5 * (ymin + ymax));
            this.addChangeListener();
            moved = true;
        }
        if (spinner == sizeSpinners[0]) {
            Rectangle2D box = this.shapeContainer.getBoundingBox();
            double W = box.getWidth();
            double H = box.getHeight();
            double w2 = sizeSpinnerModels[0].getNumber().doubleValue();
            double h2 = sizeSpinnerModels[1].getNumber().doubleValue();
            double xmin2 = positionSpinnerModels[0].getNumber().doubleValue();
            double xmax2 = positionSpinnerModels[1].getNumber().doubleValue();
            this.removeChangeListener();
            positionSpinners[1].setValue(xmin2 + w2);
            centerSpinners[0].setValue(xmin2 + 0.5 * w2);
            if (aspect_ratio) {
                double ratio = w2 / W;
                double newH = H * ratio;
                double ymin2 = positionSpinnerModels[2].getNumber().doubleValue();
                sizeSpinners[1].setValue(newH);
                positionSpinners[3].setValue(ymin2 + newH);
                centerSpinners[1].setValue(ymin2 + 0.5 * newH);
            }
            this.addChangeListener();
            resized = true;
        }
        if (spinner == sizeSpinners[1]) {
            Rectangle2D box = this.shapeContainer.getBoundingBox();
            Point2D[] Pts = this.shapeContainer.getElement().getEndPTs();
            double W = box.getWidth();
            double H = box.getHeight();
            double h3 = sizeSpinnerModels[1].getNumber().doubleValue();
            double ymin3 = positionSpinnerModels[2].getNumber().doubleValue();
            double ymax2 = positionSpinnerModels[3].getNumber().doubleValue();
            this.removeChangeListener();
            positionSpinners[3].setValue(ymin3 + h3);
            centerSpinners[1].setValue(ymin3 + 0.5 * h3);
            if (aspect_ratio) {
                double ratio = h3 / H;
                double newW = W * ratio;
                double xmin3 = positionSpinnerModels[0].getNumber().doubleValue();
                sizeSpinners[0].setValue(newW);
                positionSpinners[1].setValue(xmin3 + newW);
                centerSpinners[0].setValue(xmin3 + 0.5 * newW);
            }
            this.addChangeListener();
            resized = true;
        }
        if (spinner == centerSpinners[0]) {
            double centerX = centerSpinnerModels[0].getNumber().doubleValue();
            double w3 = sizeSpinnerModels[0].getNumber().doubleValue();
            this.removeChangeListener();
            positionSpinners[0].setValue(centerX - 0.5 * w3);
            positionSpinners[1].setValue(centerX + 0.5 * w3);
            this.addChangeListener();
            moved = true;
        }
        if (spinner == centerSpinners[1]) {
            double centerX = centerSpinnerModels[1].getNumber().doubleValue();
            double h4 = sizeSpinnerModels[1].getNumber().doubleValue();
            this.removeChangeListener();
            positionSpinners[2].setValue(centerX - 0.5 * h4);
            positionSpinners[3].setValue(centerX + 0.5 * h4);
            this.addChangeListener();
            moved = true;
        }
        Rectangle2D oldBox = this.shapeContainer.getBoundingBox();
        double xmin4 = positionSpinnerModels[0].getNumber().doubleValue();
        double xmax3 = positionSpinnerModels[1].getNumber().doubleValue();
        double ymin4 = positionSpinnerModels[2].getNumber().doubleValue();
        double ymax3 = positionSpinnerModels[3].getNumber().doubleValue();
        double pixel = 3.7795275590551185;
        double unit = 1.0;
        if (this.dialog.mmButton.isSelected()) {
            unit = pixel;
        }
        Rectangle2D.Double newBox = new Rectangle2D.Double(xmin4 * unit, ymin4 * unit, (xmax3 - xmin4) * unit, (ymax3 - ymin4) * unit);
        ConnectionUtil.moveResize(this.shapeContainer, oldBox, newBox, keep_connection, true);
        ObjectTable.getDrawPanel().repaint();
    }

    private void lineChanged(ChangeEvent e) {
        double newEndY;
        double newEndX;
        JSpinner spinner = (JSpinner)e.getSource();
        SpinnerNumberModel[] startSpinnerModels = this.dialog.getStartSpinnerModels();
        JSpinner[] startSpinners = this.dialog.getStartSpinners();
        SpinnerNumberModel[] endSpinnerModels = this.dialog.getEndSpinnerModels();
        JSpinner[] endSpinners = this.dialog.getEndSpinners();
        SpinnerNumberModel[] lineSpinnerModels = this.dialog.getLineSpinnerModels();
        JSpinner[] lineSpinners = this.dialog.getLineSpinners();
        double pixel = 3.7795275590551185;
        double unit = 1.0;
        if (this.dialog.mmButton.isSelected()) {
            unit = pixel;
        }
        boolean resizable = this.shapeContainer.getBooleanProperty(DialogOfShapeFormat.RESIZING, "DialogOfShapeFormat");
        boolean line_dir = this.shapeContainer.getBooleanProperty(DialogOfShapeFormat.LINE_DIRECTION, "DialogOfShapeFormat");
        Rectangle2D box = this.shapeContainer.getBoundingBox();
        Point2D[] Pts = this.shapeContainer.getElement().getEndPTs();
        Vector2D Tvec = Vector2D.sub(Pts[1], Pts[0]);
        double angle = Math.atan2(Tvec.getY(), Tvec.getX());
        double length = Vector2D.length(Tvec);
        Point2D[] newPts = new Point2D[]{(Point2D)Pts[0].clone(), (Point2D)Pts[1].clone()};
        boolean srartChanged = false;
        boolean endChanged = false;
        boolean angleChanged = false;
        boolean lengthChanged = false;
        if (spinner == startSpinners[0]) {
            System.out.println("Line startX chenged");
            double startX = startSpinnerModels[0].getNumber().doubleValue() * unit;
            newPts[0] = new Point2D.Double(startX, Pts[0].getY());
            srartChanged = true;
        }
        if (spinner == startSpinners[1]) {
            double startY = startSpinnerModels[1].getNumber().doubleValue() * unit;
            newPts[0] = new Point2D.Double(Pts[0].getX(), startY);
            srartChanged = true;
        }
        if (spinner == endSpinners[0]) {
            System.out.println("Line endX chenged");
            double endX = endSpinnerModels[0].getNumber().doubleValue() * unit;
            newPts[1] = new Point2D.Double(endX, Pts[1].getY());
            endChanged = true;
        }
        if (spinner == endSpinners[1]) {
            System.out.println("Line endY chenged");
            double endY = endSpinnerModels[1].getNumber().doubleValue() * unit;
            newPts[1] = new Point2D.Double(Pts[1].getX(), endY);
            endChanged = true;
        }
        if (spinner == lineSpinners[0]) {
            double newAngle = lineSpinnerModels[0].getNumber().doubleValue();
            newEndX = length * Math.cos(newAngle * Math.PI / 180.0) + Pts[0].getX();
            newEndY = length * Math.sin(-newAngle * Math.PI / 180.0) + Pts[0].getY();
            newPts[1] = new Point2D.Double(newEndX, newEndY);
            angleChanged = true;
        }
        if (spinner == lineSpinners[1]) {
            double newLength = lineSpinnerModels[1].getNumber().doubleValue() * unit;
            newEndX = newLength * Math.cos(angle) + Pts[0].getX();
            newEndY = newLength * Math.sin(angle) + Pts[0].getY();
            newPts[1] = new Point2D.Double(newEndX, newEndY);
            lengthChanged = true;
        }
        int index = 0;
        if (!resizable) {
            index = 2;
        }
        if (resizable && line_dir && !angleChanged && !lengthChanged) {
            index = 2;
        }
        switch (index) {
            case 0: {
                if (srartChanged) {
                    ConnectionUtil.moveEndPoint(this.shapeContainer, 0, Pts[0], newPts[0], true, true);
                    break;
                }
                ConnectionUtil.moveEndPoint(this.shapeContainer, 1, Pts[1], newPts[1], true, true);
                break;
            }
            case 1: {
                Vector2D move = null;
                if (srartChanged) {
                    move = Vector2D.sub(newPts[0], Pts[0]);
                    Vector2D moveVec = this.getMoveVector(Tvec, move);
                    newPts[0].setLocation(Pts[0].getX() + moveVec.getX(), Pts[0].getY() + moveVec.getY());
                    ConnectionUtil.moveEndPoint(this.shapeContainer, 0, Pts[0], newPts[0], true, true);
                    break;
                }
                move = Vector2D.sub(newPts[1], Pts[1]);
                Vector2D moveVec = this.getMoveVector(Tvec, move);
                newPts[1].setLocation(Pts[1].getX() + moveVec.getX(), Pts[1].getY() + moveVec.getY());
                ConnectionUtil.moveEndPoint(this.shapeContainer, 1, Pts[1], newPts[1], true, true);
                break;
            }
            case 2: {
                Vector2D move = new Vector2D();
                if (srartChanged) {
                    move = Vector2D.sub(newPts[0], Pts[0]);
                    newPts[1].setLocation(Pts[1].getX() + move.getX(), Pts[1].getY() + move.getY());
                } else {
                    move = Vector2D.sub(newPts[1], Pts[1]);
                    newPts[0].setLocation(Pts[0].getX() + move.getX(), Pts[0].getY() + move.getY());
                }
                Rectangle2D.Double newBox = new Rectangle2D.Double(box.getX() + move.getX(), box.getY() + move.getY(), box.getWidth(), box.getHeight());
                ConnectionUtil.moveResize(this.shapeContainer, box, newBox, true, true);
                break;
            }
        }
        Vector2D newVec = Vector2D.sub(newPts[1], newPts[0]);
        double newAngle = Math.atan2(newVec.getY(), newVec.getX());
        double newLength = Vector2D.length(newVec);
        this.removeChangeListener();
        startSpinners[0].setValue(newPts[0].getX() / unit);
        startSpinners[1].setValue(newPts[0].getY() / unit);
        endSpinners[0].setValue(newPts[1].getX() / unit);
        endSpinners[1].setValue(newPts[1].getY() / unit);
        lineSpinners[0].setValue(-newAngle * 180.0 / Math.PI);
        lineSpinners[1].setValue(newLength / unit);
        this.addChangeListener();
        ObjectTable.getDrawPanel().repaint();
    }

    private Vector2D getMoveVector(Vector2D Tvec, Vector2D move) {
        Vector2D projVec = new Vector2D();
        double sprod = Vector2D.sproduct(move, Tvec);
        double move2 = Vector2D.sproduct(move, move);
        if (Math.abs(sprod) == 0.0) {
            return projVec;
        }
        double t = move2 / sprod;
        projVec = Vector2D.multiply(t, Tvec);
        return projVec;
    }

    protected void removeChangeListener() {
        int i;
        JSpinner[] positionSpinners = this.dialog.getPositionSpinners();
        JSpinner[] sizeSpinners = this.dialog.getSizeSpinners();
        JSpinner[] centerSpinners = this.dialog.getCenterSpinners();
        JSpinner[] startSpinners = this.dialog.getStartSpinners();
        JSpinner[] endSpinners = this.dialog.getEndSpinners();
        JSpinner[] lineSpinners = this.dialog.getLineSpinners();
        for (i = 0; i < 4; ++i) {
            if (positionSpinners[i] == null) continue;
            positionSpinners[i].removeChangeListener(this);
        }
        for (i = 0; i < 2; ++i) {
            if (sizeSpinners[i] == null) continue;
            sizeSpinners[i].removeChangeListener(this);
        }
        for (i = 0; i < 2; ++i) {
            if (centerSpinners[i] == null) continue;
            centerSpinners[i].removeChangeListener(this);
        }
        for (i = 0; i < 2; ++i) {
            if (startSpinners[i] == null) continue;
            startSpinners[i].removeChangeListener(this);
        }
        for (i = 0; i < 2; ++i) {
            if (endSpinners[i] == null) continue;
            endSpinners[i].removeChangeListener(this);
        }
        for (i = 0; i < 2; ++i) {
            if (lineSpinners[i] == null) continue;
            lineSpinners[i].removeChangeListener(this);
        }
    }

    protected void addChangeListener() {
        int i;
        JSpinner[] positionSpinners = this.dialog.getPositionSpinners();
        JSpinner[] sizeSpinners = this.dialog.getSizeSpinners();
        JSpinner[] centerSpinners = this.dialog.getCenterSpinners();
        JSpinner[] startSpinners = this.dialog.getStartSpinners();
        JSpinner[] endSpinners = this.dialog.getEndSpinners();
        JSpinner[] lineSpinners = this.dialog.getLineSpinners();
        for (i = 0; i < 4; ++i) {
            if (positionSpinners[i] == null) continue;
            positionSpinners[i].addChangeListener(this);
        }
        for (i = 0; i < 2; ++i) {
            if (sizeSpinners[i] == null) continue;
            sizeSpinners[i].addChangeListener(this);
        }
        for (i = 0; i < 2; ++i) {
            if (centerSpinners[i] == null) continue;
            centerSpinners[i].addChangeListener(this);
        }
        for (i = 0; i < 2; ++i) {
            if (startSpinners[i] == null) continue;
            startSpinners[i].addChangeListener(this);
        }
        for (i = 0; i < 2; ++i) {
            if (endSpinners[i] == null) continue;
            endSpinners[i].addChangeListener(this);
        }
        for (i = 0; i < 2; ++i) {
            if (lineSpinners[i] == null) continue;
            lineSpinners[i].addChangeListener(this);
        }
    }
}

