/*
 * Decompiled with CFR 0.152.
 */
package shape;

import geomExtension.Polyline2DE;
import geomExtension.Vector2D;
import java.awt.geom.Point2D;

public class ArrowShape {
    static final double ArrowAngle = 0.6981317007977318;
    static final double MinimumArrowHeight = 8.0;
    int arrowType = 1;
    double lineWidth;
    Vector2D headPosition;
    Vector2D direction;
    int debug = 0;

    public ArrowShape(int arrowType, double lineWidth, Vector2D headPosition, Vector2D direction) {
        this.arrowType = arrowType;
        this.lineWidth = lineWidth;
        this.headPosition = headPosition;
        this.direction = direction;
    }

    Polyline2DE getArrowShape() {
        Point2D[] points;
        double arrowWidth = 3.0 * this.lineWidth;
        double arrowHeight = 0.5 * arrowWidth / Math.tan(0.3490658503988659);
        if (arrowHeight < 8.0) {
            arrowHeight = 8.0;
            arrowWidth = 2.0 * arrowHeight * Math.tan(0.3490658503988659);
        }
        Vector2D unitVec = Vector2D.unitVector(this.direction);
        Vector2D orthogonalVec = new Vector2D(-unitVec.getY(), unitVec.getX());
        Vector2D arrowBottom = Vector2D.sub(this.headPosition, Vector2D.multiply(arrowHeight, unitVec));
        Vector2D wideVec = Vector2D.multiply(0.5 * arrowWidth, orthogonalVec);
        Vector2D rightEdgeP = Vector2D.add(arrowBottom, wideVec);
        Vector2D leftEdgeP = Vector2D.sub(arrowBottom, wideVec);
        Point2D.Double headPoint = new Point2D.Double(this.headPosition.getX(), this.headPosition.getY());
        Point2D.Double rightEdgePoint = new Point2D.Double(rightEdgeP.getX(), rightEdgeP.getY());
        Point2D.Double leftEdgePoint = new Point2D.Double(leftEdgeP.getX(), leftEdgeP.getY());
        Polyline2DE shape = null;
        if (this.arrowType == 1) {
            points = new Point2D[]{leftEdgePoint, headPoint, rightEdgePoint};
            shape = new Polyline2DE(points, false);
        }
        if (this.arrowType == 2) {
            points = new Point2D[]{leftEdgePoint, headPoint, rightEdgePoint, points[0]};
            shape = new Polyline2DE(points, true);
        }
        if (this.debug > 0) {
            System.out.println(" -- Arrow,  arrowType=" + this.arrowType + ",lineWidth=" + this.lineWidth + ", arrowHeight=" + arrowHeight + ", direction=" + this.direction.toString() + ", shape=" + shape.toString());
        }
        return shape;
    }
}

