/*
 * Decompiled with CFR 0.152.
 */
package shape;

import DrawTop.ObjectTable;
import geomExtension.Curve2D;
import geomExtension.GeneralCurve2DE;
import geomExtension.Matrix2D;
import geomExtension.Segment2D;
import geomExtension.Vector2D;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import shape.CubicCurveElement;
import shape.DiscreteAngledLine;
import shape.LineElement;
import shape.PolylineElement;
import shape.SegmentModifier;
import shape.ShapeElement;
import shape.ShapeElementUtil;

public class GeneralCurveElement
extends ShapeElement {
    SegmentModifier[] segmentModifiers = null;
    SegmentModifier hitSegmentModifier = null;
    boolean topologyChanged = false;

    @Override
    public int getTypeE() {
        return 56;
    }

    @Override
    public String getShapeIdString() {
        return "GeneralCurve";
    }

    @Override
    public Rectangle2D createTextArea() {
        if (!this.isClosed()) {
            return null;
        }
        Shape shape = this.getShape();
        double sqrt2 = Math.sqrt(2.0);
        Rectangle2D textArea = ShapeElementUtil.getInscribedBox(shape, false);
        return textArea;
    }

    public ShapeElement[] getSimpleShapeElements() {
        GeneralCurve2DE gcurve = (GeneralCurve2DE)this.getCurve2D();
        Curve2D[] curves = gcurve.getSimpleCurve2Ds();
        ShapeElement[] newElements = new ShapeElement[curves.length];
        for (int i = 0; i < curves.length; ++i) {
            int type = curves[i].getType2DE();
            if (type == 51) {
                newElements[i] = new LineElement();
            }
            if (type == 54) {
                newElements[i] = new PolylineElement();
            }
            if (type == 55) {
                newElements[i] = new CubicCurveElement();
            }
            if (type == 56) {
                newElements[i] = new GeneralCurveElement();
            }
            newElements[i].setCurve2D(curves[i]);
        }
        if (this.debug > 0) {
            String str = "GeneralCurveElement.getSimpleShapeElements";
            for (int i = 0; i < newElements.length; ++i) {
                str = str + "\n newElements[" + i + "]: " + newElements[i].toString();
            }
            System.out.println(str);
        }
        return newElements;
    }

    @Override
    public SegmentModifier[] getSegmentModifiers() {
        return SegmentModifier.getSegmentModifiers(this.curve2D);
    }

    @Override
    public Point2D[] getModifierPTs() {
        SegmentModifier[] modifiers = this.getSegmentModifiers();
        this.workVector.clear();
        Point2D PT = null;
        for (int i = 0; i < modifiers.length; ++i) {
            PT = modifiers[i].getP();
            if (PT != null) {
                this.workVector.add(PT);
            }
            if ((PT = modifiers[i].getTinP1()) != null) {
                this.workVector.add(PT);
            }
            if ((PT = modifiers[i].getTinP2()) != null) {
                this.workVector.add(PT);
            }
            if ((PT = modifiers[i].getToutP1()) != null) {
                this.workVector.add(PT);
            }
            if ((PT = modifiers[i].getToutP2()) == null) continue;
            this.workVector.add(PT);
        }
        Point2D[] PTs = new Point2D[this.workVector.size()];
        for (int i = 0; i < this.workVector.size(); ++i) {
            PTs[i] = (Point2D)this.workVector.get(i);
        }
        return PTs;
    }

    @Override
    public void mouseStart(int ctrl, Point2D startPoint) {
        super.mouseStart(ctrl, startPoint);
        this.segmentModifiers = this.getSegmentModifiers();
        this.hitSegmentModifier = SegmentModifier.getHitSegmentModifier(this.segmentModifiers, startPoint);
        this.topologyChanged = false;
        if (this.hitSegmentModifier == null) {
            System.out.println("modify hit=null");
        } else if (this.debug > 0) {
            System.out.println("modify hit:" + this.hitSegmentModifier.toString());
        }
    }

    @Override
    public void mouseEnd() {
        ObjectTable.getTempShapeManager("GeneralCurveElement").clearTempShape("modify_close");
        ObjectTable.getTempShapeManager("GeneralCurveElement").clearTempShape("modify_connect");
    }

    public void creationStart(int ctrl, Point2D point) {
    }

    @Override
    public void create(Rectangle2D boundingBox) {
    }

    @Override
    public void create(Point2D startPoint, Point2D currentPoint) {
    }

    @Override
    public void create(Point2D[] points) {
    }

    public void creationEnd() {
    }

    @Override
    public void moveEndPoint(int ctrl, int movePtIndex, Point2D currentPoint) {
    }

    @Override
    public void moveEndPoint(int ctrl, int movingPoint, Point2D oldPoint, Point2D currentPoint) {
        if (ctrl >= 3) {
            return;
        }
        this.getShapeContainer().setChangeCode(4);
        Point2D newPT = currentPoint;
        Point2D oldPT = oldPoint;
        if (ctrl > 0) {
            newPT = DiscreteAngledLine.getControlledPT(0.0, 90.0, oldPoint, newPT);
            oldPT = DiscreteAngledLine.getControlledPT(0.0, 90.0, oldPoint, oldPT);
        }
        Point2D anchorP = null;
        int numseg = this.curve2D.getNumOfSegments();
        anchorP = movingPoint == 0 ? this.curve2D.getP(numseg) : this.curve2D.getP(0.0);
        Vector2D r0 = Vector2D.sub(oldPT, anchorP);
        Vector2D r = Vector2D.sub(newPT, anchorP);
        Matrix2D rotationMatrix = Matrix2D.getRotationMatrix(anchorP, r0, r);
        if (this.debug > 0) {
            System.out.println("  moveEndPoint movingPoint=" + movingPoint + "  r0,r1=" + r0.toString() + " ," + r.toString());
        }
        Segment2D[] segments = new Segment2D[numseg];
        for (int i = 0; i < numseg; ++i) {
            segments[i] = this.curve2D.getSegment2D(i);
            segments[i] = segments[i].transformSegment(rotationMatrix);
        }
        this.curve2D.setData(segments);
    }

    @Override
    public void modify(int ctrl, Point2D oldPoint, Point2D currentPoint) {
        if (this.topologyChanged) {
            return;
        }
        this.topologyChanged = SegmentModifier.modify(this.curve2D, this.hitSegmentModifier, ctrl, this.startPoint, oldPoint, currentPoint);
    }

    @Override
    public void modifyPoint(Point2D point, String command) {
        if (this.debug > 0) {
            System.out.println("modifyPoint command=" + command);
        }
        if (command.equals("add_point")) {
            SegmentModifier.addPoint(this.curve2D, this.hitSegmentModifier, point);
        }
        if (command.equals("delete_point")) {
            SegmentModifier.deletePoint(this.curve2D, this.hitSegmentModifier);
        }
        if (command.equals("smooth")) {
            SegmentModifier.smoothPoint(this.curve2D, this.hitSegmentModifier);
        }
        if (command.equals("cusp")) {
            SegmentModifier.cuspPoint(this.curve2D, this.hitSegmentModifier);
        }
        if (command.equals("disconnect")) {
            SegmentModifier.disconnectPoint(this.curve2D, this.hitSegmentModifier);
        }
    }

    @Override
    public Object clone() {
        GeneralCurveElement shapeElement = new GeneralCurveElement();
        GeneralCurve2DE generalCurve = (GeneralCurve2DE)this.curve2D.clone();
        shapeElement.setCurve2D(generalCurve);
        return shapeElement;
    }

    @Override
    public String toString() {
        String str = "";
        if (this.curve2D == null) {
            str = str + "GeneralCurve: not defined";
            return str;
        }
        return this.curve2D.toString();
    }
}

