/*
 * Decompiled with CFR 0.152.
 */
package shape;

import geomExtension.Curve2D;
import geomExtension.CurvePT;
import geomExtension.SerializableCurve2D;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Vector;
import shape.SegmentModifier;
import shape.ShapeContainer;
import shape.ShapeElement;
import shape.ShapeElementUtil;

public class GroupElement
extends ShapeElement {
    private ArrayList childrenList = new ArrayList();
    public static int debug = 0;

    @Override
    public int getTypeE() {
        return 180;
    }

    @Override
    public String getShapeIdString() {
        return "Group";
    }

    @Override
    public Shape getShape() {
        return null;
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public Curve2D getCurve2D() {
        return null;
    }

    @Override
    public void setCurve2D(Curve2D curve) {
    }

    @Override
    public SerializableCurve2D getSerializableCurve2D() {
        return null;
    }

    @Override
    public void setSerializableCurve2D(SerializableCurve2D curve2Ddata) {
    }

    @Override
    public Rectangle2D getBoundingBox() {
        double xmin;
        ShapeContainer[] shapeContainers = this.getGroupedSingleShapeContainers();
        Rectangle2D boundingBox = null;
        double ymin = xmin = Math.pow(10.0, 4.0);
        double xmax = -xmin;
        double ymax = -xmin;
        for (int i = 0; i < shapeContainers.length; ++i) {
            boundingBox = shapeContainers[i].getBoundingBox();
            if (boundingBox == null) {
                System.err.println("*** Warning GroupElement " + shapeContainers[i].getShapeId() + ": boundingBox=null");
                return null;
            }
            double x = boundingBox.getX();
            double y = boundingBox.getY();
            double w = boundingBox.getWidth();
            double h = boundingBox.getHeight();
            if (x < xmin) {
                xmin = x;
            }
            if (y < ymin) {
                ymin = y;
            }
            if (x + w > xmax) {
                xmax = x + w;
            }
            if (!(y + h > ymax)) continue;
            ymax = y + h;
        }
        Rectangle2D.Double groupBoundingBox = new Rectangle2D.Double(xmin, ymin, xmax - xmin, ymax - ymin);
        return groupBoundingBox;
    }

    @Override
    public Point2D[] getEndPTs() {
        Point2D[] PTs = new Point2D[]{};
        return PTs;
    }

    @Override
    public Rectangle2D createTextArea() {
        return null;
    }

    public Point2D[] getSamplingPTs(Rectangle2D box) {
        return new Point2D[0];
    }

    public CurvePT[] getSamplingCurvePTs(Rectangle2D box) {
        return null;
    }

    @Override
    public SegmentModifier[] getSegmentModifiers() {
        SegmentModifier[] modifiers = new SegmentModifier[]{};
        return modifiers;
    }

    @Override
    public Point2D[] getModifierPTs() {
        Point2D[] PTs = new Point2D[]{};
        return PTs;
    }

    @Override
    public void mouseStart(int ctrl, Point2D startPoint) {
        super.mouseStart(ctrl, startPoint);
        this.getShapeContainer().setChangeCode(5);
        ShapeContainer[] childShapeContainers = this.getGroupedSingleShapeContainers();
        int size = 0;
        if (childShapeContainers != null) {
            size = childShapeContainers.length;
        }
        for (int i = 0; i < size; ++i) {
            childShapeContainers[i].getElement().mouseStart(ctrl, startPoint);
        }
    }

    @Override
    public void create(Point2D startPoint, Point2D currentPoint) {
    }

    @Override
    public void create(Rectangle2D boundingBox) {
    }

    @Override
    public void create(Point2D[] points) {
    }

    @Override
    public void move(int ctrl, Point2D currentPoint, boolean resizeTextBox) {
        Rectangle2D oldBox = this.getBoundingBox();
        double x = this.startBox.getX();
        double y = this.startBox.getY();
        double w = this.startBox.getWidth();
        double h = this.startBox.getHeight();
        double moveX = currentPoint.getX() - this.startPoint.getX();
        double moveY = currentPoint.getY() - this.startPoint.getY();
        Rectangle2D.Double newBox = new Rectangle2D.Double(x + moveX, y + moveY, w, h);
        ShapeContainer[] childShapeContainers = this.getGroupedSingleShapeContainers();
        int size = 0;
        if (childShapeContainers != null) {
            size = childShapeContainers.length;
        }
        for (int i = 0; i < size; ++i) {
            childShapeContainers[i].getElement().moveResize(oldBox, newBox, resizeTextBox);
        }
    }

    @Override
    public void resize(int ctrl, Point2D currentPoint, String mousePosition, boolean resizeTextBox) {
        Rectangle2D oldBox = this.getBoundingBox();
        boolean resizable = this.shapeContainer.getBooleanProperty("Enable_Resizing", "GroupElement");
        boolean keep_aspect_ratio = this.shapeContainer.getBooleanProperty("Keep_Aspect_Ratio", "GroupElement");
        if (!resizable) {
            return;
        }
        if (keep_aspect_ratio) {
            ctrl = 1;
        }
        Rectangle2D newBox = ShapeElementUtil.resizeRectangle(ctrl, this.startBox, this.startPoint, currentPoint, mousePosition);
        ShapeContainer[] childShapeContainers = this.getGroupedSingleShapeContainers();
        int size = 0;
        if (childShapeContainers != null) {
            size = childShapeContainers.length;
        }
        for (int i = 0; i < size; ++i) {
            childShapeContainers[i].getElement().moveResize(oldBox, newBox, resizeTextBox);
        }
    }

    @Override
    public void moveResize(Rectangle2D oldBox, Rectangle2D newBox, boolean resizeTextBox) {
        this.getShapeContainer().setChangeCode(5);
        ShapeContainer[] childShapeContainers = this.getGroupedSingleShapeContainers();
        int size = 0;
        if (childShapeContainers != null) {
            size = childShapeContainers.length;
        }
        for (int i = 0; i < size; ++i) {
            childShapeContainers[i].getElement().moveResize(oldBox, newBox, true);
        }
    }

    @Override
    public void moveEndPoint(int ctrl, int movePtIndex, Point2D currentPoint) {
    }

    @Override
    public void moveEndPoint(int ctrl, int movingIndex, Point2D oldPoint, Point2D newPoint) {
    }

    @Override
    public void modify(int ctrl, Point2D oldPoint, Point2D newPoint) {
    }

    @Override
    public void modifyPoint(Point2D point, String command) {
    }

    public ArrayList getChildrenList() {
        return this.childrenList;
    }

    public void setChildrenList(ArrayList childrenList) {
        this.childrenList = childrenList;
    }

    public ShapeContainer[] getChildren() {
        int size = 0;
        if (this.childrenList != null) {
            size = this.childrenList.size();
        }
        ShapeContainer[] containers = new ShapeContainer[size];
        for (int i = 0; i < size; ++i) {
            containers[i] = (ShapeContainer)this.childrenList.get(i);
        }
        return containers;
    }

    public void addChildren(ShapeContainer container) {
        int position = this.childrenList.indexOf(container);
        if (position >= 0) {
            this.childrenList.remove(position);
        } else {
            this.childrenList.add(container);
        }
    }

    public ShapeContainer[] getGroupedContainers() {
        Vector vector = new Vector();
        this.getGroupedContainers(vector);
        int length = 0;
        if (vector.size() > 0) {
            length = vector.size();
        }
        ShapeContainer[] containers = new ShapeContainer[length];
        for (int i = 0; i < length; ++i) {
            containers[i] = (ShapeContainer)vector.get(i);
        }
        return containers;
    }

    public void getGroupedContainers(Vector vector) {
        ArrayList childrenList = this.childrenList;
        int size = 0;
        if (this.childrenList != null) {
            size = childrenList.size();
        }
        for (int i = 0; i < size; ++i) {
            ShapeContainer container = (ShapeContainer)childrenList.get(i);
            int type = container.getContainerType();
            if (type == ShapeContainer.SHAPE) {
                vector.add(container);
                continue;
            }
            ShapeContainer shapeContainer = container;
            vector.add(shapeContainer);
            GroupElement groupElement = (GroupElement)shapeContainer.getElement();
            groupElement.getGroupedContainers(vector);
        }
    }

    public ShapeContainer[] getGroupedSingleShapeContainers() {
        Vector vector = new Vector();
        this.getGroupedSingleShapeContainers(vector);
        int length = 0;
        if (vector.size() > 0) {
            length = vector.size();
        }
        ShapeContainer[] shapeContainers = new ShapeContainer[length];
        for (int i = 0; i < length; ++i) {
            shapeContainers[i] = (ShapeContainer)vector.get(i);
        }
        return shapeContainers;
    }

    public void getGroupedSingleShapeContainers(Vector vector) {
        ArrayList childrenList = this.childrenList;
        int size = 0;
        if (this.childrenList != null) {
            size = childrenList.size();
        }
        for (int i = 0; i < size; ++i) {
            ShapeContainer container = (ShapeContainer)childrenList.get(i);
            int type = container.getContainerType();
            if (type == ShapeContainer.SHAPE) {
                vector.add(container);
                continue;
            }
            ShapeContainer shapeContainer = container;
            GroupElement groupElement = (GroupElement)shapeContainer.getElement();
            groupElement.getGroupedSingleShapeContainers(vector);
        }
    }

    public void getGroupTreeDepth(Vector vector) {
        Integer treeDepth = (Integer)vector.get(1);
        treeDepth = treeDepth + 1;
        if (debug > 0) {
            System.out.println("   ** GroupElement getGroupTreeDepth treeDepth=" + treeDepth + ", search shapeId=" + (String)vector.get(0) + ", target shapeId=" + this.getShapeContainer().getShapeId());
        }
        vector.set(1, treeDepth);
        ArrayList childrenList = this.childrenList;
        int size = 0;
        if (this.childrenList != null) {
            size = childrenList.size();
        }
        for (int i = 0; i < size; ++i) {
            ShapeContainer childContainer = (ShapeContainer)childrenList.get(i);
            int type = childContainer.getContainerType();
            String shapeId = (String)vector.get(0);
            if (childContainer.getShapeId().equals(shapeId)) {
                vector.set(2, new Integer(treeDepth));
                return;
            }
            if (type != ShapeContainer.GROUP) continue;
            GroupElement groupElement = (GroupElement)childContainer.getElement();
            groupElement.getGroupTreeDepth(vector);
        }
        treeDepth = (Integer)vector.get(1);
        treeDepth = treeDepth - 1;
        vector.set(1, treeDepth);
    }

    @Override
    public Object clone() {
        return null;
    }

    @Override
    public String toString() {
        String str = "";
        ShapeContainer[] children = this.getChildren();
        int size = 0;
        if (children != null) {
            size = children.length;
        }
        for (int i = 0; i < size; ++i) {
            if (children[i] == null) continue;
            str = str + children[i].getShapeId() + ", ";
        }
        str = str + "\n    ** all containers under this group --> ";
        ShapeContainer[] containers = this.getGroupedContainers();
        size = 0;
        if (containers != null) {
            size = containers.length;
        }
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                str = str + ", ";
            }
            str = str + containers[i].getShapeId();
        }
        return str;
    }

    public String toShortString() {
        String str = "";
        ShapeContainer[] containers = this.getChildren();
        int size = 0;
        if (containers != null) {
            size = containers.length;
        }
        for (int i = 0; i < size; ++i) {
            if (containers[i] == null) continue;
            if (i > 0) {
                str = str + ", ";
            }
            str = str + containers[i].getShapeId();
        }
        return str;
    }
}

