/*
 * Decompiled with CFR 0.152.
 */
package shape;

import geomExtension.Rectangle2DE;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import shape.SegmentModifier;
import shape.ShapeElement;

public class ImageElement
extends ShapeElement {
    private BufferedImage bufferedImage = null;

    @Override
    public int getTypeE() {
        return 46;
    }

    @Override
    public String getShapeIdString() {
        return "Image";
    }

    @Override
    public Rectangle2D createTextArea() {
        return null;
    }

    public Image getBufferedImage() {
        return this.bufferedImage;
    }

    public byte[] getByteImage() {
        byte[] byteData = null;
        if (this.bufferedImage == null) {
            return null;
        }
        try {
            int w = this.bufferedImage.getWidth(null);
            int h = this.bufferedImage.getHeight(null);
            if (this.bufferedImage.getType() != 1) {
                BufferedImage bi = new BufferedImage(w, h, 1);
                Graphics g = bi.getGraphics();
                g.drawImage(this.bufferedImage, 0, 0, null);
                this.bufferedImage = bi;
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)this.bufferedImage, "JPG", outputStream);
            byteData = outputStream.toByteArray();
        }
        catch (IOException e) {
            System.out.println("*** Error ImageElement: Image could not be write");
        }
        return byteData;
    }

    public void setByteImage(byte[] byteData) {
        if (byteData == null) {
            return;
        }
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(byteData);
            this.bufferedImage = ImageIO.read(inputStream);
        }
        catch (IOException e) {
            System.out.println("*** Error ImageElement: Image could not be read");
        }
    }

    @Override
    public SegmentModifier[] getSegmentModifiers() {
        SegmentModifier[] modifiers = new SegmentModifier[]{};
        return modifiers;
    }

    @Override
    public Point2D[] getModifierPTs() {
        Point2D[] PTs = new Point2D[]{};
        return PTs;
    }

    @Override
    public void create(Point2D startPoint, Point2D currentPoint) {
    }

    @Override
    public void create(Rectangle2D boundingBox) {
        double X = boundingBox.getX();
        double Y = boundingBox.getY();
        double Width = boundingBox.getWidth();
        double Height = boundingBox.getHeight();
        this.curve2D = new Rectangle2DE(X, Y, Width, Height);
    }

    @Override
    public void create(Point2D[] points) {
    }

    public int getControlPTIndex(Point2D point) {
        return -1;
    }

    @Override
    public void moveEndPoint(int ctrl, int movePtIndex, Point2D currentPoint) {
    }

    @Override
    public void moveEndPoint(int ctrl, int movePtIndex, Point2D oldPoint, Point2D newPoint) {
    }

    @Override
    public void modify(int ctrl, Point2D oldPoint, Point2D newPoint) {
    }

    @Override
    public void modifyPoint(Point2D point, String command) {
    }

    @Override
    public Object clone() {
        ImageElement imageElement = new ImageElement();
        Rectangle2DE curve = (Rectangle2DE)this.curve2D.clone();
        imageElement.setCurve2D(curve);
        byte[] image = this.getByteImage();
        imageElement.setByteImage(image);
        return imageElement;
    }

    @Override
    public String toString() {
        String str = "";
        if (this.curve2D == null) {
            str = str + "Image: not defined";
            return str;
        }
        Rectangle2DE rectangle = (Rectangle2DE)this.curve2D;
        double x = rectangle.getX();
        double y = rectangle.getY();
        double width = rectangle.getWidth();
        double height = rectangle.getHeight();
        str = "Rectangle x,y=(" + String.valueOf((int)x) + "," + String.valueOf((int)y) + ")" + " width,height=" + String.valueOf((int)width) + "," + String.valueOf((int)height);
        return str;
    }
}

