/*
 * Decompiled with CFR 0.152.
 */
package shape;

import DrawTop.Command;
import DrawTop.DrawParameters;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Set;
import java.util.Vector;
import shape.DrawShapeUtil;
import shape.GroupElement;
import shape.PaintStyle;
import shape.ShapeElement;
import textBox.CaretPosition;
import textBox.TextBox;
import util.ContainerManager;
import util.UndoConstants;
import util.Util;

public class ShapeContainer {
    private String shapeId = "";
    protected int containerIndex = -1;
    private ShapeContainer parent = null;
    private ShapeElement element = null;
    private TextBox textBox = null;
    private PaintStyle paintStyle = null;
    public HashMap<String, Object> property = new HashMap();
    private boolean selected = false;
    private boolean visible = true;
    private boolean highlighting = false;
    private boolean blinking = false;
    protected int mode = 0;
    private int changeCode = -1;
    public boolean connectorTargetPermission = true;
    public boolean connectorPermission = true;
    public static int SHAPE = 0;
    public static int GROUP = 1;
    public static int debug = 0;
    int idNumber = 0;

    public ShapeContainer() {
        this.paintStyle = new PaintStyle(this);
    }

    public int getContainerType() {
        int type = SHAPE;
        if (this.element == null) {
            return type;
        }
        if (this.element.getTypeE() == 180) {
            type = GROUP;
        }
        return type;
    }

    public String getShapeId() {
        return this.shapeId;
    }

    public void setShapeId(String shapeId) {
        this.shapeId = shapeId;
    }

    public int getElementType(String shapeId) {
        int index = shapeId.indexOf("(");
        String type = shapeId.substring(0, index);
        int id = Command.getCommandId(type);
        if (id < 0) {
            System.err.println("***Error  getElementType shapeId" + shapeId + ", type=" + type);
        }
        return id;
    }

    public void setNewShapeId(ContainerManager manager, boolean withChildren) {
        String shapeId = this.getShapeId();
        String id = "";
        int serialNumber = manager.getUniqueSerialNumber();
        this.shapeId = id = this.configureShapeId(serialNumber);
        if (debug > 0) {
            System.out.println("** ShapeContainer.setShapeId newId=" + this.getShapeId() + ", serialNumber=" + serialNumber);
        }
        if (!withChildren) {
            return;
        }
        ShapeContainer[] children = this.getGroupedContainers();
        int size = 0;
        if (children != null) {
            size = children.length;
        }
        for (int i = 1; i < size; ++i) {
            shapeId = children[i].getShapeId();
            serialNumber = manager.getUniqueSerialNumber();
            id = children[i].configureShapeId(serialNumber);
            children[i].setShapeId(id);
            if (debug <= 0) continue;
            System.out.println("** Children setShapeId newId=" + children[i].getShapeId() + ", serialNumber=" + serialNumber);
        }
    }

    public String configureShapeId(int number) {
        String idStr = this.getElement().getShapeIdString();
        idStr = idStr + "(No-" + number + ")";
        return idStr;
    }

    public int getSerialNumber() {
        int num = -1;
        String shapeId = this.shapeId;
        if (shapeId == null || shapeId.equals("")) {
            return num;
        }
        int start = shapeId.lastIndexOf("-");
        int end = shapeId.lastIndexOf(")");
        String subStr = shapeId.substring(start + 1, end);
        subStr = subStr.replace(" ", "");
        num = Integer.parseInt(subStr);
        return num;
    }

    private static int getSerialNumber(String shapeId, String callFrom) {
        int num = -1;
        if (shapeId == null || shapeId.equals("")) {
            return num;
        }
        int start = shapeId.lastIndexOf("-");
        int end = shapeId.lastIndexOf(")");
        String subStr = shapeId.substring(start + 1, end);
        num = Integer.parseInt(subStr);
        if (debug > 0) {
            System.out.println("getSerialNumber(String) callFrom=" + callFrom);
        }
        return num;
    }

    public int getContainerIndex() {
        return this.containerIndex;
    }

    public void setContainerIndex(int containerIndex) {
        this.containerIndex = containerIndex;
    }

    public ShapeContainer getParent() {
        return this.parent;
    }

    public void setParent(ShapeContainer parent) {
        this.parent = parent;
    }

    public ShapeContainer getTopParent() {
        ShapeContainer topParent = null;
        if (this.parent == null) {
            return this;
        }
        topParent = this.parent.getTopParent();
        return topParent;
    }

    public ShapeElement getElement() {
        String id = this.shapeId;
        if (this.element == null && this.getContainerType() == SHAPE) {
            System.err.println("*** Error ShapeContainer.getElement: element=null, shapeId=" + id);
        }
        return this.element;
    }

    public void setElement(ShapeElement element) {
        this.element = element;
        element.shapeContainer = this;
        if (!this.getShapeId().equals("")) {
            int num = this.getSerialNumber();
            String shapeId = this.configureShapeId(num);
            this.setShapeId(shapeId);
        }
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        if (debug > 0) {
            System.out.println(" ** ShapeContainer id=" + this.getShapeId() + ", setMode=" + Command.getModeString(mode));
        }
        this.mode = mode;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        if (!selected && this.isEditableTextBox()) {
            this.makeTextBoxEditable(false);
        }
        ShapeContainer[] containers = this.getGroupedContainers();
        for (int i = 1; i < containers.length; ++i) {
            containers[i].selected = selected;
            if (selected || !containers[i].isEditableTextBox()) continue;
            containers[i].makeTextBoxEditable(false);
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setHighlighting(boolean highlighting) {
        if (!DrawParameters.ENABLE_HIGHLIGHTING) {
            return;
        }
        this.highlighting = highlighting;
        if (this.getContainerType() == GROUP) {
            ShapeContainer[] containers = this.getGroupedContainers();
            for (int i = 0; i < containers.length; ++i) {
                containers[i].highlighting = highlighting;
            }
        }
    }

    public boolean isHighlighting() {
        return this.highlighting;
    }

    public void setBlinking(boolean blinking) {
        if (!DrawParameters.ENABLE_BLINKING) {
            return;
        }
        this.blinking = blinking;
        if (this.getContainerType() == GROUP) {
            ShapeContainer[] containers = this.getGroupedContainers();
            for (int i = 0; i < containers.length; ++i) {
                containers[i].blinking = blinking;
            }
        }
    }

    public boolean isBlinking() {
        return this.blinking;
    }

    public boolean isEditableTextBox() {
        if (!this.isTextBox()) {
            return false;
        }
        return this.getTextBox().isEditable();
    }

    public void makeTextBoxEditable(boolean activate) {
        if (!this.isTextBox()) {
            return;
        }
        if (activate) {
            if (!this.isSelected()) {
                this.setSelected(true);
            }
            this.getTextBox().activateMouseListener(true);
        }
        if (!activate) {
            this.getTextBox().activateMouseListener(false);
        }
    }

    public void makeTextBoxEditable(Point2D point, int ctrl) {
        if (!this.isTextBox()) {
            return;
        }
        if (!this.isSelected()) {
            this.setSelected(true);
        }
        TextBox textBox = this.getTextBox();
        textBox.activateMouseListener(true);
        double X = point.getX();
        double Y = point.getY();
        CaretPosition caretP = textBox.getCaretPositionAtMouse(X, Y, "makeTextBoxEditable");
        if (caretP != null) {
            textBox.setTextSelection(caretP, null, ctrl, "makeTextBoxEditable");
        }
    }

    public int getChangeCode() {
        return this.changeCode;
    }

    public void setChangeCode(int code) {
        this.changeCode = code;
        if (debug > 0) {
            System.out.println("ShapeContainer setChangeCode=" + UndoConstants.undoStr[code] + ", " + this.getShapeId());
        }
    }

    public void setChangeCode(int code, String callFrom) {
        this.changeCode = code;
        if (debug > 0) {
            System.out.println("ShapeContainer setChangeCode=" + UndoConstants.undoStr[code] + ", " + this.getShapeId() + ", callfrom=" + callFrom);
        }
    }

    public void resetChangeCode() {
        this.changeCode = -1;
    }

    public void setProperty(String key, Object object, String callFrom) {
        this.property.put(key, object);
        if (debug > 0) {
            boolean print = false;
            String command = "";
            command = Command.getCommandString(253);
            if (key.equalsIgnoreCase(command)) {
                print = true;
            }
            if (key.equalsIgnoreCase(command = Command.getCommandString(256))) {
                print = true;
            }
            if (key.equalsIgnoreCase(command = Command.getCommandString(257))) {
                print = true;
            }
            if (print) {
                System.out.println("ShapeContainer.setProperty key=" + key + ", value=" + object + ", call From=" + callFrom);
            }
        }
    }

    public Object getProperty(String key) {
        String typeStr;
        Object inf = null;
        String original_type = Command.getCommandString(250);
        if (key.equals(original_type) && (typeStr = (String)this.property.get("type")) != null && !typeStr.equals("")) {
            String str = new String(typeStr);
            this.property.put(original_type, str);
            this.property.remove("type");
        }
        inf = this.property.get(key);
        return inf;
    }

    public void removeProperty(String key, String callFrom) {
        this.property.remove(key);
        if (debug > 0) {
            boolean print = false;
            String command = "";
            command = Command.getCommandString(253);
            if (key.equalsIgnoreCase(command)) {
                print = true;
            }
            if (key.equalsIgnoreCase(command = Command.getCommandString(256))) {
                print = true;
            }
            if (key.equalsIgnoreCase(command = Command.getCommandString(257))) {
                print = true;
            }
            if (print) {
                System.out.println("ShapeContainer.removeProperty key=" + key + ", call From=" + callFrom);
            }
        }
    }

    public boolean getBooleanProperty(String key, String callFrom) {
        String pKey = "";
        String command = "";
        boolean value = false;
        command = Command.getCommandString(253);
        if (key.equalsIgnoreCase(command)) {
            pKey = command;
            value = true;
        }
        if (key.equalsIgnoreCase(command = Command.getCommandString(255))) {
            pKey = command;
            value = false;
        }
        if (key.equalsIgnoreCase(command = Command.getCommandString(256))) {
            pKey = command;
            value = false;
        }
        if (key.equalsIgnoreCase(command = Command.getCommandString(257))) {
            pKey = command;
            value = true;
        }
        if (key.equalsIgnoreCase(command = Command.getCommandString(259))) {
            pKey = command;
            value = true;
        }
        if (pKey.equals("")) {
            System.err.println("*** Error ShapeContainer.getBooleanPropery Undefined key,  key=" + key + ", call From=" + callFrom);
            return false;
        }
        Object object = this.getProperty(pKey);
        if (object != null) {
            String className = object.getClass().getSimpleName();
            if (className.equals("Boolean")) {
                Boolean flag = (Boolean)object;
                value = flag;
            } else {
                String flag = (String)object;
                value = Boolean.parseBoolean(flag);
            }
        }
        if (debug > 0) {
            boolean print = false;
            command = "";
            command = Command.getCommandString(253);
            if (key.equalsIgnoreCase(command)) {
                print = true;
            }
            if (key.equalsIgnoreCase(command = Command.getCommandString(256))) {
                print = true;
            }
            if (key.equalsIgnoreCase(command = Command.getCommandString(257))) {
                print = true;
            }
            if (print) {
                System.out.println("ShapeContainer.getBooleanPropery , key=" + key + ", object=" + object + ", value=" + value + ", call From=" + callFrom);
            }
        }
        return value;
    }

    public PaintStyle getPaintStyle() {
        if (this.paintStyle.getShapeContainer() == null) {
            this.paintStyle.setShapeContainer(this);
        }
        return this.paintStyle;
    }

    public void setPaintStyle(PaintStyle paintStyle) {
        this.paintStyle = paintStyle;
        if (paintStyle.getShapeContainer() == null || !paintStyle.getShapeContainer().getShapeId().equals(this.shapeId)) {
            paintStyle.setShapeContainer(this);
        }
    }

    public Color[] getColors() {
        int i;
        TextBox textBox;
        Vector<Color> vector = new Vector<Color>();
        Color[] colors = new Color[]{};
        if (this.getContainerType() != SHAPE) {
            return colors;
        }
        PaintStyle style = this.getPaintStyle();
        if (style.getFillColor() != null) {
            vector.add(style.getFillColor());
        }
        if (style.getLineColor() != null) {
            vector.add(style.getLineColor());
        }
        if ((textBox = this.getTextBox()) != null) {
            Color[] fontColors = textBox.getFontColors();
            for (i = 0; i < fontColors.length; ++i) {
                if (fontColors[i] == null) continue;
                vector.add(fontColors[i]);
            }
        }
        Vector<Color> vector0 = new Vector<Color>();
        for (i = 0; i < vector.size(); ++i) {
            Color color = (Color)vector.get(i);
            int rgb = color.getRGB();
            int jsave = -1;
            for (int j = 0; j < vector0.size(); ++j) {
                if (((Color)vector0.get(j)).getRGB() != rgb) continue;
                jsave = j;
                break;
            }
            if (jsave != -1) continue;
            vector0.add(color);
        }
        colors = new Color[vector0.size()];
        for (i = 0; i < vector0.size(); ++i) {
            colors[i] = (Color)vector0.get(i);
        }
        return colors;
    }

    public boolean isTextBox() {
        boolean hasTextBox = false;
        if (this.textBox != null) {
            hasTextBox = true;
        }
        return hasTextBox;
    }

    public boolean isCommittedText() {
        boolean text = false;
        if (this.textBox != null && this.textBox.isCommittedText()) {
            text = true;
        }
        return text;
    }

    public int addTextBox() {
        Rectangle2D textArea;
        int result = 0;
        if (this.getContainerType() == GROUP) {
            result = 1;
        } else {
            int type = this.getElement().getTypeE();
            if (type < 43 || type > 56) {
                result = 2;
            }
        }
        if (!this.element.isClosed()) {
            result = 3;
        }
        if (this.isTextBox()) {
            result = 4;
        }
        if ((textArea = this.element.createTextArea()) == null) {
            result = 5;
        }
        if (textArea != null && (textArea.getWidth() < ShapeElement.MinTextArea.getWidth() || textArea.getHeight() < ShapeElement.MinTextArea.getHeight())) {
            result = 6;
        }
        if (result == 0) {
            TextBox newTextBox = new TextBox();
            newTextBox.setShapeContainer(this);
            newTextBox.setTextArea(textArea);
            this.textBox = newTextBox;
            newTextBox.setShapeContainer(this);
        } else {
            System.err.println("*** Error ShapeContainer.addTextBox error code=" + result);
            if (result == 6) {
                System.err.println(" --created text area too small, text area: " + Util.Rect(textArea));
            }
        }
        return result;
    }

    public void addTextBox(Rectangle2D textArea) {
        TextBox newTextBox = new TextBox();
        newTextBox.setShapeContainer(this);
        newTextBox.setTextArea(textArea);
        this.textBox = newTextBox;
    }

    public int deleteTextBox() {
        int result = 0;
        if (this.getContainerType() == GROUP) {
            result = 1;
            return result;
        }
        int type = this.getElement().getTypeE();
        if (type < 43 || type > 56) {
            result = 2;
            return result;
        }
        if (!this.element.isClosed()) {
            result = 3;
            return result;
        }
        if (this.textBox == null) {
            result = 4;
            return result;
        }
        TextBox currentTBox = this.getTextBox();
        this.makeTextBoxEditable(false);
        currentTBox.setShapeContainer(null);
        this.textBox = null;
        if (debug > 0) {
            System.out.println("ShapeContainer deleteTextBox result=" + result);
        }
        return result;
    }

    public TextBox getTextBox() {
        return this.textBox;
    }

    public void setTextBox(TextBox textBox) {
        this.textBox = textBox;
        this.textBox.setShapeContainer(this);
    }

    public void setConnectorTargetPermission(boolean permission) {
        this.connectorTargetPermission = permission;
    }

    public void setConnectorPermission(boolean permission) {
        this.connectorPermission = permission;
        if (this.element == null) {
            return;
        }
        int type = this.getElement().getTypeE();
        if (type == 51 || type == 52 || type == 53 || type == 54) {
            return;
        }
        this.connectorPermission = false;
    }

    public boolean isConnectorTarget() {
        return this.connectorTargetPermission;
    }

    public boolean isConnector() {
        if (this.getElement() == null || this.getContainerType() == GROUP) {
            this.connectorPermission = false;
            return false;
        }
        int type = this.getElement().getTypeE();
        boolean close = this.getElement().isClosed();
        if (type == 51 || type == 52 || type == 53 || type == 54 && !close) {
            return this.connectorPermission;
        }
        return false;
    }

    public boolean compare(ShapeContainer container) {
        boolean compare = false;
        if (this.getSerialNumber() == container.getSerialNumber()) {
            compare = true;
        }
        return compare;
    }

    public boolean compare(ShapeContainer[] containers) {
        boolean found = false;
        if (containers == null) {
            return false;
        }
        for (int i = 0; i < containers.length; ++i) {
            if (this.getSerialNumber() != containers[i].getSerialNumber()) continue;
            found = true;
            break;
        }
        return found;
    }

    public ShapeContainer[] getGroupedContainers() {
        ShapeContainer[] children = new ShapeContainer[]{};
        if (this.getContainerType() == GROUP) {
            GroupElement groupElement = (GroupElement)this.getElement();
            children = groupElement.getGroupedContainers();
        }
        ShapeContainer[] containers = new ShapeContainer[1 + children.length];
        containers[0] = this;
        for (int i = 0; i < children.length; ++i) {
            containers[i + 1] = children[i];
        }
        return containers;
    }

    public ShapeContainer[] getGroupedSingleShapeContainers() {
        ShapeContainer[] shapeContainers = new ShapeContainer[1];
        if (this.getContainerType() == SHAPE) {
            shapeContainers[0] = this;
        } else {
            GroupElement groupElement = (GroupElement)this.getElement();
            shapeContainers = groupElement.getGroupedSingleShapeContainers();
        }
        return shapeContainers;
    }

    public int getGroupTreeDepth(String shapeId) {
        Vector<Object> vector = new Vector<Object>();
        Integer treeDepth = new Integer(0);
        Integer findDepth = new Integer(-1);
        vector.add(shapeId);
        vector.add(treeDepth);
        vector.add(findDepth);
        if (this.getShapeId().equals(shapeId)) {
            findDepth = new Integer(0);
            return 0;
        }
        if (this.getContainerType() == GROUP) {
            GroupElement groupElement = (GroupElement)this.getElement();
            groupElement.getGroupTreeDepth(vector);
        }
        findDepth = (Integer)vector.get(2);
        return findDepth;
    }

    public TextBox[] getGroupedTextBoxes() {
        TextBox[] textBoxes = new TextBox[]{};
        if (this.getContainerType() == SHAPE) {
            if (this.isTextBox()) {
                textBoxes = new TextBox[]{this.getTextBox()};
            }
        } else {
            ShapeContainer[] children = this.getGroupedSingleShapeContainers();
            Vector<TextBox> vector = new Vector<TextBox>();
            for (int i = 0; i < children.length; ++i) {
                if (!children[i].isTextBox()) continue;
                vector.add(children[i].getTextBox());
            }
            int size = vector.size();
            textBoxes = new TextBox[size];
            for (int i = 0; i < size; ++i) {
                textBoxes[i] = (TextBox)vector.get(i);
            }
        }
        return textBoxes;
    }

    public TextBox getGroupedTextBox(int serialNumber) {
        TextBox targetTextBox = null;
        TextBox[] textBoxes = this.getGroupedTextBoxes();
        for (int i = 0; i < textBoxes.length; ++i) {
            if (textBoxes[i].getShapeContainer().getSerialNumber() != serialNumber) continue;
            targetTextBox = textBoxes[i];
            break;
        }
        if (targetTextBox == null) {
            System.err.println("*** Error in ShapeContainer.getGroupedTextBox:Target TextBox not found, shapeId=" + this.shapeId + ", this.shapeId=" + this.getShapeId());
        }
        return targetTextBox;
    }

    public PaintStyle[] getGroupedPaintStyles() {
        PaintStyle[] paintStyles = new PaintStyle[]{};
        if (this.getContainerType() == SHAPE) {
            paintStyles = new PaintStyle[]{this.getPaintStyle()};
        } else {
            ShapeContainer[] children = this.getGroupedSingleShapeContainers();
            Vector<PaintStyle> vector = new Vector<PaintStyle>();
            for (int i = 0; i < children.length; ++i) {
                vector.add(children[i].getPaintStyle());
            }
            int size = vector.size();
            paintStyles = new PaintStyle[size];
            for (int i = 0; i < size; ++i) {
                paintStyles[i] = (PaintStyle)vector.get(i);
            }
        }
        return paintStyles;
    }

    public PaintStyle getGroupedPaintStyle(int serialNumber) {
        PaintStyle targetPaintStyle = null;
        PaintStyle[] paintStyles = this.getGroupedPaintStyles();
        for (int i = 0; i < paintStyles.length; ++i) {
            if (paintStyles[i].getShapeContainer().getSerialNumber() != serialNumber) continue;
            targetPaintStyle = paintStyles[i];
            break;
        }
        if (targetPaintStyle == null) {
            System.err.println("*** Error in ShapeContainer.getGroupedPaintStyle:Target paintStyle not found, shapeId=" + this.shapeId + ", this.shapeId=" + this.getShapeId());
        }
        return targetPaintStyle;
    }

    public Rectangle2D getBoundingBox() {
        return this.element.getBoundingBox();
    }

    public void setTextBoxLayout(Insets textBoxInsets, int textAlign, double lineSpace) {
        ShapeContainer[] containers = this.getGroupedSingleShapeContainers();
        for (int i = 0; i < containers.length; ++i) {
            if (!containers[i].isTextBox()) continue;
            containers[i].getTextBox().setTextBoxLayout(textBoxInsets, textAlign, lineSpace);
        }
    }

    public void setFillColor(Color fillColor) {
        ShapeContainer[] containers = this.getGroupedSingleShapeContainers();
        for (int i = 0; i < containers.length; ++i) {
            containers[i].getPaintStyle().setFillColor(fillColor);
        }
    }

    public void setLineColor(Color lineColor) {
        ShapeContainer[] containers = this.getGroupedSingleShapeContainers();
        for (int i = 0; i < containers.length; ++i) {
            containers[i].getPaintStyle().setLineColor(lineColor);
            if (debug <= 0) continue;
            System.out.println("setLineColor after: " + containers[i].getPaintStyle().toShortString());
        }
    }

    public void setLineWidth(String lineWidth) {
        ShapeContainer[] containers = this.getGroupedSingleShapeContainers();
        for (int i = 0; i < containers.length; ++i) {
            containers[i].getPaintStyle().setLineWidth(lineWidth);
        }
    }

    public void setLineStroke(String lineStroke) {
        ShapeContainer[] containers = this.getGroupedSingleShapeContainers();
        for (int i = 0; i < containers.length; ++i) {
            containers[i].getPaintStyle().setDashedStyle(lineStroke);
        }
    }

    public void setArrowStyle(String arrowStyle) {
        ShapeContainer[] containers = this.getGroupedSingleShapeContainers();
        for (int i = 0; i < containers.length; ++i) {
            int elementType = containers[i].getElement().getTypeE();
            if (elementType == 54 && containers[i].getElement().isClosed()) continue;
            containers[i].getPaintStyle().setArrowStyle(arrowStyle);
        }
    }

    public void drawShape(Graphics g) {
        if (debug > 0) {
            System.out.println(" - drawShape start " + this.getShapeId());
        }
        Graphics2D g2 = (Graphics2D)g;
        if (!this.isVisible()) {
            return;
        }
        Composite currentComposit = g2.getComposite();
        int mode = this.getMode();
        float alphaComposite = 0.95f;
        if (mode == 81 || mode == 82 || mode == 83) {
            alphaComposite = 0.6f;
        }
        AlphaComposite ac = AlphaComposite.getInstance(3, alphaComposite);
        g2.setComposite(ac);
        if (this.getContainerType() == SHAPE) {
            DrawShapeUtil.drawShapeElement(g, this);
        } else {
            ShapeContainer[] containers = this.getGroupedSingleShapeContainers();
            for (int i = 0; i < containers.length; ++i) {
                containers[i].drawShape(g);
            }
        }
        if (this.getTextBox() != null) {
            this.getTextBox().drawTextBox(g);
        }
        if (this.isSelected()) {
            if (this.getMode() == 5) {
                DrawShapeUtil.drawSegmentModifiers(g, this);
            } else if (this.getParent() == null) {
                DrawShapeUtil.drawSelection(g, this);
            }
        }
        g2.setComposite(currentComposit);
        if (debug > 0) {
            System.out.println(" - drawShape end");
        }
    }

    public Object clone() {
        if (debug > 0) {
            System.out.println("ShapeContainer.clone " + this.getShapeId());
        }
        ShapeContainer newContainer = new ShapeContainer();
        int type = this.getContainerType();
        newContainer.setShapeId(this.getShapeId());
        newContainer.setContainerIndex(this.getContainerIndex());
        newContainer.setConnectorTargetPermission(this.connectorTargetPermission);
        newContainer.setConnectorPermission(this.connectorPermission);
        this.cloneHashMap(this.property);
        newContainer.property = this.cloneHashMap(this.property);
        if (type == SHAPE) {
            ShapeElement shapeElement = (ShapeElement)this.getElement().clone();
            newContainer.setElement(shapeElement);
            shapeElement.setShapeContainer(newContainer);
            PaintStyle paintStyle = (PaintStyle)this.getPaintStyle().clone();
            newContainer.setPaintStyle(paintStyle);
            paintStyle.setShapeContainer(newContainer);
            if (this.isTextBox()) {
                TextBox textBox = (TextBox)this.getTextBox().clone();
                newContainer.setTextBox(textBox);
                textBox.setShapeContainer(newContainer);
            }
        }
        if (type == GROUP) {
            GroupElement groupElement = new GroupElement();
            newContainer.setElement(groupElement);
            groupElement.setShapeContainer(newContainer);
            ShapeContainer[] children = ((GroupElement)this.getElement()).getChildren();
            for (int i = 0; i < children.length; ++i) {
                ShapeContainer childContainer = (ShapeContainer)children[i].clone();
                groupElement.addChildren(childContainer);
                childContainer.setParent(newContainer);
            }
        }
        return newContainer;
    }

    private HashMap<String, Object> cloneHashMap(HashMap<String, Object> hashMap) {
        HashMap<String, Object> newHashMap = new HashMap<String, Object>();
        Set<String> set = hashMap.keySet();
        Vector<String> list = new Vector<String>(set);
        for (int i = 0; i < list.size(); ++i) {
            String key = list.get(i);
            if (key.equals("")) continue;
            String object = hashMap.get(key).toString();
            String name = object.getClass().getSimpleName();
            if (debug > 0) {
                System.out.println("cloneHashMap key=" + key + ", object=" + object + ", object name=" + name);
            }
            if (!name.equals("String")) continue;
            String str = object;
            String newStr = new String(str);
            newHashMap.put(key, newStr);
        }
        return newHashMap;
    }

    public String toString() {
        String str = "";
        str = str + this.toString(0, "- ");
        if (this.getContainerType() == GROUP) {
            ShapeContainer[] childContainers = this.getGroupedContainers();
            for (int i = 1; i < childContainers.length; ++i) {
                int treeDepth = this.getGroupTreeDepth(childContainers[i].getShapeId());
                str = str + "\n" + childContainers[i].toString(treeDepth, "- Child: ");
            }
        }
        return str;
    }

    public String toString(int indent, String header) {
        int elementType;
        String space = "";
        for (int j = 0; j < indent; ++j) {
            space = space + "    ";
        }
        String str = "";
        ShapeContainer parent = this.getParent();
        int containerType = this.getContainerType();
        String typeStr = "SHAPE";
        if (containerType == 1) {
            typeStr = "GROUP";
        }
        str = str + space + header + this.getShapeId() + ", type=" + typeStr + ", mode=" + Command.getModeString(this.getMode());
        int index = this.getContainerIndex();
        if (parent != null) {
            str = str + ", parent=" + parent.getShapeId() + ", ";
        }
        str = str + "\n" + space + " containerIndex=" + index + " changeCode=" + this.getChangeCode();
        if (this.selected) {
            str = str + ", selected=";
        }
        if ((elementType = this.getElement().getTypeE()) != 180) {
            String textAreaStr = "null";
            if (this.getTextBox() != null) {
                Rectangle2D textArea = this.getTextBox().getTextArea();
                textAreaStr = "textArea:" + Util.Rect(textArea);
            }
            str = str + "\n" + space + "  text box=" + this.isTextBox() + ", " + textAreaStr;
            if (this.isTextBox()) {
                str = str + "\n" + space + "  Text=\"" + this.getTextBox().getCommittedTextContainer().getString().replace("\n", "\\n") + "\"";
            }
        } else {
            GroupElement groupElement = (GroupElement)this.getElement();
            str = str + "\n" + space + "  children=" + groupElement.toShortString() + ", ";
        }
        Set<String> set = this.property.keySet();
        String infStr = "";
        Vector<String> list = new Vector<String>(set);
        infStr = "\n" + space + "  property information: ";
        if (list.size() <= 0) {
            infStr = infStr + "none";
        }
        for (int i = 0; i < list.size(); ++i) {
            String key = list.get(i);
            if (key.equals("")) continue;
            String object = this.property.get(key).toString();
            key = key.toLowerCase();
            key = key.replace("_", " ");
            infStr = infStr + " key=" + key + ", value=" + object;
            if (i >= list.size() - 1) continue;
            infStr = infStr + ";";
        }
        str = str + infStr;
        return str;
    }

    public String toShortString() {
        String str = "";
        str = str + this.toShortString(0, "- ");
        if (this.getContainerType() == GROUP) {
            ShapeContainer[] childContainers = this.getGroupedContainers();
            for (int i = 1; i < childContainers.length; ++i) {
                int treeDepth = this.getGroupTreeDepth(childContainers[i].getShapeId());
                str = str + "\n" + childContainers[i].toShortString(treeDepth, "- Child: ");
            }
        }
        return str;
    }

    private String toShortString(int indent, String header) {
        int elementType;
        String space = "";
        for (int j = 0; j < indent; ++j) {
            space = space + "    ";
        }
        String str = "";
        String parentStr = "null";
        ShapeContainer parent = this.getParent();
        int containerType = this.getContainerType();
        String typeStr = "SHAPE";
        if (containerType == 1) {
            typeStr = "GROUP";
        }
        str = str + space + header + this.getShapeId() + ", type=" + typeStr + ", mode=" + Command.getModeString(this.getMode());
        int index = this.getContainerIndex();
        if (parent != null) {
            str = str + ", parent=" + parent.getShapeId() + ", ";
        }
        str = str + "\n" + space + " containerIndex=" + index + " changeCode=" + this.getChangeCode();
        if (this.selected) {
            str = str + ", selected=";
        }
        if ((elementType = this.getElement().getTypeE()) != 180) {
            String textAreaStr = "null";
            if (this.getTextBox() != null) {
                Rectangle2D textArea = this.getTextBox().getTextArea();
                textAreaStr = "textArea:" + Util.Rect(textArea);
            }
            str = str + "\n" + space + "  text box=" + this.isTextBox() + ", " + textAreaStr;
            if (this.isTextBox()) {
                str = str + "\n" + space + "  Text=\"" + this.getTextBox().getCommittedTextContainer().getString().replace("\n", "\\n") + "\"";
            }
        } else {
            GroupElement groupElement = (GroupElement)this.getElement();
            str = str + "\n" + space + "  children=" + groupElement.toShortString() + ", ";
        }
        Set<String> set = this.property.keySet();
        String infStr = "";
        Vector<String> list = new Vector<String>(set);
        infStr = "\n" + space + "  property information: ";
        if (list.size() <= 0) {
            infStr = infStr + "none";
        }
        for (int i = 0; i < list.size(); ++i) {
            String key = list.get(i);
            if (key.equals("")) continue;
            String object = this.property.get(key).toString();
            key = key.toLowerCase();
            key = key.replace("_", " ");
            infStr = infStr + " key=" + key + ", value=" + object;
            if (i >= list.size() - 1) continue;
            infStr = infStr + ";";
        }
        str = str + infStr;
        return str;
    }

    public String toVeryShortString() {
        String str = "";
        str = str + this.toVeryShortString(0, "");
        if (this.getContainerType() == GROUP) {
            ShapeContainer[] childContainers = this.getGroupedContainers();
            for (int i = 1; i < childContainers.length; ++i) {
                int treeDepth = this.getGroupTreeDepth(childContainers[i].getShapeId());
                str = str + "\n" + childContainers[i].toVeryShortString(treeDepth, "- child: ");
            }
        }
        return str;
    }

    public String toVeryShortString(int indent, String header) {
        String str = "";
        String space = "";
        for (int j = 0; j < indent; ++j) {
            space = space + "    ";
        }
        String parentStr = "null";
        ShapeContainer parent = this.getParent();
        if (parent != null) {
            parentStr = parent.getShapeId();
        }
        int containerType = this.getContainerType();
        String typeStr = "SHAPE";
        if (containerType == 1) {
            typeStr = "GROUP";
        }
        str = str + space + header + this.getShapeId();
        str = str + ", parent=" + parentStr;
        return str;
    }

    public String toPathString() {
        String str = "";
        int elementType = this.getElement().getTypeE();
        if (elementType != 180) {
            str = str + this.getElement().getCurve2D().toPathString();
        }
        return str;
    }
}

