/*
 * Decompiled with CFR 0.152.
 */
package shape;

import DrawTop.DrawParameters;
import DrawTop.ObjectTable;
import geomExtension.Curve2D;
import geomExtension.Curve2DUtil;
import geomExtension.CurvePT;
import geomExtension.FergusonCurve2D;
import geomExtension.GeneralCurve2DE;
import geomExtension.Segment2D;
import geomExtension.Vector2D;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import javax.swing.JOptionPane;
import shape.CubicCurveElement;
import shape.DiscreteAngledLine;
import shape.GeneralCurveElement;
import shape.LineElement;
import shape.PolylineElement;
import shape.SegmentModifier;
import shape.ShapeContainer;
import shape.ShapeElement;
import shape.TempShape;
import shape.TempShapeManager;
import util.Util;

public class ShapeElementUtil {
    static Vector workVector = new Vector();
    static final double Limit = 5.0;
    static int debug = 0;

    public static Rectangle2D getBoundingBox(Point2D[] points) {
        double xmin;
        double ymin = xmin = 10000.0;
        double xmax = -xmin;
        double ymax = -xmin;
        for (int i = 0; i < points.length; ++i) {
            double x = points[i].getX();
            double y = points[i].getY();
            if (x < xmin) {
                xmin = x;
            }
            if (y < ymin) {
                ymin = y;
            }
            if (x > xmax) {
                xmax = x;
            }
            if (!(y > ymax)) continue;
            ymax = y;
        }
        Rectangle2D.Double maxBoundingBox = new Rectangle2D.Double(xmin, ymin, xmax - xmin, ymax - ymin);
        return maxBoundingBox;
    }

    public static Rectangle2D getBoundingBox(Rectangle2D[] boxes) {
        double xmin;
        double ymin = xmin = 10000.0;
        double xmax = -xmin;
        double ymax = -xmin;
        for (int i = 0; i < boxes.length; ++i) {
            double x = boxes[i].getX();
            double y = boxes[i].getY();
            double w = boxes[i].getWidth();
            double h = boxes[i].getHeight();
            if (x < xmin) {
                xmin = x;
            }
            if (y < ymin) {
                ymin = y;
            }
            if (x + w > xmax) {
                xmax = x + w;
            }
            if (!(y + h > ymax)) continue;
            ymax = y + h;
        }
        Rectangle2D.Double maxBoundingBox = new Rectangle2D.Double(xmin, ymin, xmax - xmin, ymax - ymin);
        return maxBoundingBox;
    }

    public static Rectangle2D getBoundingBox(ShapeContainer[] containers) {
        double xmin;
        double ymin = xmin = 10000.0;
        double xmax = -xmin;
        double ymax = -xmin;
        for (int i = 0; i < containers.length; ++i) {
            Rectangle2D boundingBox = containers[i].getBoundingBox();
            double x = boundingBox.getX();
            double y = boundingBox.getY();
            double w = boundingBox.getWidth();
            double h = boundingBox.getHeight();
            if (x < xmin) {
                xmin = x;
            }
            if (y < ymin) {
                ymin = y;
            }
            if (x + w > xmax) {
                xmax = x + w;
            }
            if (!(y + h > ymax)) continue;
            ymax = y + h;
        }
        Rectangle2D.Double maxBoundingBox = new Rectangle2D.Double(xmin, ymin, xmax - xmin, ymax - ymin);
        return maxBoundingBox;
    }

    public static Rectangle2D getEnlargedRectangle(Rectangle2D box, double wEx, double hEx) {
        if (box == null) {
            return null;
        }
        double X = box.getX();
        double Y = box.getY();
        double Width = box.getWidth();
        double Height = box.getHeight();
        return new Rectangle2D.Double(X - wEx, Y - hEx, Width + 2.5 * wEx, Height + 2.5 * hEx);
    }

    public static Rectangle2D getShrinkedRectangle(Rectangle2D rectangle, double wideSh, double heightSh) {
        if (rectangle == null) {
            return null;
        }
        double X = rectangle.getX();
        double Y = rectangle.getY();
        double Width = rectangle.getWidth();
        double Height = rectangle.getHeight();
        Rectangle2D.Double newShape = null;
        if (Width > 2.0 * wideSh && Height > 2.0 * heightSh) {
            newShape = new Rectangle2D.Double(X + wideSh, Y + heightSh, Width - 2.0 * wideSh, Height - 2.0 * heightSh);
        }
        return newShape;
    }

    public static boolean boxIntersectionCheck(Rectangle2D box1, Rectangle2D box2) {
        double x1 = box1.getX();
        double y1 = box1.getY();
        double w1 = box1.getWidth();
        double h1 = box1.getHeight();
        double x2 = box2.getX();
        double y2 = box2.getY();
        double w2 = box2.getWidth();
        double h2 = box2.getHeight();
        if (x1 + w1 < x2) {
            return false;
        }
        if (y1 + h1 < y2) {
            return false;
        }
        if (x2 + w2 < x1) {
            return false;
        }
        return !(y2 + h2 < y1);
    }

    public static Rectangle2D getInscribedBox(Shape shape, boolean keepAspectRatio) {
        double h;
        double aspectRatio;
        int debug = 0;
        int divX = 100;
        int divY = 100;
        boolean[][] map = new boolean[divX + 1][divY + 1];
        Rectangle2D box = shape.getBounds2D();
        double centerX = box.getCenterX();
        double centerY = box.getCenterY();
        double w = box.getWidth();
        if (w < (aspectRatio = w / (h = box.getHeight())) * h) {
            w = aspectRatio * h;
        }
        double x0 = centerX - w / 2.0;
        double y0 = centerY - h / 2.0;
        double deltaX = w / (double)divX;
        double deltaY = h / (double)divY;
        double x = x0;
        double y = y0;
        for (int j = 0; j <= divY; ++j) {
            x = x0;
            for (int i = 0; i <= divX; ++i) {
                map[i][j] = shape.contains(x, y);
                x += deltaX;
            }
            y += deltaY;
        }
        double wmax = 0.0;
        double hmax = 0.0;
        double areaMax = 0.0;
        int isave = -1;
        int jsave = -1;
        Rectangle rectSave = null;
        for (int j = 0; j <= divY; ++j) {
            for (int i = 0; i <= divX; ++i) {
                double area;
                if (!map[i][j]) continue;
                Rectangle rect = null;
                rect = keepAspectRatio ? ShapeElementUtil.findSquare(map, i, j) : ShapeElementUtil.findRectangle(map, i, j);
                if (rect == null || !((area = rect.getWidth() * rect.getHeight()) >= areaMax)) continue;
                areaMax = area;
                isave = i;
                jsave = j;
                rectSave = rect;
            }
        }
        if (rectSave == null) {
            return null;
        }
        Rectangle rectangle = rectSave;
        if (debug > 0) {
            System.out.println("Print inner region by + or *");
            String mapStr = "";
            for (int j = 0; j <= divY; ++j) {
                mapStr = "[" + j + "]";
                for (int i = 0; i <= divX; ++i) {
                    boolean rect = false;
                    if ((double)i >= rectangle.getX() && (double)i <= rectangle.getX() + rectangle.getWidth() && (double)j >= rectangle.getY() && (double)j <= rectangle.getY() + rectangle.getHeight()) {
                        rect = true;
                    }
                    if (!map[i][j]) {
                        mapStr = mapStr + "-";
                    }
                    if (map[i][j] && !rect) {
                        mapStr = mapStr + "+";
                    }
                    if (!rect) continue;
                    mapStr = mapStr + "*";
                }
                System.out.println("  " + mapStr);
            }
        }
        x = x0 + rectangle.getX() * deltaX;
        y = y0 + rectangle.getY() * deltaY;
        w = deltaX * rectangle.getWidth();
        h = deltaY * rectangle.getHeight();
        Rectangle2D.Double textArea = new Rectangle2D.Double(x, y, w, h);
        return textArea;
    }

    private static Rectangle findSquare(boolean[][] bitmap, int centerI, int centerJ) {
        int ifix;
        int jfix;
        int sizeI = bitmap.length - 1;
        int sizeJ = bitmap[0].length - 1;
        int lengthI = Math.min(centerI, sizeI - centerI);
        int lengthJ = Math.min(centerJ, sizeJ - centerJ);
        int klength = Math.min(lengthI, lengthJ);
        int ksave = -1;
        int k = 0;
        while (k <= klength && ShapeElementUtil.scanMap(bitmap, centerI - k, centerI + k, jfix = centerJ - k, jfix) && ShapeElementUtil.scanMap(bitmap, centerI - k, centerI + k, jfix = centerJ + k, jfix) && ShapeElementUtil.scanMap(bitmap, ifix = centerI - k, ifix, centerJ - k, centerJ + k) && ShapeElementUtil.scanMap(bitmap, ifix = centerI + k, ifix, centerJ - k, centerJ + k)) {
            ksave = k++;
        }
        if (debug > 0) {
            System.out.println("findSquare centerI, centerJ=" + centerI + ", " + centerJ + ", klength=" + klength + ", ksave=" + ksave);
        }
        if (ksave <= 0) {
            return null;
        }
        Rectangle textArea = new Rectangle(centerI - ksave, centerJ - ksave, ksave * 2, ksave * 2);
        if (debug > 0) {
            System.out.println("findSquare rectangle=" + textArea.toString());
        }
        return textArea;
    }

    private static Rectangle findRectangle(boolean[][] bitmap, int centerI, int centerJ) {
        Rectangle square = ShapeElementUtil.findSquare(bitmap, centerI, centerJ);
        if (square == null) {
            return null;
        }
        double epc = 1.0E-12;
        int iMin = (int)(square.getX() + epc);
        int iMax = (int)(square.getX() + square.getWidth() + epc);
        int jMin = (int)(square.getY() + epc);
        int jMax = (int)(square.getY() + square.getHeight() + epc);
        int sizeI = bitmap.length - 1;
        int sizeJ = bitmap[0].length - 1;
        int iMinus = -1;
        int i = iMin - 1;
        while (i >= 0 && ShapeElementUtil.scanMap(bitmap, i, i, jMin, jMax)) {
            iMinus = i--;
        }
        if (iMinus > 0) {
            iMin = iMinus;
        }
        int iPlus = -1;
        int i2 = iMax + 1;
        while (i2 <= sizeI && ShapeElementUtil.scanMap(bitmap, i2, i2, jMin, jMax)) {
            iPlus = i2++;
        }
        if (iPlus > 0) {
            iMax = iPlus;
        }
        int jMinus = -1;
        int j = jMin - 1;
        while (j >= 0 && ShapeElementUtil.scanMap(bitmap, iMin, iMax, j, j)) {
            jMinus = j--;
        }
        if (jMinus > 0) {
            jMin = jMinus;
        }
        int jPlus = -1;
        int j2 = jMax + 1;
        while (j2 <= sizeJ && ShapeElementUtil.scanMap(bitmap, iMin, iMax, j2, j2)) {
            jPlus = j2++;
        }
        if (jPlus > 0) {
            jMax = jPlus;
        }
        Rectangle textArea = new Rectangle(iMin, jMin, iMax - iMin, jMax - jMin);
        if (debug > 0) {
            System.out.println("findRectangle rectangle=" + textArea.toString());
        }
        return textArea;
    }

    private static boolean scanMap(boolean[][] bitmap, int startI, int endI, int startJ, int endJ) {
        for (int j = startJ; j <= endJ; ++j) {
            for (int i = startI; i <= endI; ++i) {
                if (bitmap[i][j]) continue;
                return false;
            }
        }
        return true;
    }

    public static Rectangle2D resizeRectangle(int ctrl, Rectangle2D startBox, Point2D startPoint, Point2D currentPoint, String mousePosition) {
        Vector2D moveVec = Vector2D.sub(currentPoint, startPoint);
        Rectangle2D newBox = ShapeElementUtil.resizeRectangle(ctrl, startBox, moveVec, mousePosition);
        return newBox;
    }

    public static Rectangle2D resizeRectangle(int ctrl, Rectangle2D startBox, Vector2D moveVec, String mousePosition) {
        Vector2D startBoxP = new Vector2D(startBox.getX(), startBox.getY());
        double W = startBox.getWidth();
        double H = startBox.getHeight();
        Vector2D anchorP = null;
        Vector2D movingP = null;
        Rectangle2D newBox = null;
        if (mousePosition.equals("NW_RESIZE")) {
            movingP = new Vector2D(startBoxP.getX(), startBox.getY());
            anchorP = Vector2D.add(startBoxP, new Vector2D(W, H));
            newBox = ShapeElementUtil.resizeDiagonally(ctrl, anchorP, movingP, moveVec);
        } else if (mousePosition.equals("NE_RESIZE")) {
            movingP = Vector2D.add(startBoxP, new Vector2D(W, 0.0));
            anchorP = Vector2D.add(startBoxP, new Vector2D(0.0, H));
            newBox = ShapeElementUtil.resizeDiagonally(ctrl, anchorP, movingP, moveVec);
        } else if (mousePosition.equals("SE_RESIZE")) {
            movingP = Vector2D.add(startBoxP, new Vector2D(W, H));
            anchorP = startBoxP;
            newBox = ShapeElementUtil.resizeDiagonally(ctrl, anchorP, movingP, moveVec);
        } else if (mousePosition.equals("SW_RESIZE")) {
            movingP = Vector2D.add(startBoxP, new Vector2D(0.0, H));
            anchorP = Vector2D.add(startBoxP, new Vector2D(W, 0.0));
            newBox = ShapeElementUtil.resizeDiagonally(ctrl, anchorP, movingP, moveVec);
        } else if (mousePosition.equals("N_RESIZE")) {
            movingP = Vector2D.add(startBoxP, new Vector2D(0.5 * W, 0.0));
            anchorP = Vector2D.add(startBoxP, new Vector2D(0.5 * W, H));
            newBox = ShapeElementUtil.resizeOrthogonally(ctrl, 1, anchorP, movingP, moveVec, W);
        } else if (mousePosition.equals("E_RESIZE")) {
            movingP = Vector2D.add(startBoxP, new Vector2D(W, 0.5 * H));
            anchorP = Vector2D.add(startBoxP, new Vector2D(0.0, 0.5 * H));
            newBox = ShapeElementUtil.resizeOrthogonally(ctrl, 0, anchorP, movingP, moveVec, H);
        } else if (mousePosition.equals("S_RESIZE")) {
            movingP = Vector2D.add(startBoxP, new Vector2D(0.5 * W, H));
            anchorP = Vector2D.add(startBoxP, new Vector2D(0.5 * W, 0.0));
            newBox = ShapeElementUtil.resizeOrthogonally(ctrl, 1, anchorP, movingP, moveVec, W);
        } else if (mousePosition.equals("W_RESIZE")) {
            movingP = Vector2D.add(startBoxP, new Vector2D(0.0, 0.5 * H));
            anchorP = Vector2D.add(startBoxP, new Vector2D(W, 0.5 * H));
            newBox = ShapeElementUtil.resizeOrthogonally(ctrl, 0, anchorP, movingP, moveVec, H);
        } else {
            System.out.println("*** Error in ShapeElementUtil illegal mousePosition=" + mousePosition);
        }
        return newBox;
    }

    private static Rectangle2D resizeDiagonally(int ctrl, Vector2D anchorP, Vector2D movingP, Vector2D moveVec) {
        Vector2D boxDiagonal = Vector2D.sub(movingP, anchorP);
        double startW = boxDiagonal.getX();
        double startH = boxDiagonal.getY();
        double signW = Math.signum(startW);
        double signH = Math.signum(startH);
        Vector2D newP = Vector2D.add(movingP, moveVec);
        double newW = newP.getX() - anchorP.getX();
        double newH = newP.getY() - anchorP.getY();
        double newSignW = Math.signum(newW);
        double newSignH = Math.signum(newH);
        if (Math.abs(newW) < 5.0 || newSignW != signW) {
            newW = 5.0 * signW;
        }
        if (Math.abs(newH) < 5.0 || newSignH != signH) {
            newH = 5.0 * signH;
        }
        if (ctrl == 1 || ctrl == 2) {
            if (startW > startH) {
                newH = newW * startH / startW;
            } else {
                newW = newH * startW / startH;
            }
        }
        if (ctrl == 3) {
            double dir = Vector2D.sproduct(boxDiagonal, moveVec);
            double newWH = Math.min(Math.abs(newW), Math.abs(newH));
            if (dir > 0.0) {
                newWH = Math.max(Math.abs(newW), Math.abs(newH));
            }
            newW = newWH * signW;
            newH = newWH * signH;
        }
        newP = Vector2D.add(anchorP, new Vector2D(newW, newH));
        double x = Math.min(anchorP.getX(), newP.getX());
        double y = Math.min(anchorP.getY(), newP.getY());
        Rectangle2D.Double newBox = new Rectangle2D.Double(x, y, Math.abs(newW), Math.abs(newH));
        return newBox;
    }

    private static Rectangle2D resizeOrthogonally(int ctrl, int dir, Vector2D anchorP, Vector2D movingP, Vector2D draggedVec, double fixedWH) {
        Vector2D[] unitV = new Vector2D[]{new Vector2D(1.0, 0.0), new Vector2D(0.0, 1.0)};
        Vector2D draggedV = Vector2D.multiply(Vector2D.sproduct(unitV[dir], draggedVec), unitV[dir]);
        double signedWorH = Vector2D.sproduct(Vector2D.sub(movingP, anchorP), unitV[dir]);
        double sign = Math.signum(signedWorH);
        Vector2D newP = Vector2D.add(movingP, draggedV);
        double newSignedWorH = Vector2D.sproduct(Vector2D.sub(newP, anchorP), unitV[dir]);
        double newSign = Math.signum(newSignedWorH);
        if (Math.abs(newSignedWorH) < 5.0 || newSign != sign) {
            newSignedWorH = 5.0 * sign;
        }
        double newW = fixedWH;
        if (ctrl == -1 || ctrl == -2) {
            newW = Math.abs(newSignedWorH) * fixedWH / signedWorH;
        }
        if (ctrl == -3) {
            newW = Math.abs(newSignedWorH);
        }
        Vector2D[] P = new Vector2D[4];
        Vector2D wingP = Vector2D.multiply(0.5 * newW, unitV[1 - dir]);
        P[0] = Vector2D.add(anchorP, wingP);
        P[1] = Vector2D.sub(anchorP, wingP);
        P[2] = Vector2D.add(newP, wingP);
        P[3] = Vector2D.sub(newP, wingP);
        double x = 100000.0;
        double y = 100000.0;
        for (int i = 0; i < 4; ++i) {
            if (P[i].getX() < x) {
                x = P[i].getX();
            }
            if (!(P[i].getY() < y)) continue;
            y = P[i].getY();
        }
        Rectangle2D.Double newBox = null;
        newBox = dir == 0 ? new Rectangle2D.Double(x, y, Math.abs(newSignedWorH), Math.abs(newW)) : new Rectangle2D.Double(x, y, Math.abs(newW), Math.abs(newSignedWorH));
        return newBox;
    }

    public static Rectangle2D reseizeRectangle(Rectangle2D rect, Rectangle2D oldBox, Rectangle2D newBox) {
        double x = newBox.getX();
        double y = newBox.getY();
        double scaleX = newBox.getWidth() / oldBox.getWidth();
        double scaleY = newBox.getHeight() / oldBox.getHeight();
        Double X = scaleX * (rect.getX() - oldBox.getX()) + x;
        Double Y = scaleY * (rect.getY() - oldBox.getY()) + y;
        Rectangle2D.Double newRect = new Rectangle2D.Double(X, Y, scaleX * rect.getWidth(), scaleY * rect.getHeight());
        return newRect;
    }

    public static GeneralCurveElement getGeneralCurveElement(ShapeElement element) {
        Curve2D curve = element.getCurve2D();
        Segment2D[] segments = curve.getSegment2Ds();
        Segment2D[] newSegments = new Segment2D[segments.length];
        for (int i = 0; i < segments.length; ++i) {
            newSegments[i] = (Segment2D)segments[i].clone();
        }
        GeneralCurve2DE gcurve = new GeneralCurve2DE(newSegments);
        GeneralCurveElement gelement = new GeneralCurveElement();
        gelement.setCurve2D(gcurve);
        return gelement;
    }

    public static ShapeElement[] getSimpleShapeElements(GeneralCurveElement gelement) {
        GeneralCurve2DE gcurve = (GeneralCurve2DE)gelement.getCurve2D();
        Curve2D[] curves = gcurve.getSimpleCurve2Ds();
        ShapeElement[] newElement = new ShapeElement[curves.length];
        for (int i = 0; i < curves.length; ++i) {
            int type = curves[i].getType2DE();
            if (type == 51) {
                newElement[i] = new LineElement();
            }
            if (type == 54) {
                newElement[i] = new PolylineElement();
            }
            if (type == 55) {
                newElement[i] = new CubicCurveElement();
            }
            if (type == 56) {
                newElement[i] = new GeneralCurveElement();
            }
            newElement[i].setCurve2D(curves[i]);
        }
        return newElement;
    }

    public static SegmentModifier[] getSegmentModifiers(Curve2D curve2D) {
        GeneralCurve2DE gcurve = (GeneralCurve2DE)curve2D;
        int numSubPath = gcurve.getNumOfSubPaths();
        GeneralCurve2DE[] subCurves = gcurve.getSubPaths();
        workVector.clear();
        for (int k = 0; k < numSubPath; ++k) {
            int i;
            GeneralCurve2DE subCurve = subCurves[k];
            int numseg = subCurve.getNumOfSegments();
            boolean closed = ((Curve2D)subCurve).isClosed();
            for (i = 0; i <= numseg; ++i) {
                SegmentModifier modifier = ShapeElementUtil.getSegmentModifier(curve2D, 1, k, i);
                workVector.add(modifier);
            }
            for (i = 0; i < numseg; ++i) {
                int segType = subCurve.getSegment2D(i).getType();
                if (segType != 1 && segType != 2) continue;
                SegmentModifier modifier = ShapeElementUtil.getSegmentModifier(curve2D, 2, k, i);
                workVector.add(modifier);
            }
            for (i = 0; i <= numseg; ++i) {
                SegmentModifier modifier;
                int segmentId1 = i - 1;
                int segmentId2 = i;
                if (i == numseg) {
                    segmentId2 = -1;
                }
                if (closed) {
                    if (segmentId1 < 0) {
                        segmentId1 = numseg - 1;
                    }
                    if (segmentId2 < 0) {
                        segmentId2 = 0;
                    }
                }
                int segType1 = -1;
                int segType2 = -1;
                if (segmentId1 >= 0) {
                    segType1 = subCurve.getSegment2D(segmentId1).getType();
                }
                if (segmentId2 >= 0) {
                    segType2 = subCurve.getSegment2D(segmentId2).getType();
                }
                if (segType1 != 3 && segType2 != 3 || (modifier = ShapeElementUtil.getSegmentModifier(curve2D, 3, k, i)) == null) continue;
                workVector.add(modifier);
            }
        }
        SegmentModifier[] Modifiers = new SegmentModifier[workVector.size()];
        for (int i = 0; i < workVector.size(); ++i) {
            Modifiers[i] = (SegmentModifier)workVector.get(i);
        }
        String str = "GeneralCurveElement.getSegmentModifiers";
        for (int i = 0; i < Modifiers.length; ++i) {
            str = str + "\n" + Modifiers[i].toString();
        }
        if (debug > 0) {
            System.out.println(str);
        }
        return Modifiers;
    }

    public static SegmentModifier getSegmentModifier(Curve2D curve2D, int type, int subPath, int segmentPtIndex) {
        int segType;
        int segmentId1;
        GeneralCurve2DE gcurve = (GeneralCurve2DE)curve2D;
        Curve2D[] subCurves = curve2D.getSubPaths();
        Curve2D subCurve = subCurves[subPath];
        int numseg = subCurve.getNumOfSegments();
        int index = segmentPtIndex;
        boolean closed = subCurve.isClosed();
        SegmentModifier modifier = null;
        if (type == 1) {
            segmentId1 = index - 1;
            int segmentId2 = index;
            if (index == numseg) {
                segmentId2 = -1;
            }
            if (closed) {
                if (segmentId1 < 0) {
                    segmentId1 = numseg - 1;
                }
                if (segmentId2 < 0) {
                    segmentId2 = 0;
                }
            }
            String segTypeStr1 = "";
            String segTypeStr2 = "";
            segTypeStr1 = segmentId1 < 0 ? "null" : Segment2D.codeStr[subCurve.getSegment2D(segmentId1).getType()];
            segTypeStr2 = segmentId2 < 0 ? "null" : Segment2D.codeStr[subCurve.getSegment2D(segmentId2).getType()];
            modifier = new SegmentModifier(1, subPath, index, segmentId1, segmentId2, segTypeStr1, segTypeStr2, subCurve.getP(index), 0, null, null);
        }
        if (type == 2 && index < numseg && ((segType = subCurve.getSegment2D(index).getType()) == 1 || segType == 2)) {
            String segTypeStr = Segment2D.codeStr[segType];
            modifier = new SegmentModifier(2, subPath, index, index, index, segTypeStr, segTypeStr, subCurve.getP((double)index + 0.5), 0, null, null);
        }
        if (type == 3) {
            segmentId1 = index - 1;
            int segmentId2 = index;
            if (index == numseg) {
                segmentId2 = -1;
            }
            if (closed) {
                if (segmentId1 < 0) {
                    segmentId1 = numseg - 1;
                }
                if (segmentId2 < 0) {
                    segmentId2 = 0;
                }
            }
            int segType1 = -1;
            int segType2 = -1;
            if (segmentId1 >= 0) {
                segType1 = subCurve.getSegment2D(segmentId1).getType();
            }
            if (segmentId2 >= 0) {
                segType2 = subCurve.getSegment2D(segmentId2).getType();
            }
            String segTypeStr1 = "";
            String segTypeStr2 = "";
            segTypeStr1 = segmentId1 < 0 ? "null" : Segment2D.codeStr[subCurve.getSegment2D(segmentId1).getType()];
            segTypeStr2 = segmentId2 < 0 ? "null" : Segment2D.codeStr[subCurve.getSegment2D(segmentId2).getType()];
            modifier = new SegmentModifier(3, subPath, index, segmentId1, segmentId2, segTypeStr1, segTypeStr2, subCurve.getP(index), 0, null, null);
            Vector2D Tin = null;
            Vector2D Tout = null;
            if (segmentId1 >= 0 && segType1 == 3) {
                Tin = subCurve.getSegment2D(segmentId1).getTangent(1.0);
            }
            if (segmentId2 >= 0 && segType2 == 3) {
                Tout = subCurve.getSegment2D(segmentId2).getTangent(0.0);
            }
            modifier.setJointType(5);
            if (Tin != null && Tout != null && Vector2D.isSameDirection(Tin, Tout, 3.0)) {
                modifier.setJointType(4);
            }
            Segment2D TinSeg = null;
            Segment2D ToutSeg = null;
            if (Tin != null) {
                TinSeg = ShapeElementUtil.getTangentLine(subCurve.getP(index), Tin);
            }
            if (Tout != null) {
                ToutSeg = ShapeElementUtil.getTangentLine(subCurve.getP(index), Tout);
            }
            modifier.setTangentIn(TinSeg);
            modifier.setTangentOut(ToutSeg);
        }
        return modifier;
    }

    private static Segment2D getTangentLine(Point2D point, Vector2D Tvec) {
        double lineLength = 30.0 / DrawParameters.Scale;
        Vector2D PT = new Vector2D(point);
        Tvec = Vector2D.unitVector(Tvec);
        Tvec = Vector2D.multiply(lineLength, Tvec);
        Vector2D P1 = Vector2D.sub(PT, Tvec);
        Vector2D P2 = Vector2D.add(PT, Tvec);
        Line2D.Double line = new Line2D.Double(P1.getX(), P1.getY(), P2.getX(), P2.getY());
        Segment2D segment = new Segment2D(1, line);
        return segment;
    }

    public static SegmentModifier getHitSegmentModifier(SegmentModifier[] modifiers, Point2D point) {
        int size = 0;
        if (modifiers != null) {
            size = modifiers.length;
        }
        int hit = 0;
        int hitType = 0;
        double distMin = 100000.0;
        for (int i = 0; i < size; ++i) {
            Point2D tp;
            double dist = Vector2D.dist(modifiers[i].getP(), point);
            if (dist < distMin) {
                distMin = dist;
                hit = i;
                hitType = modifiers[i].getType();
            }
            if ((tp = modifiers[i].getTinP1()) != null && (dist = Vector2D.dist(tp, point)) < distMin) {
                distMin = dist;
                hit = i;
                hitType = 6;
            }
            if ((tp = modifiers[i].getTinP2()) != null && (dist = Vector2D.dist(tp, point)) < distMin) {
                distMin = dist;
                hit = i;
                hitType = 7;
            }
            if ((tp = modifiers[i].getToutP1()) != null && (dist = Vector2D.dist(tp, point)) < distMin) {
                distMin = dist;
                hit = i;
                hitType = 8;
            }
            if ((tp = modifiers[i].getToutP2()) == null || !((dist = Vector2D.dist(tp, point)) < distMin)) continue;
            distMin = dist;
            hit = i;
            hitType = 9;
        }
        if (distMin < 6.0) {
            modifiers[hit].setHitType(hitType);
            return modifiers[hit];
        }
        return null;
    }

    public static boolean modify(Curve2D curve2D, SegmentModifier hitSegmentModifier, int ctrl, Point2D startPoint, Point2D oldPoint, Point2D currentPoint) {
        boolean topologyChanged = false;
        if (hitSegmentModifier == null) {
            return topologyChanged;
        }
        int type2DE = curve2D.getType2DE();
        if (type2DE != 56) {
            return topologyChanged;
        }
        GeneralCurve2DE gcurve = (GeneralCurve2DE)curve2D;
        int subPath = hitSegmentModifier.getSubPathIndex();
        int index = hitSegmentModifier.getSegmentPid();
        int index1 = hitSegmentModifier.getSegmentId1();
        int index2 = hitSegmentModifier.getSegmentId2();
        int hitType = hitSegmentModifier.getHitType();
        Curve2D[] subCurves = curve2D.getSubPaths();
        Point2D[][] endPs = new Point2D[subCurves.length][2];
        for (int i = 0; i < subCurves.length; ++i) {
            if (i == subPath || subCurves[i].isClosed()) continue;
            endPs[i] = subCurves[i].getEndPoints();
        }
        Curve2D subCurve = subCurves[subPath];
        boolean closed = subCurve.isClosed();
        int numseg = subCurve.getNumOfSegments();
        Segment2D[] segments = subCurve.getSegment2Ds();
        Point2D newP = currentPoint;
        Point2D oldP = oldPoint;
        if (debug > 0) {
            System.out.println("GeneralCurveElement.modify hitType=" + SegmentModifier.codeStr[hitType] + ", subPath=" + subPath + ", numseg=" + numseg + ", closed=" + closed + ", index=" + index);
        }
        if (ctrl > 0) {
            newP = DiscreteAngledLine.getControlledPT(0.0, 90.0, startPoint, newP);
            oldP = DiscreteAngledLine.getControlledPT(0.0, 90.0, startPoint, oldP);
        }
        if (hitType == 1) {
            Point2D P0;
            if (ctrl > 0) {
                currentPoint = DiscreteAngledLine.getControlledPT(0.0, 90.0, startPoint, newP);
            }
            if (index >= 0 && index <= numseg) {
                if (index1 >= 0) {
                    segments[index1] = segments[index1].moveSegmentEndPT(1, newP);
                }
                if (index2 >= 0) {
                    segments[index2] = segments[index2].moveSegmentEndPT(0, newP);
                }
                subCurve.setData(segments);
                gcurve.setSubPaths(subCurves);
            }
            if (index == 0 || index == numseg) {
                P0 = subCurve.getP(0.0);
                Point2D P1 = subCurve.getP(numseg);
                double dist = Vector2D.dist(P0, P1);
                if (debug > 0) {
                    System.out.println("closing check subPath=" + subPath + ", index=" + index + ", dist=" + Util.Num(dist) + ", P0=" + Util.Pt(P0) + ", P1=" + Util.Pt(P1));
                }
                if (!closed && dist < 3.0) {
                    topologyChanged = true;
                    ShapeElementUtil.clearMessage("modify_close");
                    if (index == 0) {
                        segments[0] = segments[0].moveSegmentEndPT(0, P1);
                    }
                    if (index == numseg) {
                        segments[numseg - 1] = segments[numseg - 1].moveSegmentEndPT(1, P0);
                    }
                    ShapeElementUtil.drawMessage("modify_close", "closing", P1);
                    subCurve.setData(segments);
                    gcurve.setSubPaths(subCurves);
                    ObjectTable.getDrawPanel().repaint();
                }
            }
            if (index == 0 || index == numseg) {
                P0 = subCurve.getP(index);
                int[] inf = ShapeElementUtil.checkDistance(P0, endPs);
                int isave = inf[0];
                int jsave = inf[1];
                double dist = 100000.0;
                if (isave >= 0 && jsave >= 0) {
                    dist = Vector2D.dist(P0, endPs[isave][jsave]);
                }
                if (dist < 3.0) {
                    topologyChanged = true;
                    int path = isave;
                    int ptIndex = 0;
                    if (jsave > 0) {
                        ptIndex = numseg;
                    }
                    System.out.println("isConnecting path=" + path + ", ptIndex=" + ptIndex);
                    Point2D targetP = subCurves[path].getP(ptIndex);
                    ShapeElementUtil.clearMessage("modify_connect");
                    if (index == 0) {
                        segments[0] = segments[0].moveSegmentEndPT(0, targetP);
                    }
                    if (index == numseg) {
                        segments[numseg - 1] = segments[numseg - 1].moveSegmentEndPT(1, targetP);
                    }
                    ShapeElementUtil.drawMessage("modify_connect", "connecting", targetP);
                    subCurve.setData(segments);
                    gcurve.setSubPaths(subCurves);
                    ObjectTable.getDrawPanel().repaint();
                }
            }
        }
        if (hitType == 2) {
            double moveX = newP.getX() - oldP.getX();
            double moveY = newP.getY() - oldP.getY();
            Point2D p1 = segments[index].getP(0.0);
            Point2D p2 = segments[index].getP(1.0);
            if (ctrl > 0) {
                p2 = DiscreteAngledLine.getControlledPT(0.0, 90.0, p1, p2);
            }
            p1.setLocation(p1.getX() + moveX, p1.getY() + moveY);
            p2.setLocation(p2.getX() + moveX, p2.getY() + moveY);
            if (index >= 0 && index <= numseg - 1) {
                segments[index] = segments[index].moveSegmentEndPT(0, p1);
                segments[index] = segments[index].moveSegmentEndPT(1, p2);
            }
            if (index >= 1) {
                segments[index - 1] = segments[index - 1].moveSegmentEndPT(1, p1);
            }
            if (index <= numseg - 2) {
                segments[index + 1] = segments[index + 1].moveSegmentEndPT(0, p2);
            }
            if (index == 0 && closed) {
                segments[numseg - 1] = segments[numseg - 1].moveSegmentEndPT(1, p1);
            }
            if (index == numseg - 1 && closed) {
                segments[0] = segments[0].moveSegmentEndPT(0, p2);
            }
            subCurve.setData(segments);
            gcurve.setSubPaths(subCurves);
        }
        int junctionType = hitSegmentModifier.getJointType();
        if (hitType == 6 || hitType == 7 || hitType == 8 || hitType == 9) {
            Vector2D tan = null;
            tan = index == numseg ? segments[numseg - 1].getTangent(1.0) : segments[index].getTangent(0.0);
            double len = Vector2D.length(tan);
            Vector2D newTangent = Vector2D.sub(currentPoint, subCurve.getP(index));
            if (hitType == 6 || hitType == 8) {
                newTangent = Vector2D.multiply(-1.0, newTangent);
            }
            newTangent = Vector2D.multiply(len, Vector2D.unitVector(newTangent));
            if (index >= 0 && index <= numseg) {
                if (hitType == 6 || hitType == 7) {
                    segments[index1] = segments[index1].moveSegmentTangent(1, newTangent);
                    if (junctionType == 4) {
                        segments[index2] = segments[index2].moveSegmentTangent(0, newTangent);
                    }
                }
                if (hitType == 8 || hitType == 9) {
                    segments[index2] = segments[index2].moveSegmentTangent(0, newTangent);
                    if (junctionType == 4) {
                        segments[index1] = segments[index1].moveSegmentTangent(1, newTangent);
                    }
                }
                subCurve.setData(segments);
            }
            String str = subCurve.toString();
            if (debug > 0) {
                System.out.println("subCurve print:" + str);
            }
            gcurve.setSubPaths(subCurves);
        }
        return topologyChanged;
    }

    private static int[] checkDistance(Point2D P0, Point2D[][] endPs) {
        int[] ptId = new int[2];
        double distMin = 100000.0;
        int isave = -1;
        int jsave = -1;
        for (int i = 0; i < endPs.length; ++i) {
            for (int j = 0; j < endPs[i].length; ++j) {
                double dist;
                if (endPs[i][j] == null || !((dist = Vector2D.dist(P0, endPs[i][j])) < distMin)) continue;
                distMin = dist;
                isave = i;
                jsave = j;
            }
        }
        ptId[0] = isave;
        ptId[1] = jsave;
        return ptId;
    }

    public static void addPoint(Curve2D curve2D, SegmentModifier hitSegmentModifier, Point2D point) {
        CurvePT curvePT = Curve2DUtil.getShortestLine(point, curve2D);
        double t = curvePT.getParameter();
        int it = (int)t;
        if (debug > 0) {
            System.out.println("GeneralCurveElement.addPoint t=" + t);
        }
        int numseg = curve2D.getNumOfSegments();
        Segment2D segment = curve2D.getSegment2D(it);
        Segment2D trimmedSeg1 = segment.trimSegment(0.0, t - (double)it);
        Segment2D trimmedSeg2 = segment.trimSegment(t - (double)it, 1.0);
        Segment2D[] newSegments = new Segment2D[numseg + 1];
        for (int i = 0; i < numseg; ++i) {
            segment = curve2D.getSegment2D(i);
            if (i < it) {
                newSegments[i] = segment;
            }
            if (i == it) {
                newSegments[i] = trimmedSeg1;
                newSegments[i + 1] = trimmedSeg2;
            }
            if (i <= it) continue;
            newSegments[i + 1] = segment;
        }
        GeneralCurve2DE generalCurve = (GeneralCurve2DE)curve2D;
        generalCurve.setData(newSegments);
    }

    public static void deletePoint(Curve2D curve2D, SegmentModifier hitSegmentModifier, Point2D point) {
        if (hitSegmentModifier == null) {
            return;
        }
        System.out.println("GeneralCurveElement.deletePoint hitSegmentModifier" + hitSegmentModifier.toString());
        int type2DE = curve2D.getType2DE();
        if (type2DE != 56) {
            return;
        }
        GeneralCurve2DE gcurve = (GeneralCurve2DE)curve2D;
        int subPath = hitSegmentModifier.getSubPathIndex();
        int index = hitSegmentModifier.getSegmentPid();
        int index1 = hitSegmentModifier.getSegmentId1();
        int index2 = hitSegmentModifier.getSegmentId2();
        int hitType = hitSegmentModifier.getHitType();
        if (hitType != 1) {
            return;
        }
        if (curve2D.getNumOfSegments() == 1) {
            JOptionPane.showMessageDialog(ObjectTable.getDrawMain(), " Warning: GeneralCurve has only two points", "", 0);
            return;
        }
        Curve2D[] curves = gcurve.getSubPaths();
        GeneralCurve2DE curve = curves[subPath];
        int numseg = curve.getNumOfSegments();
        boolean closed = ((Curve2D)curve).isClosed();
        Segment2D[] segments = curve.getSegment2Ds();
        Segment2D[] newSegments = new Segment2D[numseg - 1];
        if (index > 0 && index < numseg) {
            Segment2D newSegment = ShapeElementUtil.connectSegments(segments[index1], segments[index2]);
            for (int i = 0; i < numseg; ++i) {
                if (i < index - 1) {
                    newSegments[i] = (Segment2D)segments[i].clone();
                }
                if (i == index - 1) {
                    newSegments[i] = newSegment;
                }
                if (i == index || i <= index) continue;
                newSegments[i - 1] = (Segment2D)segments[i].clone();
            }
        }
        if (index == 0) {
            for (int i = 1; i < numseg; ++i) {
                newSegments[i - 1] = segments[i];
            }
            if (closed) {
                Segment2D newSegment;
                newSegments[numseg - 2] = newSegment = ShapeElementUtil.connectSegments(segments[numseg - 1], segments[0]);
            }
        }
        if (index == numseg) {
            for (int i = 0; i < numseg - 1; ++i) {
                newSegments[i] = segments[i];
            }
            if (closed) {
                Segment2D newSegment;
                newSegments[0] = newSegment = ShapeElementUtil.connectSegments(segments[numseg - 1], segments[0]);
            }
        }
        ((Curve2D)curve).setData(newSegments);
        gcurve.setSubPaths(curves);
        String str = "";
        str = str + "\n** GeneralCurveElement.deletePoint deletePoint segmentPtIndex=" + index + ", target subPath=" + subPath + ", localSegmentPtIndex=" + index + "\n" + gcurve.toString();
        if (debug > 0) {
            System.out.println(str);
        }
    }

    private static Segment2D connectSegments(Segment2D segment1, Segment2D segment2) {
        Point2D[] P = new Point2D[2];
        Vector2D[] Tin = new Vector2D[2];
        Vector2D[] Tout = new Vector2D[2];
        P[0] = segment1.getP(0.0);
        P[1] = segment2.getP(1.0);
        Tout[0] = segment1.getTangent(0.0);
        Tin[0] = (Vector2D)Tout[0].clone();
        Tin[1] = segment2.getTangent(1.0);
        Tout[1] = (Vector2D)Tin[1].clone();
        FergusonCurve2D fergusonCurve = new FergusonCurve2D(P, Tin, Tout);
        Vector2D[] newTangents = FergusonCurve2D.getOptimizedTangents(P[0], P[1], Tout[0], Tin[1]);
        fergusonCurve.setTout(newTangents[0], 0);
        fergusonCurve.setTin(newTangents[1], 1);
        CubicCurve2D cubic = fergusonCurve.getCubicCurve2D(0);
        Segment2D newSegment = new Segment2D(3, cubic);
        String str = "";
        str = str + "\n -- connectSegment\n  -- segment1=" + segment1.toString() + "\n  -- segment2=" + segment2.toString() + "\n  -- newSegment=" + newSegment.toString();
        if (debug > 0) {
            System.out.println(str);
        }
        return newSegment;
    }

    public static void smoothPoint(Curve2D curve2D, SegmentModifier hitSegmentModifier, Point2D point) {
        if (hitSegmentModifier == null) {
            return;
        }
        System.out.println("GeneralCurveElement.smoothPoint hitSegmentModifier" + hitSegmentModifier.toString());
        int type2DE = curve2D.getType2DE();
        if (type2DE != 56) {
            return;
        }
        GeneralCurve2DE gcurve = (GeneralCurve2DE)curve2D;
        int subPath = hitSegmentModifier.getSubPathIndex();
        int index = hitSegmentModifier.getSegmentPid();
        int index1 = hitSegmentModifier.getSegmentId1();
        int index2 = hitSegmentModifier.getSegmentId2();
        int hitType = hitSegmentModifier.getHitType();
        if (hitType != 1) {
            return;
        }
        Curve2D[] curves = gcurve.getSubPaths();
        GeneralCurve2DE curve = curves[subPath];
        int numseg = curve.getNumOfSegments();
        Segment2D[] segments = curve.getSegment2Ds();
        if (index < 0 || index > numseg) {
            return;
        }
        if (index1 < 0 || index2 < 0) {
            return;
        }
        if (segments[index1].getType() != 3 && segments[index2].getType() != 3) {
            return;
        }
        Vector2D Tin = curve.getTangent((double)index - 1.0E-5);
        Vector2D Tout = curve.getTangent((double)index + 1.0E-5);
        Vector2D T = Vector2D.add(Tin, Tout);
        if (segments[index1].getType() == 3 && segments[index2].getType() == 3) {
            segments[index1] = segments[index1].moveSegmentTangent(1, T);
            segments[index2] = segments[index2].moveSegmentTangent(0, T);
        }
        if (segments[index1].getType() == 3 && segments[index2].getType() != 3) {
            segments[index1] = segments[index1].moveSegmentTangent(1, Tout);
        }
        if (segments[index1].getType() != 3 && segments[index2].getType() == 3) {
            segments[index2] = segments[index2].moveSegmentTangent(0, Tin);
        }
        ((Curve2D)curve).setData(segments);
        gcurve.setSubPaths(curves);
    }

    public static void cuspPoint(Curve2D curve2D, SegmentModifier hitSegmentModifier, Point2D point) {
        if (hitSegmentModifier == null) {
            return;
        }
        System.out.println("GeneralCurveElement.smoothPoint hitSegmentModifier" + hitSegmentModifier.toString());
        int type2DE = curve2D.getType2DE();
        if (type2DE != 56) {
            return;
        }
        GeneralCurve2DE gcurve = (GeneralCurve2DE)curve2D;
        int subPath = hitSegmentModifier.getSubPathIndex();
        int index = hitSegmentModifier.getSegmentPid();
        int index1 = hitSegmentModifier.getSegmentId1();
        int index2 = hitSegmentModifier.getSegmentId2();
        int jointType = hitSegmentModifier.getJointType();
        if (jointType == 5) {
            return;
        }
        int hitType = hitSegmentModifier.getHitType();
        if (hitType != 1) {
            return;
        }
        Curve2D[] curves = gcurve.getSubPaths();
        GeneralCurve2DE curve = curves[subPath];
        int numseg = curve.getNumOfSegments();
        Segment2D[] segments = curve.getSegment2Ds();
        if (index < 0 || index > numseg) {
            return;
        }
        if (index1 < 0 || index2 < 0) {
            return;
        }
        if (segments[index1].getType() != 3 && segments[index2].getType() != 3) {
            return;
        }
        Point2D P0 = segments[index1].getP(0.0);
        Point2D P1 = segments[index2].getP(0.0);
        Point2D P2 = segments[index2].getP(1.0);
        Vector2D Tin = curve.getTangent((double)index - 1.0E-5);
        Vector2D Tout = curve.getTangent((double)index + 1.0E-5);
        Vector2D newTin = ShapeElementUtil.divertTangent(P0, P1, P2, Tin, 1);
        Vector2D newTout = ShapeElementUtil.divertTangent(P0, P1, P2, Tout, -1);
        if (segments[index1].getType() == 3 && segments[index2].getType() == 3) {
            segments[index1] = segments[index1].moveSegmentTangent(1, newTin);
            segments[index2] = segments[index2].moveSegmentTangent(0, newTout);
        }
        if (segments[index1].getType() == 3 && segments[index2].getType() != 3) {
            segments[index1] = segments[index1].moveSegmentTangent(1, newTin);
        }
        if (segments[index1].getType() != 3 && segments[index2].getType() == 3) {
            segments[index2] = segments[index2].moveSegmentTangent(0, newTout);
        }
        ((Curve2D)curve).setData(segments);
        gcurve.setSubPaths(curves);
    }

    private static Vector2D divertTangent(Point2D P0, Point2D P1, Point2D P2, Vector2D target, int dir) {
        double divertAngle = 5.0;
        Vector2D v0 = Vector2D.sub(P2, P0);
        Vector2D v1 = Vector2D.sub(P1, P0);
        Vector2D normal = Vector2D.unitNormalVector(v0);
        if (Vector2D.sproduct(normal, v1) < 0.0) {
            normal = Vector2D.multiply(-1.0, normal);
        }
        double targetLen = Vector2D.length(target);
        Vector2D unitTarget = Vector2D.multiply(1.0 / targetLen, target);
        double divert = divertAngle / 180.0 * Math.PI;
        if (dir < 0) {
            divert = -divert;
        }
        Vector2D divertVec = Vector2D.multiply(divert, normal);
        Vector2D newTarget = Vector2D.multiply(targetLen, Vector2D.add(unitTarget, divertVec));
        return newTarget;
    }

    public static void disconnectPoint(Curve2D curve2D, SegmentModifier hitSegmentModifier, Point2D point) {
        int i;
        int i2;
        Segment2D[] newSegments;
        int type2DE;
        double trimLength = 4.0;
        if (hitSegmentModifier == null) {
            return;
        }
        if (debug > 0) {
            System.out.println("GeneralCurveElement.disconnectPoint hitSegmentModifier" + hitSegmentModifier.toString());
        }
        if ((type2DE = curve2D.getType2DE()) != 56) {
            return;
        }
        GeneralCurve2DE gcurve = (GeneralCurve2DE)curve2D;
        if (debug >= 0) {
            String str = "** disconnectPoint gcurve:" + gcurve.toString();
            System.out.println(str);
        }
        int subPath = hitSegmentModifier.getSubPathIndex();
        int index = hitSegmentModifier.getSegmentPid();
        int index1 = hitSegmentModifier.getSegmentId1();
        int index2 = hitSegmentModifier.getSegmentId2();
        int hitType = hitSegmentModifier.getHitType();
        if (hitType != 1) {
            return;
        }
        GeneralCurve2DE[] curves = gcurve.getSubPaths();
        GeneralCurve2DE curve = curves[subPath];
        int numseg = curve.getNumOfSegments();
        Segment2D[] segments = curve.getSegment2Ds();
        if (index < 0 || index > numseg) {
            return;
        }
        if (index1 < 0 || index2 < 0) {
            return;
        }
        Vector2D Tin = curve.getTangent((double)index - 1.0E-5);
        Vector2D Tout = curve.getTangent((double)index + 1.0E-5);
        double TinLen = Vector2D.length(Tin);
        double ToutLen = Vector2D.length(Tout);
        double t1 = trimLength / TinLen;
        double t2 = trimLength / ToutLen;
        if (index1 >= 0) {
            segments[index1] = segments[index1].trimSegment(0.0, 1.0 - t1);
        }
        if (index2 >= 0) {
            segments[index2] = segments[index2].trimSegment(t2, 1.0);
        }
        int pathCount = 0;
        GeneralCurve2DE[] newSubCurves = new GeneralCurve2DE[2];
        if (index1 >= 0) {
            newSegments = new Segment2D[index1 + 1];
            for (i2 = 0; i2 <= index1; ++i2) {
                newSegments[i2] = (Segment2D)segments[i2].clone();
            }
            newSubCurves[pathCount] = new GeneralCurve2DE(newSegments);
            ++pathCount;
        }
        if (index2 >= 0) {
            newSegments = new Segment2D[numseg - index2];
            for (i2 = 0; i2 < numseg - index2; ++i2) {
                newSegments[i2] = (Segment2D)segments[i2 + index2].clone();
            }
            newSubCurves[pathCount] = new GeneralCurve2DE(newSegments);
            ++pathCount;
        }
        Curve2D[] newCurves = new Curve2D[curves.length + pathCount - 1];
        int ind = 0;
        for (i = 0; i < subPath; ++i) {
            newCurves[i] = curves[i];
            ++ind;
        }
        for (i = 0; i < pathCount; ++i) {
            newCurves[ind] = newSubCurves[i];
            ++ind;
        }
        for (i = subPath + 1; i < curves.length; ++i) {
            newCurves[ind] = curves[i];
            ++ind;
        }
        gcurve.setSubPaths(newCurves);
        if (debug >= 0) {
            String str = "** disconnectPoint result gcurve:" + curve2D.toString();
            System.out.println(str);
        }
    }

    private static void drawMessage(String id, String message, Point2D pos) {
        TempShapeManager tempShapeManager = ObjectTable.getTempShapeManager("ShapeElementUtil");
        TempShape tempShape = new TempShape(id, message, pos, Color.RED, DrawParameters.DefaultFont);
        tempShapeManager.addTempShape(tempShape);
    }

    private static void clearMessage(String id) {
        TempShapeManager tempShapeManager = ObjectTable.getTempShapeManager("ShapeElementUtil");
        tempShapeManager.clearTempShape(id);
    }
}

