/*
 * Decompiled with CFR 0.152.
 */
package shape;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class TempShape {
    public String id = "";
    public Shape shape = null;
    public Stroke stroke = null;
    public Color lineColor = null;
    public Color fillColor = null;
    public String message = "";
    public Point2D messagePoint = null;
    public Color messageColor = null;
    public Font messageFont = null;

    public TempShape(String id, Shape shape, Stroke stroke, Color lineColor, Color fillColor, String message, Point2D messagePoint, Color messageColor, Font messageFont) {
        this.id = id;
        this.shape = shape;
        this.stroke = stroke;
        this.lineColor = lineColor;
        this.fillColor = fillColor;
        this.message = message;
        this.messagePoint = messagePoint;
        if (messagePoint == null) {
            this.messagePoint = this.getStringPosition();
        }
        this.messageColor = messageColor;
        this.messageFont = messageFont;
    }

    public TempShape(String id, String message, Point2D messagePoint, Color messageColor, Font messageFont) {
        this.id = id;
        this.shape = null;
        this.stroke = null;
        this.lineColor = null;
        this.fillColor = null;
        this.message = message;
        this.messagePoint = messagePoint;
        if (messagePoint == null) {
            this.messagePoint = this.getStringPosition();
        }
        this.messageColor = messageColor;
        this.messageFont = messageFont;
    }

    public String getId() {
        return this.id;
    }

    public BasicStroke getScaledStroke(double scale) {
        BasicStroke stroke;
        BasicStroke newStroke = stroke = (BasicStroke)this.stroke;
        float lineW = (float)((double)stroke.getLineWidth() / scale);
        newStroke = new BasicStroke(lineW, 2, 0, 1.0f, stroke.getDashArray(), 0.0f);
        return newStroke;
    }

    public Point2D getStringPosition() {
        double margin = 5.0;
        Point2D.Double position = null;
        Rectangle2D bound = this.shape.getBounds2D();
        double x = bound.getX() + 0.5 * bound.getWidth() + margin;
        double y = bound.getY() + 0.5 * bound.getHeight();
        position = new Point2D.Double(x, y);
        return position;
    }

    public String toString() {
        String str = "TempShape";
        str = str + ", id=" + this.id;
        if (this.message != null && !this.message.equals("")) {
            str = str + ", message" + this.message;
        }
        return str;
    }
}

