/*
 * Decompiled with CFR 0.152.
 */
package shapeUtil;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import shapeUtil.Align;
import shapeUtil.AutoAlign;
import util.Util;

class AlignedCouple {
    protected Align targetAlign = null;
    protected Align hitAlign = null;
    protected Point2D targetAlignPoint = null;
    protected Point2D hitAlignPoint = null;
    int debug = 0;
    public static double ErrorMax = 6.0;

    public AlignedCouple(Align targetAlign, Align hitAlign) {
        this.targetAlign = targetAlign;
        this.hitAlign = hitAlign;
        this.setAlignPoints();
    }

    private void setAlignPoints() {
        int alignAxis = this.hitAlign.getAlignAxis();
        Point2D[] targetAlignPTs = this.targetAlign.getAlignedPoints();
        Point2D[] hitAlignPTs = this.hitAlign.getAlignedPoints();
        Point2D targetAlignPT = null;
        Point2D hitAlignPT = null;
        double distMin = 100000.0;
        for (int j = 0; j < targetAlignPTs.length; ++j) {
            for (int i = 0; i < hitAlignPTs.length; ++i) {
                double dist = 100000.0;
                if (alignAxis == 10) {
                    dist = Math.abs(targetAlignPTs[j].getY() - hitAlignPTs[i].getY());
                }
                if (alignAxis == 11) {
                    dist = Math.abs(targetAlignPTs[j].getX() - hitAlignPTs[i].getX());
                }
                if (!(dist < distMin)) continue;
                distMin = dist;
                targetAlignPT = targetAlignPTs[j];
                hitAlignPT = hitAlignPTs[i];
            }
        }
        this.targetAlignPoint = targetAlignPT;
        this.hitAlignPoint = hitAlignPT;
    }

    public Point2D getTargetAlignPoint() {
        return this.targetAlignPoint;
    }

    public Point2D getHitAlignPoint() {
        return this.hitAlignPoint;
    }

    public boolean isHitAlignUpperLeft() {
        int alignAxis = this.targetAlign.getAlignAxis();
        double delta = 0.0;
        if (alignAxis == 10) {
            delta = this.hitAlignPoint.getY() - this.targetAlignPoint.getY();
        }
        if (alignAxis == 11) {
            delta = this.hitAlignPoint.getX() - this.targetAlignPoint.getX();
        }
        boolean forward = true;
        if (delta > 0.0) {
            forward = false;
        }
        return forward;
    }

    public double getAlignOrthogonalDistance() {
        int alignAxis = this.targetAlign.getAlignAxis();
        double dist = 0.0;
        if (alignAxis == 10) {
            dist = Math.abs(this.targetAlignPoint.getY() - this.hitAlignPoint.getY());
        }
        if (alignAxis == 11) {
            dist = Math.abs(this.targetAlignPoint.getX() - this.hitAlignPoint.getX());
        }
        return dist;
    }

    public double getAlignedError() {
        double error = ErrorMax;
        int targetAlignType = this.targetAlign.getAlignType();
        int hitAlignType = this.hitAlign.getAlignType();
        Rectangle2D targetBox = this.targetAlign.getBoundingBox();
        Rectangle2D hitBox = this.hitAlign.getBoundingBox();
        double[] target = new double[3];
        double[] hit = new double[3];
        if ((targetAlignType < 3 || targetAlignType == 6) && hitAlignType < 3) {
            for (int i = 0; i < 3; ++i) {
                target[i] = targetBox.getX() + 0.5 * targetBox.getWidth() * (double)i;
                hit[i] = hitBox.getX() + 0.5 * hitBox.getWidth() * (double)i;
            }
            if (this.targetAlign.getAlignType() != 6) {
                error = hit[hitAlignType] - target[targetAlignType];
            } else {
                Point2D[] endPTs = this.targetAlign.shapeContainer.getElement().getEndPTs();
                Point2D endPT = endPTs[this.targetAlign.getEndPTindex()];
                error = hit[hitAlignType] - endPT.getX();
            }
        } else if ((targetAlignType >= 3 || targetAlignType == 6) && hitAlignType >= 3) {
            for (int i = 0; i < 3; ++i) {
                target[i] = targetBox.getY() + 0.5 * targetBox.getHeight() * (double)i;
                hit[i] = hitBox.getY() + 0.5 * hitBox.getHeight() * (double)i;
            }
            if (this.targetAlign.getAlignType() != 6) {
                error = hit[hitAlignType - 3] - target[targetAlignType - 3];
            } else {
                Point2D[] endPTs = this.targetAlign.shapeContainer.getElement().getEndPTs();
                Point2D endPT = endPTs[this.targetAlign.getEndPTindex()];
                error = hit[hitAlignType - 3] - endPT.getY();
            }
        }
        return error;
    }

    public double[] checkIntersection() {
        double[] interval = null;
        int targetAlignAxis = this.targetAlign.getAlignAxis();
        int targetAlignType = this.targetAlign.getAlignType();
        int hitAlignType = this.hitAlign.getAlignType();
        double targetValue = this.targetAlign.getValue();
        double hitValue = this.hitAlign.getValue();
        double errorMargin = AutoAlign.ErrorMargin;
        Rectangle2D targetBox = this.targetAlign.getBoundingBox();
        Rectangle2D hitBox = this.hitAlign.getBoundingBox();
        Rectangle2D.Double targetChkBox = null;
        Rectangle2D.Double hitChkBox = null;
        double delta = 1.0;
        if (targetAlignAxis == 10) {
            targetChkBox = new Rectangle2D.Double(targetValue - errorMargin, targetBox.getY(), 2.0 * errorMargin, targetBox.getHeight());
            hitChkBox = new Rectangle2D.Double(hitValue, hitBox.getY(), 0.0, hitBox.getHeight());
        } else {
            targetChkBox = new Rectangle2D.Double(targetBox.getX(), hitValue - errorMargin, targetBox.getWidth(), 2.0 * errorMargin);
            hitChkBox = new Rectangle2D.Double(hitBox.getX(), hitValue, hitBox.getWidth(), 0.0);
        }
        Rectangle2D.Double intersect = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        Rectangle2D.intersect(targetChkBox, hitChkBox, intersect);
        if (((RectangularShape)intersect).getWidth() > 0.0 || ((RectangularShape)intersect).getHeight() > 0.0) {
            interval = new double[2];
            if (targetAlignAxis == 10) {
                interval[0] = ((RectangularShape)intersect).getY();
                interval[1] = ((RectangularShape)intersect).getY() + ((RectangularShape)intersect).getHeight();
            } else {
                interval[0] = ((RectangularShape)intersect).getX();
                interval[1] = ((RectangularShape)intersect).getX() + ((RectangularShape)intersect).getWidth();
            }
        }
        if (this.debug > 0) {
            String str = "";
            str = str + " - AlignedCouples checkInterSection\n";
            String space = "  ";
            str = str + "  targetAlign: " + this.targetAlign.toString(2) + "\n  hitAlign:    " + this.hitAlign.toString(2);
            str = str + "\n  targetChkBox: " + Util.RectC(targetChkBox) + "\n";
            str = str + "  hitChkBox: " + Util.RectC(hitChkBox) + "\n";
            str = interval == null ? str + "  intersect=null" : str + "  intersect: " + Util.Rect(intersect) + ", interval=(" + interval[0] + ", " + interval[1] + ")";
            System.out.println(str);
        }
        return interval;
    }

    public void update() {
        this.targetAlign.update();
        this.hitAlign.update();
        this.setAlignPoints();
    }

    public String toString() {
        String str = "targetAlign: " + this.targetAlign.toString() + "\nhitAlign:    " + this.hitAlign.toString();
        double[] intersect = this.checkIntersection();
        str = intersect == null ? str + "\nintersect=none" : str + "\nintersect=(" + intersect[0] + ", " + intersect[1] + ")";
        return str;
    }

    public String toString(int indent) {
        String space = "";
        for (int i = 0; i < indent; ++i) {
            space = space + " ";
        }
        String str = space + "targetAlign: " + this.targetAlign.toString(indent) + "\n" + space + "hitAlign:    " + this.hitAlign.toString(indent);
        double[] intersect = this.checkIntersection();
        str = intersect == null ? str + "\n" + space + "intersect=none" : str + "\n" + space + "intersect=(" + intersect[0] + ", " + intersect[1] + ")";
        return str;
    }
}

