/*
 * Decompiled with CFR 0.152.
 */
package shapeUtil;

import DrawTop.ObjectTable;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import javax.swing.JOptionPane;
import shape.ShapeContainer;
import shape.ShapeElement;
import shapeUtil.ComponentLibDialog;
import shapeUtil.ConnectionUtil;
import util.ContainerManager;

public class ChangeShapeElement {
    ComponentLibDialog dialog = null;
    Vector shapeVector = new Vector();
    int debug = 0;

    public ChangeShapeElement(ComponentLibDialog dialog) {
        this.dialog = dialog;
    }

    public void start() {
        if (this.dialog == null) {
            System.err.println("*** Error in ChangeShapeElement.start  getComponentLibDialog not found");
            this.dialog = ObjectTable.getComponentLibDialog();
            this.dialog.showDialog();
        }
        this.dialog.showMessage("", Color.BLACK);
        ShapeContainer selectedComponent = this.dialog.getSelectedComponent();
        selectedComponent = (ShapeContainer)selectedComponent.clone();
        if (selectedComponent == null) {
            this.dialog.showMessage("No component on the dialog !", Color.RED);
            return;
        }
        if (selectedComponent.getContainerType() == ShapeContainer.GROUP) {
            String str = "Selected component is a grouped shape\nselect another component !";
            this.dialog.showMessage(str, Color.RED);
            JOptionPane.showMessageDialog(ObjectTable.getDrawMain(), str, "", 0);
            return;
        }
        if (!selectedComponent.getElement().isClosed()) {
            String str = "Selected component isn't a closed shape\nselect another component !";
            this.dialog.showMessage(str, Color.RED);
            String str1 = str + "\nselected component : " + selectedComponent.getShapeId();
            JOptionPane.showMessageDialog(ObjectTable.getDrawMain(), str1, "", 0);
            return;
        }
        ContainerManager manager = ObjectTable.getContainerManager();
        ShapeContainer[] targetSigleShapeContainers = manager.getAllSigleShapeContainers(true);
        if (targetSigleShapeContainers.length == 0) {
            this.dialog.showMessage("No shape is selected on the canvas.\nSelect shapes and try again !", Color.RED);
            return;
        }
        this.shapeVector.clear();
        for (int i = 0; i < targetSigleShapeContainers.length; ++i) {
            if (!this.isSuitable(targetSigleShapeContainers[i])) continue;
            this.shapeVector.add(targetSigleShapeContainers[i]);
        }
        int size = this.shapeVector.size();
        ShapeContainer[] targets = new ShapeContainer[size];
        for (int i = 0; i < size; ++i) {
            targets[i] = (ShapeContainer)this.shapeVector.get(i);
        }
        ConnectionUtil connectionUtil = new ConnectionUtil();
        connectionUtil.setTargets(targets);
        ShapeContainer[] containers = connectionUtil.getTargetsAndConnectors();
        manager.undoSetupStart(containers);
        for (int i = 0; i < targets.length; ++i) {
            this.changeShapeElement(targets[i], selectedComponent);
        }
        int option = 117;
        connectionUtil.resizeConnectors(option);
        connectionUtil.end();
        manager.undoSetupEnd();
        ObjectTable.getDrawPanel().repaint("ChangeShapeElement.start");
        this.dialog.showMessage("", Color.RED);
    }

    private boolean isSuitable(ShapeContainer shapeContainer) {
        int type = shapeContainer.getElement().getTypeE();
        boolean closed = shapeContainer.getElement().isClosed();
        if (!closed) {
            return false;
        }
        return type < 51 || type > 53;
    }

    public void changeShapeElement(ShapeContainer target, ShapeContainer component) {
        if (this.debug > 0) {
            System.out.println("target shape: " + target.toString());
        }
        Rectangle2D targetBox = target.getBoundingBox();
        Rectangle2D componentBox = component.getBoundingBox();
        int targetSerialNumber = target.getSerialNumber();
        ShapeContainer componentCopy = (ShapeContainer)component.clone();
        componentCopy.getElement().moveResize(componentBox, targetBox, true);
        Rectangle2D targetTextArea = null;
        Rectangle2D componentCopyTextArea = null;
        if (target.isTextBox()) {
            targetTextArea = target.getTextBox().getTextArea();
        }
        if (componentCopy.isTextBox()) {
            componentCopyTextArea = componentCopy.getTextBox().getTextArea();
        } else {
            int result = componentCopy.addTextBox();
            if (result == 0) {
                componentCopyTextArea = componentCopy.getTextBox().getTextArea();
            }
        }
        ShapeElement newElement = (ShapeElement)componentCopy.getElement().clone();
        newElement.setShapeContainer(target);
        target.setElement(newElement);
        newElement.setShapeContainer(target);
        String newShapeId = target.configureShapeId(targetSerialNumber);
        target.setShapeId(newShapeId);
        Rectangle2D componentCopyBox = componentCopy.getBoundingBox();
        if (this.debug > 0) {
            System.out.println("changed shape: " + target.toString());
        }
        if (target.isTextBox() && componentCopyTextArea != null) {
            newElement.moveResize(componentCopyTextArea, targetTextArea, false);
        } else {
            newElement.moveResize(componentCopyBox, targetBox, true);
        }
    }
}

