/*
 * Decompiled with CFR 0.152.
 */
package shapeUtil;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Date;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import menu.MultiLineToolTip;
import shape.ShapeContainer;
import shapeUtil.ComponentLibDialog;
import shapeUtil.ComponentManager;
import shapeUtil.TransferableComponent;
import util.ContainerManager;

public class ComponentLibPanel
extends JPanel
implements MouseListener,
MouseMotionListener,
DragGestureListener,
DropTargetListener {
    ComponentLibDialog dialog;
    final Dimension sizeOfComponent = new Dimension(24, 24);
    final int xGap = 12;
    final int yGap = 12;
    final int xNum = 8;
    int yNum = 0;
    ShapeContainer[] components = null;
    Dimension panelSize = null;
    Rectangle2D[] componentRects = null;
    int selectedComponentIndex = -1;
    int gapIndex = -1;
    MultiLineToolTip mToolTip = new MultiLineToolTip(500, 60000);
    public static int debug = 0;

    public ComponentLibPanel(ComponentLibDialog dialog) {
        this.dialog = dialog;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseListener(dialog.action);
        this.mToolTip.setComponent(this);
        Font font = new Font("Dialog", 1, 12);
        this.mToolTip.setFont(font);
        String text = "Drag a component from this panel and :\n1. drop the component on the same panel to reorder the component.\n2. drop the component on the canvas to create a new shape.";
        this.setToolTipText(text);
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this, 1, this);
        DropTarget dropTarget = new DropTarget(this, this);
    }

    @Override
    public JToolTip createToolTip() {
        this.mToolTip.setComponent(this);
        return this.mToolTip;
    }

    public Dimension getSizeOfComponent() {
        return this.sizeOfComponent;
    }

    public int getSelectedComponentByIndex() {
        return this.selectedComponentIndex;
    }

    public void setSelectedComponentByIndex(int selectedComponentIndex) {
        this.selectedComponentIndex = selectedComponentIndex;
    }

    public Dimension getSizeOfScrollPane() {
        ContainerManager manager = this.dialog.getComponentManager().getContainerManager();
        int numOfComponents = manager.size();
        int n = this.xNum * (int)this.sizeOfComponent.getWidth();
        this.getClass();
        int width = n + (this.xNum + 1) * 12;
        this.yNum = numOfComponents / 8;
        if (numOfComponents > this.xNum * this.yNum) {
            ++this.yNum;
        }
        int n2 = this.yNum * (int)this.sizeOfComponent.getHeight();
        this.getClass();
        int height = n2 + (this.yNum + 1) * 12;
        return new Dimension(width + 16, height + 16);
    }

    @Override
    public void paint(Graphics g) {
        ContainerManager manager = this.dialog.getComponentManager().getContainerManager();
        int numOfComponents = manager.size();
        this.setComponentPanel(numOfComponents);
        this.components = manager.getContainers();
        if (debug > 0) {
            System.out.println("++ paint numOfComponents=" + numOfComponents + ", selectedComponentIndex=" + this.getSelectedComponentByIndex());
        }
        Graphics2D g2 = (Graphics2D)g;
        Rectangle2D.Double panelRect = new Rectangle2D.Double(0.0, 0.0, this.panelSize.getWidth(), this.panelSize.getHeight());
        g2.setColor(Color.WHITE);
        g2.fill(panelRect);
        g2.setClip(panelRect);
        for (int i = 0; i < numOfComponents; ++i) {
            double lineY;
            double lineX;
            BasicStroke wideStroke;
            Stroke currentStroke = g2.getStroke();
            g2.setColor(Color.LIGHT_GRAY);
            Rectangle2D enlargedRect = this.getEnlargedRectangle(this.componentRects[i], 4.0, 4.0);
            BasicStroke narrowStroke = new BasicStroke(0.5f, 2, 0, 10.0f);
            g2.setStroke(narrowStroke);
            g2.draw(enlargedRect);
            if (i == this.selectedComponentIndex) {
                g2.setColor(Color.DARK_GRAY);
                wideStroke = new BasicStroke(2.0f, 2, 0, 10.0f);
                g2.setStroke(wideStroke);
                g2.draw(enlargedRect);
            }
            if (this.gapIndex >= 0 && i == this.gapIndex) {
                g2.setColor(Color.DARK_GRAY);
                wideStroke = new BasicStroke(2.0f, 2, 0, 10.0f);
                g2.setStroke(wideStroke);
                lineX = this.componentRects[i].getX();
                lineY = this.componentRects[i].getY();
                double lineH = this.componentRects[i].getHeight();
                Line2D.Double line = new Line2D.Double(lineX - 6.0, lineY, lineX - 6.0, lineY + lineH);
                g2.draw(line);
            }
            if (this.gapIndex >= 0 && i + 1 == this.gapIndex) {
                g2.setColor(Color.DARK_GRAY);
                wideStroke = new BasicStroke(2.0f, 2, 0, 10.0f);
                g2.setStroke(wideStroke);
                lineX = this.componentRects[i].getX();
                lineY = this.componentRects[i].getY();
                double lineW = this.componentRects[i].getWidth();
                double lineH = this.componentRects[i].getHeight();
                Line2D.Double line = new Line2D.Double(lineX + lineW + 6.0, lineY, lineX + lineW + 6.0, lineY + lineH);
                g2.draw(line);
            }
            g2.setStroke(currentStroke);
            this.drawComponent(g, i, this.componentRects[i]);
        }
    }

    private void setComponentPanel(int numOfComponents) {
        this.yNum = numOfComponents / this.xNum;
        int residue = numOfComponents - this.yNum * this.xNum;
        if (residue > 0 || numOfComponents == 0) {
            ++this.yNum;
        }
        int n = this.xNum * (int)this.sizeOfComponent.getWidth();
        this.getClass();
        int w = n + (this.xNum + 1) * 12;
        int n2 = this.yNum * (int)this.sizeOfComponent.getHeight();
        this.getClass();
        int h = n2 + (this.yNum + 1) * 12;
        this.panelSize = new Dimension(w, h);
        this.setPreferredSize(this.panelSize);
        this.componentRects = new Rectangle2D[numOfComponents];
        double X = 12.0;
        double Y = 12.0;
        double width = this.sizeOfComponent.getWidth();
        double height = this.sizeOfComponent.getHeight();
        for (int i = 0; i < numOfComponents; ++i) {
            this.componentRects[i] = new Rectangle2D.Double(X, Y, width, height);
            X += width + 12.0;
            if (i + 1 - (i + 1) / this.xNum * this.xNum != 0) continue;
            Y += height + 12.0;
            X = 12.0;
        }
        this.revalidate();
        if (debug > 0) {
            System.out.println(" -- ComponentLibPanel.setPreferredSize&revalidate");
        }
    }

    public Rectangle2D getEnlargedRectangle(Rectangle2D box, double wEx, double hEx) {
        if (box == null) {
            return null;
        }
        double X = box.getX();
        double Y = box.getY();
        double Width = box.getWidth();
        double Height = box.getHeight();
        return new Rectangle2D.Double(X - wEx, Y - hEx, Width + 2.5 * wEx, Height + 2.5 * hEx);
    }

    private void drawComponent(Graphics g, int i, Rectangle2D rect) {
        Graphics2D g2 = (Graphics2D)g;
        Shape currentClip = g2.getClip();
        g2.setClip(rect);
        ShapeContainer container = this.components[i];
        Rectangle2D box = container.getBoundingBox();
        Color currentColor = g2.getColor();
        AffineTransform currentTransform = g2.getTransform();
        double rectCenterX = rect.getX() + rect.getWidth() * 0.5;
        double rectCenterY = rect.getY() + rect.getHeight() * 0.5;
        double moveX = rectCenterX - box.getWidth() * 0.5;
        double moveY = rectCenterY - box.getHeight() * 0.5;
        g2.translate(moveX, moveY);
        container.drawShape(g);
        g2.translate(-moveX, -moveY);
        g2.setTransform(currentTransform);
        g2.setColor(currentColor);
        g2.setClip(currentClip);
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent e) {
        int index = this.getSelectedComponentByIndex();
        ContainerManager manager = this.dialog.getComponentManager().getContainerManager();
        ShapeContainer container = manager.getContainer(index);
        TransferableComponent transfer = new TransferableComponent((ShapeContainer)container.clone());
        e.startDrag(DragSource.DefaultCopyDrop, transfer);
    }

    @Override
    public void drop(DropTargetDropEvent e) {
        if (debug >= 0) {
            System.out.println("ComponentLibPanel.drop called");
        }
        if (!e.isDataFlavorSupported(TransferableComponent.componentFlavor)) {
            e.rejectDrop();
            return;
        }
        e.acceptDrop(1);
        Transferable transferable = e.getTransferable();
        try {
            ShapeContainer container = (ShapeContainer)transferable.getTransferData(TransferableComponent.componentFlavor);
        }
        catch (Exception ex) {
            e.dropComplete(false);
            return;
        }
        Point p = e.getLocation();
        Dimension dim = this.getPreferredSize();
        if (p.x >= 0 && p.x <= dim.width && p.y >= 0 && p.y <= dim.height) {
            if (debug > 0) {
                System.out.println("** Warning drop point is inside ComponentLibPanel , drop p=" + p);
            }
            MouseEvent event = new MouseEvent(this, 502, new Date().getTime(), 16, (int)p.getX(), (int)p.getY(), 1, false);
            this.mouseReleased(event);
            e.dropComplete(false);
            return;
        }
        e.dropComplete(true);
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
    }

    @Override
    public void dragExit(DropTargetEvent e) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
        if (debug >= 0) {
            System.out.println("** dragOver pos=" + e.getLocation());
        }
        Point p = e.getLocation();
        MouseEvent event = new MouseEvent(this, 502, new Date().getTime(), 16, (int)p.getX(), (int)p.getY(), 1, false);
        this.mouseDragged(event);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        double Y;
        double X = e.getX();
        Point2D.Double startPoint = new Point2D.Double(X, Y = (double)e.getY());
        int index = this.ptInside(startPoint);
        this.selectedComponentIndex = index >= 0 ? index : -1;
        this.dialog.showMessage(" ", Color.BLACK);
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        double X = e.getX();
        double Y = e.getY();
        Point2D.Double currentPoint = new Point2D.Double(X, Y);
        this.gapIndex = this.getNearestGap(currentPoint);
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.selectedComponentIndex >= 0 && this.gapIndex >= 0) {
            this.moveComponent(this.selectedComponentIndex, this.gapIndex);
            ComponentManager componentManager = this.dialog.getComponentManager();
            componentManager.writeComponentList();
            this.selectedComponentIndex = this.gapIndex < this.selectedComponentIndex ? this.gapIndex : this.gapIndex - 1;
        }
        this.gapIndex = -1;
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public int ptInside(Point2D point) {
        int index = -1;
        for (int i = 0; i < this.componentRects.length; ++i) {
            if (!this.componentRects[i].contains(point)) continue;
            index = i;
        }
        return index;
    }

    public int getNearestGap(Point2D point) {
        int index = -1;
        int side = -1;
        double distMin = 100000.0;
        double X = point.getX();
        double Y = point.getY();
        for (int i = 0; i < this.componentRects.length; ++i) {
            double x = this.componentRects[i].getX();
            double y = this.componentRects[i].getY();
            double w = this.componentRects[i].getWidth();
            double h = this.componentRects[i].getHeight();
            if (Y < y || Y > y + h) continue;
            double dist1 = Math.abs(X - x);
            double dist2 = Math.abs(X - x - w);
            if (dist1 < distMin) {
                distMin = dist1;
                index = i;
                side = 0;
            }
            if (!(dist2 < distMin)) continue;
            distMin = dist2;
            index = i;
            side = 1;
        }
        int gapIndex = -1;
        if (index >= 0 && side == 0) {
            gapIndex = index;
        }
        if (index >= 0 && side == 1) {
            gapIndex = index + 1;
        }
        if (debug > 0) {
            System.out.println("  -- nearest gap=" + gapIndex + ", X,Y=" + X + "," + Y);
        }
        return gapIndex;
    }

    private void moveComponent(int selectedComponentIndex, int gapIndex) {
        ComponentManager componentManager = this.dialog.getComponentManager();
        componentManager.moveComponent(selectedComponentIndex, gapIndex);
    }
}

