/*
 * Decompiled with CFR 0.152.
 */
package shapeUtil;

import DrawTop.Command;
import DrawTop.DrawPanel;
import DrawTop.DrawParameters;
import DrawTop.MousePositionInfo;
import DrawTop.ObjectTable;
import geomExtension.Curve2D;
import geomExtension.Curve2DUtil;
import geomExtension.CurvePT;
import geomExtension.GeneralCurve2DE;
import geomExtension.Vector2D;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import shape.DrawShapeUtil;
import shape.LineElement;
import shape.PolylineElement;
import shape.ShapeContainer;
import shape.ShapeElement;
import shape.ShapeElementUtil;
import shapeUtil.Connection;
import shapeUtil.ConnectionContainer;
import shapeUtil.ConnectionLS;
import shapeUtil.MouseHitShape;
import shapeUtil.TargetContainer;
import util.ContainerManager;
import util.Util;

public class ConnectionUtil {
    int mode = 0;
    MousePositionInfo mousePositionInfo = null;
    ShapeContainer[] selectedContainers = null;
    int auto_tracking_option = DrawParameters.AUTO_TRACKING_OPTION;
    ShapeContainer[] targets = null;
    Vector TargetList = new Vector();
    Vector ConnectionList = new Vector();
    MouseHitShape mouseHitShape = null;
    int movingPtIndex = 0;
    public boolean connected = false;
    public boolean guided = false;
    Point2D newPoint = null;
    Point2D oldPoint = null;
    Vector vector = new Vector();
    public static int debug = 0;

    public void start(int mode, MousePositionInfo mousePositionInfo, ShapeContainer[] selectedContainers) {
        if (!DrawParameters.ENABLE_CONNECTOR) {
            return;
        }
        this.mode = mode;
        if (mode == 81) {
            this.mode = 2;
        }
        if (mode == 82) {
            this.mode = 3;
        }
        if (mode == 83) {
            this.mode = 4;
        }
        this.mousePositionInfo = mousePositionInfo;
        this.selectedContainers = selectedContainers;
        this.setTargets(this.selectedContainers);
    }

    public void end() {
        if (!DrawParameters.ENABLE_CONNECTOR) {
            return;
        }
        this.mode = 0;
        this.clearMark("Connection.pt");
        this.clearMark("Guide.pt");
        this.clearMark("ConnectionMark");
    }

    public void mouseDragged(MouseEvent e) {
        if (!DrawParameters.ENABLE_CONNECTOR) {
            return;
        }
        double scale = DrawParameters.getScale();
        double X = (double)e.getX() / scale;
        double Y = (double)e.getY() / scale;
        int key = e.getModifiersEx();
        int ctrl = 0;
        if ((key & 0x40) != 0) {
            ctrl = 1;
        }
        if ((key & 0x80) != 0) {
            ctrl = 2;
        }
        if ((key & 0x200) != 0) {
            ctrl = 3;
        }
        this.newPoint = new Point2D.Double(X, Y);
        if (this.mode == 4) {
            ConnectionLS connectionLS = ObjectTable.getConnectionLS();
            boolean lineDir = this.selectedContainers[0].getBooleanProperty("Keep_Line_Direction", "ConnectionUtil");
            Curve2D curve = this.selectedContainers[0].getElement().getCurve2D();
            int endIndex = curve.getCloseEndpointIndex(this.newPoint);
            Point2D endPT = curve.getP(endIndex);
            Vector2D vec = curve.getTangent(endIndex);
            CurvePT connectionPT = null;
            connectionPT = ctrl > 0 || lineDir ? connectionLS.drawMouseHitPT(1, endPT, vec, this.selectedContainers[0]) : connectionLS.drawMouseHitPT(0, endPT, null, this.selectedContainers[0]);
            if (connectionPT != null) {
                ShapeElement shapeElement = this.selectedContainers[0].getElement();
                Point2D replacedPT = connectionPT.getP();
                shapeElement.moveEndPoint(ctrl, this.movingPtIndex, replacedPT);
                this.connected = true;
            }
        }
        this.resizeConnectors(DrawParameters.AUTO_TRACKING_OPTION);
        this.oldPoint = this.newPoint;
    }

    public void mouseReleased(MouseEvent e) {
        if (!DrawParameters.ENABLE_CONNECTOR) {
            return;
        }
        if (DrawParameters.AUTO_ALIGN) {
            if (this.mode == 4) {
                if (!this.connected) {
                    this.resizeConnectors(DrawParameters.AUTO_TRACKING_OPTION);
                }
            } else {
                this.resizeConnectors(DrawParameters.AUTO_TRACKING_OPTION);
            }
        }
        this.newPoint = null;
        this.end();
    }

    public void setTargets(ShapeContainer[] targets) {
        this.TargetList.clear();
        this.ConnectionList.clear();
        this.vector.clear();
        this.targets = targets;
        this.mouseHitShape = null;
        MousePositionInfo info = ObjectTable.getMousePositionLS().getMousePositionInfoForMoveResize();
        if (info != null) {
            if (debug > 0) {
                System.out.println("ConnectionUtil.setTargets MousePositionInfo=" + info.toString());
            }
            if (info.getPosition() == 14) {
                MouseHitShape hitShape;
                this.mouseHitShape = hitShape = new MouseHitShape(info.getContainer(), info.getPoint());
                ShapeContainer targetContainer = info.getContainer();
                this.movingPtIndex = targetContainer.getElement().getCurve2D().getCloseEndpointIndex(info.getPoint());
            }
        }
        int size = 0;
        if (targets != null) {
            size = targets.length;
        }
        for (int i = 0; i < size; ++i) {
            ShapeContainer[] containers = targets[i].getGroupedSingleShapeContainers();
            for (int j = 0; j < containers.length; ++j) {
                containers[j].setChangeCode(4);
                this.vector.add(containers[j]);
            }
        }
        size = this.vector.size();
        ShapeContainer[] targetContainers = new ShapeContainer[size];
        for (int i = 0; i < size; ++i) {
            targetContainers[i] = (ShapeContainer)this.vector.get(i);
        }
        this.ConnectionList.clear();
        this.TargetList.clear();
        ShapeContainer[] connectors = new ShapeContainer[]{};
        for (int depth = 0; depth < 100 && (connectors = this.setConnectors(depth, targetContainers)).length != 0; ++depth) {
            targetContainers = connectors;
        }
        this.setGuideLines();
        this.drawMarks("Connection.pt", "");
        if (debug > 0) {
            this.printTargerList(" end of the setTarget");
            this.printConnectionList(" end of the setTarget");
        }
    }

    private ShapeContainer[] setConnectors(int depth, ShapeContainer[] targetContainers) {
        int i;
        ShapeContainer[] connectors = new ShapeContainer[]{};
        if (targetContainers.length == 0) {
            return connectors;
        }
        for (i = 0; i < targetContainers.length; ++i) {
            int index0 = this.getTargetIndex(targetContainers[i], 0);
            int index = this.getTargetIndex(targetContainers[i], depth);
            if (index0 >= 0 || index >= 0) continue;
            TargetContainer targetContainer = new TargetContainer(depth, targetContainers[i]);
            this.TargetList.add(targetContainer);
        }
        this.vector.clear();
        for (i = 0; i < targetContainers.length; ++i) {
            ShapeContainer target = targetContainers[i];
            Connection[] connections = this.findConnectors(target);
            int size = 0;
            if (connections != null) {
                size = connections.length;
            }
            for (int j = 0; j < size; ++j) {
                boolean resizable = connections[j].getConnector().getBooleanProperty("Enable_Resizing", "ConnectionUtil");
                boolean compared = connections[j].closeToMouseHitShape(this.mouseHitShape);
                ShapeContainer connector = connections[j].getConnector();
                ConnectionContainer connectionContainer = new ConnectionContainer("connector", depth, connections[j]);
                int connectionIndex = this.getSameConnectionContainer(connectionContainer);
                if (compared || connectionIndex >= 0 || !resizable) continue;
                this.vector.add(connector);
                this.ConnectionList.add(connectionContainer);
            }
        }
        int size = this.vector.size();
        connectors = new ShapeContainer[size];
        for (int i2 = 0; i2 < size; ++i2) {
            connectors[i2] = (ShapeContainer)this.vector.get(i2);
        }
        return connectors;
    }

    private Connection[] findConnectors(ShapeContainer target) {
        Vector<Connection> vector = new Vector<Connection>();
        if (debug > 0) {
            System.out.println("*** ConnectionUtil.findConnectors , target=" + target.toShortString());
        }
        if (!target.isConnectorTarget()) {
            return null;
        }
        ContainerManager containerManager = ObjectTable.getContainerManager();
        ShapeContainer[] connectors = containerManager.getContainers();
        int size = 0;
        if (connectors != null) {
            size = connectors.length;
        }
        for (int i = 0; i < size; ++i) {
            if (!connectors[i].isConnector() || connectors[i].equals(target) || !ShapeElementUtil.boxIntersectionCheck(connectors[i].getBoundingBox(), target.getBoundingBox())) continue;
            Point2D[] connectorEndPTs = new Point2D[2];
            Curve2D cCurve = connectors[i].getElement().getCurve2D();
            int numSeg = cCurve.getNumOfSegments();
            connectorEndPTs[0] = cCurve.getP(0.0);
            connectorEndPTs[1] = cCurve.getP(numSeg);
            Curve2D targetCurve = target.getElement().getCurve2D();
            CurvePT targetPT0 = Curve2DUtil.getShortestLine(connectorEndPTs[0], targetCurve);
            CurvePT targetPT1 = Curve2DUtil.getShortestLine(connectorEndPTs[1], targetCurve);
            double dist0 = Vector2D.dist(connectorEndPTs[0], targetPT0.getP());
            double dist1 = Vector2D.dist(connectorEndPTs[1], targetPT1.getP());
            if (dist0 < 0.01) {
                Connection connection = new Connection(target, connectors[i], targetPT0.getParameter(), 0.0);
                vector.add(connection);
                if (debug > 0) {
                    System.out.println("*** ConnectionUtil.findConnectors,  dist0=" + dist0 + "\n  connection=" + connection.toString());
                }
            }
            if (!(dist1 < 0.01)) continue;
            int numOfSeg = connectors[i].getElement().getCurve2D().getNumOfSegments();
            Connection connection = new Connection(target, connectors[i], targetPT1.getParameter(), numOfSeg);
            vector.add(connection);
            if (debug <= 0) continue;
            System.out.println("*** Connection.getConnectors,  dist1=" + dist1 + "\n  connection=" + connection.toString());
        }
        size = vector.size();
        if (size == 0) {
            return null;
        }
        Connection[] connections = new Connection[size];
        for (int i = 0; i < size; ++i) {
            connections[i] = (Connection)vector.get(i);
        }
        return connections;
    }

    private void setGuideLines() {
        int depth = 0;
        ShapeContainer[] targetContainers = this.getTargets(depth);
        ContainerManager containerManager = ObjectTable.getContainerManager();
        ShapeContainer[] guideContainers = containerManager.getAllSigleShapeContainers(false);
        for (int i = 0; i < targetContainers.length; ++i) {
            ShapeContainer target = targetContainers[i];
            if (target.getParent() != null || !target.isConnector()) continue;
            Point2D[] targetEndPTs = new Point2D[2];
            Curve2D targetCurve = target.getElement().getCurve2D();
            int numSeg = targetCurve.getNumOfSegments();
            targetEndPTs[0] = targetCurve.getP(0.0);
            targetEndPTs[1] = targetCurve.getP(numSeg);
            int size = 0;
            if (guideContainers != null) {
                size = guideContainers.length;
            }
            for (int j = 0; j < size; ++j) {
                double distE1;
                double distE0;
                if (guideContainers[j].getContainerType() == ShapeContainer.GROUP || guideContainers[j].compare(targetContainers) || !ShapeElementUtil.boxIntersectionCheck(guideContainers[j].getBoundingBox(), target.getBoundingBox())) continue;
                Curve2D guideCurve = guideContainers[j].getElement().getCurve2D();
                CurvePT guideCurvePT0 = Curve2DUtil.getShortestLine(targetEndPTs[0], guideCurve);
                CurvePT guideCurvePT1 = Curve2DUtil.getShortestLine(targetEndPTs[1], guideCurve);
                double dist0 = Vector2D.dist(targetEndPTs[0], guideCurvePT0.getP());
                double dist1 = Vector2D.dist(targetEndPTs[1], guideCurvePT1.getP());
                if (dist0 < 0.01) {
                    distE0 = guideCurvePT0.getDistanceToCurveEndPT(0);
                    distE1 = guideCurvePT0.getDistanceToCurveEndPT(1);
                    if (distE0 > 0.01 && distE1 > 0.01) {
                        Connection connection = new Connection(target, guideContainers[j], 0.0, guideCurvePT0.getParameter());
                        ConnectionContainer connectionContainer = new ConnectionContainer("guide_line", depth, connection);
                        this.ConnectionList.add(connectionContainer);
                    }
                }
                if (!(dist1 < 0.01)) continue;
                distE0 = guideCurvePT1.getDistanceToCurveEndPT(0);
                distE1 = guideCurvePT1.getDistanceToCurveEndPT(1);
                if (!(distE0 > 0.01) || !(distE1 > 0.01)) continue;
                int numOfSeg = target.getElement().getCurve2D().getNumOfSegments();
                Connection connection = new Connection(target, guideContainers[j], numOfSeg, guideCurvePT1.getParameter());
                ConnectionContainer connectionContainer = new ConnectionContainer("guide_line", depth, connection);
                this.ConnectionList.add(connectionContainer);
            }
        }
    }

    private void printTargerList(String message) {
        System.out.println("* TargetList  size=" + this.TargetList.size() + ", message=" + message);
        for (int i = 0; i < this.TargetList.size(); ++i) {
            TargetContainer target = (TargetContainer)this.TargetList.get(i);
            System.out.println(" -- target=" + target.getContainer().getShapeId() + ", depth=" + target.getDepth());
        }
    }

    private void printConnectionList(String message) {
        System.out.println("* ConnectiontList  size=" + this.ConnectionList.size() + ", message=" + message);
        for (int i = 0; i < this.ConnectionList.size(); ++i) {
            ConnectionContainer connectionContainer = (ConnectionContainer)this.ConnectionList.get(i);
            String infoStr = "not set";
            if (connectionContainer != null) {
                infoStr = "id=" + connectionContainer.getId() + ", depth=" + connectionContainer.getDepth();
            }
            System.out.println(" -- connection[" + i + "]: info: " + infoStr + ",  " + connectionContainer.getConnection().toString());
        }
    }

    private ShapeContainer[] getTargets(int depth) {
        Vector<ShapeContainer> vector = new Vector<ShapeContainer>();
        int size = this.TargetList.size();
        for (int i = 0; i < size; ++i) {
            TargetContainer TargetContainer2 = (TargetContainer)this.TargetList.get(i);
            if (TargetContainer2.getDepth() != depth) continue;
            vector.add(TargetContainer2.getContainer());
        }
        ShapeContainer[] targets = new ShapeContainer[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            targets[i] = (ShapeContainer)vector.get(i);
        }
        return targets;
    }

    private int getTargetIndex(ShapeContainer target, int depth) {
        int index = -1;
        String targetId = target.getShapeId();
        for (int i = 0; i < this.TargetList.size(); ++i) {
            TargetContainer TargetContainer2 = (TargetContainer)this.TargetList.get(i);
            int dep = TargetContainer2.getDepth();
            if (depth >= 0 && dep != depth || !TargetContainer2.getContainer().getShapeId().equals(targetId)) continue;
            index = i;
            break;
        }
        return index;
    }

    private ConnectionContainer[] getConnectionContainers(String id, int depth, ShapeContainer target, ShapeContainer connector) {
        this.vector.clear();
        for (int i = 0; i < this.ConnectionList.size(); ++i) {
            ConnectionContainer connectionContainer = (ConnectionContainer)this.ConnectionList.get(i);
            Connection connection = connectionContainer.getConnection();
            if (!connectionContainer.getId().equals(id) || depth >= 0 && depth != connectionContainer.getDepth()) continue;
            if (target != null && connector != null && target.compare(connection.getTarget()) && connector.compare(connection.getConnector())) {
                this.vector.add(connectionContainer);
            }
            if (target != null && connector == null && target.compare(connection.getTarget())) {
                this.vector.add(connectionContainer);
            }
            if (target != null || connector == null || !connector.compare(connection.getConnector())) continue;
            this.vector.add(connectionContainer);
        }
        ConnectionContainer[] connectionContainers = new ConnectionContainer[this.vector.size()];
        for (int i = 0; i < this.vector.size(); ++i) {
            connectionContainers[i] = (ConnectionContainer)this.vector.get(i);
        }
        return connectionContainers;
    }

    private ConnectionContainer[] getConnectionContainers(String id, ShapeContainer target, ShapeContainer connector) {
        return this.getConnectionContainers(id, -1, target, connector);
    }

    private int getSameConnectionContainer(ConnectionContainer connectionContainer) {
        String id = connectionContainer.getId();
        Connection connection = connectionContainer.getConnection();
        int index = -1;
        int size = this.ConnectionList.size();
        for (int i = 0; i < size; ++i) {
            ConnectionContainer testCoContainer = (ConnectionContainer)this.ConnectionList.get(i);
            Connection testConnection = testCoContainer.getConnection();
            if (!testCoContainer.getId().equals(id) || !connection.equalsInNormalData(testConnection) && !connection.equalsInReversedData(testConnection)) continue;
            index = i;
            break;
        }
        return index;
    }

    private ShapeContainer[] getConnectors(String id) {
        this.vector.clear();
        int size = this.ConnectionList.size();
        for (int i = 0; i < size; ++i) {
            ShapeContainer connector;
            int index;
            ConnectionContainer connectionContainer = (ConnectionContainer)this.ConnectionList.get(i);
            if (!id.equals(connectionContainer.getId()) || (index = this.vector.indexOf(connector = connectionContainer.getConnection().getConnector())) >= 0) continue;
            this.vector.add(connector);
        }
        size = this.vector.size();
        ShapeContainer[] connectors = new ShapeContainer[size];
        for (int i = 0; i < size; ++i) {
            connectors[i] = (ShapeContainer)this.vector.get(i);
        }
        return connectors;
    }

    public ShapeContainer[] getTargetsAndConnectors() {
        int i;
        int nTargets = this.targets.length;
        ShapeContainer[] connectors = this.getConnectors("connector");
        ShapeContainer[] containers = new ShapeContainer[nTargets + connectors.length];
        for (i = 0; i < nTargets; ++i) {
            containers[i] = this.targets[i];
        }
        for (i = 0; i < connectors.length; ++i) {
            containers[i + nTargets] = connectors[i];
        }
        if (debug > 0) {
            System.out.println("getTargetsAndConnectors");
            for (i = 0; i < containers.length; ++i) {
                System.out.println(" - container=" + containers[i].getShapeId());
            }
        }
        return containers;
    }

    public void resizeConnectors(int option) {
        ShapeContainer[] connectors;
        if (this.ConnectionList.size() == 0) {
            return;
        }
        this.clearMark("Connection.pt");
        for (int depth = 1; depth < 100 && (connectors = this.getTargets(depth)).length != 0; ++depth) {
            this.resizeConnectors(option, depth, connectors);
        }
    }

    private void resizeConnectors(int option, int depth, ShapeContainer[] connectors) {
        if (debug > 0) {
            System.out.println("resizeConnectors  depth=" + depth + ", option=" + option);
        }
        for (int i = 0; i < connectors.length; ++i) {
            ConnectionContainer[] connectionContainers = this.getConnectionContainers("connector", depth - 1, null, connectors[i]);
            int size = 0;
            if (connectionContainers != null) {
                size = connectionContainers.length;
            }
            for (int j = 0; j < size; ++j) {
                Connection connection = connectionContainers[j].getConnection();
                Vector2D unitDir = connectionContainers[j].getInitialConnection().getConnectorTangent();
                unitDir = Vector2D.unitVector(unitDir);
                ShapeContainer connector = connection.getConnector();
                boolean lineDir = connector.getBooleanProperty("Keep_Line_Direction", "ConnectionUtil");
                boolean connected = true;
                if (option == 113 && !lineDir) {
                    this.resizeConnectorByCurveParameter(connection);
                }
                if (option == 114 && !lineDir) {
                    if (this.isXOrYvector(unitDir) > 0) {
                        this.resizeConnectorKeepingDirection(connectionContainers[j]);
                        if (debug > 0) {
                            System.out.println("resizeConnectorKeepingDirection depth=" + depth + ", option=" + option);
                        }
                    } else {
                        this.resizeConnectorByCurveParameter(connection);
                    }
                }
                if (option == 117 || lineDir) {
                    connected = this.resizeConnectorKeepingDirAndPos(connectionContainers[j]);
                    if (debug > 0) {
                        System.out.println("resizeConnectorKeepingDirection depth=" + depth + ", option=" + option);
                    }
                }
                if (option == 116 && !lineDir) {
                    this.resizeConnectorToNearestPT(connection);
                }
                if (!connected) continue;
                this.drawMark("Connection.pt", "", depth - 1, connection);
            }
        }
    }

    public void resizeConnectorByCurveParameter(Connection connection) {
        Curve2D curve = connection.getTarget().getElement().getCurve2D();
        Point2D connectionPT = curve.getP(connection.targetParameter);
        Point2D connectorPT = connection.getConnectorPT();
        connection.resizeConnector(connectorPT, connectionPT);
    }

    public void resizeConnectorToNearestPT(Connection connection) {
        CurvePT[] targetPTs = connection.getTarget().getElement().getCurve2D().getSamplingCurvePTs(5.0);
        Point2D connectorPT = connection.getConnectorPT();
        Vector2D p0 = new Vector2D(connectorPT);
        int index = -1;
        double distMin = 100000.0;
        for (int i = 0; i < targetPTs.length; ++i) {
            double dist = Vector2D.dist(p0, new Vector2D(targetPTs[i].getP()));
            if (!(dist < distMin)) continue;
            distMin = dist;
            index = i;
        }
        if (index < 0) {
            return;
        }
        connection.resizeConnector(connectorPT, targetPTs[index].getP());
        connection.targetParameter = targetPTs[index].getParameter();
    }

    private void resizeConnectorKeepingDirection(ConnectionContainer connectionContainer) {
        Connection initConnection = connectionContainer.getInitialConnection();
        int initType = initConnection.getConnector().getElement().getTypeE();
        Connection connection = connectionContainer.getConnection();
        int currentType = connection.getConnector().getElement().getTypeE();
        Curve2D curve = connection.getConnector().getElement().getCurve2D();
        int numseg = curve.getNumOfSegments();
        double T = connection.getConnectorParameter();
        double oppositeT = (double)numseg - T;
        Point2D oppositeP = curve.getP(oppositeT);
        Vector2D unitDir = connectionContainer.getInitialConnection().getConnectorTangent();
        unitDir = Vector2D.unitVector(unitDir);
        if (T == 0.0) {
            unitDir = Vector2D.multiply(-1.0, unitDir);
        }
        Curve2D targetCurve = connection.getTarget().getElement().getCurve2D();
        CurvePT[] curvePTs = this.projectionPT(oppositeP, unitDir, targetCurve);
        CurvePT curvePT = this.selectCurvePT(connectionContainer, curvePTs);
        int id = 0;
        if (initType == 51 && currentType == 51) {
            id = 0;
        }
        if (initType == 51 && currentType == 54) {
            id = 1;
        }
        if (initType == 54 && currentType == 51) {
            id = 2;
        }
        if (initType == 54 && currentType == 54) {
            id = 3;
        }
        switch (id) {
            case 0: {
                if (curvePT == null) {
                    if (!this.isChangable(connection.getConnector())) break;
                    this.changeToPolylineConnector(connectionContainer);
                    break;
                }
                Point2D connectorPT = connection.getConnectorPT();
                connection.targetParameter = curvePT.getParameter();
                connection.resizeConnector(connectorPT, curvePT.getP());
                break;
            }
            case 1: {
                if (curvePT == null || !this.isChangable(connection.getConnector())) {
                    this.resizeConnectorByCurveParameter(connection);
                    break;
                }
                this.changeToLineConnector(connectionContainer, curvePT);
                break;
            }
            case 2: {
                if (curvePT == null) {
                    if (!this.isChangable(connection.getConnector()) || !this.isChangable(initConnection.getConnector())) break;
                    this.changeToPolylineConnector(connectionContainer);
                    break;
                }
                Point2D connectorPT = connection.getConnectorPT();
                connection.resizeConnector(connectorPT, curvePT.getP());
                connection.targetParameter = curvePT.getParameter();
                break;
            }
            case 3: {
                this.resizeConnectorByCurveParameter(connection);
                if (curvePT == null || !this.isChangable(connection.getConnector()) || !this.isChangable(initConnection.getConnector())) break;
                this.changeToLineConnector(connectionContainer, curvePT);
            }
        }
        if (debug > 0 && connection.getErrorDistance() > 1.0E-10) {
            System.out.println("resizeConnectorKeepingDirection, connection=" + connection.toString());
        }
    }

    private boolean resizeConnectorKeepingDirAndPos(ConnectionContainer connectionContainer) {
        Curve2D targetCurve;
        CurvePT[] curvePTs;
        CurvePT curvePT;
        Connection initConnection = connectionContainer.getInitialConnection();
        int initType = initConnection.getConnector().getElement().getTypeE();
        Connection connection = connectionContainer.getConnection();
        int currentType = connection.getConnector().getElement().getTypeE();
        Curve2D curve = connection.getConnector().getElement().getCurve2D();
        int numseg = curve.getNumOfSegments();
        double T = connection.getConnectorParameter();
        Point2D oppositeP = curve.getP(T);
        Vector2D unitDir = connectionContainer.getInitialConnection().getConnectorTangent();
        unitDir = Vector2D.unitVector(unitDir);
        if (T == 0.0) {
            unitDir = Vector2D.multiply(-1.0, unitDir);
        }
        if ((curvePT = this.selectCurvePT(connectionContainer, curvePTs = this.projectionPT(oppositeP, unitDir, targetCurve = connection.getTarget().getElement().getCurve2D()))) != null) {
            Point2D connectorPT = connection.getConnectorPT();
            connection.targetParameter = curvePT.getParameter();
            connection.resizeConnector(connectorPT, curvePT.getP());
        }
        if (debug > 0 && connection.getErrorDistance() > 1.0E-10) {
            System.out.println("resizeConnectorKeepingDirection, connection=" + connection.toString());
        }
        boolean connected = true;
        if (curvePT == null) {
            connected = false;
        }
        return connected;
    }

    private CurvePT[] projectionPT(Point2D p, Vector2D vec, Curve2D targetCurve) {
        int i;
        CurvePT[] curvePTs;
        double ext = 0.1;
        Curve2D target = targetCurve;
        GeneralCurve2DE extCurve = targetCurve.getExtendedCurve2DE(ext);
        if (extCurve != null) {
            target = extCurve;
            if (debug > 0) {
                System.out.println(" -- projectionPT extendedCurve=" + target.toString());
            }
        }
        if ((curvePTs = Curve2DUtil.getProjectionLines(p, vec, target)) == null || curvePTs.length == 0) {
            if (debug > 0) {
                System.out.println(" -- IntersectionPT not found by projection p=" + Util.Pt(p) + ", vec=" + Util.Pt(vec) + "\n   target=" + target.toString());
            }
            curvePTs = new CurvePT[]{};
            return curvePTs;
        }
        if (extCurve != null) {
            for (i = 0; i < curvePTs.length; ++i) {
                double t = curvePTs[i].getParameter();
                int numseg = targetCurve.getNumOfSegments();
                if ((t -= 1.0) < 0.0) {
                    t = 0.0;
                }
                if (t > (double)numseg) {
                    t = numseg;
                }
                curvePTs[i] = new CurvePT(t, targetCurve.getP(t));
            }
        }
        if (debug > 0) {
            for (i = 0; i < curvePTs.length; ++i) {
                System.out.println(" -- ProjectionLine found by projection curvePT=" + curvePTs[i].toString());
            }
        }
        return curvePTs;
    }

    private CurvePT selectCurvePT(ConnectionContainer connectionContainer, CurvePT[] curvePTs) {
        Connection connection = connectionContainer.getConnection();
        Curve2D connectorCurve = connection.getConnector().getElement().getCurve2D();
        int numseg = connectorCurve.getNumOfSegments();
        double T = connection.getConnectorParameter();
        double t = 1.0;
        if (T != 0.0) {
            t = (double)numseg - 1.0;
        }
        Point2D P = connectorCurve.getP(t);
        Vector2D unitDir = connectionContainer.getInitialConnection().getConnectorTangent();
        unitDir = Vector2D.unitVector(unitDir);
        if (T == 0.0) {
            unitDir = Vector2D.multiply(-1.0, unitDir);
        }
        CurvePT curvePT = null;
        if (curvePTs.length == 1) {
            return curvePTs[0];
        }
        double distMin = 10000.0;
        int index = -1;
        Point2D p = connection.getConnectorPT();
        for (int i = 0; i < curvePTs.length; ++i) {
            double scal = Vector2D.sproduct(unitDir, Vector2D.sub(curvePTs[i].getP(), P));
            Vector2D dirVec = Vector2D.sub(curvePTs[i].getP(), p);
            double dist = Math.abs(Vector2D.sproduct(dirVec, unitDir));
            if (!(dist < distMin)) continue;
            distMin = dist;
            index = i;
        }
        if (index >= 0) {
            curvePT = curvePTs[index];
        }
        return curvePT;
    }

    private boolean isChangable(ShapeContainer connector) {
        if (connector == null) {
            return false;
        }
        boolean changable = true;
        double eps = 0.01;
        int type = connector.getElement().getTypeE();
        Curve2D curve = connector.getElement().getCurve2D();
        if (type == 51) {
            Vector2D tangent = curve.getTangent(0.0);
            if ((tangent = Vector2D.unitVector(tangent)).getX() > eps && tangent.getY() > eps) {
                changable = false;
            }
        }
        if (type == 54) {
            int numseg = curve.getNumOfSegments();
            if (numseg != 3) {
                changable = false;
            }
            for (int i = 0; i < numseg; ++i) {
                Vector2D tangent = curve.getTangent(i);
                if (!((tangent = Vector2D.unitVector(tangent)).getX() > eps) || !(tangent.getY() > eps)) continue;
                changable = false;
            }
            String original_type = Command.getCommandString(250);
            String originalType = (String)connector.getProperty(original_type);
            if (originalType == null) {
                System.err.println("isChangable key=originalType value=null");
            } else if (originalType.equals("Polyline")) {
                changable = false;
            }
        }
        return changable;
    }

    private void changeToPolylineConnector(ConnectionContainer connectionContainer) {
        Connection connectionX;
        int i;
        Connection connection = connectionContainer.getConnection();
        Connection initConnection = connectionContainer.getInitialConnection();
        Vector2D unitDir = connectionContainer.getInitialConnection().getConnectorTangent();
        unitDir = Vector2D.unitVector(unitDir);
        ShapeContainer connector = connection.getConnector();
        Point2D[] endPTs = connector.getElement().getEndPTs();
        connection.targetParameter = initConnection.targetParameter;
        Point2D targetPT = connection.getTargetPT();
        if (connection.getConnectorParameter() == 0.0) {
            endPTs[0] = targetPT;
        } else {
            endPTs[1] = targetPT;
        }
        if (connection.getConnectorParameter() > 0.0) {
            connection.connectorParameter = 3.0;
        }
        ConnectionContainer[] containers = this.getConnectionContainers("connector", null, connection.connector);
        for (i = 0; i < containers.length; ++i) {
            connectionX = containers[i].getConnection();
            if (!(connectionX.getConnectorParameter() > 0.0)) continue;
            connectionX.connectorParameter = 3.0;
        }
        containers = this.getConnectionContainers("connector", connection.connector, null);
        for (i = 0; i < containers.length; ++i) {
            connectionX = containers[i].getConnection();
            connectionX.targetParameter = connectionX.getTargetParameter() * 3.0;
        }
        Vector2D p0 = new Vector2D(endPTs[0]);
        Vector2D p3 = new Vector2D(endPTs[1]);
        Vector2D vec = Vector2D.sub(endPTs[1], endPTs[0]);
        double len = Vector2D.sproduct(unitDir, vec);
        Vector2D vech = Vector2D.multiply(0.5 * len, unitDir);
        Vector2D p1 = Vector2D.add(p0, vech);
        Vector2D p2 = Vector2D.sub(p3, vech);
        Point2D[] nodePTs = new Point2D[]{new Point2D.Double(p0.getX(), p0.getY()), new Point2D.Double(p1.getX(), p1.getY()), new Point2D.Double(p2.getX(), p2.getY()), new Point2D.Double(p3.getX(), p3.getY())};
        PolylineElement newElement = new PolylineElement();
        connector.setElement(newElement);
        newElement.setShapeContainer(connector);
        ((ShapeElement)newElement).create(nodePTs);
        if (debug > 0) {
            System.out.println("changeToPolylineConnector  unitDir=" + Util.Pt(unitDir) + ", newEndPTs[0]=" + Util.Pt(endPTs[0]) + ", newEndPTs[1]=" + Util.Pt(endPTs[1]) + "\n  connection=" + connection.toString() + "\n  initConnection=" + initConnection.toString());
        }
    }

    private void changeToLineConnector(ConnectionContainer connectionContainer, CurvePT curvePT) {
        Connection connectionX;
        int i;
        Connection initConnection = connectionContainer.getInitialConnection();
        Connection connection = connectionContainer.getConnection();
        Vector2D unitDir = connectionContainer.getInitialConnection().getConnectorTangent();
        unitDir = Vector2D.unitVector(unitDir);
        ShapeContainer connector = connection.getConnector();
        ShapeElement element = connector.getElement();
        Point2D[] endPTs = element.getEndPTs();
        if (connection.getConnectorParameter() == 0.0) {
            endPTs[0] = curvePT.getP();
        } else {
            endPTs[1] = curvePT.getP();
        }
        LineElement newElement = new LineElement();
        connector.setElement(newElement);
        newElement.setShapeContainer(connector);
        ((ShapeElement)newElement).create(endPTs[0], endPTs[1]);
        if (connection.getConnectorParameter() > 0.0) {
            connection.connectorParameter = 1.0;
        }
        connection.targetParameter = curvePT.getParameter();
        ConnectionContainer[] containers = this.getConnectionContainers("connector", null, connection.connector);
        for (i = 0; i < containers.length; ++i) {
            connectionX = containers[i].getConnection();
            if (!(connectionX.getConnectorParameter() > 0.0)) continue;
            connectionX.connectorParameter = 1.0;
        }
        containers = this.getConnectionContainers("connector", connection.connector, null);
        for (i = 0; i < containers.length; ++i) {
            connectionX = containers[i].getConnection();
            connectionX.targetParameter = connectionX.getTargetParameter() / 3.0;
        }
        if (debug > 0) {
            System.out.println("changeToLineConnector  unitDir=" + Util.Pt(unitDir) + "\n  connector:" + connector.toShortString() + "\n  connection=" + connection.toString() + "\n  initConnection=" + initConnection.toString());
        }
    }

    public boolean resizeTargetsByGuideLines() {
        this.clearMark("Guide.pt");
        int depth = 0;
        ShapeContainer[] targets = this.getTargets(depth);
        if (targets.length == 0) {
            System.out.println("resizeTargetsByGuideLines targets null");
        }
        boolean guided = false;
        for (int i = 0; i < targets.length; ++i) {
            if (!targets[i].isConnector()) continue;
            ConnectionContainer[] connectionContainers = this.getConnectionContainers("guide_line", 0, targets[i], null);
            for (int j = 0; j < connectionContainers.length; ++j) {
                Connection connection = connectionContainers[j].getConnection();
                boolean resized = this.resizeTargetKeepingDirection(connectionContainers[j]);
                if (resized) {
                    this.drawMark("Guide.pt", "", 0, connection);
                    guided = true;
                }
                if (debug <= 0) continue;
                System.out.println("resizeTargetsByGuideLines target[" + i + "]=" + targets[i].getShapeId() + ", connection[" + j + "]=" + connection.toString());
            }
        }
        return guided;
    }

    private boolean resizeTargetKeepingDirection(ConnectionContainer connectionContainer) {
        Connection connection = connectionContainer.getConnection();
        Vector2D unitDir = connectionContainer.getInitialConnection().getTargetTangent();
        unitDir = Vector2D.unitVector(unitDir);
        Curve2D cCurve = connection.getConnector().getElement().getCurve2D();
        CurvePT[] curvePTs = this.projectionPT(connection.getTargetPT(), unitDir, cCurve);
        CurvePT curvePT = this.selectCurvePT(connection.getTargetPT(), unitDir, curvePTs);
        if (curvePT == null) {
            return false;
        }
        connection.resizeTarget(connection.getTargetPT(), curvePT.getP());
        connection.connectorParameter = curvePT.getParameter();
        return true;
    }

    private CurvePT selectCurvePT(Point2D p, Vector2D vec, CurvePT[] curvePTs) {
        CurvePT curvePT = null;
        if (curvePTs.length == 1) {
            return curvePTs[0];
        }
        double distMin = 10000.0;
        int index = -1;
        for (int i = 0; i < curvePTs.length; ++i) {
            Vector2D dirVec = Vector2D.sub(curvePTs[i].getP(), p);
            double dist = Math.abs(Vector2D.sproduct(dirVec, vec));
            if (!(dist < distMin)) continue;
            distMin = dist;
            index = i;
        }
        if (index >= 0) {
            curvePT = curvePTs[index];
        }
        return curvePT;
    }

    private int isXOrYvector(Vector2D vec) {
        int dir = 0;
        if (Math.abs(vec.getY()) < 0.001) {
            dir = 1;
        }
        if (Math.abs(vec.getX()) < 0.001) {
            dir = 2;
        }
        return dir;
    }

    private void drawMark(String id, String message, int depth, Connection connection) {
        Color[] colors = new Color[]{Color.RED, Color.MAGENTA, Color.ORANGE, Color.GREEN, Color.BLUE};
        Point2D point = connection.getTargetPT();
        depth -= depth / colors.length * depth;
        DrawShapeUtil.drawTempShape(id, point, 4, message, colors[depth]);
        if (debug > 0) {
            System.out.println(" - drawMark depth=" + depth);
        }
    }

    private void drawMarks(String id, String message) {
        if (debug > 0) {
            System.out.println("drawMarks id=" + id + ", message=" + message);
        }
        for (int i = 0; i < this.ConnectionList.size(); ++i) {
            ConnectionContainer connectionContainer = (ConnectionContainer)this.ConnectionList.get(i);
            int depth = connectionContainer.getDepth();
            this.drawMark(id, message, depth, connectionContainer.getConnection());
        }
    }

    private void clearMark(String id) {
        DrawPanel drawPanel = ObjectTable.getDrawPanel("");
        DrawShapeUtil.clearTempShape(id);
        drawPanel.repaint("ConnectionUtil.clearMark");
    }

    public static void moveResize(ShapeContainer container, Rectangle2D oldBox, Rectangle2D newBox, boolean keepConnection, boolean undoSetting) {
        ShapeContainer[] targetContainers = new ShapeContainer[]{container};
        ConnectionUtil connectionUtil = new ConnectionUtil();
        connectionUtil.setTargets(targetContainers);
        ShapeContainer[] containers = connectionUtil.getTargetsAndConnectors();
        for (int i = 0; i < containers.length; ++i) {
            containers[i].setChangeCode(i);
        }
        ContainerManager containerManager = ObjectTable.getContainerManager("");
        boolean result = ConnectionUtil.resizeCheck(container, oldBox, newBox);
        if (undoSetting) {
            containerManager.undoSetupStart(containers);
        }
        container.getElement().moveResize(oldBox, newBox, true);
        int connectorResizeOption = DrawParameters.AUTO_TRACKING_OPTION;
        if (keepConnection) {
            connectionUtil.resizeConnectors(connectorResizeOption);
        }
        connectionUtil.end();
        if (undoSetting) {
            containerManager.undoSetupEnd();
        }
    }

    private static boolean resizeCheck(ShapeContainer container, Rectangle2D oldBox, Rectangle2D newBox) {
        boolean result = true;
        int type = container.getElement().getTypeE();
        boolean resizable = container.getBooleanProperty("Enable_Resizing", "ConnectionUtil");
        boolean aspectRatio = container.getBooleanProperty("Keep_Aspect_Ratio", "ConnectionUtil");
        boolean lineDir = container.getBooleanProperty("Keep_Line_Direction", "ConnectionUtil");
        double oldRatio = oldBox.getHeight() / oldBox.getWidth();
        double newRatio = newBox.getHeight() / newBox.getWidth();
        if (aspectRatio && Math.abs(oldRatio - newRatio) > 1.0E-4) {
            System.err.println("Warning check for ConnectionUtil.resizeContainer: illegal aspect ratio  old(h/w)=" + oldRatio + ", new(h/w)=" + newRatio + ", shapeId=" + container.getShapeId());
            result = false;
        }
        if (lineDir && Math.abs(oldRatio - newRatio) > 1.0E-4) {
            System.err.println("Warning check for ConnectionUtil.resizeContainer: illegal line direction  old(h/w)=" + oldRatio + ", new(h/w)=" + newRatio + ", shapeId=" + container.getShapeId());
            result = false;
        }
        return result;
    }

    public static void moveEndPoint(ShapeContainer container, int movePtIndex, Point2D oldPoint, Point2D newPoint, boolean keepConnection, boolean undoSetting) {
        ShapeContainer[] targetContainers = new ShapeContainer[]{container};
        ConnectionUtil connectionUtil = new ConnectionUtil();
        connectionUtil.setTargets(targetContainers);
        ShapeContainer[] containers = connectionUtil.getTargetsAndConnectors();
        for (int i = 0; i < containers.length; ++i) {
            containers[i].setChangeCode(i);
        }
        ContainerManager containerManager = ObjectTable.getContainerManager("");
        if (undoSetting) {
            containerManager.undoSetupStart(containers);
        }
        container.getElement().moveEndPoint(0, movePtIndex, oldPoint, newPoint);
        int connectorResizeOption = DrawParameters.AUTO_TRACKING_OPTION;
        if (keepConnection) {
            connectionUtil.resizeConnectors(connectorResizeOption);
        }
        connectionUtil.end();
        if (undoSetting) {
            containerManager.undoSetupEnd();
        }
    }
}

