/*
 * Decompiled with CFR 0.152.
 */
package shapeUtil;

import DrawTop.DrawPanel;
import DrawTop.ObjectTable;
import DrawTop.SelectionLS;
import geomExtension.CrossCurvePT;
import geomExtension.Curve2D;
import geomExtension.Curve2DUtil;
import geomExtension.GeneralCurve2DE;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import shape.CubicCurveElement;
import shape.DrawShapeUtil;
import shape.GeneralCurveElement;
import shape.LineElement;
import shape.PaintStyle;
import shape.PolylineElement;
import shape.ShapeContainer;
import shape.ShapeElement;
import shapeUtil.CutShape;
import shapeUtil.MouseHitShape;
import shapeUtil.TrimmedCurve;
import util.ContainerManager;
import util.Util;

class CutShapeAction
extends AbstractAction
implements WindowListener {
    CutShape dialog = null;
    Vector vector = new Vector();
    int debug = 0;

    public CutShapeAction(CutShape dialog) {
        this.dialog = dialog;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int debug = 0;
        String commandName = e.getActionCommand();
        String componentClassName = "";
        componentClassName = e.getSource().getClass().getSimpleName();
        String componentName = ((Component)e.getSource()).getName();
        if (debug > 0) {
            System.out.println("- CutShapeAction.actionPerformed  commandName=" + commandName + ", source component name=" + componentName + ", source class simple name=" + componentClassName);
        }
        if (commandName.equals("Go")) {
            this.cutShapes();
            this.endProcess();
            ObjectTable.getDrawPanel().repaint("cut shape");
            return;
        }
        if (commandName.equals("Repeat")) {
            this.dialog.showMessage("  Click target shape !", Color.BLUE);
            this.repeatProcess();
            return;
        }
        if (commandName.equals("Cancel")) {
            this.closeDialog();
            return;
        }
    }

    private void cutShapes() {
        int i;
        MouseHitShape[] clickedShapes = this.dialog.getClickedShapes();
        for (int i2 = 0; i2 < clickedShapes.length; ++i2) {
            clickedShapes[i2].getShapeContainer().setSelected(false);
        }
        ShapeContainer shapeContainer1 = clickedShapes[0].getShapeContainer();
        ShapeContainer shapeContainer2 = clickedShapes[1].getShapeContainer();
        if (this.debug > 0) {
            System.out.println("** Cut shape: " + shapeContainer1.toShortString());
            System.out.println("** Cutting shape: " + shapeContainer2.toShortString());
        }
        Curve2D[] curve1 = new Curve2D[1];
        Curve2D[] curve2 = new Curve2D[1];
        curve1 = this.getPathCurves(shapeContainer1.getElement().getCurve2D());
        curve2 = this.getPathCurves(shapeContainer2.getElement().getCurve2D());
        CrossCurvePT[] crossPTs = this.getIntersections(curve1, curve2);
        ContainerManager containerManager = ObjectTable.getContainerManager("");
        containerManager.undoSetupStart();
        TrimmedCurve[] trimmedCurves = this.cutTargetCurves(crossPTs, curve1);
        ShapeContainer[] containers = this.createContainers(shapeContainer1, trimmedCurves);
        for (i = 0; i < containers.length; ++i) {
            containerManager.addContainer(containers[i]);
            containers[i].setSelected(true);
            containers[i].setConnectorPermission(false);
        }
        containerManager.deleteContainer(shapeContainer1);
        if (this.dialog.yesButton.isSelected()) {
            crossPTs = this.getExchangedData(crossPTs);
            trimmedCurves = this.cutTargetCurves(crossPTs, curve2);
            containers = this.createContainers(shapeContainer2, trimmedCurves);
            for (i = 0; i < containers.length; ++i) {
                containerManager.addContainer(containers[i]);
                containers[i].setSelected(true);
                containers[i].setConnectorPermission(false);
            }
            containerManager.deleteContainer(shapeContainer2);
        }
        containerManager.undoSetupEnd();
    }

    private CrossCurvePT[] getIntersections(Curve2D[] curve1, Curve2D[] curve2) {
        int i;
        this.vector.clear();
        for (int i2 = 0; i2 < curve1.length; ++i2) {
            for (int j = 0; j < curve2.length; ++j) {
                CrossCurvePT[] crossPTs = Curve2DUtil.getIntersectionPts(curve1[i2], curve2[j]);
                for (int k = 0; k < crossPTs.length; ++k) {
                    this.vector.add(crossPTs[k]);
                }
            }
        }
        int length = this.vector.size();
        CrossCurvePT[] crossPTs = new CrossCurvePT[length];
        for (i = 0; i < length; ++i) {
            crossPTs[i] = (CrossCurvePT)this.vector.get(i);
        }
        for (i = 0; i < length; ++i) {
            DrawShapeUtil.drawTempShape("CutShape", crossPTs[i].getP1(), 4, "", Color.BLUE);
        }
        return crossPTs;
    }

    private Curve2D[] getPathCurves(Curve2D curve) {
        Curve2D[] curves = new Curve2D[]{};
        if (curve.getType2DE() == 56) {
            GeneralCurve2DE gcurve = (GeneralCurve2DE)curve;
            curves = gcurve.getSubPaths();
        } else {
            curves = new Curve2D[]{curve};
        }
        return curves;
    }

    private CrossCurvePT[] getExchangedData(CrossCurvePT[] crossPTs) {
        int size = 0;
        if (crossPTs != null) {
            size = crossPTs.length;
        }
        CrossCurvePT[] newCrossPTs = new CrossCurvePT[size];
        for (int i = 0; i < size; ++i) {
            CrossCurvePT newCrossPT;
            newCrossPTs[i] = newCrossPT = crossPTs[i].getReversedOrderData();
        }
        return newCrossPTs;
    }

    private TrimmedCurve[] cutTargetCurves(CrossCurvePT[] crossPTs, Curve2D[] targetCurves) {
        int size = 0;
        if (crossPTs != null) {
            size = crossPTs.length;
        }
        double[] crossT = new double[size];
        for (int i = 0; i < size; ++i) {
            crossT[i] = crossPTs[i].getParameterT1();
        }
        Vector<TrimmedCurve> curveVector = new Vector<TrimmedCurve>();
        for (int i = 0; i < targetCurves.length; ++i) {
            double[] cutParams = this.getCutParams(targetCurves[i], crossPTs);
            Curve2D[] trimmedCurves = new Curve2D[cutParams.length - 1];
            for (int j = 0; j < cutParams.length - 1; ++j) {
                double t1 = cutParams[j];
                double t2 = cutParams[j + 1];
                trimmedCurves[j] = Curve2DUtil.trimCurve2D(targetCurves[i], t1, t2);
                if (trimmedCurves[j] == null) continue;
                TrimmedCurve trimmedCurve = new TrimmedCurve(targetCurves[i], t1, t2, trimmedCurves[j]);
                curveVector.add(trimmedCurve);
            }
            if (this.debug <= 0) continue;
            this.printTrimCurveInfo(targetCurves[i], trimmedCurves, crossPTs, cutParams);
        }
        TrimmedCurve[] trimmedCurves = new TrimmedCurve[curveVector.size()];
        for (int i = 0; i < curveVector.size(); ++i) {
            trimmedCurves[i] = (TrimmedCurve)curveVector.get(i);
        }
        return trimmedCurves;
    }

    private void printTrimCurveInfo(Curve2D targetCurve, Curve2D[] trimmedCurves, CrossCurvePT[] selectedCrossPTs, double[] cutParams) {
        int i;
        String str = "*** Print TrimCurveInfo";
        str = str + "* targetCurve: " + targetCurve.toString() + "\n";
        str = str + "-- selectedCrossPTs";
        for (i = 0; i < selectedCrossPTs.length; ++i) {
            str = str + "\n  No=" + i + " " + selectedCrossPTs[i].toString();
        }
        str = str + "\n-- cutParams\n  ";
        for (i = 0; i < cutParams.length; ++i) {
            if (i > 0) {
                str = str + ", ";
            }
            str = str + "cutParams[" + i + "]=" + Util.Num(cutParams[i]);
        }
        str = str + "\n-- trimmedCurves\n";
        for (i = 0; i < trimmedCurves.length; ++i) {
            str = trimmedCurves[i] == null ? str + "  No=" + i + " NULL" : str + "  No=" + i + " " + trimmedCurves[i].toString() + "\n";
        }
        System.out.println(str);
    }

    private ShapeContainer[] createContainers(ShapeContainer targetContainer, TrimmedCurve[] trimmedCurves) {
        int i;
        ShapeContainer[] trimmedContainers = new ShapeContainer[trimmedCurves.length];
        ContainerManager manager = ObjectTable.getContainerManager();
        for (i = 0; i < trimmedCurves.length; ++i) {
            ShapeElement trimmedElement = null;
            trimmedContainers[i] = new ShapeContainer();
            Curve2D trimmedCurve = trimmedCurves[i].getTrimmedCurve();
            if (trimmedCurve == null) continue;
            if (trimmedCurve.getType2DE() == 51) {
                trimmedElement = new LineElement();
            }
            if (trimmedCurve.getType2DE() == 54) {
                trimmedElement = new PolylineElement();
            }
            if (trimmedCurve.getType2DE() == 55) {
                trimmedElement = new CubicCurveElement();
            }
            if (trimmedCurve.getType2DE() == 56) {
                trimmedElement = new GeneralCurveElement();
            }
            trimmedElement.setCurve2D(trimmedCurve);
            trimmedContainers[i].setElement(trimmedElement);
            PaintStyle paintStyle = targetContainer.getPaintStyle();
            trimmedContainers[i].setPaintStyle((PaintStyle)paintStyle.clone());
            trimmedContainers[i].setNewShapeId(manager, false);
        }
        if (this.debug > 0) {
            System.out.println("** createContainers");
            for (i = 0; i < trimmedContainers.length; ++i) {
                System.out.println(" -- TrimmedShape i=" + i + ", " + trimmedContainers[i].toShortString());
            }
        }
        return trimmedContainers;
    }

    private double[] getCutParams(Curve2D targetCurve, CrossCurvePT[] crossPTs) {
        this.vector.clear();
        for (int i = 0; i < crossPTs.length; ++i) {
            if (!crossPTs[i].getCurve1().equals(targetCurve)) continue;
            this.vector.add(crossPTs[i]);
        }
        int size = this.vector.size();
        CrossCurvePT[] selectedCrossPTs = new CrossCurvePT[size];
        double[] selectedCrossParams = new double[size];
        for (int i = 0; i < size; ++i) {
            selectedCrossPTs[i] = (CrossCurvePT)this.vector.get(i);
            selectedCrossParams[i] = selectedCrossPTs[i].getParameterT1();
        }
        double[] sortedCrossParms = new double[size];
        for (int i = 0; i < size; ++i) {
            sortedCrossParms[i] = selectedCrossParams[i];
        }
        if (size > 1) {
            Util.simpleSort(sortedCrossParms);
        }
        boolean closed = targetCurve.isClosed();
        double[] cutParms = null;
        if (closed) {
            if (sortedCrossParms.length >= 2) {
                cutParms = new double[sortedCrossParms.length + 1];
                for (int i = 0; i < sortedCrossParms.length; ++i) {
                    cutParms[i] = sortedCrossParms[i];
                }
                cutParms[sortedCrossParms.length] = sortedCrossParms[0];
            } else {
                cutParms = new double[]{0.0, targetCurve.getNumOfSegments()};
            }
        } else {
            cutParms = new double[sortedCrossParms.length + 2];
            cutParms[0] = 0.0;
            cutParms[sortedCrossParms.length + 1] = targetCurve.getNumOfSegments();
            for (int i = 0; i < sortedCrossParms.length; ++i) {
                cutParms[i + 1] = sortedCrossParms[i];
            }
        }
        return cutParms;
    }

    private void endProcess() {
        ContainerManager manager = ObjectTable.getContainerManager("");
        ShapeContainer[] containers = manager.getSelectedContainers();
        int size = 0;
        if (containers != null) {
            size = containers.length;
        }
        for (int i = 0; i < size; ++i) {
            containers[i].setSelected(false);
        }
        this.dialog.showMessage("  Done.", Color.BLUE);
        this.dialog.goButton.setEnabled(false);
        this.dialog.repeatButton.setEnabled(true);
        SelectionLS selectionLS = ObjectTable.getSelectionLS("");
        selectionLS.removeSelectionListener(this.dialog);
        DrawPanel drawPanel = ObjectTable.getDrawPanel("");
        drawPanel.repaint();
    }

    private void repeatProcess() {
        DrawShapeUtil.clearTempShape("CutShape");
        ContainerManager manager = ObjectTable.getContainerManager("CutShape");
        ShapeContainer[] containers = manager.getSelectedContainers();
        int size = 0;
        if (containers != null) {
            size = containers.length;
        }
        for (int i = 0; i < size; ++i) {
            containers[i].setSelected(false);
        }
        this.dialog.shapeVector.clear();
        this.dialog.goButton.setEnabled(false);
        this.dialog.repeatButton.setEnabled(false);
        this.dialog.setSelectPanelEnable(false);
        this.dialog.shapeVector.clear();
        SelectionLS selectionLS = ObjectTable.getSelectionLS("");
        selectionLS.addSelectionListener(this.dialog);
        DrawPanel drawPanel = ObjectTable.getDrawPanel("");
        drawPanel.repaint();
    }

    private void closeDialog() {
        this.dialog.setVisible(false);
        DrawPanel drawPanel = ObjectTable.getDrawPanel("");
        DrawShapeUtil.clearAllTempShapes();
        drawPanel.repaint();
        this.dialog.setVisible(false);
        SelectionLS selectionLS = ObjectTable.getSelectionLS("");
        selectionLS.removeSelectionListener(this.dialog);
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (this.debug > 0) {
            System.out.println("CutShapeAction windowClosing");
        }
        this.closeDialog();
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }
}

