/*
 * Decompiled with CFR 0.152.
 */
package shapeUtil;

import DrawTop.DrawPanel;
import DrawTop.ObjectTable;
import geomExtension.Curve2D;
import geomExtension.GeneralCurve2DE;
import geomExtension.Matrix2D;
import geomExtension.Segment2D;
import geomExtension.Vector2D;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.Point2D;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import javax.swing.SpinnerNumberModel;
import shape.CubicCurveElement;
import shape.DrawShapeUtil;
import shape.GeneralCurveElement;
import shape.GroupElement;
import shape.LineElement;
import shape.PolylineElement;
import shape.ShapeContainer;
import shape.ShapeElement;
import shapeUtil.Rotate;
import util.ContainerManager;

class RotateAction
extends AbstractAction
implements WindowListener {
    Rotate dialog;
    int cutShapeContainerIndex = -1;
    ShapeContainer[] trimmedShapeContainers = null;
    int debug = 0;

    public RotateAction(Rotate dialog) {
        this.dialog = dialog;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String commandName = e.getActionCommand();
        String componentClassName = "";
        componentClassName = e.getSource().getClass().getSimpleName();
        String componentName = ((Component)e.getSource()).getName();
        if (this.debug > 0) {
            System.out.println("- RotateAction.actionPerformed  commandName=" + commandName + ", source component name=" + componentName + ", source class simple name=" + componentClassName);
        }
        if (commandName.equals("click")) {
            JCheckBox checkBox = this.dialog.checkBox;
            if (checkBox.isSelected()) {
                this.dialog.addConnectionListener();
            } else {
                this.dialog.removeConnectionListener();
                ObjectTable.getSelectionLS().start();
            }
        }
        if (commandName.equals("pixel") || commandName.equals("mm")) {
            this.dialog.setValuesToPositionSpinners();
        }
        if (commandName.equals("Go")) {
            int i;
            JRadioButton copyButton = this.dialog.getCopyButton();
            boolean copy = copyButton.isSelected();
            Vector shapesVector = this.dialog.getShapesVector();
            int size = shapesVector.size();
            if (size == 0) {
                return;
            }
            ShapeContainer[] containers = new ShapeContainer[size];
            for (int i2 = 0; i2 < size; ++i2) {
                containers[i2] = (ShapeContainer)shapesVector.get(i2);
            }
            ShapeContainer[] newContainers = new ShapeContainer[size];
            ContainerManager containerManager = ObjectTable.getContainerManager("");
            Matrix2D rotationMatrix = this.getRotationMatrix();
            if (rotationMatrix == null) {
                this.dialog.showMessage("** Error: specify non-zero angle!!", Color.RED);
                return;
            }
            containerManager.undoSetupStart(containers);
            for (i = 0; i < size; ++i) {
                newContainers[i] = this.rotateContainer(containers[i], rotationMatrix, copy);
                containers[i].setSelected(false);
                if (copy) {
                    newContainers[i].setSelected(true);
                    newContainers[i].setNewShapeId(containerManager, true);
                    containerManager.addContainer(newContainers[i]);
                    continue;
                }
                newContainers[i].setChangeCode(3);
            }
            containerManager.undoSetupEnd();
            shapesVector.clear();
            for (i = 0; i < newContainers.length; ++i) {
                shapesVector.add(newContainers[i]);
            }
            ObjectTable.getDrawPanel().repaint("rotate");
        }
        if (commandName.equals("Cancel")) {
            this.closeDialog();
        }
    }

    private ShapeContainer rotateContainer(ShapeContainer container, Matrix2D rotationMatrix, boolean copy) {
        if (rotationMatrix == null) {
            return null;
        }
        ShapeContainer[] children = null;
        ShapeContainer newContainer = container;
        if (copy) {
            newContainer = (ShapeContainer)container.clone();
        }
        if (newContainer.getContainerType() == ShapeContainer.SHAPE) {
            newContainer.deleteTextBox();
            this.rotate(rotationMatrix, newContainer);
        } else {
            GroupElement groupElement = (GroupElement)newContainer.getElement();
            children = groupElement.getGroupedSingleShapeContainers();
            for (int j = 0; j < children.length; ++j) {
                children[j].deleteTextBox();
                this.rotate(rotationMatrix, children[j]);
            }
        }
        return newContainer;
    }

    private void rotate(Matrix2D rotationMatrix, ShapeContainer container) {
        ShapeElement element = container.getElement();
        Curve2D curve2D = element.getCurve2D();
        GeneralCurve2DE generalcurve = curve2D.convertToGeneralCurve2DE();
        if (this.debug > 0) {
            System.out.println(" Before Rotation generalcurve=" + generalcurve.toString());
        }
        int numseg = generalcurve.getNumOfSegments();
        Segment2D[] segments = new Segment2D[numseg];
        for (int i = 0; i < numseg; ++i) {
            Segment2D segment = (Segment2D)generalcurve.getSegment2D(i).clone();
            segments[i] = segment.transformSegment(rotationMatrix);
        }
        generalcurve.setData(segments);
        if (this.debug > 0) {
            System.out.println(" After Rotation generalcurve=" + generalcurve.toString());
        }
        Curve2D simplerCurve = generalcurve.getSimpleCurve2D();
        ShapeElement newElement = new GeneralCurveElement();
        if (simplerCurve.getType2DE() == 51) {
            newElement = new LineElement();
        }
        if (simplerCurve.getType2DE() == 54) {
            newElement = new PolylineElement();
        }
        if (simplerCurve.getType2DE() == 55) {
            newElement = new CubicCurveElement();
        }
        newElement.setCurve2D(simplerCurve);
        container.setElement(newElement);
        newElement.setShapeContainer(container);
    }

    private Matrix2D getRotationMatrix() {
        SpinnerNumberModel angleSpinnerModel = this.dialog.getAngleSpinnerModel();
        Point2D anchorP = this.dialog.rotationCenterP;
        double angle = angleSpinnerModel.getNumber().doubleValue();
        if (angle == 0.0) {
            return null;
        }
        angle = -angle * Math.PI / 180.0;
        Vector2D r0 = new Vector2D(1.0, 0.0);
        Vector2D r = new Vector2D(Math.cos(angle), Math.sin(angle));
        Matrix2D rotationMatrix = Matrix2D.getRotationMatrix(anchorP, r0, r);
        return rotationMatrix;
    }

    protected void closeDialog() {
        this.dialog.setVisible(false);
        DrawPanel drawPanel = ObjectTable.getDrawPanel("");
        DrawShapeUtil.clearTempShape("Rotate");
        drawPanel.repaint();
        this.dialog.setVisible(false);
        this.dialog.removeConnectionListener();
        ObjectTable.getSelectionLS().start();
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.closeDialog();
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }
}

