/*
 * Decompiled with CFR 0.152.
 */
package shapeUtil;

import DrawTop.ObjectTable;
import java.awt.Color;
import java.awt.geom.Point2D;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import shape.DrawShapeUtil;
import shapeUtil.Rotate;

class RotateSpinnerListener
implements ChangeListener {
    Rotate dialog = null;
    int debug = 0;

    RotateSpinnerListener(Rotate dialog) {
        this.dialog = dialog;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JSpinner spinner = (JSpinner)e.getSource();
        if (spinner == this.dialog.positionSpinners[0] || spinner == this.dialog.positionSpinners[1]) {
            SpinnerNumberModel[] positionSpinnerModels = this.dialog.getPositionSpinnerModels();
            double pixel = 3.7795275590551185;
            double mm = 0.26458333333333334;
            double unit = 1.0;
            if (this.dialog.mmButton.isSelected()) {
                unit = pixel;
            }
            double x = unit * positionSpinnerModels[0].getNumber().doubleValue();
            double y = unit * positionSpinnerModels[1].getNumber().doubleValue();
            this.dialog.rotationCenterP = new Point2D.Double(x, y);
            this.drawMarkAtCenterP();
        }
        if (spinner == this.dialog.angleSpinner) {
            SpinnerNumberModel angleSpinnerModel = this.dialog.getAngleSpinnerModel();
            double angle = angleSpinnerModel.getNumber().doubleValue();
            if (angle == 0.0) {
                this.dialog.showMessage("** Error: specify non-zero angle !!", Color.RED);
            } else {
                this.dialog.showMessage("Angle specified !", Color.BLUE);
            }
        }
    }

    public void drawMarkAtCenterP() {
        DrawShapeUtil.clearTempShape("Rotate");
        ObjectTable.getDrawPanel().repaint();
        DrawShapeUtil.drawTempShape("Rotate", this.dialog.rotationCenterP, 4, "Rotation center", Color.RED);
    }
}

