/*
 * Decompiled with CFR 0.152.
 */
package textBox;

import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import shape.ShapeContainer;
import textBox.AttributedStringUtil;
import util.UndoDrawManager;
import util.UndoableDrawEdit;
import util.Util;

public class TextUndoSetup {

    public static class DeleteText {
        private UndoDrawManager undoDrawManager = null;
        UndoableDrawEdit.DeleteText DeleteText = null;
        int debug = 0;

        public DeleteText(UndoDrawManager undoDrawManager) {
            if (undoDrawManager == null) {
                System.err.println("*** Error  TextUndoSetup.DeleteText undoDrawManager=null");
            }
            this.undoDrawManager = undoDrawManager;
        }

        public void setDeletedText(ShapeContainer shapeContainer, AttributedString delString, int start, int end) {
            if (this.DeleteText == null || this.DeleteText.getContainer() != shapeContainer || this.DeleteText.getPosition() != end) {
                this.initialSet(shapeContainer, delString, start);
            } else {
                AttributedString oldString = this.DeleteText.getAttribString();
                AttributedCharacterIterator newString = AttributedStringUtil.createCompositeText(delString.getIterator(), oldString.getIterator(), delString.getIterator().getEndIndex(), false);
                AttributedString attribStr = AttributedStringUtil.getAttributedString(newString);
                if (this.debug > 0) {
                    System.out.println(" ** UndoSetup.DeleteText.setString strat,end=" + start + "," + end + ", newString=" + Util.Text(attribStr));
                }
                this.DeleteText.setAttribString(attribStr);
                this.DeleteText.setPosition(start);
            }
        }

        private void initialSet(ShapeContainer shapeContainer, AttributedString delString, int start) {
            boolean significant = true;
            UndoableDrawEdit.DeleteText DeleteText2 = new UndoableDrawEdit.DeleteText(shapeContainer.getShapeId(), delString, start);
            this.undoDrawManager.addEdit(DeleteText2);
            UndoableDrawEdit.Delimiter delimiter = new UndoableDrawEdit.Delimiter();
            this.undoDrawManager.addEdit(delimiter);
            this.DeleteText = DeleteText2;
        }
    }

    public static class InsertText {
        private UndoDrawManager undoDrawManager = null;
        UndoableDrawEdit.InsertText InsertText = null;
        int debug = 0;

        public InsertText(UndoDrawManager undoDrawManager) {
            if (undoDrawManager == null) {
                System.err.println("*** Error  TextUndoSetup.InsertText undoDrawManager=null");
            }
            this.undoDrawManager = undoDrawManager;
        }

        public void setInsertedText(ShapeContainer shapeContainer, AttributedString insString, int start, boolean delimit) {
            int endPosition = 0;
            if (this.InsertText != null) {
                endPosition = this.InsertText.getPosition() + this.InsertText.getAttribString().getIterator().getEndIndex();
            }
            if (this.InsertText == null || this.InsertText.getContainer() != shapeContainer || endPosition != start) {
                this.initialSet(shapeContainer, insString, start);
            } else {
                AttributedString oldString = this.InsertText.getAttribString();
                AttributedCharacterIterator newString = AttributedStringUtil.createCompositeText(oldString.getIterator(), insString.getIterator(), oldString.getIterator().getEndIndex(), false);
                AttributedString attribStr = AttributedStringUtil.getAttributedString(newString);
                if (this.debug > 0) {
                    System.out.println(" ** UndoSetup.InsertText.setString strat,=" + start + ", newString=" + Util.Text(attribStr));
                }
                this.InsertText.setAttribString(attribStr);
            }
            if (delimit) {
                this.InsertText = null;
            }
        }

        private void initialSet(ShapeContainer shapeContainer, AttributedString insString, int start) {
            UndoableDrawEdit.InsertText InsertText2 = new UndoableDrawEdit.InsertText(shapeContainer.getShapeId(), insString, start);
            this.undoDrawManager.addEdit(InsertText2);
            UndoableDrawEdit.Delimiter delimiter = new UndoableDrawEdit.Delimiter();
            this.undoDrawManager.addEdit(delimiter);
            this.InsertText = InsertText2;
        }
    }
}

