/*
 * Decompiled with CFR 0.152.
 */
package util;

import DrawTop.DrawMain;
import DrawTop.DrawPanel;
import DrawTop.DrawParameters;
import DrawTop.ObjectTable;
import java.awt.Point;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import util.ContainerManager;
import util.DrawFileIo;
import util.PageData;
import util.UndoDrawManager;
import util.ViewData;
import util.ViewUtil;

public class PageManager {
    DrawMain main = ObjectTable.getDrawMain();
    DrawPanel drawPanel = ObjectTable.getDrawPanel("");
    DrawFileIo drawFileIo = ObjectTable.getDrawFileIo();
    private ArrayList PageList = null;
    private int CurrentPage = 0;
    public String[] versions = new String[]{"ver0.0", "ver1.0"};
    public static int debug = 0;

    public DrawFileIo getDrawFileIo() {
        return this.drawFileIo;
    }

    public void init() {
        this.PageList = new ArrayList();
        this.CurrentPage = 0;
        this.insertNewPage();
        this.initApp();
    }

    public void setPageList(ArrayList pageList) {
        this.PageList = pageList;
    }

    public ArrayList getPageList() {
        return this.PageList;
    }

    public int getCurrentPage() {
        return this.CurrentPage;
    }

    public void setCurrentPage(int page) {
        this.CurrentPage = page;
    }

    public UndoDrawManager getUndoDrawManager(String callFrom) {
        UndoDrawManager undoDrawManager = null;
        if (this.CurrentPage > 0) {
            PageData pageData = (PageData)this.PageList.get(this.CurrentPage - 1);
            undoDrawManager = pageData.getUndoDrawManager();
        }
        if (undoDrawManager == null) {
            System.out.println("*** Error: PageManager.getUndoDrawManager undoDrawManager=null, current page" + this.CurrentPage + ", call from=" + callFrom);
        }
        return undoDrawManager;
    }

    private void initApp() {
        ObjectTable.getContainerManager().deSelectAll();
        DrawPanel drawPanel = ObjectTable.getDrawPanel();
        if (drawPanel != null && ObjectTable.getTempShapeManager("PageManager") != null) {
            ObjectTable.getTempShapeManager("PageManager").clearAllTempShapes();
        }
    }

    public void showTopPage() {
        this.initApp();
        int topPage = 1;
        this.saveCurrentPage();
        this.showPage(topPage);
    }

    public void showLastPage() {
        this.initApp();
        int lastPage = this.PageList.size();
        this.saveCurrentPage();
        this.showPage(lastPage);
    }

    public void showNextPage() {
        this.initApp();
        this.saveCurrentPage();
        int returnCode = this.showPage(this.CurrentPage + 1);
        if (returnCode < 0) {
            JOptionPane.showMessageDialog(this.main, "no next page", "", 0);
            return;
        }
    }

    public void showPreviousPage() {
        this.initApp();
        this.saveCurrentPage();
        int returnCode = this.showPage(this.CurrentPage - 1);
        if (returnCode < 0) {
            JOptionPane.showMessageDialog(this.main, "no previouse page", "", 0);
            return;
        }
    }

    public void insertNewPage() {
        this.initApp();
        if (this.CurrentPage > 0) {
            this.saveCurrentPage();
        }
        boolean before = false;
        if (this.CurrentPage > 0) {
            Object[] possibleValues = new Object[]{"insert after this page", "insert before this page"};
            Object selectedValue = JOptionPane.showInputDialog(this.main, "Choose one", "Input", 1, null, possibleValues, possibleValues[0]);
            if (selectedValue == null) {
                return;
            }
            if (selectedValue.equals("insert before this page")) {
                before = true;
            }
        }
        ViewData viewData = ViewUtil.getDefaultViewData();
        if (before) {
            if (this.CurrentPage == 0) {
                this.CurrentPage = 1;
            }
        } else {
            ++this.CurrentPage;
        }
        PageData pageData = new PageData(new ArrayList(), viewData, new UndoDrawManager());
        this.PageList.add(this.CurrentPage - 1, pageData);
        if (debug > 0) {
            System.out.println("** PageManager.insertNewPage newPage=" + this.CurrentPage);
        }
        this.showPage(this.CurrentPage);
        DrawPanel drawPanel = ObjectTable.getDrawPanel("");
        drawPanel.repaint("PageManager");
    }

    public void deletePage() {
        int returnCode;
        this.initApp();
        if (debug > 0) {
            System.out.println("** deletePage start page=" + this.CurrentPage + ", PageList.size()=" + this.PageList.size());
        }
        if ((returnCode = JOptionPane.showConfirmDialog(this.main, "Delete this page? Undo is not supported for this operarion", "", 0)) != 0) {
            return;
        }
        this.PageList.remove(this.CurrentPage - 1);
        if (this.CurrentPage <= this.PageList.size()) {
            this.showPage(this.CurrentPage);
        } else if (this.CurrentPage - 1 > 0) {
            this.showPage(--this.CurrentPage);
        } else {
            this.CurrentPage = 0;
            this.insertNewPage();
            JOptionPane.showMessageDialog(this.main, "all page deteted", "", 0);
        }
        System.out.println(" -- deletePage end, PageList.size()=" + this.PageList.size());
    }

    public void movePage(int selectedPage, int moveTo) {
        if (debug > 0) {
            System.out.println("** movePage  current page=" + this.CurrentPage + ", PageList.size()=" + this.PageList.size());
        }
        this.initApp();
        if (selectedPage < 1) {
            return;
        }
        Object selectedPageData = this.PageList.get(selectedPage - 1);
        if (moveTo < 1 || moveTo > this.PageList.size() + 1) {
            String message = "page can't be moved, page=" + selectedPage + ", moveTo=" + moveTo;
            return;
        }
        this.PageList.add(moveTo - 1, selectedPageData);
        if (moveTo <= selectedPage) {
            this.PageList.remove(selectedPage);
            this.CurrentPage = moveTo;
            this.showPage(this.CurrentPage);
        } else {
            this.PageList.remove(selectedPage - 1);
            this.CurrentPage = moveTo - 1;
            this.showPage(this.CurrentPage);
        }
        if (debug > 0) {
            System.out.println(" -- movePage end, PageList.size()=" + this.PageList.size());
        }
    }

    public void pageSetup(int sheetSize, int orientation) {
        System.out.println("PageManager.pageSetup page size=" + DrawParameters.SheetSizeString[sheetSize] + ", orientation=" + DrawParameters.SheetOrientationString[orientation]);
        DrawParameters.SheetSize = sheetSize;
        DrawParameters.SheetOrientation = orientation;
        double scale = DrawParameters.Scale;
        ViewUtil.setView(scale, new Point(0, 0));
        this.saveCurrentPage();
        DrawPanel drawPanel = ObjectTable.getDrawPanel("");
        drawPanel.repaint("PageManager");
    }

    public int showPage(int selectedPage) {
        if (debug > 0) {
            System.out.println("** PageManager.showPage page=" + selectedPage + ", PageList.size()=" + this.PageList.size() + ", currentPage=" + this.CurrentPage);
        }
        int size = this.PageList.size();
        PageData pageData = null;
        if (selectedPage < 1 || selectedPage > size) {
            if (debug > 0) {
                System.out.println("** PageManager.showPage selectedPage not found+ selectedPage=" + selectedPage);
            }
            return -1;
        }
        pageData = (PageData)this.PageList.get(selectedPage - 1);
        this.CurrentPage = selectedPage;
        ContainerManager containerManager = ObjectTable.getContainerManager("");
        containerManager.setContainerList(pageData.ContainerList);
        ViewUtil.setViewData(pageData.viewData);
        ObjectTable.undoDrawManager = pageData.getUndoDrawManager();
        pageData.getUndoDrawManager().changeButtonState();
        if (debug > 0) {
            System.out.println("** PageManager.showPage UndoDrawManager()=" + pageData.getUndoDrawManager().toString());
        }
        DrawPanel drawPanel = ObjectTable.getDrawPanel("");
        drawPanel.repaint("PageManager");
        return 0;
    }

    public void saveCurrentPage() {
        this.initApp();
        ContainerManager containerManager = ObjectTable.getContainerManager("");
        ArrayList containerList = containerManager.getContainerList();
        ViewData viewData = ViewUtil.getViewData();
        PageData pageData = (PageData)this.PageList.get(this.CurrentPage - 1);
        pageData.setContainerList(containerList);
        pageData.setViewData(viewData);
        if (debug > 0) {
            System.out.println(" -- savePage page=" + this.CurrentPage + "\n   page data: " + pageData.toString());
        }
        try {
            this.PageList.set(this.CurrentPage - 1, pageData);
        }
        catch (IndexOutOfBoundsException e) {
            System.err.println("*** Error PageManager.savePage; current page not found, index=" + (this.CurrentPage - 1));
        }
    }

    public ArrayList getContainerList(int page) {
        PageData pageData = (PageData)this.PageList.get(page - 1);
        ArrayList containerList = pageData.ContainerList;
        return containerList;
    }

    public ViewData getViewData(int page) {
        PageData pageData = (PageData)this.PageList.get(page - 1);
        ViewData viewData = pageData.viewData;
        return viewData;
    }
}

