/*
 * Decompiled with CFR 0.152.
 */
package util;

import DrawTop.ObjectTable;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import shape.SerializableElement;
import util.FileIo;

public class PasteContainer
implements Serializable,
Cloneable {
    String originalFileName = null;
    int originalPage = 0;
    boolean newContents = false;
    String pastedFileName = null;
    int pastedPage = 0;
    int shiftCount = 0;
    String id = "";
    SerializableElement[] sElements = null;
    BufferedImage image = null;
    int debug = 0;

    public PasteContainer(SerializableElement[] sElements) {
        this.sElements = sElements;
        this.newContents = true;
        this.id = "SerializableElement - " + sElements[0].date;
        String fileNameAndPage = sElements[0].fileNameAndPage;
        int index = fileNameAndPage.lastIndexOf(":");
        String fileName = fileNameAndPage.substring(0, index);
        String page = fileNameAndPage.substring(index + 1, fileNameAndPage.length());
        this.originalFileName = fileName;
        this.originalPage = Integer.parseInt(page);
        this.shiftCount = 0;
    }

    public PasteContainer(BufferedImage bufferedImage) {
        this.newContents = true;
        this.id = "Image - " + this.createImageId(bufferedImage);
        this.shiftCount = 0;
        this.image = bufferedImage;
        if (this.debug > 0) {
            System.out.println("** TransferableElement id=" + this.id);
        }
    }

    public String toString() {
        String str = "";
        str = str + "shiftCount=" + this.shiftCount + ", newContents=" + this.newContents;
        str = str + ", Id=" + this.id + ", newContents=" + this.newContents + ", shiftCount=" + this.shiftCount;
        str = str + "\n  page=" + this.originalPage + ", file name=" + this.originalFileName;
        str = str + "\n  pastedPage=" + this.pastedPage + ", paste file name=" + this.pastedFileName;
        if (this.sElements != null && this.sElements.length > 0) {
            str = str + "\n  ";
            for (int i = 0; i < this.sElements.length; ++i) {
                str = str + this.sElements[i].shapeId;
                if (i == this.sElements.length) continue;
                str = str + ", ";
            }
        }
        if (this.image != null) {
            str = str + "\n  image=" + this.image;
        }
        return str;
    }

    private long createImageId(BufferedImage bufferedImage) {
        int i;
        int w = bufferedImage.getWidth(null);
        int h = bufferedImage.getHeight(null);
        long id = 0L;
        int wm = (int)((double)w * 0.5);
        int hm = (int)((double)h * 0.5);
        for (i = 0; i < w; ++i) {
            id += (long)bufferedImage.getRGB(i, hm);
        }
        for (i = 0; i < h; ++i) {
            id += (long)bufferedImage.getRGB(wm, i);
        }
        return id;
    }

    public boolean isNewContents() {
        return this.newContents;
    }

    public void setNewContents(boolean newContents) {
        this.newContents = newContents;
    }

    public String getId() {
        return this.id;
    }

    public String getOriginalFileName() {
        return this.originalFileName;
    }

    public int getOriginalPage() {
        return this.originalPage;
    }

    public String getPastedFileName() {
        return this.pastedFileName;
    }

    public void setPastedFileName(String pastedFileName) {
        this.pastedFileName = pastedFileName;
    }

    public int getPastedPage() {
        return this.pastedPage;
    }

    public void setPastedPage(int pastedPage) {
        this.pastedPage = pastedPage;
    }

    public int getShiftCount() {
        return this.shiftCount;
    }

    public void setShiftCount(int shiftCount) {
        this.shiftCount = shiftCount;
    }

    public SerializableElement[] getElementList() {
        return this.sElements;
    }

    public Image getImage() {
        return this.image;
    }

    protected int getCurrentShiftCount() {
        FileIo fileIo = ObjectTable.getFileIo();
        String currentFileName = fileIo.getCurrentFileName();
        int currentPage = fileIo.getCurrentPage();
        int shiftCount = this.getShiftCount();
        boolean pasteToOriginalFilePage = this.pasteToOriginalFilePage();
        boolean pasteToSameFilePage = this.pasteToSameFilePage();
        if (pasteToOriginalFilePage) {
            this.setShiftCount(++shiftCount);
            this.setPastedFileName(currentFileName);
            this.setPastedPage(currentPage);
        } else if (pasteToSameFilePage) {
            this.setShiftCount(++shiftCount);
        } else {
            shiftCount = 0;
            this.setShiftCount(shiftCount);
            this.setPastedFileName(currentFileName);
            this.setPastedPage(currentPage);
        }
        if (this.debug > 0) {
            System.out.println("++ Edit.getPasteCount shiftCount=" + shiftCount + ", pasteToOriginalFilePage=" + pasteToOriginalFilePage + ", pasteToSameFilePage=" + pasteToSameFilePage);
        }
        return shiftCount;
    }

    protected boolean pasteToOriginalFilePage() {
        FileIo fileIo = ObjectTable.getFileIo();
        String currentFileName = fileIo.getCurrentFileName();
        int currentPage = fileIo.getCurrentPage();
        String originalFileName = this.getOriginalFileName();
        int originalPage = this.getOriginalPage();
        boolean same = false;
        if (currentFileName.equals(originalFileName) && originalPage == currentPage) {
            same = true;
        }
        return same;
    }

    protected boolean pasteToSameFilePage() {
        FileIo fileIo = ObjectTable.getFileIo();
        String currentFileName = fileIo.getCurrentFileName();
        int currentPage = fileIo.getCurrentPage();
        String pastedFileName = this.getPastedFileName();
        int pastedPage = this.getPastedPage();
        boolean same = false;
        if (currentFileName.equals(pastedFileName) && pastedPage == currentPage) {
            same = true;
        }
        return same;
    }
}

