/*
 * Decompiled with CFR 0.152.
 */
package DrawTop;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;

public class DrawParameters {
    public static final Rectangle GuidancePanelBounds = new Rectangle(160, 0, 1200, 22);
    public static Cursor DEFAULT_CURSOR = new Cursor(0);
    public static Cursor MOVE_CURSOR = new Cursor(13);
    public static Cursor NW_RESIZE_CURSOR = new Cursor(6);
    public static Cursor NE_RESIZE_CURSOR = new Cursor(7);
    public static Cursor SE_RESIZE_CURSOR = new Cursor(5);
    public static Cursor SW_RESIZE_CURSOR = new Cursor(4);
    public static Cursor N_RESIZE_CURSOR = new Cursor(8);
    public static Cursor E_RESIZE_CURSOR = new Cursor(11);
    public static Cursor S_RESIZE_CURSOR = new Cursor(9);
    public static Cursor W_RESIZE_CURSOR = new Cursor(10);
    public static Cursor CROSSHAIR_CURSOR = new Cursor(1);
    public static Cursor TEXT_CURSOR = new Cursor(2);
    public static Cursor LEFTRIGHT_CURSOR = null;
    public static Cursor UPDOWN_CURSOR = null;
    public static Cursor CURRENT_CURSOR = DEFAULT_CURSOR;
    public static final int A3 = 0;
    public static final int A4 = 1;
    public static final int A5 = 2;
    public static final int B4 = 3;
    public static final int B5 = 4;
    public static final int PostCardJP = 5;
    public static final int Letter = 6;
    public static final int Legal = 7;
    public static final int Tabloid = 8;
    public static final Dimension A3_Size = new Dimension(297, 420);
    public static final Dimension A4_Size = new Dimension(210, 297);
    public static final Dimension A5_Size = new Dimension(148, 210);
    public static final Dimension B4_Size = new Dimension(257, 364);
    public static final Dimension B5_Size = new Dimension(182, 257);
    public static final Dimension PostCardJP_Size = new Dimension(100, 148);
    public static final Dimension Letter_Size = new Dimension(216, 279);
    public static final Dimension Legal_Size = new Dimension(216, 355);
    public static final Dimension Tabloid_Size = new Dimension(279, 432);
    public static final Dimension[] SheetSizesMM = new Dimension[]{A3_Size, A4_Size, A5_Size, B4_Size, B5_Size, PostCardJP_Size, Letter_Size, Legal_Size, Tabloid_Size};
    public static final String[] SheetSizeString = new String[]{"A3", "A4", "A5", "B4", "B5", "PostCardJP", "Letter", "Legal", "Tabloid"};
    public static final int LandScape = 0;
    public static final int Portrait = 1;
    public static final String[] SheetOrientationString = new String[]{"LandScape", "Portrait"};
    public static final double InchToMM = 25.4;
    public static final int InchToPixels = 96;
    public static final String[] LF = new String[]{"\n", "\u21b2", " "};
    public static final Font DefaultFont = new Font("Dialog", 0, 12);
    public static final Font smallFont = new Font("Dialog", 0, 11);
    public static final Font Font12Bold = new Font("Dialog", 1, 12);
    public static final Font Font13Plain = new Font("Dialog", 0, 13);
    public static final Font Font13Bold = new Font("Dialog", 1, 13);
    public static final Font Font14Plain = new Font("Dialog", 0, 14);
    public static final Font Font14Bold = new Font("Dialog", 1, 14);
    public static final int SelectionBoxOffset = 6;
    public static final int DrawAreaOffset = 40;
    public static final int TempLineLength = 30;
    public static final int Mark_NormalSize = 6;
    public static final int Mark_SmallSize = 4;
    public static final double ConnectionTolerance = 4.0;
    public static final double ConnectionSmallTolerance = 2.0;
    public static final double ClosedTolerance = 3.0;
    public static final double Sampling_Pitch = 5.0;
    public static final Dimension MinTextArea = new Dimension(10, 10);
    public static final float DefaultAlpha = 0.95f;
    public static final float MoveAlpha = 0.6f;
    public static final int DrawOnScreen = 0;
    public static final int DrawOnPrinter = 1;
    public static final int DrawOnImage = 2;
    public static int DrawMode = 0;
    public static double Scale = 1.0;
    public static int SheetSize = 1;
    public static int SheetOrientation = 0;
    public static int MODE = 0;
    public static boolean AUTO_ALIGN = true;
    public static boolean ENABLE_CONNECTOR = true;
    public static int AUTO_TRACKING_OPTION = 114;
    public static boolean DRAW_NODE_POINTS = false;
    public static boolean DRAW_CHARACTERISTIC_POINTS = false;
    public static boolean DRAW_TEXTLAYOUT = false;
    public static boolean DRAW_BOUNDINGBOX = false;
    public static boolean DRAW_UNSELECTABLEAREA = false;
    public static boolean ENABLE_BLINKING = true;
    public static boolean ENABLE_HIGHLIGHTING = true;

    public DrawParameters() {
        this.createCustomCorsor();
    }

    public static double getScale() {
        return Scale;
    }

    public static Dimension getSheetSizeByPixel() {
        int sheetType = SheetSize;
        Dimension sheetSize = SheetSizesMM[sheetType];
        sheetSize = new Dimension((int)sheetSize.getHeight(), (int)sheetSize.getWidth());
        int sheetOrientation = SheetOrientation;
        double inch = 25.4;
        int pixelsPerInch = 96;
        int drawPanelW = (int)(sheetSize.getWidth() / inch * (double)pixelsPerInch);
        int drawPanelH = (int)(sheetSize.getHeight() / inch * (double)pixelsPerInch);
        if (sheetOrientation == 1) {
            int temp = drawPanelW;
            drawPanelW = drawPanelH;
            drawPanelH = temp;
        }
        return new Dimension(drawPanelW, drawPanelH);
    }

    private void createCustomCorsor() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image image0 = toolkit.getImage("images/cursor_leftright.gif");
        LEFTRIGHT_CURSOR = toolkit.createCustomCursor(image0, new Point(0, 0), "LEFTRIGHT_CURSOR");
        Image image1 = toolkit.getImage("images/connectableShapeMark16T.png");
        UPDOWN_CURSOR = toolkit.createCustomCursor(image1, new Point(0, 0), "UPDOWN_CURSOR");
    }
}

