/*
 * Decompiled with CFR 0.152.
 */
package DrawTop;

import DrawTop.DrawPanel;
import DrawTop.DrawParameters;
import DrawTop.ExecPopupMenu;
import DrawTop.ListenerPanel;
import DrawTop.MousePositionInfo;
import DrawTop.ObjectTable;
import DrawTop.SelectionLS;
import geomExtension.Curve2D;
import geomExtension.Curve2DUtil;
import geomExtension.CurvePT;
import geomExtension.Vector2D;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Vector;
import menu.StatusPanel;
import shape.DrawShapeUtil;
import shape.GroupElement;
import shape.ShapeContainer;
import shape.ShapeElement;
import shape.ShapeElementUtil;
import textBox.TextBox;
import util.ContainerManager;
import util.Util;

public class MousePositionLS
implements MouseListener,
MouseMotionListener {
    Point2D startPoint = null;
    Point2D currentPoint = null;
    public static boolean popupTrigger;
    boolean clicked;
    public Point2D clickedPoint = null;
    private int infoCount = 0;
    private int maxInfos = 50;
    MousePositionInfo[] infos = new MousePositionInfo[this.maxInfos];
    ArrayList hitList = new ArrayList();
    ShapeContainer highlightContainer = null;
    static int idNumber;
    public static int debug;

    public MousePositionLS() {
        this.activateListener(true);
        for (int i = 0; i < this.maxInfos; ++i) {
            this.infos[i] = new MousePositionInfo();
        }
    }

    private void activateListener(boolean activate) {
        ListenerPanel listenerPanel;
        if (activate && !this.isMouseListener() && !this.isMouseMotionListener()) {
            listenerPanel = ObjectTable.getListenerPanel("MousePositionLS");
            listenerPanel.addMouseListener(this);
            listenerPanel.addMouseMotionListener(this);
        }
        if (!activate && this.isMouseListener() && this.isMouseMotionListener()) {
            listenerPanel = ObjectTable.getListenerPanel("MousePositionLS");
            listenerPanel.removeMouseListener(this);
            listenerPanel.removeMouseMotionListener(this);
        }
    }

    private boolean isMouseListener() {
        ListenerPanel listenerPanel = ObjectTable.getListenerPanel("MousePositionLS");
        MouseListener[] mouseLS = listenerPanel.getMouseListeners();
        boolean isRegistered = false;
        for (int i = 0; i < mouseLS.length; ++i) {
            if (!this.equals(mouseLS[i])) continue;
            isRegistered = true;
        }
        return isRegistered;
    }

    private boolean isMouseMotionListener() {
        ListenerPanel listenerPanel = ObjectTable.getListenerPanel("MousePositionLS");
        MouseMotionListener[] mouseMotionLS = listenerPanel.getMouseMotionListeners();
        boolean isRegistered = false;
        for (int i = 0; i < mouseMotionLS.length; ++i) {
            if (!this.equals(mouseMotionLS[i])) continue;
            isRegistered = true;
        }
        return isRegistered;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        double scale = DrawParameters.getScale();
        double X = (double)e.getX() / scale;
        double Y = (double)e.getY() / scale;
        this.startPoint = new Point2D.Double(X, Y);
        this.clicked = false;
        popupTrigger = false;
        if (e.isPopupTrigger()) {
            popupTrigger = true;
        }
        int key = e.getModifiersEx();
        int ctrl = 0;
        if ((key & 0x800) != 0) {
            ctrl = 2;
        }
        if ((key & 0x1000) != 0) {
            ctrl = 3;
        }
        if (ctrl == 2 || ctrl == 3) {
            for (int i = 0; i < this.infoCount; ++i) {
                this.infos[i].setRightButtonPressed(true);
            }
        }
        this.displayMousePosition("mousePressed", X, Y);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        double scale = DrawParameters.getScale();
        double X = (double)e.getX() / scale;
        double Y = (double)e.getY() / scale;
        this.currentPoint = new Point2D.Double(X, Y);
        this.infoCount = 0;
        this.createMousePositionInfo(X, Y);
        this.displayMousePosition("mouseDragged", X, Y);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        double scale = DrawParameters.getScale();
        double X = (double)e.getX() / scale;
        double Y = (double)e.getY() / scale;
        this.currentPoint = new Point2D.Double(X, Y);
        if (e.isPopupTrigger()) {
            popupTrigger = true;
        }
        this.displayMousePosition("mouseReleased", X, Y);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        double scale = DrawParameters.getScale();
        double X = (double)e.getX() / scale;
        double Y = (double)e.getY() / scale;
        this.currentPoint = new Point2D.Double(X, Y);
        this.clicked = true;
        Point2D.Double clickedPoint = new Point2D.Double(X, Y);
        this.displayMousePosition("mouseClicked", X, Y, false);
        boolean createShapeLS = ObjectTable.getListenerPanel().isMouseListener("CreateShapeLS");
        if (createShapeLS) {
            return;
        }
        if (debug > 0) {
            System.out.println("** MousePositionLS this.allMouseEventsCompleted()=" + this.allMouseEventsCompleted() + ", SelectionLS.popupTrigger=" + SelectionLS.popupTrigger + ", MousePositionLS.popupTrigger=" + popupTrigger);
        }
        if (this.allMouseEventsCompleted() && (SelectionLS.popupTrigger || popupTrigger)) {
            if (debug >= 0) {
                System.out.println("** MousePositionLS ExecPopupMenu");
            }
            ExecPopupMenu execPopupMenu = ObjectTable.getExecPopupMenu("");
            execPopupMenu.show(new Point((int)X, (int)Y));
            popupTrigger = false;
            SelectionLS.popupTrigger = false;
        }
        DrawPanel drawPanel = ObjectTable.getDrawPanel("");
        DrawShapeUtil.clearTempShape("MousePositionLS.pt");
        drawPanel.repaint("MousePositionLS");
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        double scale = DrawParameters.getScale();
        double X = (double)e.getX() / scale;
        double Y = (double)e.getY() / scale;
        this.currentPoint = new Point2D.Double(X, Y);
        this.infoCount = 0;
        this.createMousePositionInfo(X, Y);
        this.displayMousePosition("mouseMoved", X, Y);
        int position = 0;
        MousePositionInfo[] rankedInfos = this.getMousePositionInfoForSelection();
        if (rankedInfos.length > 0) {
            position = rankedInfos[0].getPosition();
        }
        Cursor newCursor = DrawParameters.DEFAULT_CURSOR;
        switch (position) {
            case 11: {
                newCursor = DrawParameters.DEFAULT_CURSOR;
                break;
            }
            case 2: {
                newCursor = DrawParameters.MOVE_CURSOR;
                break;
            }
            case 12: {
                newCursor = DrawParameters.DEFAULT_CURSOR;
                break;
            }
            case 3: {
                newCursor = DrawParameters.NW_RESIZE_CURSOR;
                break;
            }
            case 4: {
                newCursor = DrawParameters.NE_RESIZE_CURSOR;
                break;
            }
            case 5: {
                newCursor = DrawParameters.SE_RESIZE_CURSOR;
                break;
            }
            case 6: {
                newCursor = DrawParameters.SW_RESIZE_CURSOR;
                break;
            }
            case 7: {
                newCursor = DrawParameters.N_RESIZE_CURSOR;
                break;
            }
            case 8: {
                newCursor = DrawParameters.E_RESIZE_CURSOR;
                break;
            }
            case 9: {
                newCursor = DrawParameters.S_RESIZE_CURSOR;
                break;
            }
            case 10: {
                newCursor = DrawParameters.W_RESIZE_CURSOR;
                break;
            }
            case 14: {
                newCursor = DrawParameters.CROSSHAIR_CURSOR;
                break;
            }
            case 15: {
                newCursor = DrawParameters.CROSSHAIR_CURSOR;
                break;
            }
            case 13: 
            case 16: 
            case 17: {
                newCursor = DrawParameters.DEFAULT_CURSOR;
                boolean selected = false;
                String inf = "";
                boolean isActiveTextBox = false;
                if (rankedInfos.length > 0) {
                    selected = rankedInfos[0].getContainer().isSelected();
                    inf = rankedInfos[0].getInformation();
                    isActiveTextBox = rankedInfos[0].getShapeContainerInGroup().isEditableTextBox();
                }
                if (selected) {
                    newCursor = DrawParameters.MOVE_CURSOR;
                }
                if (!isActiveTextBox) break;
                if (inf.equals("top") || inf.equals("bottom")) {
                    newCursor = DrawParameters.N_RESIZE_CURSOR;
                }
                if (!inf.equals("left") && !inf.equals("right")) break;
                newCursor = DrawParameters.W_RESIZE_CURSOR;
                break;
            }
            case 19: {
                newCursor = DrawParameters.TEXT_CURSOR;
            }
        }
        DrawParameters.CURRENT_CURSOR = newCursor;
        ObjectTable.getDrawMain().setCursor(newCursor);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        ObjectTable.getDrawMain().setCursor(DrawParameters.DEFAULT_CURSOR);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        ObjectTable.getDrawMain().setCursor(DrawParameters.DEFAULT_CURSOR);
    }

    public Point2D getMousePoint() {
        return this.currentPoint;
    }

    public void displayMousePosition(String mouseAction, double X, double Y) {
        String shapeId = "null";
        String message = " MousePositionLS :  mouse action= " + mouseAction + ": ";
        message = message + "  x,y=" + (int)X + "," + (int)Y;
        if (this.infoCount == 0) {
            message = message + " outside draw area";
        }
        MousePositionInfo[] rankedInfos = this.getMousePositionInfoForSelection();
        for (int i = 0; i < rankedInfos.length; ++i) {
            ShapeContainer container = rankedInfos[i].getContainer();
            ShapeContainer shapeContainerInGroup = rankedInfos[i].getShapeContainerInGroup();
            int position = rankedInfos[i].getPosition();
            if (container == null || (shapeId = container.getShapeId()) == null || shapeId.equals("")) continue;
            boolean group = false;
            String shapeIdInGroup = "";
            if (shapeContainerInGroup != null) {
                shapeIdInGroup = shapeContainerInGroup.getShapeId();
            }
            if (shapeIdInGroup != null && !shapeIdInGroup.equals("") && !shapeIdInGroup.equals(shapeId)) {
                group = true;
            }
            if (rankedInfos.length > 1) {
                message = message + "   [" + i + "]";
            }
            message = message + ": " + MousePositionInfo.getPositionStringInDetail(position);
            message = group ? message + ", " + shapeContainerInGroup.getShapeId() + " / " + shapeId : message + ", " + shapeId;
            if (rankedInfos[i].isRightButtonPressed()) {
                message = message + ",  right button Pressed";
            }
            if (!rankedInfos[i].getContainer().isSelected()) continue;
            message = message + ",  selected";
        }
        message = message + "   ";
        StatusPanel statusPanel = ObjectTable.getStatusPanel();
        statusPanel.showText(0, message, "MousePositionLS");
        if (ObjectTable.getContainerManager().getEditableTextBox() == null) {
            statusPanel.showText(1, "", "MousePositionLS");
        }
        boolean highlightable = true;
        if (DrawParameters.MODE != 0) {
            highlightable = false;
        }
        boolean refresh = false;
        ShapeContainer container = null;
        if (rankedInfos.length > 0) {
            container = rankedInfos[0].getContainer();
            if (container != null && !container.equals(this.highlightContainer)) {
                if (this.highlightContainer != null) {
                    this.highlightContainer.setHighlighting(false);
                }
                if (!container.isSelected() && highlightable) {
                    container.setHighlighting(true);
                } else {
                    container.setHighlighting(false);
                }
                this.highlightContainer = container;
                refresh = true;
            }
        } else {
            if (this.highlightContainer != null) {
                this.highlightContainer.setHighlighting(false);
            }
            this.highlightContainer = null;
            refresh = true;
        }
        if (refresh) {
            ObjectTable.getDrawPanel().repaint();
        }
    }

    public void displayMousePosition(String mouseAction, double X, double Y, boolean print) {
        this.displayMousePosition(mouseAction, X, Y);
        MousePositionInfo[] rankedInfos = this.getMousePositionInfoForSelection();
        if (!print) {
            return;
        }
        String message = " MousePositionLS :  mouse action= " + mouseAction + ": ";
        message = message + "  x,y=" + (int)X + "," + (int)Y;
        if (this.infoCount == 0) {
            message = message + " outside draw area";
        }
        System.out.println(message);
        for (int i = 0; i < rankedInfos.length; ++i) {
            System.out.println(" [" + i + "]" + rankedInfos[i].toString());
        }
    }

    public MousePositionInfo[] getMousePositionInfoForSelection() {
        int[] ranks = new int[this.infoCount];
        MousePositionInfo[] rankedInfos = new MousePositionInfo[]{};
        if (this.infoCount == 0) {
            return rankedInfos;
        }
        int rank = 0;
        int rankDigit = 10000;
        ContainerManager manager = ObjectTable.getContainerManager();
        Vector vec = manager.getAllShapeContainers();
        for (int i = 0; i < this.infoCount; ++i) {
            ShapeContainer container = this.infos[i].getContainer();
            ShapeContainer child = this.infos[i].getShapeContainerInGroup();
            if (child != null) {
                container = child;
            }
            int index = vec.indexOf(container);
            int position = this.infos[i].getPosition();
            rank = 0;
            if (position >= 3 && position <= 10) {
                rank = 10 * rankDigit + index;
            }
            if (position == 14 || position == 15) {
                rank = 10 * rankDigit + index;
            }
            if (position == 2) {
                rank = 9 * rankDigit + index;
            }
            if (position == 19) {
                rank = 8 * rankDigit + index;
            }
            if (position == 13) {
                rank = 7 * rankDigit + index;
            }
            if (position == 17) {
                rank = 6 * rankDigit + index;
            }
            if (position == 18) {
                rank = 5 * rankDigit + index;
            }
            if (position == 16) {
                rank = 4 * rankDigit + index;
            }
            if (position == 11 || position == 12) {
                rank = 3 * rankDigit + index;
            }
            ranks[i] = rank;
        }
        int[] indices = Util.indexedSimpleSort(ranks);
        Vector<MousePositionInfo> vector = new Vector<MousePositionInfo>();
        for (int i = 0; i < this.infoCount; ++i) {
            if (ranks[indices[i]] <= 0) continue;
            MousePositionInfo info = (MousePositionInfo)this.infos[indices[i]].clone();
            vector.add(0, info);
        }
        int size = vector.size();
        if (size == 0) {
            return rankedInfos;
        }
        rankedInfos = new MousePositionInfo[size];
        for (int i = 0; i < size; ++i) {
            rankedInfos[i] = (MousePositionInfo)vector.get(i);
        }
        return rankedInfos;
    }

    public MousePositionInfo getMousePositionInfoForMoveResize() {
        int[] ranks = new int[this.infoCount];
        MousePositionInfo[] rankedInfos = new MousePositionInfo[]{};
        if (this.infoCount == 0) {
            return null;
        }
        int rank = 0;
        int rankDigit = 100000;
        ContainerManager manager = ObjectTable.getContainerManager();
        Vector vec = manager.getAllShapeContainers();
        for (int i = 0; i < this.infoCount; ++i) {
            ShapeContainer container = this.infos[i].getContainer();
            int index = vec.indexOf(container);
            int position = this.infos[i].getPosition();
            rank = 0;
            if (!container.isSelected()) continue;
            if (position >= 3 && position <= 10 || position == 14) {
                rank = 10 * rankDigit + index;
            }
            if (position >= 17) {
                rank = 9 * rankDigit + index;
            }
            if (position == 13) {
                rank = 8 * rankDigit + index;
            }
            if (position == 2) {
                rank = 7 * rankDigit + index;
            }
            if (position == 16) {
                rank = 6 * rankDigit + index;
            }
            ranks[i] = rank;
        }
        int[] indices = Util.indexedSimpleSort(ranks);
        Vector<MousePositionInfo> vector = new Vector<MousePositionInfo>();
        for (int i = 0; i < this.infoCount; ++i) {
            if (ranks[indices[i]] <= 0) continue;
            MousePositionInfo info = (MousePositionInfo)this.infos[indices[i]].clone();
            vector.add(0, info);
        }
        int size = vector.size();
        if (size == 0) {
            return null;
        }
        rankedInfos = new MousePositionInfo[size];
        for (int i = 0; i < size; ++i) {
            rankedInfos[i] = (MousePositionInfo)vector.get(i);
        }
        return rankedInfos[0];
    }

    public MousePositionInfo[] getAllMousePositionInfo() {
        MousePositionInfo[] mousePositionInfos = new MousePositionInfo[this.infoCount];
        for (int i = 0; i < this.infoCount; ++i) {
            mousePositionInfos[i] = this.infos[i];
        }
        return mousePositionInfos;
    }

    public boolean mouseEventCompleted() {
        return this.clicked;
    }

    public boolean allMouseEventsCompleted() {
        boolean completed = false;
        SelectionLS selectionLS = ObjectTable.getSelectionLS("MousePositionLS");
        if (selectionLS.mouseEventCompleted() && this.mouseEventCompleted()) {
            completed = true;
        }
        return completed;
    }

    private void createMousePositionInfo(double X, double Y) {
        this.infoCount = 0;
        ContainerManager containerManager = ObjectTable.getContainerManager("Edit");
        ShapeContainer[] containers = containerManager.getContainers();
        int size = 0;
        if (containers != null) {
            size = containers.length;
        }
        MousePositionInfo info = new MousePositionInfo();
        for (int i = size - 1; i >= 0; --i) {
            int containerType = containers[i].getContainerType();
            if (containerType == ShapeContainer.GROUP) {
                ShapeContainer shapeContainer = containers[i];
                this.createMousePositionOfGroup(X, Y, shapeContainer);
            }
            if (containerType != ShapeContainer.SHAPE) continue;
            this.createMousePositionOfShape(X, Y, containers[i]);
        }
    }

    private void createMousePositionOfShape(double X, double Y, ShapeContainer shapeContainer) {
        int onEndPoint;
        int position = 0;
        String inf = "";
        Rectangle2D boundingBox = shapeContainer.getBoundingBox();
        if (boundingBox == null) {
            return;
        }
        boolean selected = shapeContainer.isSelected();
        double maxOffset = 40.0;
        Rectangle2D drawBoundingBox = ShapeElementUtil.getEnlargedRectangle(boundingBox, maxOffset, maxOffset);
        int pos = this.ptOnBox(X, Y, drawBoundingBox);
        if (pos >= 11) {
            position = 1;
        }
        if (position == 0) {
            return;
        }
        double scale = DrawParameters.Scale;
        double delta = 6.0 / scale;
        Rectangle2D largeBoundingBox = ShapeElementUtil.getEnlargedRectangle(boundingBox, delta, delta);
        selected = shapeContainer.isSelected();
        pos = this.ptOnBox(X, Y, largeBoundingBox);
        if (selected && pos == 11) {
            position = 2;
            int onMark = this.onResizeMark(X, Y, largeBoundingBox);
            if (onMark != 0) {
                position = onMark;
            }
            this.setMousePosition(shapeContainer, shapeContainer, null, position, new Point2D.Double(X, Y), inf);
            return;
        }
        pos = this.ptOnBox(X, Y, boundingBox);
        if (pos == 11 || pos == 12) {
            position = 11;
        }
        this.setMousePosition(shapeContainer, shapeContainer, null, position, new Point2D.Double(X, Y), inf);
        pos = this.ptOnShape(X, Y, shapeContainer);
        if (pos > 0) {
            position = pos;
            this.setMousePosition(shapeContainer, shapeContainer, null, position, new Point2D.Double(X, Y), inf);
        }
        Rectangle2D textArea = null;
        Rectangle2D textLayoutArea = null;
        if (shapeContainer.getTextBox() != null) {
            textArea = shapeContainer.getTextBox().getTextArea();
            textLayoutArea = shapeContainer.getTextBox().getTextLayoutArea();
        }
        if (textArea != null) {
            pos = this.ptOnBox(X, Y, textArea);
            int posLayout = this.ptOnBox(X, Y, textLayoutArea);
            if (pos == 11) {
                position = 17;
                inf = this.ptInfOnBox(X, Y, textArea);
                this.setMousePosition(shapeContainer, shapeContainer, shapeContainer.getTextBox(), position, new Point2D.Double(X, Y), inf);
            }
            if (pos == 12) {
                position = 18;
                inf = this.ptInfOnBox(X, Y, textArea);
                this.setMousePosition(shapeContainer, shapeContainer, shapeContainer.getTextBox(), position, new Point2D.Double(X, Y), inf);
            }
            if (posLayout == 12) {
                position = 19;
                inf = this.ptInfOnBox(X, Y, textLayoutArea);
                this.setMousePosition(shapeContainer, shapeContainer, shapeContainer.getTextBox(), position, new Point2D.Double(X, Y), inf);
            }
        }
        Point2D[] endPTs = new Point2D[2];
        if (shapeContainer.getElement() != null && (onEndPoint = this.onPoint(X, Y, endPTs = shapeContainer.getElement().getEndPTs())) >= 0) {
            position = 14;
            this.setMousePosition(shapeContainer, shapeContainer, null, position, new Point2D.Double(X, Y), inf);
            return;
        }
        if (shapeContainer.getMode() == 5 && selected && position >= 1) {
            Point2D[] ctrlPTs = null;
            ShapeElement shapeElement = shapeContainer.getElement();
            if (shapeElement != null) {
                ctrlPTs = shapeElement.getModifierPTs();
            }
            position = 0;
            if (this.onPoint(X, Y, ctrlPTs) >= 0) {
                position = 15;
            }
            if (this.onPoint(X, Y, endPTs) >= 0) {
                position = 14;
            }
            if (position > 0) {
                this.setMousePosition(shapeContainer, shapeContainer, null, position, new Point2D.Double(X, Y), inf);
            }
        }
    }

    private void createMousePositionOfGroup(double X, double Y, ShapeContainer groupContainer) {
        double scale = DrawParameters.Scale;
        double delta = 6.0 / scale;
        int position = 0;
        String inf = "";
        Rectangle2D boundingBox = groupContainer.getBoundingBox();
        Rectangle2D largeBoundingBox = ShapeElementUtil.getEnlargedRectangle(boundingBox, delta, delta);
        if (boundingBox == null) {
            return;
        }
        boolean selected = groupContainer.isSelected();
        int pos = this.ptOnBox(X, Y, largeBoundingBox);
        if (pos == 0) {
            return;
        }
        if (selected && pos == 11) {
            position = 2;
            int onMark = this.onResizeMark(X, Y, largeBoundingBox);
            if (onMark != 0) {
                position = onMark;
            }
            this.setMousePosition(groupContainer, null, null, position, new Point2D.Double(X, Y), inf);
            return;
        }
        pos = this.ptOnBox(X, Y, boundingBox);
        if (pos == 0) {
            return;
        }
        if (pos > 0) {
            position = pos;
            this.setMousePosition(groupContainer, null, null, position, new Point2D.Double(X, Y), inf);
        }
        GroupElement groupElement = (GroupElement)groupContainer.getElement();
        ShapeContainer[] shapeContainers = groupElement.getGroupedSingleShapeContainers();
        int size = shapeContainers.length;
        for (int i = size - 1; i >= 0; --i) {
            this.createMousePositionOfShapeInGroup(X, Y, groupContainer, shapeContainers[i]);
        }
    }

    private void createMousePositionOfShapeInGroup(double X, double Y, ShapeContainer groupContainer, ShapeContainer shapeContainer) {
        int position = 0;
        String inf = "";
        Rectangle2D boundingBox = shapeContainer.getBoundingBox();
        if (boundingBox == null) {
            return;
        }
        double scale = DrawParameters.Scale;
        double delta = 6.0 / scale;
        int pos = 0;
        pos = this.ptOnShape(X, Y, shapeContainer);
        if (pos > 0) {
            position = pos;
            this.setMousePosition(groupContainer, shapeContainer, null, position, new Point2D.Double(X, Y), inf);
        }
        Rectangle2D textArea = null;
        if (shapeContainer.getTextBox() != null) {
            textArea = shapeContainer.getTextBox().getTextArea();
        }
        if (textArea != null) {
            pos = this.ptOnBox(X, Y, textArea);
            if (pos == 11) {
                position = 17;
                inf = this.ptInfOnBox(X, Y, textArea);
                this.setMousePosition(groupContainer, shapeContainer, shapeContainer.getTextBox(), position, new Point2D.Double(X, Y), inf);
            }
            if (pos == 12) {
                position = 19;
                this.setMousePosition(groupContainer, shapeContainer, shapeContainer.getTextBox(), position, new Point2D.Double(X, Y), inf);
            }
        }
    }

    private int ptOnShape(double X, double Y, ShapeContainer shapeContainer) {
        double scale = DrawParameters.Scale;
        double margin = 1.2;
        double delta = 0.5 * margin * 6.0 / scale;
        Shape shape = shapeContainer.getElement().getShape();
        boolean closed = shapeContainer.getElement().isClosed();
        int position = 0;
        if (!closed) {
            Point2D.Double pt = new Point2D.Double(X, Y);
            Curve2D curve = shapeContainer.getElement().getCurve2D();
            CurvePT curvePT = Curve2DUtil.getShortestLine(pt, curve);
            if (Vector2D.dist(pt, curvePT.getP()) < delta) {
                position = 13;
            }
        } else {
            boolean north = shape.contains(X, Y - delta);
            boolean south = shape.contains(X, Y + delta);
            boolean west = shape.contains(X - delta, Y);
            boolean east = shape.contains(X + delta, Y);
            if (north || south || west || east) {
                position = 13;
            }
            if (north && south && west && east) {
                position = 16;
            }
        }
        return position;
    }

    private int ptOnBox(double X, double Y, Rectangle2D box) {
        double scale = DrawParameters.Scale;
        double delta = 3.0 / scale;
        int boundary = 11;
        int inside = 12;
        int position = 0;
        if (box == null) {
            return position;
        }
        boolean top = box.contains(X, Y - delta);
        boolean bottom = box.contains(X, Y + delta);
        boolean left = box.contains(X - delta, Y);
        boolean right = box.contains(X + delta, Y);
        if (top || bottom || left || right) {
            position = boundary;
        }
        if (top && bottom && left && right) {
            position = inside;
        }
        return position;
    }

    private String ptInfOnBox(double X, double Y, Rectangle2D box) {
        double scale = DrawParameters.Scale;
        double delta = 3.0 / scale;
        String str = "outside";
        if (box == null) {
            return str;
        }
        double x0 = box.getX();
        double y0 = box.getY();
        double w = box.getWidth();
        double h = box.getHeight();
        Rectangle2D.Double topBox = new Rectangle2D.Double(x0, y0 + h - delta, w, 2.0 * delta);
        Rectangle2D.Double bottomBox = new Rectangle2D.Double(x0, y0 - delta, w, 2.0 * delta);
        Rectangle2D.Double leftBox = new Rectangle2D.Double(x0 - delta, y0, 2.0 * delta, h);
        Rectangle2D.Double rightBox = new Rectangle2D.Double(x0 + w - delta, y0, 2.0 * delta, h);
        boolean top = topBox.contains(X, Y);
        boolean bottom = bottomBox.contains(X, Y);
        boolean left = leftBox.contains(X, Y);
        boolean right = rightBox.contains(X, Y);
        if (box.contains(X, Y)) {
            str = "inside";
        }
        if (top) {
            str = "top";
        }
        if (bottom) {
            str = "bottom";
        }
        if (left) {
            str = "left";
        }
        if (right) {
            str = "right";
        }
        return str;
    }

    private int onPoint(double X, double Y, Point2D[] points) {
        if (points == null) {
            return -1;
        }
        double scale = DrawParameters.Scale;
        int size = 0;
        if (points != null) {
            size = points.length;
        }
        double delta = 3.0 / scale;
        int index = -1;
        for (int i = 0; i < size; ++i) {
            double y;
            double x = points[i].getX();
            if (!this.boxContains(X, Y, delta, x, y = points[i].getY())) continue;
            index = i;
            break;
        }
        return index;
    }

    private int onResizeMark(double X, double Y, Rectangle2D rectangle) {
        double scale = DrawParameters.Scale;
        double delta = 3.0 / scale;
        double x = rectangle.getX();
        double y = rectangle.getY();
        double w = rectangle.getWidth();
        double h = rectangle.getHeight();
        double markX = x;
        double markY = y;
        if (this.boxContains(X, Y, delta, markX, markY)) {
            return 3;
        }
        markX = x + w;
        if (this.boxContains(X, Y, delta, markX, markY)) {
            return 4;
        }
        markY = y + h;
        if (this.boxContains(X, Y, delta, markX, markY)) {
            return 5;
        }
        markX = x;
        if (this.boxContains(X, Y, delta, markX, markY)) {
            return 6;
        }
        markX = x + w / 2.0;
        markY = y;
        if (this.boxContains(X, Y, delta, markX, markY)) {
            return 7;
        }
        markX = x + w;
        markY = y + h / 2.0;
        if (this.boxContains(X, Y, delta, markX, markY)) {
            return 8;
        }
        markX = x + w / 2.0;
        markY = y + h;
        if (this.boxContains(X, Y, delta, markX, markY)) {
            return 9;
        }
        markX = x;
        markY = y + h / 2.0;
        if (this.boxContains(X, Y, delta, markX, markY)) {
            return 10;
        }
        return 0;
    }

    private boolean boxContains(double X, double Y, double delta, double boxX, double boxY) {
        if (X < boxX - delta) {
            return false;
        }
        if (X > boxX + delta) {
            return false;
        }
        if (Y < boxY - delta) {
            return false;
        }
        return !(Y > boxY + delta);
    }

    private void setMousePosition(ShapeContainer container, ShapeContainer shapeContainerInGroup, TextBox textBox, int position, Point2D point, String inf) {
        if (this.infoCount < this.maxInfos) {
            this.infos[this.infoCount].setContainer(container);
            this.infos[this.infoCount].setShapeContainerInGroup(shapeContainerInGroup);
            this.infos[this.infoCount].setTextBox(textBox);
            this.infos[this.infoCount].setPosition(position);
            this.infos[this.infoCount].setPoint(point);
            this.infos[this.infoCount].setMouseStatus("");
            this.infos[this.infoCount].setRightButtonPressed(false);
            this.infos[this.infoCount].setInformation(inf);
            ++this.infoCount;
        } else {
            System.err.println("*** Warning MousePositionInfo: Num. of infos excedded max");
        }
    }

    static {
        idNumber = 0;
        debug = 0;
    }
}

