/*
 * Decompiled with CFR 0.152.
 */
package DrawTop;

import DrawTop.ObjectTable;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import shape.ShapeContainer;
import util.ContainerManager;
import util.Util;

public class UnselectableAreas {
    ArrayList<String> typeList = new ArrayList();
    ArrayList<Shape> areaList = new ArrayList();
    String textBoxString = "TextBox";
    int debug = 0;

    public boolean covers(double X, double Y) {
        boolean cover = false;
        int size = this.areaList.size();
        for (int i = 0; i < size; ++i) {
            Shape shape = this.areaList.get(i);
            if (shape.contains(X, Y)) {
                cover = true;
            }
            if (this.debug <= 0) continue;
            Rectangle2D rect = (Rectangle2D)shape;
            System.out.println("Unselectable Area: " + Util.Rect(rect));
        }
        return cover;
    }

    public boolean covers(double X, double Y, String message) {
        boolean cover = this.covers(X, Y);
        this.println(message + ", contain=" + cover + ", ");
        return cover;
    }

    public Shape[] getShapes() {
        int size = this.areaList.size();
        Shape[] shapes = new Shape[size];
        for (int i = 0; i < size; ++i) {
            shapes[i] = this.areaList.get(i);
        }
        return shapes;
    }

    public void setUnselectableAreas() {
        this.typeList.clear();
        this.areaList.clear();
        ContainerManager manager = ObjectTable.getContainerManager();
        ShapeContainer shapeContainer = manager.getEditableTextBox();
        if (shapeContainer == null) {
            int index = this.typeList.indexOf(this.textBoxString);
            if (index >= 0) {
                this.areaList.remove(index);
                this.typeList.remove(index);
            }
        } else {
            if (this.debug > 0) {
                System.out.println("UnselectableAreas.getAreas shapeContainer : " + shapeContainer.toShortString());
            }
            Rectangle2D rect = shapeContainer.getTextBox().getTextArea();
            int index = this.typeList.indexOf(this.textBoxString);
            if (index < 0) {
                this.typeList.add(this.textBoxString);
                this.areaList.add(rect);
            } else {
                this.areaList.set(index, rect);
            }
        }
    }

    public void clearUnselectableAreas() {
        this.typeList.clear();
        this.areaList.clear();
    }

    public String toString() {
        int size = this.areaList.size();
        String str = "Unselectable Areas : ";
        if (size == 0) {
            str = str + "none";
        }
        String type = "";
        String areaStr = "";
        for (int i = 0; i < size; ++i) {
            type = this.typeList.get(i);
            Shape shapeContainer = this.areaList.get(i);
            areaStr = "";
            if (type.equals(this.textBoxString)) {
                Rectangle2D rect = (Rectangle2D)shapeContainer;
                areaStr = "Rectangle, " + Util.Rect(rect);
            }
            str = str + "Area[" + i + "} type=" + type + ", area=" + areaStr + ";  ";
        }
        return str;
    }

    public void println(String message) {
        String str = this.toString();
        System.out.println(message + ", " + str);
    }
}

