/*
 * Decompiled with CFR 0.152.
 */
package geomExtension;

import geomExtension.Curve2D;
import geomExtension.Segment2D;
import geomExtension.Vector2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.Vector;

public class Polyline2DE
extends Curve2D {
    public Polyline2DE(Segment2D[] segments) {
        super(segments);
    }

    public Polyline2DE(Point2D[] points) {
        this.setData(points);
    }

    public Polyline2DE(Point2D[] points, boolean closed) {
        this.generalPath = new GeneralPath(0);
        this.segments = new Segment2D[points.length - 1];
        this.closed = closed;
        if (closed) {
            points[points.length - 1] = points[0];
        }
        for (int i = 0; i < points.length - 1; ++i) {
            Line2D.Double line = new Line2D.Double(points[i], points[i + 1]);
            Segment2D segment = new Segment2D(1, line);
            this.generalPath.append(line, true);
            this.segments[i] = segment;
        }
    }

    public void setData(Point2D[] points) {
        this.generalPath = new GeneralPath(0);
        this.segments = new Segment2D[points.length - 1];
        this.closed = false;
        int np = points.length;
        double dist = Vector2D.dist(points[0], points[np - 1]);
        if (dist < 3.0) {
            points[np - 1] = (Point2D)points[0].clone();
            this.closed = true;
        }
        for (int i = 0; i < points.length - 1; ++i) {
            Line2D.Double line = new Line2D.Double(points[i], points[i + 1]);
            Segment2D segment = new Segment2D(1, line);
            this.generalPath.append(line, true);
            this.segments[i] = segment;
        }
    }

    @Override
    public int getType2DE() {
        return 54;
    }

    public Point2D[] getPoints() {
        Point2D[] points = new Point2D[this.segments.length + 1];
        for (int i = 0; i < points.length; ++i) {
            points[i] = new Point2D.Double(this.getP(i).getX(), this.getP(i).getY());
        }
        return points;
    }

    public Point2D getPoint(int index) {
        if (index < 0 || index > this.segments.length) {
            System.out.println("*** Error Polyline2DE.getPoint; index out of range; index=" + index);
            return null;
        }
        return this.getP(index);
    }

    public Polyline2DE getTrimmedCurve2D(double t1, double t2) {
        if (this.isClosed() || t1 == 0.0 && t2 == 0.0) {
            return this;
        }
        Polyline2DE trimmedCurve = null;
        Vector<Segment2D> vector = new Vector<Segment2D>();
        int it1 = (int)t1;
        int it2 = (int)t2;
        if (Math.abs(t2 - (double)it2) < 1.0E-5 && t2 >= 1.0) {
            --it2;
        }
        for (int i = it1; i <= it2; ++i) {
            double t01 = 0.0;
            double t02 = 1.0;
            if (i == it1) {
                t01 = t1 - (double)it1;
            }
            if (i == it2) {
                t02 = t2 - (double)it2;
            }
            Segment2D segment = this.getSegment2D(i);
            if (!(Math.abs(t02 - t01) > 1.0E-5)) continue;
            Segment2D subSegment = segment.trimSegment(t01, t02);
            vector.add(subSegment);
        }
        int size = vector.size();
        if (size == 0) {
            return null;
        }
        Segment2D[] segments = new Segment2D[size];
        for (int i = 0; i < size; ++i) {
            segments[i] = (Segment2D)vector.get(i);
        }
        trimmedCurve = new Polyline2DE(segments);
        return trimmedCurve;
    }

    public Polyline2DE getTrimmedPolyline(double cut1, double cut2) {
        if (this.isClosed() || cut1 == 0.0 && cut2 == 0.0) {
            return this;
        }
        int numseg = this.getNumOfSegments();
        double length1 = this.getCurveLength(0.0, 1.0);
        double t1 = cut1 / length1;
        double length2 = this.getCurveLength(numseg - 1, numseg);
        double t2 = (double)numseg - cut2 / length2;
        return this.getTrimmedCurve2D(t1, t2);
    }

    @Override
    public Object clone() {
        Point2D[] points = this.getPoints();
        return new Polyline2DE(points);
    }

    @Override
    public String toString() {
        String str = "";
        str = str + "Polyline, segments=" + this.segments.length + ", close=" + this.closed;
        for (int i = 0; i < this.segments.length; ++i) {
            Segment2D segment = this.segments[i];
            str = str + "\n    -- segments[" + i + "]=" + segment.toString();
        }
        return str;
    }
}

