/*
 * Decompiled with CFR 0.152.
 */
package menu;

import DrawTop.ObjectTable;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import menu.ButtonOfToggelAction;
import menu.DrawImageIcon;
import menu.MenuConstants;
import menu.MenuUtil;

public class ButtonOfToggle
extends JToggleButton
implements ItemListener {
    ButtonOfToggelAction action = new ButtonOfToggelAction();
    protected Border raisedBorder = new BevelBorder(0);
    protected Border loweredBorder = new BevelBorder(1);
    ImageIcon imageEnabled = null;
    ImageIcon imageDisabled = null;
    public static int debug = 0;

    public ButtonOfToggle(String commandName, String tip, String[] accelerators) {
        this.setActionCommand(commandName);
        this.addActionListener(this.action);
        this.setName(commandName);
        this.setText(commandName);
        this.setName(commandName);
        this.setToolTipText(tip);
        this.setStandardButtonStyle();
        this.setAccelerators(accelerators);
        this.addItemListener(this);
    }

    public ButtonOfToggle(String commandName, boolean setText, ImageIcon imageEnabled, ImageIcon imageDisabled, String tip, String[] accelerators) {
        super(imageDisabled, false);
        this.setActionCommand(commandName);
        this.addActionListener(this.action);
        this.setName(commandName);
        this.imageEnabled = imageEnabled;
        this.imageDisabled = imageDisabled;
        if (setText) {
            this.setText(commandName);
            this.setHorizontalTextPosition(2);
        }
        this.setToolTipText(tip);
        this.setStandardButtonStyle();
        this.setAccelerators(accelerators);
        this.addItemListener(this);
    }

    public void setStandardButtonStyle() {
        this.setBorder(this.raisedBorder);
        this.setIconTextGap(0);
        this.setHorizontalTextPosition(0);
        this.setVerticalTextPosition(3);
        this.setHorizontalAlignment(0);
        this.setFont(MenuConstants.MenuFont);
        this.setBackground(null);
        this.setForeground(Color.BLACK);
    }

    public void setAccelerators(String[] accelerators) {
        int size = 0;
        if (accelerators != null) {
            size = accelerators.length;
        }
        for (int i = 0; i < size; ++i) {
            KeyStroke stroke = KeyStroke.getKeyStroke(accelerators[i]);
            InputMap inputMap = this.getInputMap(2);
            inputMap.put(stroke, accelerators[i]);
            ActionMap actionMap = this.getActionMap();
            actionMap.put(accelerators[i], this.action);
            if (debug <= 0) continue;
            System.out.println("-- ButtonOfAcceleratoractionMap stroke=" + stroke + ", key=" + accelerators[i] + ", value=" + actionMap.get(accelerators[i]));
        }
    }

    @Override
    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        if (enable) {
            super.setIcon(this.imageEnabled);
        } else {
            super.setIcon(this.imageDisabled);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.setBorder(this.isSelected() ? this.loweredBorder : this.raisedBorder);
    }

    public static ButtonOfToggle createButton(String commandName, int width, String tip, String[] accelerators) {
        ButtonOfToggle button = new ButtonOfToggle(commandName, tip, accelerators);
        if (width > 0) {
            button.setPreferredSize(new Dimension(width, 22));
        } else {
            TextLayout textlayout = new TextLayout(commandName, MenuConstants.MenuFont, new FontRenderContext(null, false, false));
            int textWidth = (int)textlayout.getAdvance() + 5;
            button.setPreferredSize(new Dimension(textWidth, 22));
        }
        MenuUtil menuUtil = ObjectTable.getMenuUtil();
        menuUtil.setMenuComponent(button);
        if (debug > 0) {
            menuUtil.printMenuComponent(button);
        }
        button.requestFocus();
        return button;
    }

    public static ButtonOfToggle createButton(String commandName, boolean setText, String imageName, String tip) {
        ButtonOfToggle button = null;
        if (imageName == null || imageName.equals("")) {
            button = new ButtonOfToggle(commandName, tip, null);
            TextLayout textlayout = new TextLayout(commandName, MenuConstants.MenuFont, new FontRenderContext(null, false, false));
            int textWidth = (int)textlayout.getAdvance() + 5;
            button.setPreferredSize(new Dimension(textWidth, 22));
        } else {
            ImageIcon icon = DrawImageIcon.get(imageName, 20, 20);
            button = new ButtonOfToggle(commandName, setText, icon, icon, tip, null);
            button.setPreferredSize(new Dimension(22, 22));
        }
        MenuUtil menuUtil = ObjectTable.getMenuUtil();
        menuUtil.setMenuComponent(button);
        if (debug > 0) {
            menuUtil.printMenuComponent(button);
        }
        return button;
    }

    public static ButtonOfToggle createButton(String commandName, String imageEnabled, String imageDisabled, String tip) {
        ButtonOfToggle button = null;
        if (imageEnabled.equals("") || imageDisabled.equals("")) {
            System.err.println("*** Error Button.createButton image not found");
            return null;
        }
        ImageIcon iconEnabled = DrawImageIcon.get(imageEnabled, 20, 20);
        ImageIcon iconDisenabled = DrawImageIcon.get(imageDisabled, 20, 20);
        button = new ButtonOfToggle(commandName, false, iconEnabled, iconDisenabled, tip, null);
        button.setPreferredSize(new Dimension(22, 22));
        MenuUtil menuUtil = ObjectTable.getMenuUtil();
        menuUtil.setMenuComponent(button);
        if (debug > 0) {
            menuUtil.printMenuComponent(button);
        }
        return button;
    }
}

