/*
 * Decompiled with CFR 0.152.
 */
package menu;

import DrawTop.DrawParameters;
import DrawTop.ObjectTable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import menu.DialogOfZoomAction;
import menu.MenuConstants;
import menu.ZoomItemListener;
import menu.ZoomSpinnerChangeListener;

public class DialogOfZoom
extends JDialog {
    public static DialogOfZoom main;
    Dimension dialogDimension = new Dimension(300, 120);
    JComboBox zoomComboBox;
    JSpinner zoomSpinner;
    SpinnerNumberModel zoomSpinnerModel;
    double scaleSave = DrawParameters.Scale;

    public DialogOfZoom() {
        super((Frame)ObjectTable.getDrawMain(), "zoom");
        main = this;
    }

    public void showDialog() {
        Window owner = this.getOwner();
        Point centerP = new Point(owner.getX() + 150, owner.getY() + 90);
        this.setLocation(centerP);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JTabbedPane tabbedPane = new JTabbedPane();
        contentPane.add((Component)tabbedPane, "North");
        JPanel zoomPanel = this.createZoomPanel();
        JPanel propertyPanel = new JPanel();
        zoomPanel.setPreferredSize(this.dialogDimension);
        propertyPanel.setPreferredSize(this.dialogDimension);
        tabbedPane.add("zoom", zoomPanel);
        tabbedPane.add("property", propertyPanel);
        this.pack();
        this.setVisible(true);
    }

    private JPanel createZoomPanel() {
        JPanel basePanel = new JPanel();
        JPanel zoomPanel = new JPanel();
        GridLayout zoomPanelLayout = new GridLayout(1, 2);
        zoomPanelLayout.setHgap(20);
        zoomPanel.setLayout(zoomPanelLayout);
        JPanel comboBoxPanel = new JPanel();
        TitledBorder frameBorder = BorderFactory.createTitledBorder("Zoom to");
        frameBorder.setTitleColor(Color.BLACK);
        frameBorder.setTitleFont(MenuConstants.MenuFont);
        comboBoxPanel.setBorder(frameBorder);
        GridLayout comboBoxPanelLayout = new GridLayout(1, 1);
        comboBoxPanel.setLayout(comboBoxPanelLayout);
        String[] scales = new String[]{"", "400%", "300%", "200%", "173%", "141%", "122%", "100%", "86%", "71%", "61%", "50%", "35%", "fit width", "fit height"};
        this.zoomComboBox = new JComboBox<String>(scales);
        DialogOfZoomAction action = new DialogOfZoomAction();
        ZoomItemListener zoomItemListener = new ZoomItemListener();
        this.zoomComboBox.setActionCommand("zomm to");
        int percentScale = (int)(DrawParameters.Scale * 100.0);
        this.scaleSave = DrawParameters.Scale;
        String scalStr = percentScale + "%";
        this.zoomComboBox.setSelectedItem(scalStr);
        this.zoomComboBox.setFont(MenuConstants.MenuItemFont);
        comboBoxPanel.add(this.zoomComboBox);
        zoomPanel.add(comboBoxPanel);
        JPanel spinnerPanel = new JPanel();
        frameBorder = BorderFactory.createTitledBorder("percent");
        frameBorder.setTitleColor(Color.BLACK);
        frameBorder.setTitleFont(MenuConstants.MenuFont);
        spinnerPanel.setBorder(frameBorder);
        GridLayout spinnerPanelLayout = new GridLayout(1, 1);
        spinnerPanel.setLayout(spinnerPanelLayout);
        this.zoomSpinnerModel = new SpinnerNumberModel(100.0, 10.0, 500.0, 1.0);
        this.zoomSpinner = new JSpinner(this.zoomSpinnerModel);
        ZoomSpinnerChangeListener zoomSpinnerChangeListener = new ZoomSpinnerChangeListener();
        this.zoomSpinner.setValue(percentScale);
        this.zoomSpinner.setFont(MenuConstants.MenuItemFont);
        spinnerPanel.add(this.zoomSpinner);
        zoomPanel.add(spinnerPanel);
        JPanel buttonPanel = new JPanel();
        JButton okButton = new JButton("OK");
        JButton cancelButton = new JButton("Cancel");
        okButton.setActionCommand("OK Zoom");
        cancelButton.setActionCommand("Cancel Zoom");
        okButton.addActionListener(action);
        cancelButton.addActionListener(action);
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        Box box = Box.createVerticalBox();
        basePanel.add(box);
        box.add(Box.createVerticalStrut(5));
        box.add(zoomPanel);
        box.add(Box.createVerticalStrut(5));
        box.add(buttonPanel);
        box.add(Box.createVerticalStrut(5));
        this.zoomComboBox.addActionListener(action);
        this.zoomComboBox.setActionCommand("Zoom");
        this.zoomComboBox.addItemListener(zoomItemListener);
        this.zoomSpinner.addChangeListener(zoomSpinnerChangeListener);
        return basePanel;
    }
}

