/*
 * Decompiled with CFR 0.152.
 */
package menu;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.event.EventListenerList;
import menu.ColorSelectionEvent;
import menu.ColorSelectionListener;
import util.Util;

class ImportedColorsPanel
extends JComponent
implements MouseListener {
    protected EventListenerList listenerList = new EventListenerList();
    protected Color[] colors = new Color[0];
    protected boolean[] selected;
    Dimension numSwatches = new Dimension(10, 5);
    protected Dimension swatchSize = new Dimension(10, 10);
    protected Dimension gap = new Dimension(1, 1);
    protected Dimension margin = new Dimension(3, 3);
    int ctrl = 0;
    int debug = 0;

    public ImportedColorsPanel() {
        this.setToolTipText("");
        int width = this.numSwatches.width * (this.swatchSize.width + this.gap.width) + 2 * this.margin.width;
        int height = this.numSwatches.height * (this.swatchSize.height + this.gap.height) + 2 * this.margin.height;
        Dimension panaleSize = new Dimension(width, height);
        this.setPreferredSize(panaleSize);
        this.addMouseListener(this);
    }

    protected void setImportedColors(Color[] colors) {
        int i;
        int i2;
        int i3;
        Color[] newColors = new Color[this.colors.length + colors.length];
        for (i3 = 0; i3 < this.colors.length; ++i3) {
            newColors[i3] = this.colors[i3];
        }
        for (i3 = 0; i3 < colors.length; ++i3) {
            newColors[this.colors.length + i3] = colors[i3];
        }
        int[] rgb = new int[newColors.length];
        for (int i4 = 0; i4 < newColors.length; ++i4) {
            rgb[i4] = newColors[i4].getRGB();
        }
        int[] indice = Util.indexedSimpleSort(rgb);
        Color[] orderedColors = new Color[newColors.length];
        for (i2 = 0; i2 < newColors.length; ++i2) {
            orderedColors[i2] = newColors[indice[i2]];
        }
        if (this.debug > 0) {
            System.out.print("setImportedColors orderedColors=");
            for (i2 = 0; i2 < newColors.length; ++i2) {
                System.out.print(orderedColors[i2] + ", ");
            }
            System.out.println(" ");
        }
        int index = 0;
        int count = 0;
        for (int i5 = 1; i5 < orderedColors.length; ++i5) {
            int rgbRef = orderedColors[index].getRGB();
            if (orderedColors[i5].getRGB() == rgbRef) {
                orderedColors[i5] = null;
                ++count;
                continue;
            }
            index = i5;
        }
        Color[] newOrderedColors = new Color[orderedColors.length - count];
        int id = 0;
        for (i = orderedColors.length - 1; i >= 0; --i) {
            if (orderedColors[i] == null) continue;
            newOrderedColors[id] = orderedColors[i];
            ++id;
        }
        this.colors = newOrderedColors;
        this.selected = new boolean[this.colors.length];
        for (i = 0; i < this.colors.length; ++i) {
            this.selected[i] = false;
        }
        this.repaint();
    }

    protected void removeCurrentColors() {
        int i;
        int count = 0;
        for (int i2 = 0; i2 < this.colors.length; ++i2) {
            if (!this.selected[i2]) continue;
            ++count;
        }
        Color[] currentColors = new Color[this.colors.length - count];
        int id = 0;
        for (i = 0; i < this.colors.length; ++i) {
            if (this.selected[i]) continue;
            currentColors[id] = this.colors[i];
            ++id;
        }
        this.colors = currentColors;
        for (i = 0; i < this.colors.length; ++i) {
            this.selected[i] = false;
        }
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int id;
        double X = e.getX();
        double Y = e.getY();
        int key = e.getModifiersEx();
        this.ctrl = 0;
        if ((key & 0x40) != 0) {
            this.ctrl = 2;
        }
        if ((key & 0x80) != 0) {
            this.ctrl = 3;
        }
        if ((id = this.getColorIndex(X, Y)) >= 0 && id < this.colors.length) {
            Color color = this.colors[id];
            ColorSelectionEvent event = new ColorSelectionEvent(this, color);
            this.fireEvent(event);
            this.setSelected(id);
            this.repaint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    protected void setSelected(int id) {
        this.selected[id] = !this.selected[id];
        if (this.ctrl == 0) {
            for (int i = 0; i < this.colors.length; ++i) {
                if (i == id) continue;
                this.selected[i] = false;
            }
        }
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        int id = this.getColorIndex(e.getX(), e.getY());
        Color color = null;
        if (id >= 0 && id < this.colors.length) {
            color = this.colors[id];
            return "RGB: " + color.getRed() + ", " + color.getGreen() + ", " + color.getBlue();
        }
        color = null;
        return "";
    }

    protected int getColorIndex(double X, double Y) {
        double x = X - this.margin.getWidth();
        double y = Y - this.margin.getHeight();
        int ix = (int)(x / (double)(this.swatchSize.width + this.gap.width));
        int iy = (int)(y / (double)(this.swatchSize.height + this.gap.height));
        if (ix >= this.numSwatches.width || iy >= this.numSwatches.height) {
            return -1;
        }
        int id = ix + iy * this.numSwatches.width;
        if (this.debug > 0) {
            System.out.println("ImportedColorsPanel getColorIndex ix=" + ix + ", iy=" + iy + ", id=" + id);
        }
        return id;
    }

    protected void addColorSelectionListener(ColorSelectionListener listener) {
        this.listenerList.add(ColorSelectionListener.class, listener);
    }

    protected void removeColorSelectionListener(ColorSelectionListener listener) {
        this.listenerList.remove(ColorSelectionListener.class, listener);
    }

    protected void fireEvent(ColorSelectionEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != ColorSelectionListener.class) continue;
            ((ColorSelectionListener)listeners[i + 1]).colorSelected(event);
        }
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(Color.white);
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2.translate(this.margin.getWidth(), this.margin.getHeight());
        for (int row = 0; row < this.numSwatches.height; ++row) {
            int y = row * (this.swatchSize.height + this.gap.height);
            for (int column = 0; column < this.numSwatches.width; ++column) {
                Color color = this.getColorForCell(column, row);
                if (color == null) {
                    color = Color.white;
                }
                g2.setColor(color);
                int x = column * (this.swatchSize.width + this.gap.width);
                g2.fillRect(x, y, this.swatchSize.width, this.swatchSize.height);
                g2.setColor(Color.black);
                g2.drawLine(x + this.swatchSize.width - 1, y, x + this.swatchSize.width - 1, y + this.swatchSize.height - 1);
                g2.drawLine(x, y + this.swatchSize.height - 1, x + this.swatchSize.width - 1, y + this.swatchSize.height - 1);
            }
        }
        Color colorSave = g2.getColor();
        Stroke strokeSave = g2.getStroke();
        for (int row = 0; row < this.numSwatches.height; ++row) {
            int y = row * (this.swatchSize.height + this.gap.height);
            for (int column = 0; column < this.numSwatches.width; ++column) {
                int id = row * this.numSwatches.width + column;
                if (id >= this.colors.length || !this.selected[id]) continue;
                g2.setColor(Color.DARK_GRAY);
                BasicStroke stroke = new BasicStroke(1.5f, 1, 1);
                g2.setStroke(stroke);
                int x = column * (this.swatchSize.width + this.gap.width);
                Rectangle2D.Float rect = new Rectangle2D.Float(x, y, this.swatchSize.width, this.swatchSize.height);
                g2.draw(rect);
            }
        }
        g2.setColor(colorSave);
        g2.setStroke(strokeSave);
        int width = this.numSwatches.width * (this.swatchSize.width + this.gap.width);
        int height = this.numSwatches.height * (this.swatchSize.height + this.gap.height);
        g2.setColor(Color.black);
        g2.drawRect(0, 0, width, height);
        g2.translate(-this.margin.getWidth(), -this.margin.getHeight());
    }

    private Color getColorForCell(int column, int row) {
        int index = row * this.numSwatches.width + column;
        if (index < this.colors.length) {
            return this.colors[index];
        }
        return null;
    }
}

