/*
 * Decompiled with CFR 0.152.
 */
package menu;

import DrawTop.ObjectTable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JScrollPane;
import menu.DialogOfPageLayout;
import menu.MenuUtil;
import util.Util;

class PageLayoutListener
extends WindowAdapter
implements ComponentListener {
    DialogOfPageLayout dialog = null;
    int debug = 0;

    PageLayoutListener(DialogOfPageLayout dialog) {
        this.dialog = dialog;
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (this.debug > 0) {
            System.out.println("** Dialog componentResized called");
        }
        String componentName = e.getComponent().getClass().getSimpleName();
        if (this.debug > 1) {
            System.out.println(" - componentResized  componentName=" + componentName);
        }
        Dimension sizeOfDialog = this.dialog.getSize();
        Insets dialogInsets = this.dialog.getInsets();
        if (sizeOfDialog == null) {
            return;
        }
        JScrollPane scrollPane = this.dialog.getScrollPane();
        Dimension newSize = new Dimension((int)(sizeOfDialog.getWidth() - (double)dialogInsets.left - (double)dialogInsets.right), (int)(sizeOfDialog.getHeight() - (double)dialogInsets.top - (double)dialogInsets.bottom));
        scrollPane.setPreferredSize(newSize);
        if (this.debug > 1) {
            System.out.println(" - componentResized  sizeOfDialog=" + Util.Dim(sizeOfDialog) + ", newSize=" + Util.Dim(newSize));
        }
        this.dialog.getScrollPane().revalidate();
        this.dialog.validate();
        this.repaint();
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
        if (this.debug > 0) {
            System.out.println("** Dialog componentShown called");
        }
        this.dialog.setScrollViewPosition();
        this.repaint();
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.closeDialog();
    }

    private void closeDialog() {
        this.dialog.setVisible(false);
        MenuUtil menuUtil = ObjectTable.getMenuUtil();
        Component component = menuUtil.getMenuComponent(this.dialog.getName());
        if (component != null) {
            menuUtil.removeMenuComponent(component);
        }
    }

    private void repaint() {
        this.dialog.getScrollPane().repaint();
        this.dialog.repaint();
    }
}

