/*
 * Decompiled with CFR 0.152.
 */
package menu;

import DrawTop.DrawParameters;
import DrawTop.ObjectTable;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.AbstractAction;
import menu.DialogOfPageSetup;
import menu.MenuUtil;
import util.PageManager;

class PageSetupAction
extends AbstractAction
implements WindowListener {
    DialogOfPageSetup dialog = null;

    public PageSetupAction(DialogOfPageSetup dialog) {
        this.dialog = dialog;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int debug = MenuUtil.debug;
        String commandName = e.getActionCommand();
        String componentClassName = "";
        componentClassName = e.getSource().getClass().getSimpleName();
        String componentName = ((Component)e.getSource()).getName();
        if (debug > 0) {
            System.out.println("- PullDownMenuAction.actionPerformed  commandName=" + commandName + ", source component name=" + componentName + ", source class simple name=" + componentClassName);
        }
        if (commandName.equals("OK")) {
            System.out.println(" -- actionPerformed OK");
            String pageSize = (String)this.dialog.pageSizeSpinnerModel.getValue();
            int length = DrawParameters.SheetSizeString.length;
            int size = 0;
            for (int i = 0; i < length; ++i) {
                if (!pageSize.startsWith(DrawParameters.SheetSizeString[i])) continue;
                size = i;
                break;
            }
            int orientation = 0;
            if (this.dialog.portraitButton.isSelected()) {
                orientation = 1;
            }
            PageManager pageManager = ObjectTable.getPageManager();
            pageManager.pageSetup(size, orientation);
            this.closeDialog();
            return;
        }
        if (commandName.equals("Cancel")) {
            System.out.println(" -- actionPerformed Cancel");
            this.closeDialog();
            return;
        }
    }

    private void closeDialog() {
        this.dialog.setVisible(false);
        MenuUtil menuUtil = ObjectTable.getMenuUtil();
        Component component = menuUtil.getMenuComponent(this.dialog.getName());
        if (component != null) {
            menuUtil.removeMenuComponent(component);
        }
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.closeDialog();
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }
}

