/*
 * Decompiled with CFR 0.152.
 */
package shape;

import DrawTop.DrawPanel;

public class BlinkingShape
implements Runnable {
    DrawPanel drawPanel = null;
    private volatile Thread blinker = null;
    private int blinkingInterval = 250;
    private boolean isVisible = true;

    public BlinkingShape(DrawPanel drawPanel) {
        this.drawPanel = drawPanel;
    }

    @Override
    public void run() {
        Thread thisThread = Thread.currentThread();
        while (this.blinker == thisThread) {
            try {
                Thread.sleep(this.blinkingInterval);
            }
            catch (InterruptedException e) {
                System.out.println("BlinkingShape.run InterruptedException e=" + e);
            }
            this.drawPanel.repaint();
            this.isVisible = !this.isVisible;
        }
    }

    public void startBlinking() {
        if (this.blinker == null) {
            this.blinker = new Thread(this);
            this.blinker.start();
            this.isVisible = true;
        }
    }

    public void stopBlinking() {
        Thread tmpBlinker = this.blinker;
        this.blinker = null;
        if (tmpBlinker != null) {
            tmpBlinker.interrupt();
        }
        this.isVisible = false;
    }

    public boolean isVisible() {
        return this.isVisible;
    }
}

