/*
 * Decompiled with CFR 0.152.
 */
package shape;

import DrawTop.DrawParameters;
import geomExtension.Curve2D;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import shape.ShapeElement;

public class ConnectorMark {
    public void drawTargetMark(Graphics g, ShapeElement shapeElement) {
        Graphics2D g2 = (Graphics2D)g;
        double scale = DrawParameters.Scale;
        double markSize = 4.0 / scale;
        Rectangle2D.Double targetMark = new Rectangle2D.Double(-0.5 * markSize, -0.5 * markSize, markSize, markSize);
        Curve2D curve = shapeElement.getCurve2D();
        BasicStroke stroke = new BasicStroke((float)(1.5 / scale), 2, 0, 10.0f);
        Color currentColor = g2.getColor();
        AffineTransform currentTransform = g2.getTransform();
        Stroke currentStroke = g2.getStroke();
        g2.setStroke(stroke);
        double[] t = this.getTargetMarkPosition(shapeElement);
        for (int i = 0; i < t.length; ++i) {
            Point2D position = curve.getP(t[i]);
            double moveX = position.getX();
            double moveY = position.getY();
            g2.translate(moveX, moveY);
            g2.setColor(Color.WHITE);
            g2.draw(targetMark);
            g2.setColor(Color.RED);
            g2.fill(targetMark);
            g2.translate(-moveX, -moveY);
        }
        g2.setStroke(currentStroke);
        g2.setColor(currentColor);
        g2.setTransform(currentTransform);
    }

    public void drawConnectorMark(Graphics g, ShapeElement shapeElement) {
        Graphics2D g2 = (Graphics2D)g;
        double scale = DrawParameters.Scale;
        double markSize = 5.0 / scale;
        Rectangle2D.Double connectorMark = new Rectangle2D.Double(-0.5 * markSize, -0.5 * markSize, markSize, markSize);
        Curve2D curve = shapeElement.getCurve2D();
        BasicStroke stroke = new BasicStroke((float)(2.0 / scale), 2, 0, 10.0f);
        Color currentColor = g2.getColor();
        AffineTransform currentTransform = g2.getTransform();
        Stroke currentStroke = g2.getStroke();
        g2.setStroke(stroke);
        double[] t = this.getConnectorMarkPosition(shapeElement);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (int i = 0; i < t.length; ++i) {
            Point2D position = curve.getP(t[i]);
            double moveX = position.getX();
            double moveY = position.getY();
            g2.translate(moveX, moveY);
            g2.setColor(Color.WHITE);
            g2.fill(connectorMark);
            g2.setColor(Color.RED);
            g2.draw(connectorMark);
            g2.translate(-moveX, -moveY);
        }
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g2.setStroke(currentStroke);
        g2.setColor(currentColor);
        g2.setTransform(currentTransform);
    }

    private double[] getTargetMarkPosition(ShapeElement shapeElement) {
        double[] params = new double[]{};
        if (shapeElement.getTypeE() == 180) {
            return params;
        }
        Curve2D curve = shapeElement.getCurve2D();
        int numseg = curve.getNumOfSegments();
        int type = shapeElement.getTypeE();
        if (type == 43 || type == 46) {
            params = new double[]{0.5, 1.5, 2.5, 3.5};
        } else if (type == 44) {
            params = new double[]{0.5, 2.5, 4.5, 6.5};
        } else if (type == 45) {
            params = new double[]{0.0, 0.25, 0.5, 0.75};
        } else {
            params = new double[numseg];
            for (int i = 0; i < numseg; ++i) {
                params[i] = (double)i + 0.5;
            }
        }
        return params;
    }

    private double[] getConnectorMarkPosition(ShapeElement shapeElement) {
        double[] params = new double[]{};
        Curve2D curve = shapeElement.getCurve2D();
        if (curve == null) {
            return params;
        }
        int numseg = curve.getNumOfSegments();
        int type = shapeElement.getTypeE();
        if (type == 51) {
            params = new double[]{0.0, 1.0};
        } else if (type == 54 && !curve.isClosed()) {
            params = new double[]{0.0, numseg};
        }
        return params;
    }
}

