/*
 * Decompiled with CFR 0.152.
 */
package shape;

import DrawTop.DrawPanel;
import DrawTop.DrawParameters;
import DrawTop.ObjectTable;
import geomExtension.Curve2D;
import geomExtension.CurvePT;
import geomExtension.Line2DE;
import geomExtension.Polyline2DE;
import geomExtension.Segment2D;
import geomExtension.Vector2D;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import shape.ArrowShape;
import shape.BlinkingShape;
import shape.ImageElement;
import shape.PaintStyle;
import shape.SegmentModifier;
import shape.ShapeContainer;
import shape.ShapeElement;
import shape.ShapeElementUtil;
import shape.TempShape;

public class DrawShapeUtil {
    static Color boxColor = new Color(0x9900FF);
    static DrawPanel drawPanel = ObjectTable.getDrawPanel();
    static int debug = 0;

    public static void drawShapeElement(Graphics g, ShapeContainer shapeContainer) {
        ShapeElement shapeElement = shapeContainer.getElement();
        int type = shapeElement.getTypeE();
        boolean closed = shapeElement.isClosed();
        if (!(type != 51 && type != 54 || closed)) {
            DrawShapeUtil.drawLineElement(g, shapeContainer);
        } else if (type == 46) {
            DrawShapeUtil.drawImageElement(g, shapeContainer);
        } else {
            DrawShapeUtil.drawStandardElement(g, shapeContainer);
        }
        DrawShapeUtil.drawConnectorMark(g, shapeContainer);
        DrawShapeUtil.drawNodeMark(g, shapeContainer);
        DrawShapeUtil.drawCharacteristicMark(g, shapeContainer);
    }

    private static void drawStandardElement(Graphics g, ShapeContainer shapeContainer) {
        Graphics2D g2 = (Graphics2D)g;
        ShapeElement shapeElement = shapeContainer.getElement();
        Curve2D curve2D = shapeElement.getCurve2D();
        PaintStyle paintStyle = shapeContainer.getPaintStyle();
        boolean blinking = shapeContainer.isBlinking();
        BlinkingShape blinkingShape = ObjectTable.getBlinkingShape();
        if (curve2D == null) {
            return;
        }
        Rectangle currentClip = g2.getClipBounds();
        Color currentColor = g2.getColor();
        Stroke currentStroke = g2.getStroke();
        double lineWidth = paintStyle.getLineWidth();
        double enLarge = 0.5 * lineWidth + 10.0;
        Rectangle2D enlargedBoundingBox = ShapeElementUtil.getEnlargedRectangle(shapeElement.getBoundingBox(), enLarge, enLarge);
        if (enlargedBoundingBox != null) {
            g2.setClip(enlargedBoundingBox);
        }
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color fillColor = paintStyle.getFillColor();
        g2.setColor(fillColor);
        if (curve2D.isClosed() && fillColor != null && (!blinking || blinkingShape.isVisible())) {
            g2.fill(curve2D.getShape());
        }
        Stroke stroke = paintStyle.getLineStroke();
        g2.setStroke(stroke);
        Color lineColor = paintStyle.getLineColor();
        g2.setColor(lineColor);
        if (curve2D != null && lineColor != null && (!blinking || blinkingShape.isVisible())) {
            g2.draw(curve2D.getShape());
        }
        if (DrawParameters.DRAW_BOUNDINGBOX) {
            g2.setColor(boxColor);
            g2.setStroke(currentStroke);
            g2.draw(curve2D.getBoundingBox());
            g2.setColor(currentColor);
        }
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        DrawShapeUtil.drawClosedMessage(g, shapeContainer);
        g2.setStroke(currentStroke);
        g2.setColor(currentColor);
        g2.setClip(currentClip);
    }

    private static void drawImageElement(Graphics g, ShapeContainer shapeContainer) {
        Graphics2D g2 = (Graphics2D)g;
        ShapeElement shapeElement = shapeContainer.getElement();
        Curve2D curve2D = shapeElement.getCurve2D();
        ImageElement imageElement = (ImageElement)shapeElement;
        PaintStyle paintStyle = shapeContainer.getPaintStyle();
        boolean blinking = shapeContainer.isBlinking();
        BlinkingShape blinkingShape = ObjectTable.getBlinkingShape();
        if (curve2D == null) {
            return;
        }
        Rectangle currentClip = g2.getClipBounds();
        Color currentColor = g2.getColor();
        Stroke currentStroke = g2.getStroke();
        double lineWidth = paintStyle.getLineWidth();
        double enLarge = 0.5 * lineWidth + 10.0;
        Rectangle2D enlargedBoundingBox = ShapeElementUtil.getEnlargedRectangle(shapeElement.getBoundingBox(), enLarge, enLarge);
        if (enlargedBoundingBox != null) {
            g2.setClip(enlargedBoundingBox);
        }
        g2.setColor(Color.WHITE);
        if (!blinking || blinkingShape.isVisible()) {
            g2.fill(curve2D.getShape());
        }
        g2.setColor(currentColor);
        Rectangle2D shrinkedRect = ShapeElementUtil.getShrinkedRectangle(curve2D.getBoundingBox(), lineWidth, lineWidth);
        if (shrinkedRect != null) {
            g.drawImage(imageElement.getBufferedImage(), (int)shrinkedRect.getX(), (int)shrinkedRect.getY(), (int)shrinkedRect.getWidth(), (int)shrinkedRect.getHeight(), null);
        }
        shrinkedRect = ShapeElementUtil.getShrinkedRectangle(curve2D.getBoundingBox(), 0.5 * lineWidth, 0.5 * lineWidth);
        Stroke stroke = paintStyle.getLineStroke();
        g2.setStroke(stroke);
        Color lineColor = paintStyle.getLineColor();
        g2.setColor(lineColor);
        if (shrinkedRect != null && (!blinking || blinkingShape.isVisible())) {
            g2.draw(shrinkedRect);
        }
        g2.setStroke(currentStroke);
        g2.setColor(currentColor);
        g2.setClip(currentClip);
    }

    private static void drawLineElement(Graphics g, ShapeContainer shapeContainer) {
        Graphics2D g2 = (Graphics2D)g;
        ShapeElement shapeElement = shapeContainer.getElement();
        Curve2D curve2D = shapeElement.getCurve2D();
        PaintStyle paintStyle = shapeContainer.getPaintStyle();
        boolean blinking = shapeContainer.isBlinking();
        BlinkingShape blinkingShape = ObjectTable.getBlinkingShape();
        if (curve2D == null) {
            return;
        }
        Rectangle currentClip = g2.getClipBounds();
        Color currentColor = g2.getColor();
        Stroke currentStroke = g2.getStroke();
        double lineWidth = paintStyle.getLineWidth();
        double enLarge = 0.5 * lineWidth + 10.0;
        Rectangle2D enlargedBoundingBox = ShapeElementUtil.getEnlargedRectangle(shapeElement.getBoundingBox(), enLarge, enLarge);
        if (enlargedBoundingBox != null) {
            g2.setClip(enlargedBoundingBox);
        }
        Color fillColor = shapeElement.getShapeContainer().getPaintStyle().getFillColor();
        g2.setColor(fillColor);
        if (curve2D.isClosed() && fillColor != null && (!blinking || blinkingShape.isVisible())) {
            g2.fill(curve2D.getShape());
        }
        Stroke stroke = paintStyle.getLineStroke();
        g2.setStroke(stroke);
        Color lineColor = paintStyle.getLineColor();
        g2.setColor(lineColor);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (!blinking || blinkingShape.isVisible()) {
            DrawShapeUtil.drawLine(g, shapeContainer);
        }
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        if (DrawParameters.DRAW_BOUNDINGBOX) {
            g2.setColor(boxColor);
            g2.setStroke(currentStroke);
            g2.draw(curve2D.getBoundingBox());
            g2.setColor(currentColor);
        }
        DrawShapeUtil.drawClosedMessage(g, shapeContainer);
        g2.setStroke(currentStroke);
        g2.setColor(currentColor);
        g2.setClip(currentClip);
    }

    private static void drawClosedMessage(Graphics g, ShapeContainer shapeContainer) {
        ShapeElement shapeElement = shapeContainer.getElement();
        int type = shapeElement.getTypeE();
        if (type != 54 && type != 55 && type != 56) {
            return;
        }
        int mode = shapeElement.getShapeContainer().getMode();
        Color currentColor = null;
        Graphics2D g2 = (Graphics2D)g;
        Curve2D curve2D = shapeElement.getCurve2D();
        int numseg = curve2D.getNumOfSegments();
        double dist = Vector2D.dist(new Vector2D(curve2D.getP(0.0)), new Vector2D(curve2D.getP(numseg)));
        DrawShapeUtil.clearTempShape("ClosedMessage");
        if (numseg > 1 && dist < 3.0) {
            currentColor = g2.getColor();
            g2.setColor(Color.red);
            Rectangle2D box = curve2D.getBoundingBox();
            Rectangle2D.Double mark = new Rectangle2D.Double(box.getCenterX(), box.getCenterY(), 0.0, 0.0);
            int x = (int)(box.getX() + 0.5 * box.getWidth() - 10.0);
            int y = (int)(box.getY() + 0.5 * box.getHeight() - 10.0);
            g2.setFont(DrawParameters.Font14Plain);
            Point2D.Double messagePoint = null;
            if (mode == 1 || mode == 4 || mode == 5) {
                messagePoint = new Point2D.Double(box.getCenterX() - 10.0, box.getCenterY());
                DrawShapeUtil.drawTempShape("ClosedMessage", mark, null, null, null, "closed !", messagePoint, Color.RED);
            }
            if (mode == 1) {
                messagePoint = new Point2D.Double(box.getCenterX() - 130.0, box.getCenterY() + 16.0);
                DrawShapeUtil.drawTempShape("ClosedMessage", null, null, null, null, "Recommend right button click to finish", messagePoint, Color.RED);
                messagePoint = new Point2D.Double(box.getCenterX() - 130.0, box.getCenterY() + 32.0);
                DrawShapeUtil.drawTempShape("ClosedMessage", null, null, null, null, "You can always add a text box by 'util- add text box' menu", messagePoint, Color.RED);
            }
            g2.setColor(currentColor);
        }
    }

    private static void drawLine(Graphics g, ShapeContainer shapeContainer) {
        ArrowShape arrow;
        Graphics2D g2 = (Graphics2D)g;
        ShapeElement shapeElement = shapeContainer.getElement();
        PaintStyle paintStyle = shapeElement.getShapeContainer().getPaintStyle();
        Color currentColor = g2.getColor();
        g2.setStroke(paintStyle.getDefaultStroke());
        Stroke currentStroke = g2.getStroke();
        Stroke stroke = paintStyle.getLineStroke();
        g2.setStroke(stroke);
        Color lineColor = paintStyle.getLineColor();
        g2.setColor(lineColor);
        Curve2D line = shapeElement.getCurve2D();
        if (paintStyle.startArrowType > 0 || paintStyle.endArrowType > 0) {
            line = DrawShapeUtil.getTrimmedLine(shapeContainer);
        }
        if (line != null) {
            g2.draw(line.getShape());
        }
        Stroke arrowStroke = paintStyle.getArrowStroke();
        g2.setStroke(arrowStroke);
        Polyline2DE arrowShape = null;
        if (paintStyle.startArrowType > 0) {
            arrow = DrawShapeUtil.createArrowShape(0, shapeContainer);
            arrowShape = arrow.getArrowShape();
            if (paintStyle.startArrowType == 2) {
                g2.fill(arrowShape.getShape());
            }
            if (paintStyle.startArrowType >= 1) {
                g2.draw(arrowShape.getShape());
            }
        }
        if (paintStyle.endArrowType > 0) {
            arrow = DrawShapeUtil.createArrowShape(1, shapeContainer);
            arrowShape = arrow.getArrowShape();
            if (paintStyle.endArrowType == 2) {
                g2.fill(arrowShape.getShape());
            }
            if (paintStyle.endArrowType >= 1) {
                g2.draw(arrowShape.getShape());
            }
        }
        g2.setStroke(currentStroke);
        g2.setColor(currentColor);
    }

    private static Curve2D getTrimmedLine(ShapeContainer shapeContainer) {
        ShapeElement shapeElement = shapeContainer.getElement();
        PaintStyle paintStyle = shapeContainer.getPaintStyle();
        double startTrim = 0.0;
        double endTrim = 0.0;
        double trimFactor = 1.0 / Math.tan(0.3490658503988659);
        if (paintStyle.startArrowType > 0) {
            if (paintStyle.startArrowType == 1) {
                startTrim = 0.6 * (double)paintStyle.lineWidth * trimFactor;
            }
            if (paintStyle.startArrowType == 2) {
                startTrim = 0.6 * (double)paintStyle.lineWidth * trimFactor;
            }
        }
        if (paintStyle.endArrowType > 0) {
            if (paintStyle.endArrowType == 1) {
                endTrim = 0.6 * (double)paintStyle.lineWidth * trimFactor;
            }
            if (paintStyle.endArrowType == 2) {
                endTrim = 0.6 * (double)paintStyle.lineWidth * trimFactor;
            }
        }
        int type = shapeElement.getTypeE();
        Curve2D newLine = null;
        if (type == 51) {
            Line2DE line = (Line2DE)shapeElement.getCurve2D();
            newLine = line.getTrimmedLine(startTrim, endTrim);
        }
        if (type == 54) {
            Polyline2DE polyLine = (Polyline2DE)shapeElement.getCurve2D();
            newLine = polyLine.getTrimmedPolyline(startTrim, endTrim);
        }
        if (debug > 0) {
            System.out.println("++ PaintStyleUtility startArrowType=" + paintStyle.startArrowType + ", endArrowType=" + paintStyle.endArrowType + ", cutLengthAtStart=" + startTrim + ", endTrim=" + endTrim);
        }
        return newLine;
    }

    private static ArrowShape createArrowShape(int position, ShapeContainer shapeContainer) {
        ShapeElement shapeElement = shapeContainer.getElement();
        PaintStyle paintStyle = shapeElement.getShapeContainer().getPaintStyle();
        Vector2D pt = null;
        Vector2D tangent = null;
        Curve2D curve = shapeElement.getCurve2D();
        int numSeg = curve.getNumOfSegments();
        double t = 0.0;
        if (position == 1) {
            t = numSeg;
        }
        pt = new Vector2D(curve.getP(t));
        tangent = curve.getTangent(t);
        if (position == 0) {
            tangent = Vector2D.multiply(-1.0, tangent);
        }
        int arrowtype = paintStyle.startArrowType;
        if (position == 1) {
            arrowtype = paintStyle.endArrowType;
        }
        ArrowShape arrow = new ArrowShape(arrowtype, paintStyle.lineWidth, pt, tangent);
        return arrow;
    }

    private static void drawNodeMark(Graphics g, ShapeContainer shapeContainer) {
        Graphics2D g2 = (Graphics2D)g;
        ShapeElement shapeElement = shapeContainer.getElement();
        Curve2D curve = shapeElement.getCurve2D();
        if (!DrawParameters.DRAW_NODE_POINTS) {
            return;
        }
        if (shapeElement == null || curve == null) {
            return;
        }
        int type = shapeElement.getTypeE();
        if (type != 54 && type != 55 && type != 56) {
            return;
        }
        double scale = DrawParameters.Scale;
        double markSize = 4.0 / scale;
        Rectangle2D.Double nodeMark = new Rectangle2D.Double(-0.5 * markSize, -0.5 * markSize, markSize, markSize);
        BasicStroke stroke = new BasicStroke((float)(1.5 / scale), 2, 0, 10.0f);
        Color currentColor = g2.getColor();
        AffineTransform currentTransform = g2.getTransform();
        Stroke currentStroke = g2.getStroke();
        g2.setStroke(stroke);
        int numSeg = 0;
        numSeg = curve.getNumOfSegments();
        for (int i = 0; i <= numSeg; ++i) {
            Point2D position = curve.getP(i);
            double moveX = position.getX();
            double moveY = position.getY();
            g2.translate(moveX, moveY);
            g2.setColor(Color.WHITE);
            g2.draw(nodeMark);
            g2.setColor(Color.BLUE);
            g2.fill(nodeMark);
            g2.translate(-moveX, -moveY);
        }
        g2.setStroke(currentStroke);
        g2.setColor(currentColor);
        g2.setTransform(currentTransform);
    }

    private static void drawCharacteristicMark(Graphics g, ShapeContainer shapeContainer) {
        Graphics2D g2 = (Graphics2D)g;
        ShapeElement shapeElement = shapeContainer.getElement();
        Curve2D curve = shapeElement.getCurve2D();
        if (!DrawParameters.DRAW_CHARACTERISTIC_POINTS) {
            return;
        }
        if (shapeElement == null || curve == null) {
            return;
        }
        double scale = DrawParameters.Scale;
        double markSize = 4.0 / scale;
        Rectangle2D.Double nodeMark = new Rectangle2D.Double(-0.5 * markSize, -0.5 * markSize, markSize, markSize);
        BasicStroke stroke = new BasicStroke((float)(1.5 / scale), 2, 0, 10.0f);
        Color currentColor = g2.getColor();
        AffineTransform currentTransform = g2.getTransform();
        Stroke currentStroke = g2.getStroke();
        g2.setStroke(stroke);
        CurvePT[] curvePTs = curve.getCharacteristicPoints();
        for (int i = 0; i < curvePTs.length; ++i) {
            Point2D position = curvePTs[i].getP();
            double t = curvePTs[i].getParameter();
            double moveX = position.getX();
            double moveY = position.getY();
            g2.translate(moveX, moveY);
            if (Math.abs(t - (double)((int)t)) < 1.0E-12) {
                g2.setColor(Color.WHITE);
                g2.draw(nodeMark);
                g2.setColor(Color.BLUE);
                g2.fill(nodeMark);
            } else {
                g2.setColor(Color.WHITE);
                g2.draw(nodeMark);
                g2.setColor(Color.BLUE);
                g2.fill(nodeMark);
            }
            g2.translate(-moveX, -moveY);
        }
        g2.setStroke(currentStroke);
        g2.setColor(currentColor);
        g2.setTransform(currentTransform);
    }

    private static void drawConnectorMark(Graphics g, ShapeContainer shapeContainer) {
        Graphics2D g2 = (Graphics2D)g;
        ShapeElement shapeElement = shapeContainer.getElement();
    }

    public static void drawSelection(Graphics g, ShapeContainer shapeContainer) {
        ShapeElement shapeElement = shapeContainer.getElement();
        int type = shapeElement.getTypeE();
        if (type == 51) {
            DrawShapeUtil.drawLineSelection(g, shapeContainer);
        } else {
            DrawShapeUtil.drawSelectionBox(g, shapeContainer);
        }
    }

    private static void drawSelectionBox(Graphics g, ShapeContainer shapeContainer) {
        Graphics2D g2 = (Graphics2D)g;
        if (DrawParameters.DrawMode != 0) {
            return;
        }
        boolean unmovable = false;
        String from = "DrawShapeUtil";
        boolean resizable = shapeContainer.getBooleanProperty("Enable_Resizing", from);
        boolean aspectRatio = shapeContainer.getBooleanProperty("Keep_Aspect_Ratio", from);
        boolean connector = shapeContainer.getBooleanProperty("Keep_Connector_Connections", from);
        boolean ungrouping = shapeContainer.getBooleanProperty("Enable_Ungrouping", from);
        ShapeElement shapeElement = shapeContainer.getElement();
        double scale = DrawParameters.Scale;
        Font smallFont = new Font("Dialog", 0, (int)(12.0 / scale));
        double offset = 6.0 / scale;
        double markNSize = 6.0 / scale;
        double markSSize = 4.0 / scale;
        float linewidth = (float)(1.0 / scale);
        Stroke defaultStroke10 = PaintStyle.getDefaultStroke(linewidth);
        linewidth = (float)(1.5 / scale);
        Stroke defaultStroke15 = PaintStyle.getDefaultStroke(linewidth);
        Rectangle2D boundingBox = shapeElement.getBoundingBox();
        if (boundingBox == null || boundingBox.getWidth() == 0.0 && boundingBox.getHeight() == 0.0) {
            return;
        }
        Rectangle2D selectionBox = ShapeElementUtil.getEnlargedRectangle(boundingBox, offset, offset);
        double X = selectionBox.getX();
        double Y = selectionBox.getY();
        double W = selectionBox.getWidth();
        double H = selectionBox.getHeight();
        double markSize = markNSize;
        double halfMarkSize = markSize / 2.0;
        Color markFillColor = Color.white;
        Color markLineColor = Color.black;
        int type = shapeElement.getTypeE();
        if (type == 54 || type == 55 || type == 56) {
            Curve2D[] curves = shapeElement.getCurve2D().getSubPaths();
            for (int i = 0; i < curves.length; ++i) {
                if (curves[i].isClosed()) continue;
                Point2D startPT = curves[i].getP(0.0);
                int nseg = curves[i].getNumOfSegments();
                Point2D endPT = curves[i].getP(nseg);
                g2.setStroke(defaultStroke15);
                if (unmovable || !resizable || aspectRatio) {
                    markFillColor = Color.DARK_GRAY;
                    markLineColor = Color.DARK_GRAY;
                    g2.setStroke(defaultStroke10);
                    markSize = markSSize;
                }
                Rectangle2D.Double mark = new Rectangle2D.Double(0.0, 0.0, markSize, markSize);
                double x = startPT.getX() - halfMarkSize;
                double y = startPT.getY() - halfMarkSize;
                Stroke currentStroke = g2.getStroke();
                g2.setStroke(defaultStroke15);
                g2.translate(x, y);
                g2.setColor(markFillColor);
                g2.fill(mark);
                g2.setColor(markLineColor);
                g2.draw(mark);
                g2.translate(-x, -y);
                x = endPT.getX() - halfMarkSize;
                y = endPT.getY() - halfMarkSize;
                g2.translate(x, y);
                g2.setColor(markFillColor);
                g2.fill(mark);
                g2.setColor(markLineColor);
                g2.draw(mark);
                g2.translate(-x, -y);
                g2.setStroke(currentStroke);
            }
        }
        markSize = markNSize;
        halfMarkSize = markSize / 2.0;
        Color currentColor = g2.getColor();
        g2.setColor(Color.LIGHT_GRAY);
        Composite currentComposit = g2.getComposite();
        float alfa = ((AlphaComposite)currentComposit).getAlpha();
        AlphaComposite ac = AlphaComposite.getInstance(3, 0.5f * alfa);
        g2.setComposite(ac);
        Stroke currentStroke = g2.getStroke();
        if (!unmovable) {
            Rectangle2D.Double selectionFrame = new Rectangle2D.Double(X - halfMarkSize, Y - halfMarkSize, W, markSize);
            g2.fill(selectionFrame);
            selectionFrame = new Rectangle2D.Double(X - halfMarkSize, Y + H - halfMarkSize, W, markSize);
            g2.fill(selectionFrame);
            selectionFrame = new Rectangle2D.Double(X - halfMarkSize, Y - halfMarkSize, markSize, H + markSize);
            g2.fill(selectionFrame);
            selectionFrame = new Rectangle2D.Double(X + W - halfMarkSize, Y - halfMarkSize, markSize, H + markSize);
            g2.fill(selectionFrame);
        } else {
            g2.setColor(Color.DARK_GRAY);
            g2.setStroke(defaultStroke15);
            g2.draw(selectionBox);
        }
        g2.setComposite(currentComposit);
        g2.setColor(currentColor);
        g2.setStroke(currentStroke);
        if (unmovable || !resizable || aspectRatio || !connector || !ungrouping) {
            Font currentFont = g2.getFont();
            g2.setColor(Color.RED);
            g2.setFont(smallFont);
            float xx = (float)(X + halfMarkSize + 5.0);
            float yy = (float)(Y + H + halfMarkSize);
            String str = "";
            if (unmovable) {
                str = "unable moving";
                g2.drawString(str, xx, yy);
                yy += (float)(16.0 / scale);
            }
            if (!resizable) {
                str = "unable resizing";
                g2.drawString(str, xx, yy);
                yy += (float)(16.0 / scale);
            }
            if (aspectRatio) {
                str = "keep aspect ratio";
                g2.drawString(str, xx, yy);
                yy += (float)(16.0 / scale);
            }
            if (!connector) {
                str = "ignore connectors";
                g2.drawString(str, xx, yy);
                yy += (float)(16.0 / scale);
            }
            if (!ungrouping) {
                str = "unable ungrouping";
                g2.drawString(str, xx, yy);
            }
            g2.setFont(currentFont);
            g2.setColor(currentColor);
        }
        markLineColor = Color.BLACK;
        markFillColor = Color.WHITE;
        AffineTransform currentTransform = g2.getTransform();
        if (resizable) {
            g2.setStroke(defaultStroke10);
            Ellipse2D.Double circle = new Ellipse2D.Double(X - halfMarkSize, Y - halfMarkSize, markSize, markSize);
            g2.setColor(markFillColor);
            g2.fill(circle);
            g2.translate(W, 0.0);
            g2.fill(circle);
            g2.translate(0.0, H);
            g2.fill(circle);
            g2.translate(-W, 0.0);
            g2.fill(circle);
            g2.translate(0.0, -H);
            g2.setColor(markLineColor);
            g2.draw(circle);
            g2.translate(W, 0.0);
            g2.draw(circle);
            g2.translate(0.0, H);
            g2.draw(circle);
            g2.translate(-W, 0.0);
            g2.draw(circle);
            g2.translate(0.0, -H);
        }
        if (resizable && !aspectRatio) {
            Rectangle2D.Double rect = new Rectangle2D.Double(X + 0.5 * W - halfMarkSize, Y - halfMarkSize, markSize, markSize);
            g2.setColor(markFillColor);
            g2.fill(rect);
            g2.translate(0.5 * W, 0.5 * H);
            g2.fill(rect);
            g2.translate(-0.5 * W, 0.5 * H);
            g2.fill(rect);
            g2.translate(-0.5 * W, -0.5 * H);
            g2.fill(rect);
            g2.translate(0.5 * W, -0.5 * H);
            g2.setColor(markLineColor);
            g2.draw(rect);
            g2.translate(0.5 * W, 0.5 * H);
            g2.draw(rect);
            g2.translate(-0.5 * W, 0.5 * H);
            g2.draw(rect);
            g2.translate(-0.5 * W, -0.5 * H);
            g2.draw(rect);
            g2.translate(0.5 * W, -0.5 * H);
            g2.setTransform(currentTransform);
            g2.setColor(currentColor);
        }
    }

    private static void drawLineSelection(Graphics g, ShapeContainer shapeContainer) {
        Graphics2D g2 = (Graphics2D)g;
        if (DrawParameters.DrawMode != 0) {
            return;
        }
        boolean unmovable = false;
        String from = "DrawShapeUtil";
        boolean resizable = shapeContainer.getBooleanProperty("Enable_Resizing", from);
        boolean lineDirection = shapeContainer.getBooleanProperty("Keep_Line_Direction", from);
        boolean connector = shapeContainer.getBooleanProperty("Keep_Connector_Connections", from);
        ShapeElement shapeElement = shapeContainer.getElement();
        PaintStyle paintStyle = shapeElement.getShapeContainer().getPaintStyle();
        double scale = DrawParameters.Scale;
        Font smallFont = new Font("Dialog", 0, (int)(12.0 / scale));
        double markNSize = 6.0 / scale;
        double markSSize = 4.0 / scale;
        float linewidth10 = (float)(1.0 / scale);
        Stroke defaultStroke10 = PaintStyle.getDefaultStroke(linewidth10);
        float linewidth15 = (float)(1.5 / scale);
        Stroke defaultStroke15 = PaintStyle.getDefaultStroke(linewidth15);
        AlphaComposite ac = AlphaComposite.getInstance(3, 0.5f);
        Line2DE line = (Line2DE)shapeElement.getCurve2D();
        if (line == null) {
            return;
        }
        double X1 = line.getX1();
        double Y1 = line.getY1();
        double X2 = line.getX2();
        double Y2 = line.getY2();
        Stroke currentStroke = g2.getStroke();
        Composite currentComposit = g2.getComposite();
        g2.setColor(paintStyle.getLineColor());
        Color markFillColor = Color.WHITE;
        Color markLineColor = Color.BLACK;
        Color currentColor = g2.getColor();
        g2.setStroke(defaultStroke15);
        double markSize = markNSize;
        if (unmovable || !resizable) {
            markFillColor = Color.DARK_GRAY;
            markLineColor = Color.DARK_GRAY;
            g2.setColor(paintStyle.getLineColor());
            markSize = markSSize;
        }
        Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, markSize, markSize);
        double halfMarkSize = 0.5 * markSize;
        double x = X1 - halfMarkSize;
        double y = Y1 - halfMarkSize;
        g2.setColor(markFillColor);
        g2.translate(x, y);
        g2.fill(rect);
        g2.setColor(markLineColor);
        g2.draw(rect);
        g2.translate(-x, -y);
        x = X2 - halfMarkSize;
        y = Y2 - halfMarkSize;
        g2.setColor(markFillColor);
        g2.translate(x, y);
        g2.fill(rect);
        g2.setColor(markLineColor);
        g2.draw(rect);
        g2.translate(-x, -y);
        double X = 0.5 * (X1 + X2);
        double Y = 0.5 * (Y1 + Y2);
        if (unmovable || !resizable || lineDirection || !connector) {
            Font currentFont = g2.getFont();
            g2.setColor(Color.RED);
            g2.setFont(smallFont);
            float xx = (float)(X - 30.0 / scale);
            float yy = (float)Y;
            String str = "";
            if (unmovable) {
                str = "unable moving";
                g2.drawString(str, xx, yy);
                yy += (float)(16.0 / scale);
            }
            if (!resizable) {
                str = "unable resizing";
                g2.drawString(str, xx, yy);
                yy += (float)(16.0 / scale);
            }
            if (lineDirection) {
                str = "keep line direction";
                g2.drawString(str, xx, yy);
                yy += (float)(16.0 / scale);
            }
            if (!connector) {
                str = "ignore connectors";
                g2.drawString(str, xx, yy);
            }
            g2.setFont(currentFont);
            g2.setColor(currentColor);
        }
        g2.setComposite(currentComposit);
        g2.setColor(currentColor);
        g2.setStroke(currentStroke);
    }

    public static void drawSegmentModifiers(Graphics g, ShapeContainer shapeContainer) {
        double y;
        double x;
        int type;
        int i;
        Graphics2D g2 = (Graphics2D)g;
        ShapeElement element = shapeContainer.getElement();
        double scale = DrawParameters.Scale;
        double markSize = 4.0 / scale;
        double halfMarkSize = markSize / 2.0;
        Color markFillColor = Color.BLUE;
        Color markLineColor = Color.BLUE;
        float linewidth = (float)(1.0 / scale);
        Stroke defaultStroke10 = PaintStyle.getDefaultStroke(linewidth);
        Rectangle2D.Double mark = new Rectangle2D.Double(0.0, 0.0, markSize, markSize);
        Color currentColor = g2.getColor();
        Stroke currentStroke = g2.getStroke();
        AffineTransform currentTransform = g2.getTransform();
        Rectangle2D boundingBox = element.getBoundingBox();
        boundingBox = ShapeElementUtil.getEnlargedRectangle(boundingBox, 4.0, 4.0);
        g2.setStroke(defaultStroke10);
        g2.setColor(Color.LIGHT_GRAY);
        g2.draw(boundingBox);
        g2.setTransform(currentTransform);
        SegmentModifier[] modifiers = element.getSegmentModifiers();
        int size = 0;
        if (modifiers != null) {
            size = modifiers.length;
        }
        Point2D PT = null;
        Object shape = null;
        g2.setColor(Color.BLUE);
        for (i = 0; i < size; ++i) {
            type = modifiers[i].getType();
            if (type != 1) continue;
            x = modifiers[i].getP().getX() - halfMarkSize;
            y = modifiers[i].getP().getY() - halfMarkSize;
            g2.translate(x, y);
            g2.setColor(markFillColor);
            g2.fill(mark);
            g2.setColor(markLineColor);
            g2.draw(mark);
            g2.translate(-x, -y);
        }
        for (i = 0; i < size; ++i) {
            type = modifiers[i].getType();
            if (type != 2 || (PT = modifiers[i].getP()) == null) continue;
            x = PT.getX() - halfMarkSize;
            y = PT.getY() - halfMarkSize;
            g2.translate(x, y);
            g2.setColor(Color.WHITE);
            g2.fill(mark);
            g2.setColor(markLineColor);
            g2.draw(mark);
            g2.translate(-x, -y);
        }
        for (i = 0; i < size; ++i) {
            Line2D line;
            int jointType;
            type = modifiers[i].getType();
            if (type != 3 || (jointType = modifiers[i].getJointType()) != 4 && jointType != 5) continue;
            Segment2D tangentIn = modifiers[i].getTangentIn();
            Segment2D tangentOut = modifiers[i].getTangentOut();
            if (tangentIn != null && Vector2D.dist((line = (Line2D)tangentIn.getShape()).getP1(), line.getP2()) > 0.1) {
                g2.draw(line);
            }
            if (jointType != 5 || tangentOut == null || !(Vector2D.dist((line = (Line2D)tangentOut.getShape()).getP1(), line.getP2()) > 0.1)) continue;
            g2.draw(line);
        }
        for (i = 0; i < size; ++i) {
            double y2;
            double x2;
            type = modifiers[i].getType();
            if (type != 3) continue;
            PT = modifiers[i].getTinP1();
            if (PT != null) {
                x2 = PT.getX() - halfMarkSize;
                y2 = PT.getY() - halfMarkSize;
                g2.translate(x2, y2);
                g2.setColor(Color.WHITE);
                g2.fill(mark);
                g2.setColor(markLineColor);
                g2.draw(mark);
                g2.translate(-x2, -y2);
            }
            if ((PT = modifiers[i].getTinP2()) != null) {
                x2 = PT.getX() - halfMarkSize;
                y2 = PT.getY() - halfMarkSize;
                g2.translate(x2, y2);
                g2.setColor(Color.WHITE);
                g2.fill(mark);
                g2.setColor(markLineColor);
                g2.draw(mark);
                g2.translate(-x2, -y2);
            }
            if (modifiers[i].getJointType() != 5) continue;
            PT = modifiers[i].getToutP1();
            if (PT != null) {
                x2 = PT.getX() - halfMarkSize;
                y2 = PT.getY() - halfMarkSize;
                g2.translate(x2, y2);
                g2.setColor(Color.WHITE);
                g2.fill(mark);
                g2.setColor(markLineColor);
                g2.draw(mark);
                g2.translate(-x2, -y2);
            }
            if ((PT = modifiers[i].getToutP2()) == null) continue;
            x2 = PT.getX() - halfMarkSize;
            y2 = PT.getY() - halfMarkSize;
            g2.translate(x2, y2);
            g2.setColor(Color.WHITE);
            g2.fill(mark);
            g2.setColor(markLineColor);
            g2.draw(mark);
            g2.translate(-x2, -y2);
        }
        g2.setColor(currentColor);
        g2.setStroke(currentStroke);
    }

    public static void drawTempShape(String id, Point2D point, int size, String message, Color color) {
        double scale = DrawParameters.getScale();
        int markSize = 4;
        if (size > 0) {
            markSize = size;
        }
        double x = point.getX() - 0.5 * (double)markSize / scale;
        double y = point.getY() - 0.5 * (double)markSize / scale;
        Rectangle2D.Double mark = new Rectangle2D.Double(x, y, (double)markSize / scale, (double)markSize / scale);
        DrawPanel drawPanel = ObjectTable.getDrawPanel();
        TempShape drawMark = new TempShape(id, mark, null, color, color, message, null, color, DrawParameters.DefaultFont);
        ObjectTable.getTempShapeManager("DrawShapeUtil").addTempShape(drawMark);
    }

    public static void drawTempShape(String id, Shape shape, Stroke stroke, Color lineColor, Color fillColor, String message, Point2D messagePosition, Color messageColor) {
        DrawPanel drawPanel = ObjectTable.getDrawPanel();
        TempShape drawMark = new TempShape(id, shape, stroke, lineColor, fillColor, message, messagePosition, messageColor, DrawParameters.DefaultFont);
        ObjectTable.getTempShapeManager("DrawShapeUtil").addTempShape(drawMark);
    }

    public static void removeTempShape(String id, Point2D point) {
        DrawPanel drawPanel = ObjectTable.getDrawPanel();
        ObjectTable.getTempShapeManager("DrawShapeUtil").removeTempShape(id, point);
    }

    public static void clearTempShape(String id) {
        DrawPanel drawPanel = ObjectTable.getDrawPanel();
        ObjectTable.getTempShapeManager("DrawShapeUtil").clearTempShape(id);
    }

    public static void clearAllTempShapes() {
        DrawPanel drawPanel = ObjectTable.getDrawPanel();
        ObjectTable.getTempShapeManager().clearAllTempShapes();
    }
}

