/*
 * Decompiled with CFR 0.152.
 */
package shape;

import geomExtension.Vector2D;
import java.awt.geom.Point2D;
import java.util.Vector;
import shape.Joint;
import shape.JointList;
import shape.PathSegment;
import util.Util;

public class PathConnect {
    PathSegment[] PathSegments = null;
    JointList jointList = new JointList();
    Vector pathVector = new Vector();
    static double eps = 1.0E-4;
    int debug = 0;

    public PathSegment[][] findPaths(Point2D[][] endPs) {
        this.PathSegments = this.createPathSegments(endPs);
        this.createJoints(this.PathSegments);
        PathSegment startSeg = null;
        int pathCount = 0;
        PathSegment[][] paths = new PathSegment[this.PathSegments.length][];
        while ((startSeg = this.searchStartPathSegment()) != null) {
            if (startSeg.closed) {
                paths[pathCount] = new PathSegment[1];
                paths[pathCount][0] = startSeg;
                startSeg.passed = true;
                ++pathCount;
                continue;
            }
            paths[pathCount] = this.findPath(startSeg);
            ++pathCount;
        }
        PathSegment[][] outPaths = new PathSegment[pathCount][1];
        for (int i = 0; i < pathCount; ++i) {
            int len = paths[i].length;
            outPaths[i] = new PathSegment[len];
            for (int j = 0; j < len; ++j) {
                outPaths[i][j] = paths[i][j];
            }
        }
        return outPaths;
    }

    private PathSegment[] createPathSegments(Point2D[][] endPs) {
        int numseg = endPs.length;
        PathSegment[] PathSegments = new PathSegment[numseg];
        for (int i = 0; i < numseg; ++i) {
            PathSegments[i] = new PathSegment(i, endPs[i][0], endPs[i][1]);
            if (!(Vector2D.dist(PathSegments[i].startP, PathSegments[i].endP) < eps)) continue;
            PathSegments[i].closed = true;
        }
        String str = "PathSegmentConnect PathSegment List";
        for (int i = 0; i < numseg; ++i) {
            str = str + "\n -- PathSegment " + PathSegments[i].toString();
            PathSegments[i] = new PathSegment(i, endPs[i][0], endPs[i][1]);
        }
        if (this.debug > 0) {
            System.out.println(str);
        }
        return PathSegments;
    }

    private void createJoints(PathSegment[] PathSegments) {
        int numseg = PathSegments.length;
        boolean[] closed = new boolean[numseg];
        for (int i = 0; i < numseg; ++i) {
            closed[i] = false;
            if (!(Vector2D.dist(PathSegments[i].startP, PathSegments[i].endP) < eps)) continue;
            closed[i] = true;
        }
        double dist = 0.0;
        for (int i = 0; i < numseg; ++i) {
            for (int j = i; j < numseg; ++j) {
                Joint joint;
                if (j == i) continue;
                dist = Vector2D.dist(PathSegments[i].startP, PathSegments[j].startP);
                if (dist < eps) {
                    joint = new Joint(PathSegments[i], 0, PathSegments[j], 0);
                    this.jointList.addJoint(joint);
                }
                if ((dist = Vector2D.dist(PathSegments[i].startP, PathSegments[j].endP)) < eps) {
                    joint = new Joint(PathSegments[i], 0, PathSegments[j], 1);
                    this.jointList.addJoint(joint);
                }
                if ((dist = Vector2D.dist(PathSegments[i].endP, PathSegments[j].startP)) < eps) {
                    joint = new Joint(PathSegments[i], 1, PathSegments[j], 0);
                    this.jointList.addJoint(joint);
                }
                if (!((dist = Vector2D.dist(PathSegments[i].endP, PathSegments[j].endP)) < eps)) continue;
                joint = new Joint(PathSegments[i], 1, PathSegments[j], 1);
                this.jointList.addJoint(joint);
            }
        }
        String str = this.jointList.toString();
        if (this.debug > 0) {
            System.out.println(str);
        }
    }

    private PathSegment searchStartPathSegment() {
        int numseg = this.PathSegments.length;
        PathSegment PathSegmentSave = null;
        for (int i = 0; i < numseg; ++i) {
            if (this.PathSegments[i].passed) continue;
            PathSegmentSave = this.PathSegments[i];
            break;
        }
        return PathSegmentSave;
    }

    private PathSegment[] findPath(PathSegment startSeg) {
        this.pathVector.clear();
        this.pathVector.add(startSeg);
        startSeg.passed = true;
        PathSegment currentSeg = startSeg;
        PathSegment nextSeg = startSeg;
        while ((nextSeg = this.searchBackward(currentSeg)) != null && nextSeg.id != startSeg.id) {
            this.pathVector.add(nextSeg);
            nextSeg.passed = true;
            currentSeg = nextSeg;
        }
        while ((nextSeg = this.searchForward(currentSeg = startSeg)) != null && nextSeg.id != startSeg.id) {
            this.pathVector.add(0, nextSeg);
            nextSeg.passed = true;
            currentSeg = nextSeg;
        }
        int size = this.pathVector.size();
        PathSegment[] PathSegments = new PathSegment[size];
        for (int i = 0; i < size; ++i) {
            PathSegments[i] = (PathSegment)this.pathVector.get(i);
        }
        String str = " ** finedPath pathList numofsegs=" + size;
        for (int i = 0; i < size; ++i) {
            Point2D jointPoint = PathSegments[i].endP;
            if (PathSegments[i].reversed) {
                jointPoint = PathSegments[i].startP;
            }
            str = str + "\n  segmenId-" + PathSegments[i].id + ", reversed=" + PathSegments[i].reversed + ", passed=" + PathSegments[i].passed + ", jointPoint=" + Util.Pt(jointPoint);
        }
        if (this.debug > 0) {
            System.out.println(str);
        }
        return PathSegments;
    }

    private PathSegment searchBackward(PathSegment PathSegment2) {
        PathSegment next = null;
        Joint[] joints = this.jointList.getJoints(PathSegment2);
        int len = joints.length;
        int jointPos = 1;
        if (PathSegment2.reversed) {
            jointPos = 0;
        }
        if (len == 0) {
            return null;
        }
        Joint jointSave = null;
        for (int i = 0; i < len; ++i) {
            if (joints[i].passed) continue;
            if (joints[i].PathSegment1.id == PathSegment2.id && joints[i].seg1_pos == jointPos) {
                joints[i].passed = true;
                if (joints[i].seg2_pos == 1) {
                    joints[i].PathSegment2.reversed = true;
                }
                next = joints[i].PathSegment2;
                next.passed = true;
                jointSave = joints[i];
                break;
            }
            if (joints[i].PathSegment2.id != PathSegment2.id || joints[i].seg2_pos != jointPos) continue;
            joints[i].passed = true;
            if (joints[i].seg1_pos == 1) {
                joints[i].PathSegment1.reversed = true;
            }
            next = joints[i].PathSegment1;
            next.passed = true;
            jointSave = joints[i];
            break;
        }
        String str = " searchBackward current: " + PathSegment2.toShortString();
        str = next != null ? str + ", next: " + next.toShortString() + ", " + jointSave.toShortString() : str + ", next=null, joint=null";
        if (this.debug > 0) {
            System.out.println(str);
        }
        return next;
    }

    private PathSegment searchForward(PathSegment PathSegment2) {
        PathSegment next = null;
        Joint[] joints = this.jointList.getJoints(PathSegment2);
        int len = joints.length;
        int jointPos = 0;
        if (PathSegment2.reversed) {
            jointPos = 1;
        }
        if (len == 0) {
            return null;
        }
        Joint jointSave = null;
        for (int i = 0; i < len; ++i) {
            if (joints[i].passed) continue;
            if (joints[i].PathSegment1.id == PathSegment2.id && joints[i].seg1_pos == jointPos) {
                joints[i].passed = true;
                if (joints[i].seg2_pos == 0) {
                    joints[i].PathSegment2.reversed = true;
                }
                next = joints[i].PathSegment2;
                next.passed = true;
                jointSave = joints[i];
                break;
            }
            if (joints[i].PathSegment2.id != PathSegment2.id || joints[i].seg2_pos != jointPos) continue;
            joints[i].passed = true;
            if (joints[i].seg1_pos == 0) {
                joints[i].PathSegment1.reversed = true;
            }
            next = joints[i].PathSegment1;
            next.passed = true;
            jointSave = joints[i];
            break;
        }
        String str = " searchBackward current: " + PathSegment2.toShortString();
        str = next != null ? str + ", next: " + next.toShortString() + ", " + jointSave.toShortString() : str + ", next=null, joint=null";
        if (this.debug > 0) {
            System.out.println(str);
        }
        return next;
    }

    public static void exec() {
        PathConnect con = new PathConnect();
        Point2D[][] endPs = con.createTest();
        PathSegment[][] paths = con.findPaths(endPs);
        String str = "Path list";
        int numPaths = paths.length;
        for (int i = 0; i < numPaths; ++i) {
            int len = paths[i].length;
            if (len == 0) continue;
            str = str + "\npath no.=" + i;
            for (int j = 0; j < len; ++j) {
                PathSegment pathSeg = paths[i][j];
                str = str + "\n  -- PathSegment " + pathSeg.toString();
            }
        }
        System.out.println(str);
        System.exit(0);
    }

    private Point2D[][] createTest() {
        Point2D[][] endPs = new Point2D[10][2];
        endPs[0][0] = new Point2D.Double(20.0, 10.0);
        endPs[0][1] = new Point2D.Double(40.0, 10.0);
        endPs[1][0] = new Point2D.Double(0.0, 0.0);
        endPs[1][1] = new Point2D.Double(0.0, 0.0);
        endPs[2][0] = new Point2D.Double(10.0, 30.0);
        endPs[2][1] = new Point2D.Double(10.0, 40.0);
        endPs[3][0] = new Point2D.Double(40.0, 20.0);
        endPs[3][1] = new Point2D.Double(40.0, 10.0);
        endPs[4][0] = new Point2D.Double(10.0, 30.0);
        endPs[4][1] = new Point2D.Double(0.0, 20.0);
        endPs[5][0] = new Point2D.Double(20.0, 30.0);
        endPs[5][1] = new Point2D.Double(30.0, 30.0);
        endPs[6][0] = new Point2D.Double(20.0, 30.0);
        endPs[6][1] = new Point2D.Double(20.0, 10.0);
        endPs[7][0] = new Point2D.Double(30.0, 20.0);
        endPs[7][1] = new Point2D.Double(40.0, 20.0);
        endPs[8][0] = new Point2D.Double(20.0, 40.0);
        endPs[8][1] = new Point2D.Double(10.0, 40.0);
        endPs[9][0] = new Point2D.Double(30.0, 20.0);
        endPs[9][1] = new Point2D.Double(30.0, 30.0);
        return endPs;
    }
}

