/*
 * Decompiled with CFR 0.152.
 */
package shape;

import geomExtension.Curve2D;
import geomExtension.RoundRectangle2DE;
import geomExtension.Segment2D;
import geomExtension.Vector2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import shape.SegmentModifier;
import shape.ShapeElement;

public class RoundRectangleElement
extends ShapeElement {
    SegmentModifier[] segmentModifiers = null;
    SegmentModifier hitSegmentModifier = null;
    int debug = 0;

    @Override
    public int getTypeE() {
        return 44;
    }

    @Override
    public String getShapeIdString() {
        return "Round_Rectangle";
    }

    @Override
    public Rectangle2D createTextArea() {
        double h;
        double w;
        double y;
        RoundRectangle2DE roundRect = (RoundRectangle2DE)this.curve2D;
        double arcw = roundRect.getArcWidth();
        double arch = roundRect.getArcHeight();
        double margin = 3.0;
        double width = Math.min(arcw, arch) * (1.0 - 1.0 / Math.sqrt(2.0)) + margin;
        double x = roundRect.getX();
        Rectangle2D.Double textArea = new Rectangle2D.Double(x + 0.5 * width, (y = roundRect.getY()) + 0.5 * width, (w = roundRect.getWidth()) - width, (h = roundRect.getHeight()) - width);
        if (((RectangularShape)textArea).getWidth() < ShapeElement.MinTextArea.getWidth() || ((RectangularShape)textArea).getHeight() < ShapeElement.MinTextArea.getHeight()) {
            return null;
        }
        return textArea;
    }

    @Override
    public SegmentModifier[] getSegmentModifiers() {
        Curve2D curve2D = this.getCurve2D();
        SegmentModifier[] modifiers = new SegmentModifier[2];
        String lineSegStr = Segment2D.codeStr[1];
        String arcSegStr = Segment2D.codeStr[2];
        modifiers[0] = new SegmentModifier(1, 0, 1, 0, 1, lineSegStr, arcSegStr, curve2D.getP(1.0), 0, null, null);
        modifiers[1] = new SegmentModifier(1, 0, 2, 1, 2, arcSegStr, lineSegStr, curve2D.getP(2.0), 0, null, null);
        return modifiers;
    }

    @Override
    public Point2D[] getModifierPTs() {
        SegmentModifier[] modifiers = this.getSegmentModifiers();
        Point2D[] PTs = new Point2D[modifiers.length];
        Object PT = null;
        for (int i = 0; i < modifiers.length; ++i) {
            PTs[i] = modifiers[i].getP();
        }
        return PTs;
    }

    @Override
    public void mouseStart(int ctrl, Point2D startPoint) {
        super.mouseStart(ctrl, startPoint);
        this.segmentModifiers = this.getSegmentModifiers();
        this.hitSegmentModifier = SegmentModifier.getHitSegmentModifier(this.segmentModifiers, startPoint);
        if (this.hitSegmentModifier == null) {
            System.out.println("modify hit=null");
        }
    }

    @Override
    public void create(Point2D startPoint, Point2D currentPoint) {
    }

    @Override
    public void create(Rectangle2D boundingBox) {
        double X = boundingBox.getX();
        double Y = boundingBox.getY();
        double Width = boundingBox.getWidth();
        double Height = boundingBox.getHeight();
        double edgeLength = Math.min(Width, Height);
        double Arcw = 0.2 * edgeLength;
        double Arch = 0.2 * edgeLength;
        this.curve2D = new RoundRectangle2DE(X, Y, Width, Height, Arcw, Arch);
    }

    @Override
    public void create(Point2D[] points) {
    }

    @Override
    public void moveEndPoint(int ctrl, int movePtIndex, Point2D currentPoint) {
    }

    @Override
    public void moveEndPoint(int ctrl, int movePtIndex, Point2D oldPoint, Point2D newPoint) {
    }

    @Override
    public void modify(int ctrl, Point2D oldPoint, Point2D currentPoint) {
        if (this.hitSegmentModifier == null) {
            return;
        }
        int type2DE = this.curve2D.getType2DE();
        if (type2DE != 44) {
            return;
        }
        RoundRectangle2DE roundRectangle = (RoundRectangle2DE)this.curve2D;
        double x = roundRectangle.getX();
        double y = roundRectangle.getY();
        double width = roundRectangle.getWidth();
        double height = roundRectangle.getHeight();
        Curve2D curve2D = this.getCurve2D();
        Vector2D tangent = curve2D.getTangent(this.hitSegmentModifier.getSegmentPid());
        Vector2D normalTangent = Vector2D.unitVector(tangent);
        Point2D.Double cornerP = new Point2D.Double(x, y + height);
        Vector2D arcVec = Vector2D.sub(currentPoint, cornerP);
        double arcWidth = 2.0 * Math.abs(Vector2D.sproduct(arcVec, normalTangent));
        double margin = 2.0;
        double arcWidthMax = Math.min(width, height) - margin;
        if (arcWidth >= arcWidthMax) {
            arcWidth = arcWidthMax;
        }
        roundRectangle.setData(x, y, width, height, arcWidth, arcWidth);
        if (this.shapeContainer.isTextBox()) {
            Rectangle2D textArea = this.createTextArea();
            this.shapeContainer.getTextBox().setTextArea(textArea);
        }
    }

    @Override
    public void modifyPoint(Point2D point, String command) {
    }

    @Override
    public Object clone() {
        RoundRectangleElement shapeElement = new RoundRectangleElement();
        RoundRectangle2DE curve = (RoundRectangle2DE)this.curve2D.clone();
        shapeElement.setCurve2D(curve);
        return shapeElement;
    }

    @Override
    public String toString() {
        String str = "";
        if (this.curve2D == null) {
            str = str + "RoundRectangle: not defined";
            return str;
        }
        RoundRectangle2DE roundRectangle = (RoundRectangle2DE)this.curve2D;
        double x = roundRectangle.getX();
        double y = roundRectangle.getY();
        double width = roundRectangle.getWidth();
        double height = roundRectangle.getHeight();
        double arcw = roundRectangle.getArcWidth();
        double arch = roundRectangle.getArcHeight();
        str = "RoundRectangle x,y=(" + String.valueOf((int)x) + "," + String.valueOf((int)y) + ")" + " width,height=" + String.valueOf((int)width) + "," + String.valueOf((int)height) + " arcw,arch=" + String.valueOf((int)arcw) + "," + String.valueOf((int)arch);
        return str;
    }
}

