/*
 * Decompiled with CFR 0.152.
 */
package shape;

import DrawTop.DrawParameters;
import DrawTop.ObjectTable;
import geomExtension.Curve2D;
import geomExtension.Curve2DUtil;
import geomExtension.CurvePT;
import geomExtension.FergusonCurve2D;
import geomExtension.GeneralCurve2DE;
import geomExtension.Segment2D;
import geomExtension.Vector2D;
import java.awt.Color;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.text.NumberFormat;
import java.util.Vector;
import javax.swing.JOptionPane;
import shape.DiscreteAngledLine;
import shape.TempShape;
import shape.TempShapeManager;
import util.Util;

public class SegmentModifier {
    int type = 0;
    int subPathIndex = 0;
    int segmentPid = 0;
    public int segmentId1 = 0;
    public int segmentId2 = 0;
    public String segmentType1 = "";
    public String segmentType2 = "";
    Point2D p = null;
    Segment2D tangentIn = null;
    Segment2D tangentOut = null;
    int jointType = 0;
    int hitType = 0;
    public static final int SegmentP = 1;
    public static final int SegmentMP = 2;
    public static final int Tangent = 3;
    public static final int Smooth = 4;
    public static final int Cusp = 5;
    public static final int TinP1 = 6;
    public static final int TinP2 = 7;
    public static final int ToutP1 = 8;
    public static final int ToutP2 = 9;
    public static String[] codeStr = new String[]{"Undef", "SegmentP", "SegmentMP", "Tangent", "Smooth", "Cusp", "TinP1", "TinP2", "ToutP1", "ToutP2"};
    static final int Mark_NormalSize = 6;
    static Vector workVector = new Vector();
    static int debug = 0;

    public SegmentModifier(int type, int subPathIndex, int segmentPid, int segmentId1, int segmentId2, String segmentType1, String segmentType2, Point2D p, int jointType, Segment2D tangentIn, Segment2D tangentOut) {
        this.type = type;
        this.subPathIndex = subPathIndex;
        this.segmentPid = segmentPid;
        this.segmentId1 = segmentId1;
        this.segmentId2 = segmentId2;
        this.segmentType1 = segmentType1;
        this.segmentType2 = segmentType2;
        this.p = p;
        this.jointType = jointType;
        this.tangentIn = tangentIn;
        this.tangentOut = tangentOut;
    }

    public int getType() {
        return this.type;
    }

    public int getSubPathIndex() {
        return this.subPathIndex;
    }

    public int getSegmentPid() {
        return this.segmentPid;
    }

    public int getSegmentId1() {
        return this.segmentId1;
    }

    public int getSegmentId2() {
        return this.segmentId2;
    }

    public Point2D getP() {
        return this.p;
    }

    public int getJointType() {
        return this.jointType;
    }

    public void setJointType(int jointType) {
        this.jointType = jointType;
    }

    public Segment2D getTangentIn() {
        return this.tangentIn;
    }

    public void setTangentIn(Segment2D tangentIn) {
        this.tangentIn = tangentIn;
    }

    public Segment2D getTangentOut() {
        return this.tangentOut;
    }

    public void setTangentOut(Segment2D tangentOut) {
        this.tangentOut = tangentOut;
    }

    public Point2D getTinP1() {
        Point2D pt = null;
        if (this.tangentIn != null) {
            Line2D line = (Line2D)this.tangentIn.getShape();
            pt = line.getP1();
        }
        return pt;
    }

    public Point2D getTinP2() {
        Point2D pt = null;
        if (this.tangentIn != null) {
            Line2D line = (Line2D)this.tangentIn.getShape();
            pt = line.getP2();
        }
        return pt;
    }

    public Point2D getToutP1() {
        Point2D pt = null;
        if (this.tangentOut != null) {
            Line2D line = (Line2D)this.tangentOut.getShape();
            pt = line.getP1();
        }
        return pt;
    }

    public Point2D getToutP2() {
        Point2D pt = null;
        if (this.tangentOut != null) {
            Line2D line = (Line2D)this.tangentOut.getShape();
            pt = line.getP2();
        }
        return pt;
    }

    public int getHitType() {
        return this.hitType;
    }

    protected void setHitType(int type) {
        this.hitType = type;
    }

    public String toString() {
        NumberFormat nf1 = NumberFormat.getNumberInstance();
        nf1.setMaximumIntegerDigits(4);
        nf1.setMinimumFractionDigits(2);
        NumberFormat nf2 = NumberFormat.getNumberInstance();
        nf2.setMaximumIntegerDigits(5);
        nf2.setMinimumFractionDigits(2);
        String str = "  SegmentModifier ";
        String tangentInStr = "null";
        if (this.tangentIn != null) {
            tangentInStr = this.tangentIn.toString();
        }
        String tangentOutStr = "null";
        if (this.tangentOut != null) {
            tangentOutStr = this.tangentOut.toString();
        }
        str = str + "type=" + codeStr[this.type] + ", hitType=" + codeStr[this.hitType] + ", subPath=" + this.subPathIndex + ", segmentPid=" + this.segmentPid + ", segmentId1=" + this.segmentId1 + " (" + this.segmentType1 + ")" + ", segmentId2=" + this.segmentId2 + " (" + this.segmentType2 + ")" + ", point=" + Util.Pt(this.p) + ", jointType=" + codeStr[this.jointType] + ", tangentIn=" + tangentInStr + ", tangentOut=" + tangentOutStr;
        return str;
    }

    public Object clone() {
        SegmentModifier ctrlP = new SegmentModifier(this.type, this.subPathIndex, this.segmentPid, this.segmentId1, this.segmentId1, this.segmentType1, this.segmentType2, this.p, this.jointType, this.tangentIn, this.tangentOut);
        this.setHitType(this.getHitType());
        return ctrlP;
    }

    public static SegmentModifier[] getSegmentModifiers(Curve2D curve2D) {
        GeneralCurve2DE gcurve = (GeneralCurve2DE)curve2D;
        int numSubPath = gcurve.getNumOfSubPaths();
        GeneralCurve2DE[] subCurves = gcurve.getSubPaths();
        workVector.clear();
        for (int k = 0; k < numSubPath; ++k) {
            int i;
            GeneralCurve2DE subCurve = subCurves[k];
            int numseg = subCurve.getNumOfSegments();
            boolean closed = ((Curve2D)subCurve).isClosed();
            for (i = 0; i <= numseg; ++i) {
                SegmentModifier modifier = SegmentModifier.getSegmentModifier(curve2D, 1, k, i);
                workVector.add(modifier);
            }
            for (i = 0; i < numseg; ++i) {
                int segType = subCurve.getSegment2D(i).getType();
                if (segType != 1 && segType != 2) continue;
                SegmentModifier modifier = SegmentModifier.getSegmentModifier(curve2D, 2, k, i);
                workVector.add(modifier);
            }
            for (i = 0; i <= numseg; ++i) {
                SegmentModifier modifier;
                int segmentId1 = i - 1;
                int segmentId2 = i;
                if (i == numseg) {
                    segmentId2 = -1;
                }
                if (closed) {
                    if (segmentId1 < 0) {
                        segmentId1 = numseg - 1;
                    }
                    if (segmentId2 < 0) {
                        segmentId2 = 0;
                    }
                }
                int segType1 = -1;
                int segType2 = -1;
                if (segmentId1 >= 0) {
                    segType1 = subCurve.getSegment2D(segmentId1).getType();
                }
                if (segmentId2 >= 0) {
                    segType2 = subCurve.getSegment2D(segmentId2).getType();
                }
                if (segType1 != 3 && segType2 != 3 || (modifier = SegmentModifier.getSegmentModifier(curve2D, 3, k, i)) == null) continue;
                workVector.add(modifier);
            }
        }
        SegmentModifier[] Modifiers = new SegmentModifier[workVector.size()];
        for (int i = 0; i < workVector.size(); ++i) {
            Modifiers[i] = (SegmentModifier)workVector.get(i);
        }
        String str = "GeneralCurveElement.getSegmentModifiers";
        for (int i = 0; i < Modifiers.length; ++i) {
            str = str + "\n" + Modifiers[i].toString();
        }
        if (debug > 0) {
            System.out.println(str);
        }
        return Modifiers;
    }

    public static SegmentModifier getSegmentModifier(Curve2D curve2D, int type, int subPath, int segmentPtIndex) {
        int segType;
        int segmentId1;
        GeneralCurve2DE gcurve = (GeneralCurve2DE)curve2D;
        Curve2D[] subCurves = curve2D.getSubPaths();
        Curve2D subCurve = subCurves[subPath];
        int numseg = subCurve.getNumOfSegments();
        int index = segmentPtIndex;
        boolean closed = subCurve.isClosed();
        SegmentModifier modifier = null;
        if (type == 1) {
            segmentId1 = index - 1;
            int segmentId2 = index;
            if (index == numseg) {
                segmentId2 = -1;
            }
            if (closed) {
                if (segmentId1 < 0) {
                    segmentId1 = numseg - 1;
                }
                if (segmentId2 < 0) {
                    segmentId2 = 0;
                }
            }
            String segTypeStr1 = "";
            String segTypeStr2 = "";
            segTypeStr1 = segmentId1 < 0 ? "null" : Segment2D.codeStr[subCurve.getSegment2D(segmentId1).getType()];
            segTypeStr2 = segmentId2 < 0 ? "null" : Segment2D.codeStr[subCurve.getSegment2D(segmentId2).getType()];
            modifier = new SegmentModifier(1, subPath, index, segmentId1, segmentId2, segTypeStr1, segTypeStr2, subCurve.getP(index), 0, null, null);
        }
        if (type == 2 && index < numseg && ((segType = subCurve.getSegment2D(index).getType()) == 1 || segType == 2)) {
            String segTypeStr = Segment2D.codeStr[segType];
            modifier = new SegmentModifier(2, subPath, index, index, index, segTypeStr, segTypeStr, subCurve.getP((double)index + 0.5), 0, null, null);
        }
        if (type == 3) {
            segmentId1 = index - 1;
            int segmentId2 = index;
            if (index == numseg) {
                segmentId2 = -1;
            }
            if (closed) {
                if (segmentId1 < 0) {
                    segmentId1 = numseg - 1;
                }
                if (segmentId2 < 0) {
                    segmentId2 = 0;
                }
            }
            int segType1 = -1;
            int segType2 = -1;
            if (segmentId1 >= 0) {
                segType1 = subCurve.getSegment2D(segmentId1).getType();
            }
            if (segmentId2 >= 0) {
                segType2 = subCurve.getSegment2D(segmentId2).getType();
            }
            String segTypeStr1 = "";
            String segTypeStr2 = "";
            segTypeStr1 = segmentId1 < 0 ? "null" : Segment2D.codeStr[subCurve.getSegment2D(segmentId1).getType()];
            segTypeStr2 = segmentId2 < 0 ? "null" : Segment2D.codeStr[subCurve.getSegment2D(segmentId2).getType()];
            modifier = new SegmentModifier(3, subPath, index, segmentId1, segmentId2, segTypeStr1, segTypeStr2, subCurve.getP(index), 0, null, null);
            Vector2D Tin = null;
            Vector2D Tout = null;
            if (segmentId1 >= 0 && segType1 == 3) {
                Tin = subCurve.getSegment2D(segmentId1).getTangent(1.0);
            }
            if (segmentId2 >= 0 && segType2 == 3) {
                Tout = subCurve.getSegment2D(segmentId2).getTangent(0.0);
            }
            modifier.setJointType(5);
            if (Tin != null && Tout != null && Vector2D.isSameDirection(Tin, Tout, 3.0)) {
                modifier.setJointType(4);
            }
            Segment2D TinSeg = null;
            Segment2D ToutSeg = null;
            if (Tin != null) {
                TinSeg = SegmentModifier.getTangentLine(subCurve.getP(index), Tin);
            }
            if (Tout != null) {
                ToutSeg = SegmentModifier.getTangentLine(subCurve.getP(index), Tout);
            }
            modifier.setTangentIn(TinSeg);
            modifier.setTangentOut(ToutSeg);
        }
        return modifier;
    }

    private static Segment2D getTangentLine(Point2D point, Vector2D Tvec) {
        double lineLength = 30.0 / DrawParameters.Scale;
        Vector2D PT = new Vector2D(point);
        Tvec = Vector2D.unitVector(Tvec);
        Tvec = Vector2D.multiply(lineLength, Tvec);
        Vector2D P1 = Vector2D.sub(PT, Tvec);
        Vector2D P2 = Vector2D.add(PT, Tvec);
        Line2D.Double line = new Line2D.Double(P1.getX(), P1.getY(), P2.getX(), P2.getY());
        Segment2D segment = new Segment2D(1, line);
        return segment;
    }

    public static SegmentModifier getHitSegmentModifier(SegmentModifier[] modifiers, Point2D point) {
        int size = 0;
        if (modifiers != null) {
            size = modifiers.length;
        }
        int hit = 0;
        int hitType = 0;
        double distMin = 100000.0;
        for (int i = 0; i < size; ++i) {
            Point2D tp;
            double dist = Vector2D.dist(modifiers[i].getP(), point);
            if (dist < distMin) {
                distMin = dist;
                hit = i;
                hitType = modifiers[i].getType();
            }
            if ((tp = modifiers[i].getTinP1()) != null && (dist = Vector2D.dist(tp, point)) < distMin) {
                distMin = dist;
                hit = i;
                hitType = 6;
            }
            if ((tp = modifiers[i].getTinP2()) != null && (dist = Vector2D.dist(tp, point)) < distMin) {
                distMin = dist;
                hit = i;
                hitType = 7;
            }
            if ((tp = modifiers[i].getToutP1()) != null && (dist = Vector2D.dist(tp, point)) < distMin) {
                distMin = dist;
                hit = i;
                hitType = 8;
            }
            if ((tp = modifiers[i].getToutP2()) == null || !((dist = Vector2D.dist(tp, point)) < distMin)) continue;
            distMin = dist;
            hit = i;
            hitType = 9;
        }
        if (distMin < 6.0) {
            modifiers[hit].setHitType(hitType);
            return modifiers[hit];
        }
        return null;
    }

    public static boolean modify(Curve2D curve2D, SegmentModifier hitSegmentModifier, int ctrl, Point2D startPoint, Point2D oldPoint, Point2D currentPoint) {
        boolean topologyChanged = false;
        if (hitSegmentModifier == null) {
            return topologyChanged;
        }
        int type2DE = curve2D.getType2DE();
        if (type2DE != 56) {
            return topologyChanged;
        }
        GeneralCurve2DE gcurve = (GeneralCurve2DE)curve2D;
        int subPath = hitSegmentModifier.getSubPathIndex();
        int index = hitSegmentModifier.getSegmentPid();
        int index1 = hitSegmentModifier.getSegmentId1();
        int index2 = hitSegmentModifier.getSegmentId2();
        int hitType = hitSegmentModifier.getHitType();
        Curve2D[] subCurves = curve2D.getSubPaths();
        Point2D[][] endPs = new Point2D[subCurves.length][2];
        for (int i = 0; i < subCurves.length; ++i) {
            if (i == subPath || subCurves[i].isClosed()) continue;
            endPs[i] = subCurves[i].getEndPoints();
        }
        Curve2D subCurve = subCurves[subPath];
        boolean closed = subCurve.isClosed();
        int numseg = subCurve.getNumOfSegments();
        Segment2D[] segments = subCurve.getSegment2Ds();
        Point2D newP = currentPoint;
        Point2D oldP = oldPoint;
        if (debug > 0) {
            System.out.println("GeneralCurveElement.modify hitType=" + codeStr[hitType] + ", subPath=" + subPath + ", numseg=" + numseg + ", closed=" + closed + ", index=" + index);
        }
        if (ctrl > 0) {
            newP = DiscreteAngledLine.getControlledPT(0.0, 90.0, startPoint, newP);
            oldP = DiscreteAngledLine.getControlledPT(0.0, 90.0, startPoint, oldP);
        }
        if (hitType == 1) {
            Point2D P0;
            if (ctrl > 0) {
                currentPoint = DiscreteAngledLine.getControlledPT(0.0, 90.0, startPoint, newP);
            }
            if (index >= 0 && index <= numseg) {
                if (index1 >= 0) {
                    segments[index1] = segments[index1].moveSegmentEndPT(1, newP);
                }
                if (index2 >= 0) {
                    segments[index2] = segments[index2].moveSegmentEndPT(0, newP);
                }
                subCurve.setData(segments);
                gcurve.setSubPaths(subCurves);
            }
            if (index == 0 || index == numseg) {
                P0 = subCurve.getP(0.0);
                Point2D P1 = subCurve.getP(numseg);
                double dist = Vector2D.dist(P0, P1);
                if (debug > 0) {
                    System.out.println("closing check subPath=" + subPath + ", index=" + index + ", dist=" + Util.Num(dist) + ", P0=" + Util.Pt(P0) + ", P1=" + Util.Pt(P1));
                }
                if (!closed && dist < 3.0) {
                    topologyChanged = true;
                    SegmentModifier.clearMessage("modify_close");
                    if (index == 0) {
                        segments[0] = segments[0].moveSegmentEndPT(0, P1);
                    }
                    if (index == numseg) {
                        segments[numseg - 1] = segments[numseg - 1].moveSegmentEndPT(1, P0);
                    }
                    SegmentModifier.drawMessage("modify_close", "closing", P1);
                    subCurve.setData(segments);
                    gcurve.setSubPaths(subCurves);
                    ObjectTable.getDrawPanel().repaint();
                }
            }
            if (index == 0 || index == numseg) {
                P0 = subCurve.getP(index);
                int[] inf = SegmentModifier.checkDistance(P0, endPs);
                int isave = inf[0];
                int jsave = inf[1];
                double dist = 100000.0;
                if (isave >= 0 && jsave >= 0) {
                    dist = Vector2D.dist(P0, endPs[isave][jsave]);
                }
                if (dist < 3.0) {
                    topologyChanged = true;
                    int path = isave;
                    int ptIndex = 0;
                    if (jsave > 0) {
                        ptIndex = numseg;
                    }
                    System.out.println("isConnecting path=" + path + ", ptIndex=" + ptIndex);
                    Point2D targetP = subCurves[path].getP(ptIndex);
                    SegmentModifier.clearMessage("modify_connect");
                    if (index == 0) {
                        segments[0] = segments[0].moveSegmentEndPT(0, targetP);
                    }
                    if (index == numseg) {
                        segments[numseg - 1] = segments[numseg - 1].moveSegmentEndPT(1, targetP);
                    }
                    SegmentModifier.drawMessage("modify_connect", "connecting", targetP);
                    subCurve.setData(segments);
                    gcurve.setSubPaths(subCurves);
                    ObjectTable.getDrawPanel().repaint();
                }
            }
        }
        if (hitType == 2) {
            double moveX = newP.getX() - oldP.getX();
            double moveY = newP.getY() - oldP.getY();
            Point2D p1 = segments[index].getP(0.0);
            Point2D p2 = segments[index].getP(1.0);
            if (ctrl > 0) {
                p2 = DiscreteAngledLine.getControlledPT(0.0, 90.0, p1, p2);
            }
            p1.setLocation(p1.getX() + moveX, p1.getY() + moveY);
            p2.setLocation(p2.getX() + moveX, p2.getY() + moveY);
            if (index >= 0 && index <= numseg - 1) {
                segments[index] = segments[index].moveSegmentEndPT(0, p1);
                segments[index] = segments[index].moveSegmentEndPT(1, p2);
            }
            if (index >= 1) {
                segments[index - 1] = segments[index - 1].moveSegmentEndPT(1, p1);
            }
            if (index <= numseg - 2) {
                segments[index + 1] = segments[index + 1].moveSegmentEndPT(0, p2);
            }
            if (index == 0 && closed) {
                segments[numseg - 1] = segments[numseg - 1].moveSegmentEndPT(1, p1);
            }
            if (index == numseg - 1 && closed) {
                segments[0] = segments[0].moveSegmentEndPT(0, p2);
            }
            subCurve.setData(segments);
            gcurve.setSubPaths(subCurves);
        }
        int junctionType = hitSegmentModifier.getJointType();
        if (hitType == 6 || hitType == 7 || hitType == 8 || hitType == 9) {
            Vector2D tan = null;
            tan = index == numseg ? segments[numseg - 1].getTangent(1.0) : segments[index].getTangent(0.0);
            double len = Vector2D.length(tan);
            Vector2D newTangent = Vector2D.sub(currentPoint, subCurve.getP(index));
            if (hitType == 6 || hitType == 8) {
                newTangent = Vector2D.multiply(-1.0, newTangent);
            }
            newTangent = Vector2D.multiply(len, Vector2D.unitVector(newTangent));
            if (index >= 0 && index <= numseg) {
                if (hitType == 6 || hitType == 7) {
                    segments[index1] = segments[index1].moveSegmentTangent(1, newTangent);
                    if (junctionType == 4) {
                        segments[index2] = segments[index2].moveSegmentTangent(0, newTangent);
                    }
                }
                if (hitType == 8 || hitType == 9) {
                    segments[index2] = segments[index2].moveSegmentTangent(0, newTangent);
                    if (junctionType == 4) {
                        segments[index1] = segments[index1].moveSegmentTangent(1, newTangent);
                    }
                }
                subCurve.setData(segments);
            }
            String str = subCurve.toString();
            if (debug > 0) {
                System.out.println("subCurve print:" + str);
            }
            gcurve.setSubPaths(subCurves);
        }
        return topologyChanged;
    }

    private static int[] checkDistance(Point2D P, Point2D[][] endPs) {
        int[] ptId = new int[2];
        double distMin = 100000.0;
        int isave = -1;
        int jsave = -1;
        for (int i = 0; i < endPs.length; ++i) {
            for (int j = 0; j < endPs[i].length; ++j) {
                double dist;
                if (endPs[i][j] == null || !((dist = Vector2D.dist(P, endPs[i][j])) < distMin)) continue;
                distMin = dist;
                isave = i;
                jsave = j;
            }
        }
        ptId[0] = isave;
        ptId[1] = jsave;
        return ptId;
    }

    public static void addPoint(Curve2D curve2D, SegmentModifier hitSegmentModifier, Point2D point) {
        CurvePT curvePT = Curve2DUtil.getShortestLine(point, curve2D);
        double t = curvePT.getParameter();
        int it = (int)t;
        if (debug > 0) {
            System.out.println("GeneralCurveElement.addPoint t=" + t);
        }
        int numseg = curve2D.getNumOfSegments();
        Segment2D segment = curve2D.getSegment2D(it);
        Segment2D trimmedSeg1 = segment.trimSegment(0.0, t - (double)it);
        Segment2D trimmedSeg2 = segment.trimSegment(t - (double)it, 1.0);
        Segment2D[] newSegments = new Segment2D[numseg + 1];
        for (int i = 0; i < numseg; ++i) {
            segment = curve2D.getSegment2D(i);
            if (i < it) {
                newSegments[i] = segment;
            }
            if (i == it) {
                newSegments[i] = trimmedSeg1;
                newSegments[i + 1] = trimmedSeg2;
            }
            if (i <= it) continue;
            newSegments[i + 1] = segment;
        }
        GeneralCurve2DE generalCurve = (GeneralCurve2DE)curve2D;
        generalCurve.setData(newSegments);
    }

    public static void deletePoint(Curve2D curve2D, SegmentModifier hitSegmentModifier) {
        if (hitSegmentModifier == null) {
            return;
        }
        System.out.println("GeneralCurveElement.deletePoint hitSegmentModifier" + hitSegmentModifier.toString());
        int type2DE = curve2D.getType2DE();
        if (type2DE != 56) {
            return;
        }
        GeneralCurve2DE gcurve = (GeneralCurve2DE)curve2D;
        int subPath = hitSegmentModifier.getSubPathIndex();
        int index = hitSegmentModifier.getSegmentPid();
        int index1 = hitSegmentModifier.getSegmentId1();
        int index2 = hitSegmentModifier.getSegmentId2();
        int hitType = hitSegmentModifier.getHitType();
        if (hitType != 1) {
            return;
        }
        if (curve2D.getNumOfSegments() == 1) {
            JOptionPane.showMessageDialog(ObjectTable.getDrawMain(), " Warning: GeneralCurve has only two points", "", 0);
            return;
        }
        Curve2D[] curves = gcurve.getSubPaths();
        GeneralCurve2DE curve = curves[subPath];
        int numseg = curve.getNumOfSegments();
        boolean closed = ((Curve2D)curve).isClosed();
        Segment2D[] segments = curve.getSegment2Ds();
        Segment2D[] newSegments = new Segment2D[numseg - 1];
        if (index > 0 && index < numseg) {
            Segment2D newSegment = SegmentModifier.connectSegments(segments[index1], segments[index2]);
            for (int i = 0; i < numseg; ++i) {
                if (i < index - 1) {
                    newSegments[i] = (Segment2D)segments[i].clone();
                }
                if (i == index - 1) {
                    newSegments[i] = newSegment;
                }
                if (i == index || i <= index) continue;
                newSegments[i - 1] = (Segment2D)segments[i].clone();
            }
        }
        if (index == 0) {
            for (int i = 1; i < numseg; ++i) {
                newSegments[i - 1] = segments[i];
            }
            if (closed) {
                Segment2D newSegment;
                newSegments[numseg - 2] = newSegment = SegmentModifier.connectSegments(segments[numseg - 1], segments[0]);
            }
        }
        if (index == numseg) {
            for (int i = 0; i < numseg - 1; ++i) {
                newSegments[i] = segments[i];
            }
            if (closed) {
                Segment2D newSegment;
                newSegments[0] = newSegment = SegmentModifier.connectSegments(segments[numseg - 1], segments[0]);
            }
        }
        ((Curve2D)curve).setData(newSegments);
        gcurve.setSubPaths(curves);
        String str = "";
        str = str + "\n** SegmentModifier GeneralCurveElement.deletePoint deletePoint segmentPtIndex=" + index + ", target subPath=" + subPath + ", localSegmentPtIndex=" + index + "\n" + gcurve.toString();
        if (debug > 0) {
            System.out.println(str);
        }
    }

    private static Segment2D connectSegments(Segment2D segment1, Segment2D segment2) {
        Point2D[] P = new Point2D[2];
        Vector2D[] Tin = new Vector2D[2];
        Vector2D[] Tout = new Vector2D[2];
        P[0] = segment1.getP(0.0);
        P[1] = segment2.getP(1.0);
        Tout[0] = segment1.getTangent(0.0);
        Tin[0] = (Vector2D)Tout[0].clone();
        Tin[1] = segment2.getTangent(1.0);
        Tout[1] = (Vector2D)Tin[1].clone();
        FergusonCurve2D fergusonCurve = new FergusonCurve2D(P, Tin, Tout);
        Vector2D[] newTangents = FergusonCurve2D.getOptimizedTangents(P[0], P[1], Tout[0], Tin[1]);
        fergusonCurve.setTout(newTangents[0], 0);
        fergusonCurve.setTin(newTangents[1], 1);
        CubicCurve2D cubic = fergusonCurve.getCubicCurve2D(0);
        Segment2D newSegment = new Segment2D(3, cubic);
        String str = "";
        str = str + "\n -- connectSegment\n  -- segment1=" + segment1.toString() + "\n  -- segment2=" + segment2.toString() + "\n  -- newSegment=" + newSegment.toString();
        if (debug > 0) {
            System.out.println(str);
        }
        return newSegment;
    }

    public static void smoothPoint(Curve2D curve2D, SegmentModifier hitSegmentModifier) {
        if (hitSegmentModifier == null) {
            return;
        }
        System.out.println("GeneralCurveElement.smoothPoint hitSegmentModifier" + hitSegmentModifier.toString());
        int type2DE = curve2D.getType2DE();
        if (type2DE != 56) {
            return;
        }
        GeneralCurve2DE gcurve = (GeneralCurve2DE)curve2D;
        int subPath = hitSegmentModifier.getSubPathIndex();
        int index = hitSegmentModifier.getSegmentPid();
        int index1 = hitSegmentModifier.getSegmentId1();
        int index2 = hitSegmentModifier.getSegmentId2();
        int hitType = hitSegmentModifier.getHitType();
        if (hitType != 1) {
            return;
        }
        Curve2D[] curves = gcurve.getSubPaths();
        GeneralCurve2DE curve = curves[subPath];
        int numseg = curve.getNumOfSegments();
        Segment2D[] segments = curve.getSegment2Ds();
        if (index < 0 || index > numseg) {
            return;
        }
        if (index1 < 0 || index2 < 0) {
            return;
        }
        if (segments[index1].getType() != 3 && segments[index2].getType() != 3) {
            return;
        }
        Vector2D Tin = curve.getTangent((double)index - 1.0E-5);
        Vector2D Tout = curve.getTangent((double)index + 1.0E-5);
        Vector2D T = Vector2D.add(Tin, Tout);
        if (segments[index1].getType() == 3 && segments[index2].getType() == 3) {
            segments[index1] = segments[index1].moveSegmentTangent(1, T);
            segments[index2] = segments[index2].moveSegmentTangent(0, T);
        }
        if (segments[index1].getType() == 3 && segments[index2].getType() != 3) {
            segments[index1] = segments[index1].moveSegmentTangent(1, Tout);
        }
        if (segments[index1].getType() != 3 && segments[index2].getType() == 3) {
            segments[index2] = segments[index2].moveSegmentTangent(0, Tin);
        }
        ((Curve2D)curve).setData(segments);
        gcurve.setSubPaths(curves);
    }

    public static void cuspPoint(Curve2D curve2D, SegmentModifier hitSegmentModifier) {
        if (hitSegmentModifier == null) {
            return;
        }
        System.out.println("GeneralCurveElement.smoothPoint hitSegmentModifier" + hitSegmentModifier.toString());
        int type2DE = curve2D.getType2DE();
        if (type2DE != 56) {
            return;
        }
        GeneralCurve2DE gcurve = (GeneralCurve2DE)curve2D;
        int subPath = hitSegmentModifier.getSubPathIndex();
        int index = hitSegmentModifier.getSegmentPid();
        int index1 = hitSegmentModifier.getSegmentId1();
        int index2 = hitSegmentModifier.getSegmentId2();
        int jointType = hitSegmentModifier.getJointType();
        if (jointType == 5) {
            return;
        }
        int hitType = hitSegmentModifier.getHitType();
        if (hitType != 1) {
            return;
        }
        Curve2D[] curves = gcurve.getSubPaths();
        GeneralCurve2DE curve = curves[subPath];
        int numseg = curve.getNumOfSegments();
        Segment2D[] segments = curve.getSegment2Ds();
        if (index < 0 || index > numseg) {
            return;
        }
        if (index1 < 0 || index2 < 0) {
            return;
        }
        if (segments[index1].getType() != 3 && segments[index2].getType() != 3) {
            return;
        }
        Point2D P0 = segments[index1].getP(0.0);
        Point2D P1 = segments[index2].getP(0.0);
        Point2D P2 = segments[index2].getP(1.0);
        Vector2D Tin = curve.getTangent((double)index - 1.0E-5);
        Vector2D Tout = curve.getTangent((double)index + 1.0E-5);
        Vector2D newTin = SegmentModifier.divertTangent(P0, P1, P2, Tin, 1);
        Vector2D newTout = SegmentModifier.divertTangent(P0, P1, P2, Tout, -1);
        if (segments[index1].getType() == 3 && segments[index2].getType() == 3) {
            segments[index1] = segments[index1].moveSegmentTangent(1, newTin);
            segments[index2] = segments[index2].moveSegmentTangent(0, newTout);
        }
        if (segments[index1].getType() == 3 && segments[index2].getType() != 3) {
            segments[index1] = segments[index1].moveSegmentTangent(1, newTin);
        }
        if (segments[index1].getType() != 3 && segments[index2].getType() == 3) {
            segments[index2] = segments[index2].moveSegmentTangent(0, newTout);
        }
        ((Curve2D)curve).setData(segments);
        gcurve.setSubPaths(curves);
    }

    private static Vector2D divertTangent(Point2D P0, Point2D P1, Point2D P2, Vector2D tangent, int dir) {
        double divertAngle = 5.0;
        Vector2D v0 = Vector2D.sub(P2, P0);
        Vector2D v1 = Vector2D.sub(P1, P0);
        Vector2D normal = Vector2D.unitNormalVector(v0);
        if (Vector2D.sproduct(normal, v1) < 0.0) {
            normal = Vector2D.multiply(-1.0, normal);
        }
        double targetLen = Vector2D.length(tangent);
        Vector2D unitTarget = Vector2D.multiply(1.0 / targetLen, tangent);
        double divert = divertAngle / 180.0 * Math.PI;
        if (dir < 0) {
            divert = -divert;
        }
        Vector2D divertVec = Vector2D.multiply(divert, normal);
        Vector2D newTarget = Vector2D.multiply(targetLen, Vector2D.add(unitTarget, divertVec));
        return newTarget;
    }

    public static void disconnectPoint(Curve2D curve2D, SegmentModifier hitSegmentModifier) {
        int i;
        int i2;
        Segment2D[] newSegments;
        int type2DE;
        double trimLength = 4.0;
        if (hitSegmentModifier == null) {
            return;
        }
        if (debug >= 0) {
            System.out.println("\nhitSegmentModifier" + hitSegmentModifier.toString());
        }
        if ((type2DE = curve2D.getType2DE()) != 56) {
            return;
        }
        GeneralCurve2DE gcurve = (GeneralCurve2DE)curve2D;
        if (debug >= 0) {
            String str = "\n** SegmentModifier disconnectPoint gcurve:" + gcurve.toString();
            System.out.println(str);
        }
        int subPath = hitSegmentModifier.getSubPathIndex();
        int index = hitSegmentModifier.getSegmentPid();
        int index1 = hitSegmentModifier.getSegmentId1();
        int index2 = hitSegmentModifier.getSegmentId2();
        int hitType = hitSegmentModifier.getHitType();
        if (hitType != 1) {
            return;
        }
        GeneralCurve2DE[] curves = gcurve.getSubPaths();
        GeneralCurve2DE curve = curves[subPath];
        boolean closed = ((Curve2D)curve).isClosed();
        int numseg = curve.getNumOfSegments();
        if (!(index != 0 && index != numseg || closed)) {
            System.err.println("** SegmentModifier disconnectPoint start or end point specified for unclosed curve");
            return;
        }
        Segment2D[] segments = curve.getSegment2Ds();
        if (index < 0 || index > numseg) {
            return;
        }
        if (index1 < 0 || index2 < 0) {
            return;
        }
        Vector2D Tin = curve.getTangent((double)index - 1.0E-5);
        Vector2D Tout = curve.getTangent((double)index + 1.0E-5);
        double TinLen = Vector2D.length(Tin);
        double ToutLen = Vector2D.length(Tout);
        double t1 = trimLength / TinLen;
        double t2 = trimLength / ToutLen;
        if (index1 >= 0) {
            segments[index1] = segments[index1].trimSegment(0.0, 1.0 - t1);
        }
        if (index2 >= 0) {
            segments[index2] = segments[index2].trimSegment(t2, 1.0);
        }
        int pathCount = 0;
        GeneralCurve2DE[] newSubCurves = new GeneralCurve2DE[2];
        if (index == 0 || index == numseg) {
            newSegments = new Segment2D[numseg];
            for (i2 = 0; i2 < numseg; ++i2) {
                newSegments[i2] = (Segment2D)segments[i2].clone();
            }
            newSubCurves[pathCount] = new GeneralCurve2DE(newSegments);
            ++pathCount;
        } else {
            if (index1 >= 0) {
                newSegments = new Segment2D[index1 + 1];
                for (i2 = 0; i2 <= index1; ++i2) {
                    newSegments[i2] = (Segment2D)segments[i2].clone();
                }
                newSubCurves[pathCount] = new GeneralCurve2DE(newSegments);
                ++pathCount;
            }
            if (index2 >= 0) {
                newSegments = new Segment2D[numseg - index2];
                for (i2 = 0; i2 < numseg - index2; ++i2) {
                    newSegments[i2] = (Segment2D)segments[i2 + index2].clone();
                }
                newSubCurves[pathCount] = new GeneralCurve2DE(newSegments);
                ++pathCount;
            }
        }
        Curve2D[] newCurves = new Curve2D[curves.length + pathCount - 1];
        int ind = 0;
        for (i = 0; i < subPath; ++i) {
            newCurves[i] = curves[i];
            ++ind;
        }
        for (i = 0; i < pathCount; ++i) {
            newCurves[ind] = newSubCurves[i];
            ++ind;
        }
        for (i = subPath + 1; i < curves.length; ++i) {
            newCurves[ind] = curves[i];
            ++ind;
        }
        gcurve.setSubPaths(newCurves);
        if (debug >= 0) {
            String str = "** SegmentModifier result gcurve:" + curve2D.toString();
            System.out.println(str);
        }
    }

    private static void drawMessage(String id, String message, Point2D pos) {
        TempShapeManager tempShapeManager = ObjectTable.getTempShapeManager();
        TempShape tempShape = new TempShape(id, message, pos, Color.RED, DrawParameters.DefaultFont);
        tempShapeManager.addTempShape(tempShape);
    }

    private static void clearMessage(String id) {
        TempShapeManager tempShapeManager = ObjectTable.getTempShapeManager();
        tempShapeManager.clearTempShape(id);
    }
}

