/*
 * Decompiled with CFR 0.152.
 */
package shape;

import DrawTop.DrawParameters;
import geomExtension.Vector2D;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import shape.TempShape;

public class TempShapeManager {
    Vector tempShapeVector = new Vector();
    int debug = 0;

    public void drawTempShape(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Color currentColor = g2.getColor();
        Stroke currentStroke = g2.getStroke();
        double scale = DrawParameters.getScale();
        int size = this.tempShapeVector.size();
        if (this.debug > 0) {
            System.out.println("drawTempShape size=" + size);
        }
        if (size == 0) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            String str;
            TempShape temp = (TempShape)this.tempShapeVector.get(i);
            Shape shape = temp.shape;
            if (shape != null) {
                if (temp.fillColor != null) {
                    currentColor = g2.getColor();
                    g2.setColor(temp.fillColor);
                    g2.fill(shape);
                    g2.setColor(currentColor);
                }
                Stroke stroke = temp.stroke;
                currentStroke = g2.getStroke();
                if (stroke != null) {
                    g2.setStroke(stroke);
                }
                g2.setColor(temp.lineColor);
                g2.draw(shape);
                g2.setStroke(currentStroke);
            }
            if ((str = temp.message) == null || str.equals("")) continue;
            Point2D stringPosition = temp.messagePoint;
            float x = (float)stringPosition.getX();
            float y = (float)stringPosition.getY();
            g2.setColor(temp.messageColor);
            g2.setFont(temp.messageFont);
            g2.drawString(str, x, y);
        }
        g2.setColor(currentColor);
    }

    public void addTempShape(TempShape tempShape) {
        this.tempShapeVector.add(tempShape);
        int size = this.tempShapeVector.size();
        if (size > 100) {
            System.out.println("*** Warning TempShapeManager.addTempShape: Num of marks=" + size);
            System.out.println(this.toString());
            System.err.println("*** Warning TempShapeManager.addTempShape: Num of marks=" + size);
            System.err.println(this.toString());
        }
    }

    public void clearTempShape(String id) {
        boolean removed;
        if (this.debug > 0) {
            System.out.println("clearTempShape id=" + id);
        }
        do {
            removed = false;
            for (int i = 0; i < this.tempShapeVector.size(); ++i) {
                TempShape drawMark = (TempShape)this.tempShapeVector.get(i);
                if (!drawMark.id.equals(id)) continue;
                this.tempShapeVector.remove(drawMark);
                removed = true;
            }
        } while (removed);
    }

    public void removeTempShape(String id, Point2D point) {
        boolean removed;
        if (this.debug > 0) {
            System.out.println("removeTempShape id=" + id);
        }
        do {
            removed = false;
            for (int i = 0; i < this.tempShapeVector.size(); ++i) {
                TempShape drawMark = (TempShape)this.tempShapeVector.get(i);
                Rectangle2D rect = drawMark.shape.getBounds2D();
                Point2D.Double tempPoint = new Point2D.Double(rect.getX() + 0.5 * rect.getWidth(), rect.getY() + 0.5 * rect.getHeight());
                double dist = Vector2D.dist(point, tempPoint);
                if (!drawMark.id.equals(id) || !(dist < 2.0)) continue;
                this.tempShapeVector.remove(drawMark);
                removed = true;
            }
        } while (removed);
    }

    public void clearAllTempShapes() {
        if (this.debug > 0) {
            System.out.println("TempShapeManager.clearAllTempShape");
        }
        this.tempShapeVector.clear();
    }

    public String toString() {
        Vector<String> strVector = new Vector<String>();
        Vector<Integer> countVector = new Vector<Integer>();
        for (int i = 0; i < this.tempShapeVector.size(); ++i) {
            TempShape tempShape = (TempShape)this.tempShapeVector.get(i);
            int jsave = -1;
            for (int j = 0; j < strVector.size(); ++j) {
                if (!tempShape.getId().equals(strVector.get(j))) continue;
                jsave = j;
                break;
            }
            if (jsave < 0) {
                strVector.add(tempShape.getId());
                countVector.add(new Integer(1));
                continue;
            }
            int count = (Integer)countVector.get(jsave);
            countVector.set(jsave, new Integer(++count));
        }
        String str = "";
        str = " TempShapeManager num. of tempShapes=" + this.tempShapeVector.size() + " ";
        for (int i = 0; i < strVector.size(); ++i) {
            str = str + "id:" + (String)strVector.get(i) + " num:" + countVector.get(i);
            if (i >= strVector.size() - 1) continue;
            str = str + ",  ";
        }
        return str;
    }
}

