/*
 * Decompiled with CFR 0.152.
 */
package shapeUtil;

import DrawTop.Command;
import DrawTop.DrawParameters;
import DrawTop.MousePositionInfo;
import DrawTop.ObjectTable;
import geomExtension.CrossCurvePT;
import geomExtension.Curve2D;
import geomExtension.Vector2D;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Vector;
import shape.DrawShapeUtil;
import shape.ShapeContainer;
import shapeUtil.Align;
import shapeUtil.AlignedCouple;
import shapeUtil.MoveResizeShapeLS;
import util.ContainerManager;

public class AutoAlign {
    MousePositionInfo mousePositionInfo = null;
    ShapeContainer[] selectedContainers = null;
    int auto_tracking_option;
    MoveResizeShapeLS moveResizeShapeLS = null;
    int mode = 0;
    ArrayList xAlignList = new ArrayList();
    ArrayList yAlignList = new ArrayList();
    Vector hitAlignedCouples = new Vector();
    Vector selectedHitAlignedCouples = new Vector();
    public static double ErrorMargin = 3.0;
    Color color = Color.RED;
    int debug = 0;

    public AutoAlign() {
    }

    public AutoAlign(MoveResizeShapeLS moveResizeShapeLS) {
        this.moveResizeShapeLS = moveResizeShapeLS;
    }

    public AutoAlign(int mode, MousePositionInfo mousePositionInfo, ShapeContainer[] selectedContainers) {
        this.mode = mode;
        this.mousePositionInfo = mousePositionInfo;
        this.selectedContainers = selectedContainers;
        this.createAlign();
    }

    public void start(int mode, MousePositionInfo mousePositionInfo, ShapeContainer[] selectedContainers) {
        if (!DrawParameters.AUTO_ALIGN) {
            return;
        }
        this.auto_tracking_option = DrawParameters.AUTO_TRACKING_OPTION;
        this.xAlignList.clear();
        this.yAlignList.clear();
        this.hitAlignedCouples.clear();
        this.selectedHitAlignedCouples.clear();
        this.mode = mode;
        if (mode == 81) {
            this.mode = 2;
        }
        if (mode == 82) {
            this.mode = 3;
        }
        if (mode == 83) {
            this.mode = 4;
        }
        this.mousePositionInfo = mousePositionInfo;
        this.selectedContainers = selectedContainers;
        this.createAlign();
        this.drawHitAligns();
        ObjectTable.getDrawPanel().repaint();
    }

    public void mouseDragged(MouseEvent e) {
        if (!DrawParameters.AUTO_ALIGN) {
            return;
        }
        this.drawHitAligns();
    }

    public void mouseReleased(MouseEvent e) {
        if (!DrawParameters.AUTO_ALIGN) {
            return;
        }
        int ctrl = 0;
        int key = e.getModifiersEx();
        if ((key & 0x40) != 0) {
            ctrl = 1;
        }
        if ((key & 0x80) != 0) {
            ctrl = 2;
        }
        if ((key & 0x200) != 0) {
            ctrl = 3;
        }
        if (this.mode == 4) {
            boolean connected = this.moveResizeShapeLS.connectionUtil.connected;
            if (!connected) {
                this.ajustAlignment(ctrl);
            }
            if (this.debug >= 0 && connected) {
                System.out.println("**** AutoAlign mouseReleased connected=true");
            }
        } else {
            boolean guided = this.moveResizeShapeLS.connectionUtil.guided;
            if (!guided) {
                this.ajustAlignment(ctrl);
            }
            if (this.debug >= 0 && guided) {
                System.out.println("** AutoAlign mouseReleased guided=true");
            }
        }
        if (this.debug >= 0) {
            System.out.println("** AutoAlign.mouseReleased called");
        }
    }

    private void createAlign() {
        int i;
        ContainerManager containerManager = ObjectTable.getContainerManager();
        ShapeContainer[] containers = containerManager.getContainers();
        for (i = 0; i < containers.length; ++i) {
            boolean same = false;
            for (int j = 0; j < this.selectedContainers.length; ++j) {
                if (containers[i] != this.selectedContainers[j] && !containers[i].equals(this.selectedContainers[j])) continue;
                same = true;
            }
            if (same) continue;
            Rectangle2D box = containers[i].getBoundingBox();
            double x = box.getX();
            double w = box.getWidth();
            double y = box.getY();
            double h = box.getHeight();
            this.putAlign(10, 0, x, containers[i]);
            this.putAlign(10, 1, x + 0.5 * w, containers[i]);
            this.putAlign(10, 2, x + w, containers[i]);
            this.putAlign(11, 3, y, containers[i]);
            this.putAlign(11, 4, y + 0.5 * h, containers[i]);
            this.putAlign(11, 5, y + h, containers[i]);
        }
        if (this.debug > 0) {
            System.out.println("Print xAlignList");
            for (i = 0; i < this.xAlignList.size(); ++i) {
                Align align = (Align)this.xAlignList.get(i);
                System.out.println("-- " + align.toString());
            }
            System.out.println("Print yAlignList");
            for (i = 0; i < this.yAlignList.size(); ++i) {
                Align align = (Align)this.yAlignList.get(i);
                System.out.println("-- " + align.toString());
            }
        }
    }

    private void putAlign(int alignAxis, int alignType, double value, ShapeContainer shapeContainer) {
        double startValue = -100000.0;
        int index = -1;
        ArrayList alignList = null;
        if (alignAxis == 10) {
            alignList = this.xAlignList;
        }
        if (alignAxis == 11) {
            alignList = this.yAlignList;
        }
        for (int i = 0; i < alignList.size(); ++i) {
            Align alignSaved = (Align)alignList.get(i);
            double endValue = alignSaved.getValue();
            if (value > startValue && value <= endValue) {
                index = i;
                break;
            }
            startValue = endValue;
        }
        Align align = new Align(alignAxis, alignType, value, shapeContainer);
        if (index < 0) {
            alignList.add(align);
        } else {
            alignList.add(index, align);
        }
    }

    public void drawHitAligns() {
        int i;
        int i2;
        this.hitAlignedCouples.clear();
        ShapeContainer targetContainer = this.mousePositionInfo.getContainer();
        if (this.mode == 4) {
            if (this.selectedContainers.length > 1) {
                System.err.println("*** ERROR in AutoAlign.drawHitAligns: The num of this.selectedContainers must be one");
            }
            targetContainer = this.selectedContainers[0];
        }
        this.createHitAlignedCouples(targetContainer);
        DrawShapeUtil.clearTempShape("Auto_align");
        ObjectTable.getDrawPanel().repaint();
        int numSel = 6;
        AlignedCouple[] alignedCouplesX = new AlignedCouple[numSel];
        alignedCouplesX[0] = this.selectHitAlignedCouple(0, 0);
        alignedCouplesX[1] = this.selectHitAlignedCouple(0, 1);
        alignedCouplesX[2] = this.selectHitAlignedCouple(1, 0);
        alignedCouplesX[3] = this.selectHitAlignedCouple(1, 1);
        alignedCouplesX[4] = this.selectHitAlignedCouple(2, 0);
        alignedCouplesX[5] = this.selectHitAlignedCouple(2, 1);
        AlignedCouple[] alignedCouplesY = new AlignedCouple[numSel];
        alignedCouplesY[0] = this.selectHitAlignedCouple(3, 0);
        alignedCouplesY[1] = this.selectHitAlignedCouple(3, 1);
        alignedCouplesY[2] = this.selectHitAlignedCouple(4, 0);
        alignedCouplesY[3] = this.selectHitAlignedCouple(4, 1);
        alignedCouplesY[4] = this.selectHitAlignedCouple(5, 0);
        alignedCouplesY[5] = this.selectHitAlignedCouple(5, 1);
        this.selectedHitAlignedCouples.clear();
        for (i2 = 0; i2 < 6; ++i2) {
            if (alignedCouplesX[i2] == null) continue;
            if (!(Math.abs(alignedCouplesX[i2].getAlignedError()) < ErrorMargin)) continue;
            this.selectedHitAlignedCouples.add(alignedCouplesX[i2]);
        }
        for (i2 = 0; i2 < 6; ++i2) {
            if (alignedCouplesY[i2] == null) continue;
            if (!(Math.abs(alignedCouplesY[i2].getAlignedError()) < ErrorMargin)) continue;
            this.selectedHitAlignedCouples.add(alignedCouplesY[i2]);
        }
        int size = this.selectedHitAlignedCouples.size();
        for (i = 0; i < size; ++i) {
            AlignedCouple alignedCouple = (AlignedCouple)this.selectedHitAlignedCouples.get(i);
            this.drawAlign(alignedCouple);
            if (this.debug <= 0) continue;
            System.out.println("alignedCouples i=" + i);
        }
        if (this.debug > 0) {
            System.out.println("\n** drawHitAligns selectedHitAlignedCouples size=" + size);
            for (i = 0; i < size; ++i) {
                AlignedCouple couple = (AlignedCouple)this.selectedHitAlignedCouples.get(i);
                String str = "- AlignedCouple:\n" + couple.toString(1);
                System.out.println(str);
            }
        }
    }

    private void createHitAlignedCouples(ShapeContainer targetContainer) {
        int size;
        AlignedCouple couple;
        Align targetAlign;
        int targetAlignAxis;
        int i;
        int j;
        if (this.debug > 0) {
            System.out.println("* getHitAlignedCouples mode=" + Command.getModeString(this.mode));
        }
        ArrayList alignList = null;
        Rectangle2D targetBox = targetContainer.getBoundingBox();
        int endPTindex = -1;
        if (this.mode == 4 && (endPTindex = this.selectMovingEndPT()) >= 0) {
            Point2D[] PTs = targetContainer.getElement().getEndPTs();
            targetBox = new Rectangle2D.Double(PTs[endPTindex].getX(), PTs[endPTindex].getY(), 0.0, 0.0);
        }
        double X = targetBox.getX();
        double Y = targetBox.getY();
        double W = targetBox.getWidth();
        double H = targetBox.getHeight();
        Align hitAlign = null;
        int hitAlignType = -1;
        int hitAlignAxis = -1;
        int targetAlignType = -1;
        double value = 0.0;
        if (this.debug > 0) {
            this.printAlignList();
        }
        alignList = this.xAlignList;
        for (j = 0; j < alignList.size(); ++j) {
            hitAlign = (Align)alignList.get(j);
            hitAlignAxis = hitAlign.getAlignAxis();
            hitAlignType = hitAlign.getAlignType();
            value = hitAlign.getValue();
            targetAlignType = 0;
            double[] x = new double[1];
            if (this.mode != 4) {
                x = new double[3];
            }
            for (i = 0; i < x.length; ++i) {
                x[i] = X + 0.5 * W * (double)i;
            }
            for (i = 0; i < x.length; ++i) {
                if (!(Math.abs(x[i] - value) < ErrorMargin)) continue;
                if (this.mode == 2 || this.mode == 3) {
                    targetAlignType = i;
                } else if (this.mode == 4) {
                    targetAlignType = 6;
                }
                targetAlignAxis = 10;
                targetAlign = new Align(targetAlignAxis, targetAlignType, x[i], targetContainer, endPTindex);
                couple = new AlignedCouple(targetAlign, hitAlign);
                this.hitAlignedCouples.add(couple);
            }
        }
        alignList = this.yAlignList;
        for (j = 0; j < alignList.size(); ++j) {
            hitAlign = (Align)alignList.get(j);
            hitAlignAxis = hitAlign.getAlignAxis();
            hitAlignType = hitAlign.getAlignType();
            value = hitAlign.getValue();
            targetAlignType = 0;
            double[] y = new double[1];
            if (this.mode != 4) {
                y = new double[3];
            }
            for (i = 0; i < y.length; ++i) {
                y[i] = Y + 0.5 * H * (double)i;
            }
            for (i = 0; i < y.length; ++i) {
                if (!(Math.abs(y[i] - value) < ErrorMargin)) continue;
                if (this.mode == 2 || this.mode == 3) {
                    targetAlignType = i + 3;
                } else if (this.mode == 4) {
                    targetAlignType = 6;
                }
                targetAlignAxis = 11;
                targetAlign = new Align(targetAlignAxis, targetAlignType, y[i], targetContainer, endPTindex);
                couple = new AlignedCouple(targetAlign, hitAlign);
                this.hitAlignedCouples.add(couple);
            }
        }
        if (this.debug > 0 && (size = this.hitAlignedCouples.size()) > 0) {
            System.out.println("* getHitAlignedCouples HitAlign, endPTindex=" + endPTindex + ", mode=" + Command.getModeString(this.mode));
            for (int j2 = 0; j2 < size; ++j2) {
                AlignedCouple couple2 = (AlignedCouple)this.hitAlignedCouples.get(j2);
                System.out.println(couple2);
            }
        }
    }

    private void printAlignList() {
        int j;
        ArrayList alignList = null;
        Align hitAlign = null;
        alignList = this.xAlignList;
        System.out.println("** printAlignList");
        System.out.println("xAlignList");
        for (j = 0; j < alignList.size(); ++j) {
            hitAlign = (Align)alignList.get(j);
            System.out.println("- align[" + j + "]: " + hitAlign.toString());
        }
        alignList = this.yAlignList;
        System.out.println("yAlignList");
        for (j = 0; j < alignList.size(); ++j) {
            hitAlign = (Align)alignList.get(j);
            System.out.println("- align[" + j + "]: " + hitAlign.toString());
        }
    }

    private int selectMovingEndPT() {
        Point2D mousePoint = this.mousePositionInfo.getPoint();
        int movingEndPTindex = -1;
        int containerType = this.selectedContainers[0].getContainerType();
        int type = this.selectedContainers[0].getElement().getTypeE();
        if (containerType == ShapeContainer.GROUP) {
            return movingEndPTindex;
        }
        if (type < 51 || type > 56) {
            return movingEndPTindex;
        }
        if (this.selectedContainers[0].getElement().isClosed()) {
            return movingEndPTindex;
        }
        Point2D[] endPTs = this.selectedContainers[0].getElement().getEndPTs();
        if (endPTs != null && endPTs.length > 0) {
            double d0 = Vector2D.dist(mousePoint, endPTs[0]);
            double d1 = Vector2D.dist(mousePoint, endPTs[1]);
            movingEndPTindex = 0;
            if (d1 < d0) {
                movingEndPTindex = 1;
            }
        }
        if (this.debug > 0) {
            System.out.println("- selectMovingEndPT movingEndPTindex=" + movingEndPTindex);
        }
        return movingEndPTindex;
    }

    private AlignedCouple selectHitAlignedCouple(int alignType, int dir) {
        int size = this.hitAlignedCouples.size();
        double distMin = 100000.0;
        int index = -1;
        for (int i = 0; i < size; ++i) {
            AlignedCouple alignedCouple = (AlignedCouple)this.hitAlignedCouples.get(i);
            int hitAlignType = alignedCouple.hitAlign.getAlignType();
            if (hitAlignType != alignType) continue;
            int hitSide = 0;
            if (!alignedCouple.isHitAlignUpperLeft()) {
                hitSide = 1;
            }
            if (hitSide != dir) continue;
            double dist = 0.0;
            if (alignType == 0 || alignType == 1 || alignType == 2) {
                dist = alignedCouple.getAlignOrthogonalDistance();
            } else if (alignType == 3 || alignType == 4 || alignType == 5) {
                dist = alignedCouple.getAlignOrthogonalDistance();
            }
            if (!(dist < distMin)) continue;
            distMin = dist;
            index = i;
        }
        if (index < 0) {
            return null;
        }
        AlignedCouple retCouple = (AlignedCouple)this.hitAlignedCouples.get(index);
        if (this.debug > 0) {
            System.out.println("- selectHitAlignedCouple alignType=" + Align.alignString[alignType] + ", dir=" + dir + "\n" + retCouple.toString());
        }
        return retCouple;
    }

    private void drawAlign(AlignedCouple couple) {
        double scale = DrawParameters.getScale();
        Align hitAlign = couple.hitAlign;
        int hitAlignType = hitAlign.getAlignType();
        Point2D targetP = couple.getTargetAlignPoint();
        Point2D hitP = couple.getHitAlignPoint();
        Line2D.Double line = null;
        String message = "";
        if (hitAlignType == 0) {
            line = new Line2D.Double(hitP.getX(), hitP.getY(), hitP.getX(), targetP.getY());
            message = "left align";
        }
        if (hitAlignType == 1) {
            line = new Line2D.Double(hitP.getX(), targetP.getY(), hitP.getX(), hitP.getY());
            message = "center align";
        }
        if (hitAlignType == 2) {
            line = new Line2D.Double(hitP.getX(), hitP.getY(), hitP.getX(), targetP.getY());
            message = "right align";
        }
        if (hitAlignType == 3) {
            line = new Line2D.Double(hitP.getX(), hitP.getY(), targetP.getX(), hitP.getY());
            message = "top align";
        }
        if (hitAlignType == 4) {
            line = new Line2D.Double(hitP.getX(), hitP.getY(), targetP.getX(), hitP.getY());
            message = "middle align";
        }
        if (hitAlignType == 5) {
            line = new Line2D.Double(hitP.getX(), hitP.getY(), targetP.getX(), hitP.getY());
            message = "bottom align";
        }
        float[] dash = new float[]{2.0f, 3.0f};
        BasicStroke stroke = new BasicStroke(1.0f / (float)scale, 2, 0, 1.0f, dash, 0.0f);
        DrawShapeUtil.drawTempShape("Auto_align", line, stroke, this.color, null, null, null, this.color);
        double[] intersect = couple.checkIntersection();
        double val = couple.hitAlign.getValue();
        int alignAxis = couple.hitAlign.getAlignAxis();
        if (intersect != null) {
            line = alignAxis == 10 ? new Line2D.Double(val, intersect[0], val, intersect[1]) : new Line2D.Double(intersect[0], val, intersect[1], val);
            float[] dash1 = new float[]{2.0f, 6.0f};
            stroke = new BasicStroke(3.0f / (float)scale, 2, 0, 3.0f, dash1, 0.0f);
            DrawShapeUtil.drawTempShape("Auto_align", line, stroke, Color.red, null, null, null, Color.red);
        }
        if (this.debug > 0) {
            System.out.println("  -- drawAlign\n    " + couple.toString());
        }
    }

    public void ajustAlignment(int ctrl) {
        double errorY;
        double errorX;
        int mousePositionCode = this.mousePositionInfo.getPosition();
        Point2D currentP = ObjectTable.getMousePositionLS().getMousePoint();
        if (this.debug > 0) {
            String str = "";
            str = str + "** ajustment mode=" + Command.getModeString(this.mode) + ", ctrl=" + ctrl + ", mousePositionCode=" + MousePositionInfo.getPositionString(mousePositionCode);
            System.out.println(str);
        }
        AlignedCouple bestCoupleX = null;
        AlignedCouple bestCoupleY = null;
        if (this.mode == 2) {
            errorX = 0.0;
            errorY = 0.0;
            bestCoupleX = this.getBestAlignedCouple(10);
            if (bestCoupleX != null) {
                errorX = bestCoupleX.getAlignedError();
            }
            if ((bestCoupleY = this.getBestAlignedCouple(11)) != null) {
                errorY = bestCoupleY.getAlignedError();
            }
            Point2D.Double newP = new Point2D.Double(currentP.getX() + errorX, currentP.getY() + errorY);
            if (this.debug > 0) {
                this.printAjustment("\n** print Before ajustment", bestCoupleX, bestCoupleY);
            }
            for (int i = 0; i < this.selectedContainers.length; ++i) {
                this.selectedContainers[i].getElement().move(ctrl, newP, true);
            }
        }
        if (this.mode == 3) {
            int i;
            errorX = 0.0;
            errorY = 0.0;
            String mousePosition = MousePositionInfo.getPositionString(mousePositionCode);
            switch (mousePositionCode) {
                case 3: {
                    bestCoupleX = this.getBestAlignedCouple(10, 0);
                    if (bestCoupleX != null) {
                        errorX = bestCoupleX.getAlignedError();
                    }
                    if ((bestCoupleY = this.getBestAlignedCouple(11, 3)) == null) break;
                    errorY = bestCoupleY.getAlignedError();
                    break;
                }
                case 4: {
                    bestCoupleX = this.getBestAlignedCouple(10, 2);
                    if (bestCoupleX != null) {
                        errorX = bestCoupleX.getAlignedError();
                    }
                    if ((bestCoupleY = this.getBestAlignedCouple(11, 3)) == null) break;
                    errorY = bestCoupleY.getAlignedError();
                    break;
                }
                case 5: {
                    bestCoupleX = this.getBestAlignedCouple(10, 2);
                    if (bestCoupleX != null) {
                        errorX = bestCoupleX.getAlignedError();
                    }
                    if ((bestCoupleY = this.getBestAlignedCouple(11, 5)) == null) break;
                    errorY = bestCoupleY.getAlignedError();
                    break;
                }
                case 6: {
                    bestCoupleX = this.getBestAlignedCouple(10, 0);
                    if (bestCoupleX != null) {
                        errorX = bestCoupleX.getAlignedError();
                    }
                    if ((bestCoupleY = this.getBestAlignedCouple(11, 5)) == null) break;
                    errorY = bestCoupleY.getAlignedError();
                    break;
                }
                case 7: {
                    bestCoupleY = this.getBestAlignedCouple(11, 3);
                    if (bestCoupleY == null) break;
                    errorY = bestCoupleY.getAlignedError();
                    break;
                }
                case 8: {
                    bestCoupleX = this.getBestAlignedCouple(10, 2);
                    if (bestCoupleX == null) break;
                    errorX = bestCoupleX.getAlignedError();
                    break;
                }
                case 9: {
                    bestCoupleY = this.getBestAlignedCouple(11, 5);
                    if (bestCoupleY == null) break;
                    errorY = bestCoupleY.getAlignedError();
                    break;
                }
                case 10: {
                    bestCoupleX = this.getBestAlignedCouple(10, 0);
                    if (bestCoupleX == null) break;
                    errorX = bestCoupleX.getAlignedError();
                }
            }
            Point2D.Double P0 = new Point2D.Double(0.0, 0.0);
            Point2D.Double P1 = new Point2D.Double(errorX, errorY);
            for (i = 0; i < this.selectedContainers.length; ++i) {
                this.selectedContainers[i].getElement().mouseStart(ctrl, P0);
            }
            for (i = 0; i < this.selectedContainers.length; ++i) {
                this.selectedContainers[i].getElement().resize(ctrl, P1, mousePosition, true);
            }
        }
        if (this.mode == 4) {
            int ptIndex;
            errorX = 0.0;
            errorY = 0.0;
            bestCoupleX = this.getBestAlignedCouple(10, 6);
            if (bestCoupleX != null) {
                errorX = bestCoupleX.getAlignedError();
            }
            if ((bestCoupleY = this.getBestAlignedCouple(11, 6)) != null) {
                errorY = bestCoupleY.getAlignedError();
            }
            if ((ptIndex = this.selectMovingEndPT()) < 0) {
                return;
            }
            boolean lineDir = false;
            String key = Command.getCommandString(256);
            Object obj = this.selectedContainers[0].getProperty(key);
            if (obj != null) {
                lineDir = (Boolean)this.selectedContainers[0].getProperty(key);
            }
            Point2D[] endPTs = this.selectedContainers[0].getElement().getEndPTs();
            Point2D oldPoint = endPTs[ptIndex];
            Point2D newPoint = new Point2D.Double(oldPoint.getX() + errorX, oldPoint.getY() + errorY);
            Point2D projPT = null;
            if (lineDir) {
                projPT = this.projectPT(this.selectedContainers[0], ptIndex, 2, newPoint);
                if (errorX != 0.0 && projPT != null) {
                    newPoint = projPT;
                }
                projPT = this.projectPT(this.selectedContainers[0], ptIndex, 1, newPoint);
                if (errorY != 0.0 && projPT != null) {
                    newPoint = projPT;
                }
            }
            this.selectedContainers[0].getElement().moveEndPoint(ctrl, ptIndex, newPoint);
        }
        if (this.debug > 0) {
            this.printAjustment("** print ajustment results", bestCoupleX, bestCoupleY);
        }
    }

    private void printAjustment(String message, AlignedCouple bestCoupleX, AlignedCouple bestCoupleY) {
        String str = "";
        str = str + message;
        if (bestCoupleX != null) {
            bestCoupleX.update();
            str = str + "\n - x-align  errorX=" + bestCoupleX.getAlignedError() + "\n" + bestCoupleX.toString(2);
        } else {
            str = str + "\n - x-align: none";
        }
        if (bestCoupleY != null) {
            bestCoupleY.update();
            str = str + "\n - y-align  errorY=" + bestCoupleY.getAlignedError() + "\n" + bestCoupleY.toString(2);
        } else {
            str = str + "\n - y-align: none";
        }
        System.out.println(str);
    }

    private AlignedCouple getBestAlignedCouple(int alignAxis) {
        AlignedCouple bestCouple = null;
        double intersectLenMax = 0.0;
        double errorMin = 100000.0;
        int index = -1;
        double alignedError = 100000.0;
        double[] intersect = new double[2];
        double intersectLen = 0.0;
        int size = this.selectedHitAlignedCouples.size();
        for (int i = 0; i < size; ++i) {
            AlignedCouple couple = (AlignedCouple)this.selectedHitAlignedCouples.get(i);
            int targetAxis = couple.targetAlign.getAlignAxis();
            int hitAxis = couple.hitAlign.getAlignAxis();
            int type = couple.hitAlign.getAlignType();
            if (targetAxis != alignAxis || hitAxis != alignAxis) continue;
            intersect = couple.checkIntersection();
            if (intersect != null) {
                intersectLen = Math.abs(intersect[0] - intersect[1]);
            }
            alignedError = Math.abs(couple.getAlignedError());
            if (intersectLen > intersectLenMax) {
                intersectLenMax = intersectLen;
                index = i;
                bestCouple = couple;
                continue;
            }
            if (!(alignedError < errorMin)) continue;
            errorMin = alignedError;
            index = i;
            bestCouple = couple;
        }
        return bestCouple;
    }

    private AlignedCouple getBestAlignedCouple(int alignAxis, int targetAlignType) {
        AlignedCouple bestCouple = null;
        double intersectLenMax = 0.0;
        double errorMin = 100000.0;
        int index = -1;
        double alignedError = 100000.0;
        double[] intersect = new double[2];
        double intersectLen = 0.0;
        int size = this.selectedHitAlignedCouples.size();
        for (int i = 0; i < size; ++i) {
            AlignedCouple couple = (AlignedCouple)this.selectedHitAlignedCouples.get(i);
            int targetAxis = couple.targetAlign.getAlignAxis();
            int hitAxis = couple.hitAlign.getAlignAxis();
            int targetType = couple.targetAlign.getAlignType();
            int hitType = couple.hitAlign.getAlignType();
            if (targetAxis != alignAxis || hitAxis != alignAxis || targetType != targetAlignType) continue;
            intersect = couple.checkIntersection();
            if (intersect != null) {
                intersectLen = Math.abs(intersect[0] - intersect[1]);
            }
            alignedError = Math.abs(couple.getAlignedError());
            if (intersectLen > intersectLenMax) {
                intersectLenMax = intersectLen;
                index = i;
                bestCouple = couple;
                continue;
            }
            if (!(alignedError < errorMin)) continue;
            errorMin = alignedError;
            index = i;
            bestCouple = couple;
        }
        return bestCouple;
    }

    private Point2D projectPT(ShapeContainer container, int endPtIndex, int dir, Point2D pt) {
        CrossCurvePT crossPT;
        Curve2D curve = container.getElement().getCurve2D();
        int numseg = curve.getNumOfSegments();
        double t = 0.0;
        if (endPtIndex > 0) {
            t = numseg;
        }
        Point2D p0 = curve.getP(t);
        Vector2D tvec = curve.getTangent(t);
        Point2D.Double p1 = new Point2D.Double(p0.getX() + tvec.getX(), p0.getY() + tvec.getY());
        Point2D.Double pt1 = new Point2D.Double(pt.getX() + 1.0, pt.getY());
        if (dir == 2) {
            pt1 = new Point2D.Double(pt.getX(), pt.getY() + 1.0);
        }
        if ((crossPT = Vector2D.crossPoint(p0, p1, pt, pt1)) == null) {
            return null;
        }
        return crossPT.getP1();
    }
}

