/*
 * Decompiled with CFR 0.152.
 */
package shapeUtil;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import shape.ShapeContainer;
import shapeUtil.ComponentLibDialog;
import util.ContainerManager;
import util.DrawFileIo;

class ComponentManager {
    ComponentLibDialog dialog;
    ContainerManager containerManager = null;
    DrawFileIo drawFileIo = null;
    String filePath = "";
    String version = "ver0.0";
    int debug = 0;

    public ComponentManager(ComponentLibDialog dialog) {
        this.dialog = dialog;
        this.containerManager = new ContainerManager();
        this.drawFileIo = new DrawFileIo();
        File file = new File("");
        String currentPath = file.getAbsolutePath();
        this.filePath = currentPath + "/ComponentLibrary";
    }

    public ContainerManager getContainerManager() {
        return this.containerManager;
    }

    public void writeComponentList() {
        ArrayList containerList = this.containerManager.getContainerList();
        try {
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(this.filePath));
            this.drawFileIo.writeContainerList(0, out, this.version, containerList);
        }
        catch (Exception e) {
            System.err.println("*** Error ComponentManager.writeContainerList e=" + e);
            e.printStackTrace();
        }
    }

    public void readComponentList() {
        File file = new File(this.filePath);
        if (!file.isFile()) {
            try {
                file.createNewFile();
            }
            catch (Exception e) {
                System.err.println("*** Error: File.createNewFile e=" + e);
            }
        }
        try {
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(this.filePath));
            ArrayList containerList = this.drawFileIo.readContainerList(0, in);
            this.containerManager.setContainerList(containerList);
        }
        catch (Exception e) {
            System.out.println("*** Message: Componentlib is empty, e=" + e);
        }
    }

    public void moveComponent(int selectedComponentIndex, int moveTo) {
        if (this.debug > 0) {
            System.out.println("ComponentManager moveComponent gapIndex=" + moveTo + ", selectedIndex=" + selectedComponentIndex);
        }
        ShapeContainer selectedContainer = this.containerManager.getContainer(selectedComponentIndex);
        if (moveTo == this.containerManager.size()) {
            this.containerManager.deleteContainer(selectedContainer);
            this.containerManager.addContainer(selectedContainer);
        } else {
            this.containerManager.deleteContainer(selectedContainer);
            int targetIndex = moveTo;
            if (selectedComponentIndex < moveTo) {
                --targetIndex;
            }
            this.containerManager.addContainer(targetIndex, selectedContainer);
        }
        this.dialog.getComponentLibPanel().repaint();
    }
}

