/*
 * Decompiled with CFR 0.152.
 */
package shapeUtil;

import DrawTop.DrawPanel;
import DrawTop.DrawParameters;
import DrawTop.ObjectTable;
import DrawTop.SelectionEvent;
import DrawTop.SelectionLS;
import DrawTop.SelectionListener;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import shape.DrawShapeUtil;
import shape.ShapeContainer;
import shape.ShapeElement;
import shapeUtil.ConnectCurvesAction;
import shapeUtil.MouseHitShape;
import util.ContainerManager;

public class ConnectCurves
extends JDialog
implements SelectionListener {
    ConnectCurvesAction action = null;
    JLabel instructionLabel = null;
    JLabel messageLabel1 = null;
    JLabel messageLabel2 = null;
    JButton goButton = null;
    JButton repeatButton = null;
    JButton cancelButton = null;
    Vector shapeVector = new Vector();
    Color warningColor = new Color(255, 0, 153);
    int debug = 0;

    public ConnectCurves() {
        super((Frame)ObjectTable.getDrawMain(), "connect curves");
        this.setName("connect curves");
        this.action = new ConnectCurvesAction(this);
        this.createDialog();
    }

    public void createDialog() {
        Window owner = this.getOwner();
        Point centerP = new Point(owner.getX() + 10, owner.getY() + 80);
        this.setLocation(centerP);
        this.addWindowListener(this.action);
        SelectionLS selectionLS = ObjectTable.getSelectionLS("connectCurves");
        selectionLS.addSelectionListener(this);
        Container contentPane = this.getContentPane();
        Box box = Box.createVerticalBox();
        contentPane.add(box);
        JPanel messagePanel = new JPanel();
        messagePanel.setBorder(BorderFactory.createTitledBorder("message:"));
        Dimension messagePanelSize = new Dimension(300, 80);
        messagePanel.setPreferredSize(messagePanelSize);
        GridLayout basePanelLayout = new GridLayout(3, 1);
        basePanelLayout.setHgap(20);
        basePanelLayout.setVgap(5);
        messagePanel.setLayout(basePanelLayout);
        JLabel instructionLabel = new JLabel(" Connect curves.  Click curve !");
        this.messageLabel1 = new JLabel(" ");
        this.messageLabel2 = new JLabel(" ");
        messagePanel.add(instructionLabel);
        messagePanel.add(this.messageLabel1);
        messagePanel.add(this.messageLabel2);
        Dimension messageDimension = new Dimension(300, 14);
        this.messageLabel1.setPreferredSize(messageDimension);
        this.messageLabel2.setPreferredSize(messageDimension);
        messagePanel.add(instructionLabel);
        messagePanel.add(this.messageLabel1);
        messagePanel.add(this.messageLabel2);
        JPanel buttonPanel = new JPanel();
        this.goButton = new JButton("Go !");
        this.goButton.setActionCommand("Go");
        this.goButton.setEnabled(false);
        this.repeatButton = new JButton("Repeat");
        this.repeatButton.setActionCommand("Repeat");
        this.repeatButton.setEnabled(false);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setActionCommand("Cancel");
        this.goButton.addActionListener(this.action);
        this.repeatButton.addActionListener(this.action);
        this.cancelButton.addActionListener(this.action);
        buttonPanel.add(this.goButton);
        buttonPanel.add(this.repeatButton);
        buttonPanel.add(this.cancelButton);
        box.add(Box.createVerticalStrut(5));
        box.add(messagePanel);
        box.add(Box.createVerticalStrut(5));
        box.add(buttonPanel);
    }

    public void showDialog() {
        this.pack();
        this.setVisible(true);
        ContainerManager manager = ObjectTable.getContainerManager("");
        this.shapeVector.clear();
        ShapeContainer[] containers = manager.getSelectedContainers();
        int size = 0;
        if (containers != null) {
            size = containers.length;
        }
        for (int i = 0; i < size; ++i) {
            containers[i].setSelected(false);
        }
        DrawPanel drawPanel = ObjectTable.getDrawPanel("");
        drawPanel.repaint();
    }

    public void showMessage(String message, Color color) {
        this.messageLabel1.setForeground(color);
        this.messageLabel2.setForeground(color);
        this.messageLabel1.setFont(DrawParameters.Font12Bold);
        this.messageLabel2.setFont(DrawParameters.Font12Bold);
        int index = message.indexOf("\n");
        String str1 = message;
        String str2 = "";
        if (index > 0) {
            str1 = message.substring(0, index);
            if (index + 1 < message.length()) {
                str2 = message.substring(index + 1, message.length());
            }
        }
        this.messageLabel1.setText(str1);
        this.messageLabel2.setText(str2);
    }

    @Override
    public void selected(SelectionEvent event) {
        Point2D point = event.getClickedPoint();
        ShapeContainer[] containers = event.getSelectedContainers();
        int len = containers.length;
        if (len > 1) {
            this.showMessage("  Error.  Select one by one!.", Color.RED);
            return;
        }
        ShapeContainer container = containers[0];
        if (this.debug > 0) {
            System.out.println("selected curve  container=" + container + ", point=" + point);
        }
        if (!this.isSuitable(container)) {
            return;
        }
        String str = "curve - " + (this.shapeVector.size() + 1);
        DrawShapeUtil.drawTempShape("ConnectCurves", point, 4, str, Color.RED);
        if (this.shapeVector.size() == 0) {
            this.showMessage(" Accepted.  Click next curve.", Color.BLUE);
        }
        if (this.shapeVector.size() >= 1) {
            this.showMessage(" Accepted.  Click next curve or Go !", Color.BLUE);
        }
        if (this.shapeVector.size() >= 1 && this.isDuplicated(container) >= 0) {
            this.showMessage("  Accepted.  Click next curve or Go !\n  warning! Selected curve is already selected !", this.warningColor);
        }
        MouseHitShape clickedShape = new MouseHitShape(container, point);
        this.shapeVector.add(clickedShape);
        if (this.shapeVector.size() >= 2) {
            this.goButton.setEnabled(true);
        }
    }

    private boolean isSuitable(ShapeContainer container) {
        boolean suitable = true;
        if (container.getContainerType() == ShapeContainer.GROUP) {
            this.showMessage(" Error: Group was clicked, Click again !", Color.RED);
            suitable = false;
        }
        ShapeElement shapeElement = container.getElement();
        int type = container.getElement().getTypeE();
        if (type < 51 || type > 56) {
            this.showMessage(" Error: Not curve, Click again !", Color.RED);
            suitable = false;
        }
        if (type >= 51 && type <= 56 && shapeElement.isClosed()) {
            this.showMessage(" Error: Closed curve, Click again! ", Color.RED);
            suitable = false;
        }
        return suitable;
    }

    private int isDuplicated(ShapeContainer container) {
        int size = this.shapeVector.size();
        int isave = -1;
        for (int i = 0; i < size; ++i) {
            MouseHitShape clickedShape = (MouseHitShape)this.shapeVector.get(i);
            String id = clickedShape.getShapeContainer().getShapeId();
            if (!container.getShapeId().equals(id)) continue;
            isave = i;
            break;
        }
        return isave;
    }

    public MouseHitShape[] getClickedShapes() {
        int size = this.shapeVector.size();
        MouseHitShape[] shapes = new MouseHitShape[size];
        for (int i = 0; i < size; ++i) {
            shapes[i] = (MouseHitShape)this.shapeVector.get(i);
        }
        return shapes;
    }

    public ShapeContainer[] getSelectedCurves() {
        Vector<ShapeContainer> vector = new Vector<ShapeContainer>();
        int size = this.shapeVector.size();
        for (int i = 0; i < size; ++i) {
            MouseHitShape clickedShape = (MouseHitShape)this.shapeVector.get(i);
            ShapeContainer container = clickedShape.getShapeContainer();
            int index = vector.indexOf(container);
            if (index >= 0) continue;
            vector.add(container);
        }
        size = vector.size();
        ShapeContainer[] containers = new ShapeContainer[size];
        for (int i = 0; i < size; ++i) {
            containers[i] = (ShapeContainer)vector.get(i);
        }
        return containers;
    }

    private void closeDialog() {
        this.setVisible(false);
        DrawPanel drawPanel = ObjectTable.getDrawPanel("");
        DrawShapeUtil.clearTempShape("ConnectCurves");
        drawPanel.repaint("ConnectCurves");
        this.setVisible(false);
        SelectionLS selectionLS = ObjectTable.getSelectionLS("");
        selectionLS.removeSelectionListener(this);
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        if (this.debug >= 0) {
            System.out.println("CutShape windowClosing");
        }
        this.closeDialog();
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }
}

